/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-27 09:43:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=569 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=8068 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1683 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=33216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15970 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;

CREATE TABLE `wp_statistics_exclusions` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reason` varchar(180) DEFAULT NULL,
  `count` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `date` (`date`),
  KEY `reason` (`reason`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_historical` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(25) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `uri` varchar(190) NOT NULL,
  `value` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `page_id` (`page_id`),
  UNIQUE KEY `uri` (`uri`),
  KEY `category` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_pages` (
  `page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uri` varchar(190) NOT NULL,
  `type` varchar(180) NOT NULL,
  `date` date NOT NULL,
  `count` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `date_2` (`date`,`uri`),
  KEY `url` (`uri`),
  KEY `date` (`date`),
  KEY `id` (`id`),
  KEY `uri` (`uri`,`count`,`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_search` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `engine` varchar(64) NOT NULL,
  `host` varchar(190) DEFAULT NULL,
  `words` varchar(190) DEFAULT NULL,
  `visitor` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `last_counter` (`last_counter`),
  KEY `engine` (`engine`),
  KEY `host` (`host`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_useronline` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `ip` varchar(60) NOT NULL,
  `created` int(11) DEFAULT NULL,
  `timestamp` int(10) NOT NULL,
  `date` datetime NOT NULL,
  `referred` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `agent` varchar(255) NOT NULL,
  `platform` varchar(255) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  `location` varchar(10) DEFAULT NULL,
  `user_id` bigint(48) NOT NULL,
  `page_id` bigint(48) NOT NULL,
  `type` varchar(100) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_visit` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_visit` datetime NOT NULL,
  `last_counter` date NOT NULL,
  `visit` int(10) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `unique_date` (`last_counter`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_visitor` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `referred` text NOT NULL,
  `agent` varchar(180) NOT NULL,
  `platform` varchar(180) DEFAULT NULL,
  `version` varchar(180) DEFAULT NULL,
  `UAString` varchar(190) DEFAULT NULL,
  `ip` varchar(60) NOT NULL,
  `location` varchar(10) DEFAULT NULL,
  `user_id` bigint(40) NOT NULL,
  `hits` int(11) DEFAULT NULL,
  `honeypot` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `date_ip_agent` (`last_counter`,`ip`,`agent`(50),`platform`(50),`version`(50)),
  KEY `agent` (`agent`),
  KEY `platform` (`platform`),
  KEY `version` (`version`),
  KEY `location` (`location`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_statistics_visitor_relationships` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `visitor_id` bigint(20) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `visitor_id` (`visitor_id`),
  KEY `page_id` (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(250)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("305", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-02-17 14:17:12", "2023-02-17 17:47:12", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676643432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676643432;}", "4", "1", "2023-02-17 14:17:26", "2023-02-17 17:47:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("329", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-03-09 13:21:48", "2023-03-09 16:51:48", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678368108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678368108;}", "4", "1", "2023-03-09 13:21:56", "2023-03-09 16:51:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("372", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-04 11:03:04", "2023-05-04 14:33:04", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683198184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683198184;}", "4", "1", "2023-05-04 11:03:05", "2023-05-04 14:33:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("506", "woocommerce_cleanup_draft_orders", "complete", "2025-09-21 14:27:42", "2025-09-21 17:57:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758464862;s:18:\"\0*\0first_timestamp\";i:1655967544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758464862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-05 02:07:23", "2025-10-05 05:37:23", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("528", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-21 15:05:44", "2025-09-21 18:35:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758467144;s:18:\"\0*\0first_timestamp\";i:1758380739;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758467144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("529", "wc_admin_daily_wrapper", "complete", "2025-09-21 15:05:46", "2025-09-21 18:35:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758467146;s:18:\"\0*\0first_timestamp\";i:1758380744;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758467146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-05 02:07:27", "2025-10-05 05:37:27", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("530", "woocommerce_cleanup_personal_data", "complete", "2025-09-21 15:06:45", "2025-09-21 18:36:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758467205;s:18:\"\0*\0first_timestamp\";i:1758380754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758467205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("531", "woocommerce_geoip_updater", "complete", "2025-10-05 15:06:46", "2025-10-05 18:36:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759676806;s:18:\"\0*\0first_timestamp\";i:1758380804;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759676806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "1", "2025-10-27 09:27:03", "2025-10-27 12:57:03", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("533", "woocommerce_cleanup_logs", "complete", "2025-09-21 19:13:15", "2025-09-21 22:43:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758481995;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758481995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("534", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-21 19:13:15", "2025-09-21 22:43:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758481995;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758481995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("535", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 10:37:14", "2025-09-21 14:07:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758451034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758451034;}", "8", "1", "2025-10-05 02:07:23", "2025-10-05 05:37:23", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("536", "woocommerce_scheduled_sales", "complete", "2025-09-22 09:37:14", "2025-09-22 13:07:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758533834;s:18:\"\0*\0first_timestamp\";i:1758402000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758533834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("537", "woocommerce_cleanup_sessions", "complete", "2025-09-21 21:37:14", "2025-09-22 01:07:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758490634;s:18:\"\0*\0first_timestamp\";i:1758402344;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758490634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("538", "woocommerce_refresh_order_count_cache", "complete", "2025-09-21 21:37:14", "2025-09-22 01:07:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758490634;s:18:\"\0*\0first_timestamp\";i:1758423944;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758490634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-05 02:07:28", "2025-10-05 05:37:28", "8057", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("539", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 03:07:23", "2025-10-05 06:37:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759633643;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759633643;}", "8", "1", "2025-10-27 09:27:03", "2025-10-27 12:57:03", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("540", "woocommerce_cleanup_draft_orders", "complete", "2025-10-06 02:07:23", "2025-10-06 05:37:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716443;s:18:\"\0*\0first_timestamp\";i:1655967544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-27 09:27:03", "2025-10-27 12:57:03", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("541", "wc_admin_daily_wrapper", "complete", "2025-10-06 02:07:27", "2025-10-06 05:37:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716447;s:18:\"\0*\0first_timestamp\";i:1758380744;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-27 09:27:05", "2025-10-27 12:57:05", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("542", "woocommerce_cleanup_personal_data", "complete", "2025-10-06 02:07:28", "2025-10-06 05:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716448;s:18:\"\0*\0first_timestamp\";i:1758380754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-27 09:27:06", "2025-10-27 12:57:06", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("543", "woocommerce_cleanup_logs", "complete", "2025-10-06 02:07:28", "2025-10-06 05:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716448;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-27 09:27:06", "2025-10-27 12:57:06", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("544", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-06 02:07:28", "2025-10-06 05:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716448;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-27 09:27:06", "2025-10-27 12:57:06", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("545", "woocommerce_cleanup_sessions", "complete", "2025-10-05 14:07:28", "2025-10-05 17:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759673248;s:18:\"\0*\0first_timestamp\";i:1758402344;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759673248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-10-27 09:27:03", "2025-10-27 12:57:03", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("546", "woocommerce_refresh_order_count_cache", "complete", "2025-10-05 14:07:28", "2025-10-05 17:37:28", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759673248;s:18:\"\0*\0first_timestamp\";i:1758423944;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759673248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-27 09:27:03", "2025-10-27 12:57:03", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("547", "woocommerce_scheduled_sales", "complete", "2025-10-06 02:07:28", "2025-10-06 05:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716448;s:18:\"\0*\0first_timestamp\";i:1758402000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-10-27 09:27:06", "2025-10-27 12:57:06", "8060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("548", "generate_category_lookup_table_wrapper", "complete", "2025-10-05 02:07:38", "2025-10-05 05:37:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759630058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759630058;}", "8", "1", "2025-10-20 03:23:04", "2025-10-20 06:53:04", "8059", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("549", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-06 02:07:28", "2025-10-06 05:37:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759716448;s:18:\"\0*\0first_timestamp\";i:1758380739;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759716448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 09:27:06", "2025-10-27 12:57:06", "8060", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("550", "woocommerce_cancel_unpaid_orders", "pending", "2025-10-27 10:27:03", "2025-10-27 13:57:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761560823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761560823;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("551", "woocommerce_cleanup_sessions", "pending", "2025-10-27 21:27:03", "2025-10-28 00:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761600423;s:18:\"\0*\0first_timestamp\";i:1758402344;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761600423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("552", "woocommerce_refresh_order_count_cache", "pending", "2025-10-27 21:27:03", "2025-10-28 00:57:03", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761600423;s:18:\"\0*\0first_timestamp\";i:1758423944;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761600423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("553", "woocommerce_geoip_updater", "pending", "2025-11-11 09:27:03", "2025-11-11 12:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762853223;s:18:\"\0*\0first_timestamp\";i:1758380804;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762853223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("554", "woocommerce_cleanup_draft_orders", "pending", "2025-10-28 09:27:03", "2025-10-28 12:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643623;s:18:\"\0*\0first_timestamp\";i:1655967544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "wc_admin_daily_wrapper", "pending", "2025-10-28 09:27:05", "2025-10-28 12:57:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643625;s:18:\"\0*\0first_timestamp\";i:1758380744;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("556", "woocommerce_cleanup_personal_data", "pending", "2025-10-28 09:27:06", "2025-10-28 12:57:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643626;s:18:\"\0*\0first_timestamp\";i:1758380754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("557", "woocommerce_cleanup_logs", "pending", "2025-10-28 09:27:06", "2025-10-28 12:57:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643626;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("558", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-10-28 09:27:06", "2025-10-28 12:57:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643626;s:18:\"\0*\0first_timestamp\";i:1758391544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("559", "woocommerce_scheduled_sales", "pending", "2025-10-28 09:27:06", "2025-10-28 12:57:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643626;s:18:\"\0*\0first_timestamp\";i:1758402000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("560", "generate_category_lookup_table_wrapper", "complete", "2025-10-27 09:27:16", "2025-10-27 12:57:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557236;}", "8", "1", "2025-10-27 09:28:22", "2025-10-27 12:58:22", "8062", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("561", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-10-28 09:27:06", "2025-10-28 12:57:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761643626;s:18:\"\0*\0first_timestamp\";i:1758380739;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761643626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("562", "fetch_patterns", "complete", "2025-10-27 09:28:53", "2025-10-27 12:58:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557333;}", "6", "1", "2025-10-27 09:31:06", "2025-10-27 13:01:06", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("563", "woocommerce_run_update_callback", "complete", "2025-10-27 09:29:03", "2025-10-27 12:59:03", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557343;}", "3", "1", "2025-10-27 09:31:06", "2025-10-27 13:01:06", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("564", "woocommerce_run_update_callback", "complete", "2025-10-27 09:29:04", "2025-10-27 12:59:04", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557344;}", "3", "1", "2025-10-27 09:31:07", "2025-10-27 13:01:07", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("565", "woocommerce_update_db_to_current_version", "complete", "2025-10-27 09:29:05", "2025-10-27 12:59:05", "{\"version\":\"10.3.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557345;}", "3", "1", "2025-10-27 09:31:07", "2025-10-27 13:01:07", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("566", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-10-27 09:29:04", "2025-10-27 12:59:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557344;}", "3", "1", "2025-10-27 09:31:07", "2025-10-27 13:01:07", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("567", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-10-27 09:29:03", "2025-10-27 12:59:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557343;}", "4", "1", "2025-10-27 09:31:07", "2025-10-27 13:01:07", "8064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("568", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-10-27 09:31:08", "2025-10-27 13:01:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557468;}", "3", "1", "2025-10-27 09:31:13", "2025-10-27 13:01:13", "8066", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("909", "305", "ایجاد فعالیت", "2023-02-17 14:17:12", "2023-02-17 17:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("910", "305", "عملیات توسط WP Cron شروع شد", "2023-02-17 14:17:26", "2023-02-17 17:47:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("911", "305", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-02-17 14:17:26", "2023-02-17 17:47:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("981", "329", "ایجاد فعالیت", "2023-03-09 13:21:48", "2023-03-09 16:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("982", "329", "عملیات توسط Async Request شروع شد", "2023-03-09 13:21:56", "2023-03-09 16:51:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("983", "329", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-03-09 13:21:56", "2023-03-09 16:51:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1110", "372", "ایجاد فعالیت", "2023-05-04 11:03:04", "2023-05-04 14:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1111", "372", "عملیات توسط WP Cron شروع شد", "2023-05-04 11:03:05", "2023-05-04 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1112", "372", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-04 11:03:05", "2023-05-04 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1516", "506", "ایجاد فعالیت", "2025-09-20 14:27:42", "2025-09-20 17:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1560", "528", "ایجاد فعالیت", "2025-09-20 15:05:44", "2025-09-20 18:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1563", "529", "ایجاد فعالیت", "2025-09-20 15:05:46", "2025-09-20 18:35:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1566", "530", "ایجاد فعالیت", "2025-09-20 15:06:45", "2025-09-20 18:36:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1571", "531", "ایجاد فعالیت", "2025-09-20 15:06:46", "2025-09-20 18:36:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1577", "533", "ایجاد فعالیت", "2025-09-20 19:13:15", "2025-09-20 22:43:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1580", "534", "ایجاد فعالیت", "2025-09-20 19:13:15", "2025-09-20 22:43:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1582", "535", "ایجاد فعالیت", "2025-09-21 09:37:14", "2025-09-21 13:07:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1586", "536", "ایجاد فعالیت", "2025-09-21 09:37:14", "2025-09-21 13:07:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1589", "537", "ایجاد فعالیت", "2025-09-21 09:37:14", "2025-09-21 13:07:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1592", "538", "ایجاد فعالیت", "2025-09-21 09:37:14", "2025-09-21 13:07:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1593", "535", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1594", "539", "ایجاد فعالیت", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1595", "535", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1596", "506", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1597", "506", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1598", "540", "ایجاد فعالیت", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1599", "529", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:23", "2025-10-05 05:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1600", "529", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:27", "2025-10-05 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1601", "541", "ایجاد فعالیت", "2025-10-05 02:07:27", "2025-10-05 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1602", "530", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:27", "2025-10-05 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1603", "530", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1604", "542", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1605", "533", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1606", "533", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1607", "543", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1608", "534", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1609", "534", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1610", "544", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1611", "537", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1612", "537", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1613", "545", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1614", "538", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1615", "538", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1616", "546", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1617", "536", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1618", "536", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1619", "547", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1620", "528", "عملیات توسط WP Cron شروع شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1621", "548", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1622", "528", "عملیات توسط WP Cron کامل شد", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1623", "549", "ایجاد فعالیت", "2025-10-05 02:07:28", "2025-10-05 05:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1624", "548", "عملیات توسط WP Cron شروع شد", "2025-10-20 03:23:04", "2025-10-20 06:53:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1625", "548", "عملیات توسط WP Cron کامل شد", "2025-10-20 03:23:04", "2025-10-20 06:53:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1626", "539", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1627", "550", "ایجاد فعالیت", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1628", "539", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1629", "545", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1630", "545", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1631", "551", "ایجاد فعالیت", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1632", "546", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1633", "546", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1634", "552", "ایجاد فعالیت", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1635", "531", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1636", "531", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1637", "553", "ایجاد فعالیت", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1638", "540", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1639", "540", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1640", "554", "ایجاد فعالیت", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1641", "541", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:03", "2025-10-27 12:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1642", "541", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:05", "2025-10-27 12:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1643", "555", "ایجاد فعالیت", "2025-10-27 09:27:05", "2025-10-27 12:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1644", "542", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:05", "2025-10-27 12:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1645", "542", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1646", "556", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1647", "543", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1648", "543", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1649", "557", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1650", "544", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1651", "544", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1652", "558", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1653", "547", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1654", "547", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1655", "559", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1656", "549", "عملیات توسط Async Request شروع شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1657", "560", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1658", "549", "عملیات توسط Async Request کامل شد", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1659", "561", "ایجاد فعالیت", "2025-10-27 09:27:06", "2025-10-27 12:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1660", "560", "عملیات توسط Async Request شروع شد", "2025-10-27 09:28:22", "2025-10-27 12:58:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1661", "560", "عملیات توسط Async Request کامل شد", "2025-10-27 09:28:22", "2025-10-27 12:58:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1662", "562", "ایجاد فعالیت", "2025-10-27 09:28:53", "2025-10-27 12:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1663", "563", "ایجاد فعالیت", "2025-10-27 09:29:03", "2025-10-27 12:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1664", "564", "ایجاد فعالیت", "2025-10-27 09:29:03", "2025-10-27 12:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1665", "565", "ایجاد فعالیت", "2025-10-27 09:29:03", "2025-10-27 12:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1666", "566", "ایجاد فعالیت", "2025-10-27 09:29:03", "2025-10-27 12:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1667", "567", "ایجاد فعالیت", "2025-10-27 09:29:03", "2025-10-27 12:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1668", "562", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:06", "2025-10-27 13:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1669", "562", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:06", "2025-10-27 13:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1670", "563", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:06", "2025-10-27 13:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1671", "563", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:06", "2025-10-27 13:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1672", "567", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:06", "2025-10-27 13:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1673", "567", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1674", "564", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1675", "564", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1676", "566", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1677", "568", "ایجاد فعالیت", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1678", "566", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1679", "565", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1680", "565", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:07", "2025-10-27 13:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1681", "568", "عملیات توسط Async Request شروع شد", "2025-10-27 09:31:13", "2025-10-27 13:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1682", "568", "عملیات توسط Async Request کامل شد", "2025-10-27 09:31:13", "2025-10-27 13:01:13");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("5", "8", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("6", "8", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("7", "9", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("8", "9", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("27", "18", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("28", "18", "verified", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "1601", "ووکامرس", "", "", "", "2022-06-23 10:50:32", "2022-06-23 07:20:32", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "1633", "ووکامرس", "", "", "", "2022-06-23 12:40:32", "2022-06-23 09:10:32", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "2105", "WooCommerce", "woocommerce@polarisweb.ir", "", "", "2022-09-19 18:00:40", "2022-09-19 13:30:40", "Payment to be made upon delivery. Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "2034", "Joann", "joann.mcmullan@gmail.com", "", "46.246.122.124", "2022-09-23 19:17:06", "2022-09-23 15:47:06", "Excellent blog post. I certainly appteciate this website.\r\nContinue tthe good work!\r\n\r\nFeeel free to visit mmy website; <a href=\"https://live-xnxx-videos.com/\" rel=\"nofollow ugc\">vkh</a>", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "2034", "Lee", "leeatencio@gmx.net", "", "46.246.122.182", "2022-09-27 09:48:59", "2022-09-27 06:18:59", "My brother suggested I might like this web site. He wass entirely right.\r\nThis pot actually made myy day. Youu can not imnagine simlly how \r\nmucxh timme I hhad spebt ffor thhis info! Thanks!\r\n\r\n\r\n\r\nAllso visi myy site <a href=\"https://fapxtube.com/hotmovs-desahan-nikmat-cewek-indo/1/\" rel=\"nofollow ugc\">xxx video</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "2034", "Angel", "angellatham@t-online.de", "", "45.80.105.157", "2022-11-27 05:23:25", "2022-11-27 01:53:25", "I just like the helpful information you provide in your articles.\r\n\r\nI\'ll bookmark your weblog and take a look at \r\nagain here regularly. I am moderately sure I will learn many new stuff proper here!\r\n\r\nBest of luck for the following!\r\n\r\nReview my site; <a href=\"https://goo.su/kK2Yby4\" rel=\"nofollow ugc\">binary options experts review</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "review", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("38", "novaco_211", "8ba016f96662a6c76886_20251027094302", "20", "2025-10-27 09:43:18", "nova", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-27 09:43:02\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:38;s:4:\"Name\";s:10:\"novaco_211\";s:4:\"Hash\";s:35:\"8ba016f96662a6c76886_20251027094302\";s:8:\"NameHash\";s:46:\"novaco_211_8ba016f96662a6c76886_20251027094302\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:56:\"novaco_211_8ba016f96662a6c76886_20251027094302_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:4:\"nova\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"novaco_211_8ba016f96662a6c76886_20251027094302_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/novathem/domains/novatheme.ir/public_html/edit\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2177;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:15720;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-27 09:43:02\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"novaco_211\";s:4:\"Hash\";s:35:\"8ba016f96662a6c76886_20251027094302\";s:8:\"NameHash\";s:46:\"novaco_211_8ba016f96662a6c76886_20251027094302\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:64:\"novaco_211_8ba016f96662a6c76886_20251027094302_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:16:\"MTE0MjE2NDdHaA==\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:66:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:59:\"novaco_211_8ba016f96662a6c76886_20251027094302_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:144:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/backups-dup-lite/tmp/novaco_211_8ba016f96662a6c76886_20251027094302_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:61:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-admin\";i:1;s:64:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-includes\";i:2;s:73:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:52:\"/home/novathem/domains/novatheme.ir/public_html/edit\";i:1;s:52:\"/home/novathem/domains/novatheme.ir/public_html/edit\";i:2;s:63:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content\";i:3;s:71:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/uploads\";i:4;s:71:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/plugins\";i:5;s:74:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/mu-plugins\";i:6;s:70:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:84:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://novatheme.ir/edit", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://novatheme.ir/edit", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "نُواکو", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "قالب وردپرسی نُواکو", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "alirza.sh826@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:9:{i:0;s:21:\"polylang/polylang.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:23:\"revslider/revslider.php\";i:6;s:33:\"woo-poly-integration/__init__.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:23:\"wp-shamsi/wp-shamsi.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:87:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes/Novaco/style.css\";i:1;s:88:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes/Novaco/js/main.js\";i:3;s:91:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes/Novaco/functions.php\";i:4;s:88:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes/Novaco/footer.php\";i:5;s:88:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/themes/Novaco/header.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Novaco", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "Novaco", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "identicon", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "314", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1761816464", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:20:{i:1760930603;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1760931726;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760931984;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760932048;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760932376;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760944088;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760946126;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760951549;a:1:{s:28:\"wp_statistics_add_visit_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760968308;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760971648;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760989411;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760989421;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760989675;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760990773;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761002936;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761131331;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761334925;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761506107;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762165800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("120", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("121", "theme_mods_twentytwentyone", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1658685444;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:18:\"nav_menu_locations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("150", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("153", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("154", "elementor_version", "3.32.5", "yes");
INSERT INTO `wp_options` VALUES("155", "elementor_install_history", "a:18:{s:5:\"3.4.4\";i:1632426225;s:5:\"3.5.3\";i:1642146188;s:5:\"3.6.4\";i:1650477860;s:5:\"3.6.6\";i:1654788561;s:5:\"3.6.7\";i:1658685521;s:5:\"3.7.6\";i:1663651731;s:5:\"3.7.8\";i:1666353244;s:5:\"3.8.1\";i:1669360718;s:5:\"3.9.2\";i:1672253721;s:6:\"3.10.2\";i:1675857796;s:6:\"3.11.1\";i:1676643398;s:6:\"3.11.3\";i:1678368076;s:6:\"3.12.2\";i:1683198065;s:6:\"3.13.4\";i:1686982580;s:6:\"3.14.0\";i:1687333326;s:6:\"3.28.3\";i:1743807510;s:6:\"3.32.2\";i:1758378624;s:6:\"3.32.5\";i:1761557303;}", "yes");
INSERT INTO `wp_options` VALUES("158", "_elementor_installed_time", "1632426228", "yes");
INSERT INTO `wp_options` VALUES("159", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("160", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("161", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("170", "polylang", "a:17:{s:7:\"browser\";b:0;s:7:\"rewrite\";b:1;s:12:\"hide_default\";b:1;s:10:\"force_lang\";i:1;s:13:\"redirect_lang\";b:0;s:13:\"media_support\";b:0;s:9:\"uninstall\";i:0;s:4:\"sync\";a:11:{i:0;s:10:\"taxonomies\";i:1;s:9:\"post_meta\";i:2;s:14:\"comment_status\";i:3;s:11:\"ping_status\";i:4;s:12:\"sticky_posts\";i:5;s:9:\"post_date\";i:6;s:11:\"post_format\";i:7;s:11:\"post_parent\";i:8;s:17:\"_wp_page_template\";i:9;s:10:\"menu_order\";i:10;s:13:\"_thumbnail_id\";}s:10:\"post_types\";a:6:{i:0;s:14:\"e-landing-page\";i:1;s:17:\"elementor_library\";i:2;s:9:\"portfolio\";i:3;s:10:\"shop_order\";i:4;s:7:\"product\";i:5;s:17:\"product_variation\";}s:10:\"taxonomies\";a:4:{i:0;s:13:\"portfolio_cat\";i:1;s:14:\"portfolio_tags\";i:2;s:11:\"product_cat\";i:3;s:11:\"product_tag\";}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"3.7.3\";s:16:\"first_activation\";i:1632426282;s:12:\"default_lang\";s:2:\"fa\";s:9:\"nav_menus\";a:6:{s:4:\"Nova\";a:0:{}s:5:\"tower\";a:4:{s:11:\"header-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"mobile-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"footer-menu\";a:1:{s:2:\"fa\";i:0;}s:9:\"side-menu\";a:1:{s:2:\"fa\";i:0;}}s:3:\"Oil\";a:4:{s:11:\"header-menu\";a:2:{s:2:\"fa\";i:0;s:2:\"en\";i:0;}s:11:\"mobile-menu\";a:2:{s:2:\"fa\";i:0;s:2:\"en\";i:0;}s:11:\"footer-menu\";a:2:{s:2:\"fa\";i:0;s:2:\"en\";i:0;}s:9:\"side-menu\";a:2:{s:2:\"fa\";i:0;s:2:\"en\";i:0;}}s:7:\"polaris\";a:4:{s:11:\"header-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"mobile-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"footer-menu\";a:1:{s:2:\"fa\";i:0;}s:9:\"side-menu\";a:1:{s:2:\"fa\";i:0;}}s:10:\"polarisweb\";a:4:{s:11:\"header-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"mobile-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"footer-menu\";a:1:{s:2:\"fa\";i:0;}s:9:\"side-menu\";a:1:{s:2:\"fa\";i:0;}}s:6:\"Novaco\";a:4:{s:11:\"header-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"mobile-menu\";a:1:{s:2:\"fa\";i:0;}s:11:\"footer-menu\";a:1:{s:2:\"fa\";i:0;}s:9:\"side-menu\";a:1:{s:2:\"fa\";i:0;}}}s:16:\"previous_version\";s:5:\"3.6.7\";s:19:\"language_taxonomies\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("171", "polylang_wpml_strings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("172", "widget_polylang", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("181", "pll_dismissed_notices", "a:4:{i:0;s:6:\"wizard\";i:1;s:8:\"lingotek\";i:2;s:5:\"pllwc\";i:3;s:6:\"review\";}", "yes");
INSERT INTO `wp_options` VALUES("186", "action_scheduler_hybrid_store_demarkation", "8", "yes");
INSERT INTO `wp_options` VALUES("187", "schema-ActionScheduler_StoreSchema", "8.0.1758380659", "yes");
INSERT INTO `wp_options` VALUES("188", "schema-ActionScheduler_LoggerSchema", "3.0.1642146340", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("192", "woocommerce_store_address", "tehran", "yes");
INSERT INTO `wp_options` VALUES("193", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("194", "woocommerce_store_city", "tehran", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_store_postcode", "0000000000", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("198", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("201", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("203", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("204", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_price_decimal_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("211", "woocommerce_shop_page_id", "189", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("214", "woocommerce_placeholder_image", "8", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("216", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("220", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("222", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_stock_email_recipient", "alirza.sh826@gmail.com", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("228", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("231", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("234", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("237", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("238", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("240", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("243", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("244", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("245", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("246", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("249", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("251", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("252", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("254", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("255", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("256", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("258", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("260", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("261", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("262", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("263", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("264", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("265", "woocommerce_email_from_name", "nova", "no");
INSERT INTO `wp_options` VALUES("266", "woocommerce_email_from_address", "alirza.sh826@gmail.com", "no");
INSERT INTO `wp_options` VALUES("267", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("268", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("269", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("270", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("271", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("272", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("273", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("274", "woocommerce_cart_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("275", "woocommerce_checkout_page_id", "11", "no");
INSERT INTO `wp_options` VALUES("276", "woocommerce_myaccount_page_id", "1098", "no");
INSERT INTO `wp_options` VALUES("277", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("278", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("280", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("281", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("283", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("285", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("287", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("288", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("290", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("291", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("292", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("293", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("294", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("295", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("296", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("297", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("298", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("299", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("301", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("302", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("306", "default_product_cat", "163", "yes");
INSERT INTO `wp_options` VALUES("314", "woocommerce_refund_returns_page_id", "13", "yes");
INSERT INTO `wp_options` VALUES("317", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:22:\"alirza.sh826@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:22:\"alirza.sh826@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("318", "woocommerce_version", "10.3.3", "yes");
INSERT INTO `wp_options` VALUES("319", "woocommerce_db_version", "10.3.3", "yes");
INSERT INTO `wp_options` VALUES("320", "woocommerce_inbox_variant_assignment", "4", "yes");
INSERT INTO `wp_options` VALUES("325", "action_scheduler_lock_async-request-runner", "68ff3e89735051.11682666|1761558213", "yes");
INSERT INTO `wp_options` VALUES("326", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("327", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"u4Pq0N0PH0bBgfjIB5qSSo42mWZNxIDs\";}", "yes");
INSERT INTO `wp_options` VALUES("329", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("330", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("331", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("332", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("333", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("334", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("335", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("336", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("337", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("338", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("339", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("340", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("344", "woocommerce_admin_install_timestamp", "1632426476", "yes");
INSERT INTO `wp_options` VALUES("345", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("347", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("352", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("354", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("367", "woocommerce_onboarding_profile", "a:8:{s:12:\"setup_client\";b:0;s:8:\"industry\";a:1:{i:0;a:1:{s:4:\"slug\";s:5:\"other\";}}s:13:\"product_types\";a:2:{i:0;s:8:\"physical\";i:1;s:9:\"downloads\";}s:13:\"product_count\";s:5:\"1000+\";s:14:\"selling_venues\";s:2:\"no\";s:19:\"business_extensions\";a:0:{}s:5:\"theme\";s:15:\"twentytwentyone\";s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("375", "woocommerce_task_list_tracked_completed_tasks", "a:8:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"purchase\";i:3;s:8:\"payments\";i:4;s:14:\"store_creation\";i:5;s:8:\"shipping\";i:6;s:15:\"review-shipping\";i:7;s:17:\"launch-your-store\";}", "yes");
INSERT INTO `wp_options` VALUES("385", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `wp_options` VALUES("392", "current_theme", "Novaco", "yes");
INSERT INTO `wp_options` VALUES("393", "theme_mods_Nova", "a:13:{s:18:\"nav_menu_locations\";a:4:{s:11:\"header-menu\";i:0;s:11:\"mobile-menu\";i:0;s:11:\"footer-menu\";i:0;s:9:\"side-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:15:\"hedaer_template\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:16:\"article_template\";s:2:\"72\";s:23:\"single_archive_template\";s:3:\"124\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_project_template\";s:3:\"136\";s:13:\"page_template\";s:3:\"167\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1654863016;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:24:\"archive_product_template\";s:3:\"184\";s:23:\"single_product_template\";s:3:\"280\";s:7:\"loading\";s:8:\"loading6\";}", "no");
INSERT INTO `wp_options` VALUES("394", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("395", "Nova_customizer_polylang_settings_", "a:3:{s:8:\"template\";s:4:\"Nova\";s:4:\"mods\";a:5:{s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:15:\"footer_template\";s:2:\"20\";s:15:\"hedaer_template\";s:2:\"30\";s:16:\"article_template\";s:2:\"37\";}s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("396", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wp_options` VALUES("398", "Nova_customizer_polylang_settings_fa", "a:3:{s:8:\"template\";s:4:\"Nova\";s:4:\"mods\";a:13:{s:18:\"nav_menu_locations\";a:4:{s:11:\"header-menu\";i:0;s:11:\"mobile-menu\";i:0;s:11:\"footer-menu\";i:0;s:9:\"side-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:15:\"hedaer_template\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:16:\"article_template\";s:2:\"72\";s:23:\"single_archive_template\";s:3:\"124\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_project_template\";s:3:\"136\";s:13:\"page_template\";s:3:\"167\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1654863016;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:24:\"archive_product_template\";s:3:\"184\";s:23:\"single_product_template\";s:3:\"280\";s:7:\"loading\";s:8:\"loading6\";}s:7:\"options\";a:2:{s:8:\"blogname\";s:4:\"nova\";s:15:\"blogdescription\";s:51:\"یک سایت دیگر با وردپرس فارسی\";}}", "yes");
INSERT INTO `wp_options` VALUES("405", "elementor_log", "a:43:{s:32:\"d6dfa09eac015f33c4ed5e1b0dce84da\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-17 17:46:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-17 17:46:38\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"2da9ac81fd212160d86955c07ada6f35\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-17 17:46:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.10.2\";s:2:\"to\";s:6:\"3.11.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-17 17:46:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.10.2\";s:2:\"to\";s:6:\"3.11.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1da600870234b31fb3894a0517033af4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-17 17:46:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.10.2\";s:2:\"to\";s:6:\"3.11.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-17 17:46:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.10.2\";s:2:\"to\";s:6:\"3.11.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c422eff60207aad1d7e7508f6cad673b\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"35947\";s:7:\"\0*\0file\";s:92:\"https://polarisweb.ir/edit/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.11.1\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2023-02-17 14:19:28\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:33:\"e.dispatchEvent is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2023-02-17 14:19:28\";i:1;s:19:\"2023-02-17 14:20:06\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1676643568\";s:7:\"message\";s:33:\"e.dispatchEvent is not a function\";s:3:\"url\";s:92:\"https://polarisweb.ir/edit/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.11.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"35947\";}}s:32:\"13297aebef0a19fe74a5e4fe2e839171\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:115:\"/home/novathem/domains/polarisweb.ir/public_html/edit/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:1578;s:7:\"\0*\0date\";s:19:\"2023-02-20 11:19:23\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:32;s:14:\"\0*\0times_dates\";a:32:{i:0;s:19:\"2023-02-20 11:19:23\";i:1;s:19:\"2023-02-20 17:25:00\";i:2;s:19:\"2023-02-20 17:25:05\";i:3;s:19:\"2023-02-23 13:12:41\";i:4;s:19:\"2023-02-23 13:12:48\";i:5;s:19:\"2023-02-23 13:13:04\";i:6;s:19:\"2023-02-23 13:14:21\";i:7;s:19:\"2023-02-23 13:14:28\";i:8;s:19:\"2023-03-09 16:56:33\";i:9;s:19:\"2023-03-09 16:57:04\";i:10;s:19:\"2023-05-07 22:37:47\";i:11;s:19:\"2023-06-17 09:55:55\";i:12;s:19:\"2023-06-17 09:57:10\";i:13;s:19:\"2023-06-17 09:57:24\";i:14;s:19:\"2023-06-17 10:03:05\";i:15;s:19:\"2023-08-30 11:29:55\";i:16;s:19:\"2024-11-18 20:24:00\";i:17;s:19:\"2024-11-18 20:31:08\";i:18;s:19:\"2024-11-18 20:34:00\";i:19;s:19:\"2024-11-18 20:34:47\";i:20;s:19:\"2024-11-18 20:35:07\";i:21;s:19:\"2025-01-03 11:10:26\";i:22;s:19:\"2025-01-03 11:11:46\";i:23;s:19:\"2025-01-03 11:11:55\";i:24;s:19:\"2025-01-03 11:12:51\";i:25;s:19:\"2025-01-03 11:12:55\";i:26;s:19:\"2025-01-03 11:13:33\";i:27;s:19:\"2025-01-03 11:19:19\";i:28;s:19:\"2025-01-03 11:19:49\";i:29;s:19:\"2025-04-05 02:24:40\";i:30;s:19:\"2025-05-30 13:34:50\";i:31;s:19:\"2025-06-06 19:35:39\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type null\";s:4:\"file\";s:115:\"/home/novathem/domains/polarisweb.ir/public_html/edit/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1578;s:5:\"trace\";b:1;}}s:32:\"c1bc32200402a47afaed47c65204f1ac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-09 16:51:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-09 16:51:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"2851dc48812c3ef1ede0338bd4f914f0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-09 16:51:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-09 16:51:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"969f265c7c46579880150f21bb9995c0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-09 16:51:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-09 16:51:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"35ad55d4dd2b43702c1946dc1b9305d8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-09 16:51:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-09 16:51:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"18c12840eeb304e5f454a5a93ef7f8c4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-09 16:51:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-09 16:51:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4f7d9b933b7528571cb639d21ffa0be0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-04 14:31:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-04 14:31:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8705aeb6d31ce0a05b04361c7f81fe96\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-04 14:31:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-04 14:31:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"817c7e4b176033f8d58898d2e4d0cf46\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-04 14:31:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-04 14:31:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"ba793ed237f16db8a55073355c12bc55\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-04 14:31:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.3\";s:2:\"to\";s:6:\"3.12.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-04 14:31:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.3\";s:2:\"to\";s:6:\"3.12.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"eb5d6888148ebce318650da6e4158b9f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-04 14:31:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.3\";s:2:\"to\";s:6:\"3.12.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-04 14:31:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.3\";s:2:\"to\";s:6:\"3.12.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"68e75697b3ac1bccc0867bc82695f7c8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-17 09:46:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-17 09:46:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"74cbcae938a18cdabe9f62dc35ea8a25\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-17 09:46:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-17 09:46:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"42593d4df6fa233b7cbc4b7fb3411253\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-17 09:46:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-17 09:46:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9507c51aea5bfb92d30ba22963a56bbb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-17 09:46:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-17 09:46:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"629258beb4bfcf6f8a9434f3c92d6c48\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-17 09:46:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-17 09:46:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0588df86111f845963045fe714865b40\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"52335975fcace3945363817738c1459f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"0d7ce255075f29ec7138f3ecd74b4d68\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"7c4568f32cc0d89a2543461ebc9a1af1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:06\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"82a4b5a06d0b0dccaaa539fbaad709e9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:06\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9e147c8820c9f80f59142d67721e129e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-21 11:12:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-21 11:12:07\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.14.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"682443d8b181d653c26d525df032d8f2\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"33694\";s:7:\"\0*\0file\";s:101:\"https://novatheme.ir/edit/wp-content/plugins/elementor/assets/js/e-react-promotions.min.js?ver=3.26.3\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-01-03 07:28:57\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:26:\"elementorV2 is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-01-03 07:28:57\";i:1;s:19:\"2025-01-03 07:42:46\";i:2;s:19:\"2025-01-03 07:43:24\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1735889337\";s:7:\"message\";s:26:\"elementorV2 is not defined\";s:3:\"url\";s:101:\"https://novatheme.ir/edit/wp-content/plugins/elementor/assets/js/e-react-promotions.min.js?ver=3.26.3\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"33694\";}}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:109:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;s:7:\"\0*\0date\";s:19:\"2025-01-03 11:13:39\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 11:13:39\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:109:\"/home/novathem/domains/novatheme.ir/public_html/edit/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}}s:32:\"0578ae53fb4314e8c0963b21da43d809\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"780868\";s:7:\"\0*\0file\";s:89:\"https://novatheme.ir/edit/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-01-03 07:43:41\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:92:\"can&#039;t access property &quot;get&quot;, elementor.getCurrentElement().model is undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 07:43:41\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1735890221\";s:7:\"message\";s:77:\"can\'t access property \"get\", elementor.getCurrentElement().model is undefined\";s:3:\"url\";s:89:\"https://novatheme.ir/edit/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"780868\";}}s:32:\"6f3c4c576d529246af0052952f16afa5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-05 02:28:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-05 02:28:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"028496655369dc35cb19c198c3f8199c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-05 02:28:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-05 02:28:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"21c46be2a67ece969f5eab90a306699e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-05 02:28:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-05 02:28:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"295ded33c564ab02f85495e3948d5c88\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-05 02:28:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.14.0\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-05 02:28:30\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.14.0\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ece54919b171f18b178a908261967af1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-20 18:00:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-20 18:00:24\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"dbf48e9b2c8b2bc381a52c0e1e539dfd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-20 18:00:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-20 18:00:24\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"3f13f0c3c6514f08b425cb5509963124\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-20 18:00:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-20 18:00:24\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"9ed7339c50d5a624d97db1e677e1d779\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-20 18:00:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-20 18:00:24\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c5e440d6e3cb3f6cccde6f7b6bb37b63\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-20 18:00:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-20 18:00:24\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"dedb520ca6720aee28bccd9e31bc3578\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-27 12:58:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 12:58:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"61372e49281f55409fa122f03c74e85d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-27 12:58:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 12:58:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"767573cb3aaf6f072a84a56923890794\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-27 12:58:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 12:58:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ee7b0b9219038ca1454b120fd3162950\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-27 12:58:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 12:58:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d018d929500d73066f73ae16b2f50980\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-27 12:58:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 12:58:23\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("407", "_elementor_settings_update_time", "1655550559", "yes");
INSERT INTO `wp_options` VALUES("408", "elementor_cpt_support", "a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:9:\"portfolio\";i:4;s:7:\"product\";}", "yes");
INSERT INTO `wp_options` VALUES("409", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("410", "elementor_disable_typography_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("411", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("412", "elementor_notice", "", "yes");
INSERT INTO `wp_options` VALUES("413", "elementor_google_maps_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("414", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_options` VALUES("415", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_options` VALUES("416", "elementor_unfiltered_files_upload", "1", "yes");
INSERT INTO `wp_options` VALUES("417", "elementor_font_display", "auto", "yes");
INSERT INTO `wp_options` VALUES("418", "elementor_load_fa4_shim", "yes", "yes");
INSERT INTO `wp_options` VALUES("419", "elementor_experiment-e_dom_optimization", "inactive", "yes");
INSERT INTO `wp_options` VALUES("420", "elementor_experiment-e_optimized_assets_loading", "inactive", "yes");
INSERT INTO `wp_options` VALUES("421", "elementor_experiment-e_optimized_css_loading", "inactive", "yes");
INSERT INTO `wp_options` VALUES("422", "elementor_experiment-e_font_icon_svg", "inactive", "yes");
INSERT INTO `wp_options` VALUES("423", "elementor_experiment-a11y_improvements", "inactive", "yes");
INSERT INTO `wp_options` VALUES("424", "elementor_experiment-e_import_export", "inactive", "yes");
INSERT INTO `wp_options` VALUES("425", "elementor_experiment-additional_custom_breakpoints", "inactive", "yes");
INSERT INTO `wp_options` VALUES("426", "elementor_experiment-landing-pages", "inactive", "yes");
INSERT INTO `wp_options` VALUES("427", "elementor_experiment-elements-color-picker", "inactive", "yes");
INSERT INTO `wp_options` VALUES("428", "elementor_experiment-admin-top-bar", "inactive", "yes");
INSERT INTO `wp_options` VALUES("435", "elementor_controls_usage", "a:3:{s:7:\"section\";a:41:{s:8:\"icon-box\";a:2:{s:5:\"count\";i:16;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:13:\"selected_icon\";i:16;s:10:\"title_text\";i:16;s:16:\"description_text\";i:16;s:8:\"position\";i:16;}}s:5:\"style\";a:2:{s:18:\"section_style_icon\";a:4:{s:13:\"primary_color\";i:14;s:10:\"icon_space\";i:14;s:9:\"icon_size\";i:14;s:19:\"hover_primary_color\";i:10;}s:21:\"section_style_content\";a:13:{s:10:\"text_align\";i:16;s:11:\"title_color\";i:14;s:27:\"title_typography_typography\";i:16;s:26:\"title_typography_font_size\";i:16;s:28:\"title_typography_font_weight\";i:16;s:26:\"content_vertical_alignment\";i:4;s:18:\"title_bottom_space\";i:4;s:28:\"title_typography_font_family\";i:8;s:17:\"description_color\";i:2;s:33:\"description_typography_typography\";i:12;s:34:\"description_typography_font_family\";i:10;s:34:\"description_typography_font_weight\";i:12;s:32:\"description_typography_font_size\";i:2;}}s:8:\"advanced\";a:3:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:12;s:8:\"_padding\";i:4;}s:15:\"_section_border\";a:4:{s:14:\"_border_border\";i:2;s:13:\"_border_width\";i:4;s:13:\"_border_color\";i:4;s:14:\"_border_radius\";i:4;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:6;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:114;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:3:{s:12:\"_inline_size\";i:114;s:16:\"content_position\";i:32;s:5:\"align\";i:58;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:53;s:6:\"margin\";i:5;}s:19:\"_section_responsive\";a:1:{s:11:\"hide_mobile\";i:2;}}s:5:\"style\";a:2:{s:14:\"section_border\";a:3:{s:13:\"border_radius\";i:12;s:21:\"box_shadow_box_shadow\";i:14;s:26:\"box_shadow_box_shadow_type\";i:4;}s:13:\"section_style\";a:2:{s:21:\"background_background\";i:5;s:16:\"background_color\";i:5;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:1:{s:16:\"social_icon_list\";i:5;}}s:5:\"style\";a:2:{s:20:\"section_social_style\";a:5:{s:12:\"icon_padding\";i:4;s:12:\"icon_spacing\";i:4;s:10:\"icon_color\";i:3;s:18:\"icon_primary_color\";i:3;s:20:\"icon_secondary_color\";i:1;}s:20:\"section_social_hover\";a:1:{s:15:\"hover_animation\";i:5;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:78;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:28;}s:14:\"section_layout\";a:2:{s:6:\"layout\";i:3;s:15:\"stretch_section\";i:3;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:7:{s:21:\"background_background\";i:44;s:16:\"background_color\";i:37;s:18:\"background_color_b\";i:7;s:25:\"background_gradient_angle\";i:7;s:16:\"background_image\";i:8;s:17:\"background_repeat\";i:8;s:15:\"background_size\";i:8;}s:14:\"section_border\";a:6:{s:26:\"box_shadow_box_shadow_type\";i:36;s:21:\"box_shadow_box_shadow\";i:37;s:13:\"border_radius\";i:29;s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}s:26:\"section_background_overlay\";a:5:{s:29:\"background_overlay_background\";i:8;s:24:\"background_overlay_color\";i:8;s:26:\"background_overlay_color_b\";i:8;s:26:\"background_overlay_opacity\";i:8;s:33:\"background_overlay_gradient_angle\";i:6;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:18;s:6:\"margin\";i:30;}s:19:\"_section_responsive\";a:2:{s:20:\"reverse_order_tablet\";i:6;s:20:\"reverse_order_mobile\";i:6;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:2:{s:5:\"image\";i:7;s:10:\"image_size\";i:4;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:5:\"width\";i:7;s:6:\"height\";i:4;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:7;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:6:\"Search\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:3:{s:5:\"style\";a:3:{s:19:\"section_condfgtent3\";a:4:{s:7:\"searlor\";i:3;s:5:\"seaac\";i:3;s:15:\"search-icocolor\";i:3;s:9:\"searcback\";i:3;}s:16:\"section_content1\";a:4:{s:21:\"form-box-border-color\";i:8;s:14:\"list-bac-color\";i:2;s:16:\"input-text-color\";i:2;s:15:\"input-bac-color\";i:2;}s:16:\"section_content3\";a:4:{s:17:\"search-icon-color\";i:2;s:15:\"search-icon-bac\";i:2;s:23:\"search-icon-hover-color\";i:2;s:22:\"search-icon-hover-back\";i:2;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:3;s:8:\"_padding\";i:1;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}}s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:11:\"search_type\";i:7;s:9:\"show-list\";i:8;s:9:\"search-in\";i:8;s:18:\"search-placeholder\";i:3;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:36;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:2:{s:5:\"title\";i:36;s:5:\"align\";i:9;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:5:{s:11:\"title_color\";i:27;s:21:\"typography_typography\";i:32;s:20:\"typography_font_size\";i:32;s:22:\"typography_font_weight\";i:32;s:22:\"typography_font_family\";i:8;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:9;s:8:\"_padding\";i:25;}s:15:\"_section_border\";a:7:{s:13:\"_border_width\";i:25;s:13:\"_border_color\";i:21;s:14:\"_border_border\";i:21;s:22:\"_box_shadow_box_shadow\";i:17;s:20:\"_border_hover_border\";i:4;s:19:\"_border_hover_width\";i:4;s:24:\"_border_hover_transition\";i:4;}s:19:\"_section_background\";a:1:{s:17:\"_background_color\";i:17;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:24;}}}}s:10:\"Breadcrumb\";a:2:{s:5:\"count\";i:9;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:20:\"sectionsdfghjk_style\";a:5:{s:15:\"sep_cosdfghjlor\";i:9;s:24:\"this_tisdfghjkltle_color\";i:9;s:34:\"this_currentsdftgyujil_title_color\";i:9;s:37:\"content_typosdfghjkgraphy3_typography\";i:3;s:38:\"content_typosdfghjkgraphy3_font_weight\";i:3;}}}}s:9:\"sideposts\";a:2:{s:5:\"count\";i:9;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:12:\"border_style\";i:9;s:5:\"image\";i:7;s:8:\"posttype\";i:3;s:9:\"read_more\";i:4;s:9:\"post_pers\";i:1;}}s:5:\"style\";a:3:{s:21:\"sectiosdfghjkn_cesnt3\";a:6:{s:20:\"coiuytrsdfghjkleolor\";i:9;s:20:\"conoiuytrsdfghjkllor\";i:9;s:27:\"contensdfghjkt_y_typography\";i:9;s:26:\"contensdfghjkt_y_font_size\";i:7;s:28:\"contensdfghjkt_y_font_weight\";i:9;s:14:\"consdfghjkllor\";i:9;}s:14:\"section_cesnt3\";a:2:{s:12:\"coiuytreolor\";i:9;s:12:\"conoiuytrlor\";i:9;}s:17:\"sectiosdfghjksdt3\";a:5:{s:19:\"coidfghnjmkukleolor\";i:9;s:20:\"condfghjkoifghjkllor\";i:9;s:28:\"contenjdfghjkkt_y_typography\";i:2;s:29:\"contenjdfghjkkt_y_font_family\";i:2;s:29:\"contenjdfghjkkt_y_font_weight\";i:2;}}s:8:\"advanced\";a:3:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:7;}s:19:\"_section_background\";a:1:{s:17:\"_background_color\";i:7;}s:15:\"_section_border\";a:2:{s:14:\"_border_radius\";i:7;s:22:\"_box_shadow_box_shadow\";i:7;}}}}s:8:\"Category\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:10:\"item-style\";a:5:{s:11:\"title_color\";i:7;s:17:\"title_color_hover\";i:7;s:26:\"text-typography_typography\";i:1;s:27:\"text-typography_font_family\";i:1;s:27:\"text-typography_font_weight\";i:1;}}s:7:\"content\";a:1:{s:16:\"section_content5\";a:1:{s:8:\"cat_type\";i:3;}}}}s:8:\"Thetitle\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"content_section\";a:4:{s:11:\"title_color\";i:5;s:29:\"content_typography_typography\";i:5;s:28:\"content_typography_font_size\";i:5;s:30:\"content_typography_font_weight\";i:5;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:5;}}}}s:15:\"Postinformation\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:6;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:2;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}s:5:\"style\";a:1:{s:13:\"style_section\";a:7:{s:20:\"coiuytrsdfghjkleolor\";i:6;s:20:\"conoiuytrsdfghjkllor\";i:6;s:10:\"icon_color\";i:6;s:16:\"text_cvvgjhgolor\";i:4;s:29:\"content_typography_typography\";i:2;s:30:\"content_typography_font_weight\";i:2;s:33:\"content_typography_letter_spacing\";i:2;}}}}s:7:\"Content\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:0:{}}s:5:\"Share\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:14:\"linkedin_title\";i:5;s:14:\"whatsapp_title\";i:5;s:14:\"telegram_title\";i:5;s:10:\"mail_title\";i:5;s:12:\"reddit_title\";i:5;s:13:\"twitter_title\";i:5;s:14:\"facebook_title\";i:5;s:15:\"pinterest_title\";i:5;s:14:\"reddit_control\";i:3;s:17:\"pinterest_control\";i:3;}}s:5:\"style\";a:2:{s:20:\"section_svdconte2nt1\";a:8:{s:6:\"p_cfre\";i:5;s:7:\"p_coler\";i:5;s:4:\"size\";i:5;s:8:\"p_c2oler\";i:5;s:8:\"p_col3er\";i:5;s:30:\"content_typography1_typography\";i:5;s:29:\"content_typography1_font_size\";i:5;s:31:\"content_typography1_font_weight\";i:5;}s:19:\"section_svdcontent1\";a:3:{s:4:\"siza\";i:5;s:10:\"p_cfsolore\";i:5;s:15:\"p_color_hofsver\";i:5;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:5;}s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:5;s:17:\"_background_color\";i:5;}s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:5;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}}}}s:13:\"pre_next_page\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:15:\"section_content\";a:5:{s:5:\"color\";i:5;s:9:\"contfolor\";i:5;s:18:\"content_csfsdfolor\";i:5;s:13:\"conteft_color\";i:5;s:9:\"conteolor\";i:5;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:5;}}}}s:8:\"Comments\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:0:{}}s:8:\"Projects\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:16:\"section_con3tent\";a:3:{s:6:\"slider\";i:2;s:13:\"count_in_line\";i:2;s:5:\"image\";i:2;}}s:5:\"style\";a:4:{s:21:\"sectiosdfghjkn_cesnt3\";a:5:{s:20:\"coiuytrsdfghjkleolor\";i:2;s:20:\"conoiuytrsdfghjkllor\";i:2;s:27:\"contensdfghjkt_y_typography\";i:2;s:26:\"contensdfghjkt_y_font_size\";i:2;s:28:\"contensdfghjkt_y_font_weight\";i:2;}s:8:\"secesnt3\";a:1:{s:7:\"coiulor\";i:2;}s:17:\"sectiosdfghjksdt3\";a:4:{s:19:\"coidfghnjmkukleolor\";i:2;s:28:\"contenjdfghjkkt_y_typography\";i:1;s:29:\"contenjdfghjkkt_y_font_family\";i:1;s:29:\"contenjdfghjkkt_y_font_weight\";i:1;}s:13:\"section_cent3\";a:6:{s:5:\"pxamn\";i:2;s:3:\"sre\";i:2;s:5:\"pxdre\";i:2;s:2:\"px\";i:2;s:4:\"p2re\";i:2;s:2:\"pe\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:16:\"Related-Projects\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:0:{}}s:34:\"wp-widget-woocommerce_price_filter\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:15:\"Archiveproducts\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:3:{s:15:\"content_section\";a:5:{s:7:\"t_color\";i:1;s:13:\"t_color_hover\";i:1;s:32:\"content_typogwseraphy_typography\";i:1;s:31:\"content_typogwseraphy_font_size\";i:1;s:33:\"content_typogwseraphy_font_weight\";i:1;}s:16:\"content_section2\";a:6:{s:6:\"t_cdor\";i:1;s:11:\"t_colorover\";i:1;s:7:\"t_c2dor\";i:1;s:12:\"t_colorov2er\";i:1;s:31:\"content_wtypodgraphy_typography\";i:1;s:32:\"content_wtypodgraphy_font_weight\";i:1;}s:17:\"content_section32\";a:2:{s:5:\"t_cdr\";i:1;s:9:\"t_colrver\";i:1;}}}}s:12:\"PRODUCTIMAGE\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:12:\"PRODUCTPRICE\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:13:\"PRODUCTRATING\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:14:\"PRODUCTEXCERPT\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:11:\"add-to-cart\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:11:\"PRODUCTMETA\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:11:\"PRODUCTTABS\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:2:{s:9:\"tab-style\";a:5:{s:9:\"tab-color\";i:1;s:7:\"tab-bac\";i:1;s:15:\"tab-color-hover\";i:1;s:13:\"tab-hover-bac\";i:1;s:16:\"tab-color-active\";i:1;}s:13:\"style_section\";a:1:{s:11:\"stars-color\";i:1;}}}}s:14:\"RELATEDPRODUCT\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:3:{s:15:\"content_section\";a:5:{s:7:\"t_color\";i:1;s:13:\"t_color_hover\";i:1;s:32:\"content_typogwseraphy_typography\";i:1;s:31:\"content_typogwseraphy_font_size\";i:1;s:33:\"content_typogwseraphy_font_weight\";i:1;}s:16:\"content_section2\";a:6:{s:6:\"t_cdor\";i:1;s:11:\"t_colorover\";i:1;s:7:\"t_c2dor\";i:1;s:12:\"t_colorov2er\";i:1;s:31:\"content_wtypodgraphy_typography\";i:1;s:32:\"content_wtypodgraphy_font_weight\";i:1;}s:17:\"content_section32\";a:2:{s:5:\"t_cdr\";i:1;s:9:\"t_colrver\";i:1;}}}}s:13:\"Post_thumnail\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:4:{s:5:\"width\";i:2;s:6:\"height\";i:2;s:6:\"margin\";i:2;s:5:\"image\";i:2;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:14:\"_border_radius\";i:2;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:15:\"Relatedarticles\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:4:{s:4:\"icon\";i:2;s:5:\"image\";i:2;s:9:\"read_more\";i:1;s:7:\"cattext\";i:1;}}s:5:\"style\";a:4:{s:21:\"sectiosdfghjkn_cesnt3\";a:3:{s:20:\"coiuytrsdfghjkleolor\";i:1;s:27:\"contensdfghjkt_y_typography\";i:1;s:28:\"contensdfghjkt_y_font_weight\";i:1;}s:10:\"sectiosdt3\";a:1:{s:11:\"coiukleolor\";i:1;}s:8:\"secesnt3\";a:6:{s:7:\"coiulor\";i:1;s:8:\"conorlor\";i:1;s:11:\"coisdfgulor\";i:1;s:22:\"consdfgvt_y_typography\";i:1;s:21:\"consdfgvt_y_font_size\";i:1;s:23:\"consdfgvt_y_font_weight\";i:1;}s:17:\"sectiosdfghjksdt3\";a:2:{s:19:\"coidfghnjmkukleolor\";i:1;s:20:\"condfghjkoifghjkllor\";i:1;}}}}s:6:\"Header\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:5:\"style\";a:11:{s:14:\"section_cesnt3\";a:5:{s:12:\"conoiuytrlor\";i:2;s:20:\"content_y_typography\";i:2;s:19:\"content_y_font_size\";i:2;s:21:\"content_y_font_weight\";i:2;s:13:\"coiuyt3reolor\";i:2;}s:9:\"sectisnt3\";a:4:{s:8:\"coytrlor\";i:2;s:7:\"cyeolor\";i:2;s:7:\"coyrlor\";i:2;s:6:\"coytor\";i:2;}s:17:\"sectionsdf_cesnt3\";a:6:{s:14:\"coiuytrsdeolor\";i:2;s:15:\"conoiuysdftrlor\";i:2;s:16:\"coiusdfyt3reolor\";i:2;s:24:\"contesdfgnt_y_typography\";i:2;s:23:\"contesdfgnt_y_font_size\";i:2;s:25:\"contesdfgnt_y_font_weight\";i:2;}s:10:\"sec7cesnt3\";a:4:{s:22:\"background2_background\";i:2;s:17:\"background2_color\";i:2;s:19:\"background2_color_b\";i:2;s:26:\"background2_gradient_angle\";i:2;}s:11:\"sectisndft3\";a:9:{s:11:\"conodftrlor\";i:2;s:8:\"coiuolor\";i:2;s:11:\"coiuoloiuor\";i:2;s:30:\"cart-box-background_background\";i:2;s:25:\"cart-box-background_image\";i:2;s:28:\"cart-box-background_position\";i:2;s:26:\"cart-box-background_repeat\";i:2;s:24:\"cart-box-background_size\";i:2;s:6:\"conlor\";i:2;}s:17:\"section_contengft\";a:9:{s:11:\"title_color\";i:2;s:29:\"content_typography_typography\";i:2;s:28:\"content_typography_font_size\";i:2;s:30:\"content_typography_font_weight\";i:2;s:7:\"p_clore\";i:2;s:9:\"p_co2lver\";i:2;s:11:\"p_clsdf2ore\";i:2;s:12:\"p_csdfo2lver\";i:2;s:8:\"p_colver\";i:2;}s:16:\"section_content1\";a:3:{s:14:\"list-bac-color\";i:2;s:16:\"input-text-color\";i:2;s:15:\"input-bac-color\";i:2;}s:16:\"section_content3\";a:4:{s:17:\"search-icon-color\";i:2;s:15:\"search-icon-bac\";i:2;s:23:\"search-icon-hover-color\";i:2;s:22:\"search-icon-hover-back\";i:2;}s:19:\"section_condfgtent3\";a:4:{s:7:\"searlor\";i:2;s:5:\"seaac\";i:2;s:15:\"search-icocolor\";i:2;s:9:\"searcback\";i:2;}s:14:\"sect1tesdfgnt3\";a:4:{s:8:\"sear1lor\";i:2;s:6:\"s1eaac\";i:2;s:4:\"se1r\";i:2;s:7:\"1rcback\";i:2;}s:10:\"total-btns\";a:8:{s:16:\"total-background\";i:2;s:16:\"total-text-color\";i:2;s:32:\"total-text-typography_typography\";i:2;s:31:\"total-text-typography_font_size\";i:2;s:33:\"total-text-typography_font_weight\";i:2;s:16:\"total-btns-color\";i:2;s:32:\"total-btns-background_background\";i:2;s:27:\"total-btns-background_color\";i:2;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:2:{s:27:\"_box_shadow_box_shadow_type\";i:2;s:22:\"_box_shadow_box_shadow\";i:2;}}s:7:\"content\";a:1:{s:17:\"section_wertyuiop\";a:1:{s:12:\"show_current\";i:2;}}}}s:10:\"Mobilemenu\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:9:\"menu_list\";i:3;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:21:\"_element_width_tablet\";i:3;}s:19:\"_section_responsive\";a:1:{s:12:\"hide_desktop\";i:1;}}}}s:10:\"Headermenu\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:9:\"menu_list\";i:3;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}s:19:\"_section_responsive\";a:2:{s:11:\"hide_tablet\";i:3;s:11:\"hide_mobile\";i:3;}}s:5:\"style\";a:2:{s:14:\"section_cesnt3\";a:6:{s:20:\"content_y_typography\";i:3;s:19:\"content_y_font_size\";i:3;s:21:\"content_y_font_weight\";i:3;s:12:\"coiuytreolor\";i:1;s:12:\"conoiuytrlor\";i:1;s:13:\"coiuyt3reolor\";i:1;}s:9:\"sectisnt3\";a:6:{s:19:\"contet_y_typography\";i:3;s:18:\"contet_y_font_size\";i:3;s:20:\"contet_y_font_weight\";i:3;s:23:\"contsdfget_y_typography\";i:3;s:22:\"contsdfget_y_font_size\";i:3;s:24:\"contsdfget_y_font_weight\";i:3;}}}}s:5:\"Login\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}}s:5:\"style\";a:1:{s:14:\"sect1tesdfgnt3\";a:4:{s:8:\"sear1lor\";i:3;s:6:\"s1eaac\";i:3;s:4:\"se1r\";i:3;s:7:\"1rcback\";i:3;}}}}s:8:\"Minicart\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:5:\"style\";a:2:{s:11:\"sectisndft3\";a:8:{s:11:\"conodftrlor\";i:3;s:8:\"coiuolor\";i:3;s:6:\"conlor\";i:3;s:11:\"coiuoloiuor\";i:3;s:30:\"cart-box-background_background\";i:3;s:25:\"cart-box-background_image\";i:3;s:26:\"cart-box-background_repeat\";i:3;s:24:\"cart-box-background_size\";i:3;}s:10:\"total-btns\";a:9:{s:16:\"total-background\";i:3;s:14:\"total-bt-color\";i:3;s:16:\"total-text-color\";i:3;s:32:\"total-text-typography_typography\";i:3;s:31:\"total-text-typography_font_size\";i:3;s:33:\"total-text-typography_font_weight\";i:3;s:16:\"total-btns-color\";i:3;s:32:\"total-btns-background_background\";i:3;s:27:\"total-btns-background_color\";i:3;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:3;}}}}s:8:\"Language\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:8:\"advanced\";a:3:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:3;}s:19:\"_section_responsive\";a:2:{s:11:\"hide_tablet\";i:3;s:11:\"hide_mobile\";i:3;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}s:7:\"content\";a:1:{s:17:\"section_wertyuiop\";a:1:{s:12:\"show_current\";i:3;}}s:5:\"style\";a:1:{s:17:\"section_contengft\";a:4:{s:8:\"p_cl2ore\";i:3;s:9:\"p_co2lver\";i:3;s:11:\"p_clsdf2ore\";i:3;s:12:\"p_csdfo2lver\";i:3;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:4;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:6:{s:10:\"text_color\";i:4;s:21:\"typography_typography\";i:4;s:22:\"typography_font_family\";i:4;s:20:\"typography_font_size\";i:4;s:22:\"typography_font_weight\";i:4;s:5:\"align\";i:1;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:2;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:4:\"menu\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:15:\"content_section\";a:3:{s:11:\"title_color\";i:2;s:17:\"title_color_hover\";i:2;s:18:\"title_color_active\";i:2;}}s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:9:\"menu_list\";i:1;}}}}s:4:\"Back\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"icon\";i:2;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:5:{s:14:\"_element_width\";i:2;s:9:\"_position\";i:2;s:9:\"_offset_x\";i:2;s:21:\"_offset_orientation_v\";i:2;s:13:\"_offset_y_end\";i:2;}}s:5:\"style\";a:1:{s:17:\"sedsction_content\";a:5:{s:21:\"back_to_up_background\";i:2;s:27:\"back_to_up_background_hover\";i:2;s:16:\"back_toackground\";i:2;s:21:\"back_to_up_back_hover\";i:2;s:10:\"icon_color\";i:2;}}}}s:10:\"Side_image\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:3:{s:14:\"list_icon_nova\";i:2;s:6:\"width3\";i:2;s:5:\"wight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:8:\"Articles\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:6:{s:4:\"icon\";i:2;s:13:\"count_in_line\";i:2;s:13:\"sliderarticle\";i:2;s:9:\"read_more\";i:1;s:9:\"read_time\";i:1;s:7:\"cattext\";i:1;}}s:5:\"style\";a:4:{s:21:\"sectiosdfghjkn_cesnt3\";a:3:{s:20:\"coiuytrsdfghjkleolor\";i:2;s:27:\"contensdfghjkt_y_typography\";i:2;s:28:\"contensdfghjkt_y_font_weight\";i:2;}s:10:\"sectiosdt3\";a:1:{s:11:\"coiukleolor\";i:2;}s:8:\"secesnt3\";a:6:{s:7:\"coiulor\";i:2;s:8:\"conorlor\";i:2;s:11:\"coisdfgulor\";i:2;s:22:\"consdfgvt_y_typography\";i:2;s:21:\"consdfgvt_y_font_size\";i:2;s:23:\"consdfgvt_y_font_weight\";i:2;}s:17:\"sectiosdfghjksdt3\";a:5:{s:19:\"coidfghnjmkukleolor\";i:2;s:20:\"condfghjkoifghjkllor\";i:2;s:28:\"contenjdfghjkkt_y_typography\";i:1;s:29:\"contenjdfghjkkt_y_font_family\";i:1;s:29:\"contenjdfghjkkt_y_font_weight\";i:1;}}}}}s:7:\"wp-page\";a:29:{s:10:\"Breadcrumb\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:20:\"sectionsdfghjk_style\";a:5:{s:15:\"sep_cosdfghjlor\";i:5;s:24:\"this_tisdfghjkltle_color\";i:5;s:34:\"this_currentsdftgyujil_title_color\";i:5;s:37:\"content_typosdfghjkgraphy3_typography\";i:1;s:38:\"content_typosdfghjkgraphy3_font_weight\";i:1;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:2;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:124;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:3:{s:12:\"_inline_size\";i:124;s:5:\"align\";i:24;s:16:\"content_position\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:45;s:6:\"margin\";i:18;}}s:5:\"style\";a:2:{s:14:\"section_border\";a:5:{s:13:\"border_radius\";i:23;s:21:\"box_shadow_box_shadow\";i:23;s:12:\"border_width\";i:16;s:12:\"border_color\";i:16;s:26:\"box_shadow_box_shadow_type\";i:18;}s:13:\"section_style\";a:2:{s:21:\"background_background\";i:18;s:16:\"background_color\";i:20;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:77;s:8:\"controls\";a:3:{s:5:\"style\";a:3:{s:18:\"section_background\";a:7:{s:21:\"background_background\";i:32;s:16:\"background_image\";i:12;s:17:\"background_repeat\";i:8;s:15:\"background_size\";i:8;s:16:\"background_color\";i:27;s:18:\"background_color_b\";i:1;s:25:\"background_gradient_angle\";i:1;}s:26:\"section_background_overlay\";a:5:{s:29:\"background_overlay_background\";i:10;s:24:\"background_overlay_color\";i:10;s:26:\"background_overlay_color_b\";i:2;s:33:\"background_overlay_gradient_angle\";i:2;s:26:\"background_overlay_opacity\";i:8;}s:14:\"section_border\";a:3:{s:13:\"border_radius\";i:13;s:26:\"box_shadow_box_shadow_type\";i:13;s:21:\"box_shadow_box_shadow\";i:17;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:22;s:6:\"margin\";i:40;}s:19:\"_section_responsive\";a:2:{s:20:\"reverse_order_tablet\";i:4;s:20:\"reverse_order_mobile\";i:4;}}s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:29;}s:14:\"section_layout\";a:2:{s:6:\"layout\";i:4;s:15:\"stretch_section\";i:4;}}}}s:6:\"Search\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:11:\"search_type\";i:3;s:9:\"show-list\";i:3;s:9:\"search-in\";i:3;s:18:\"search-placeholder\";i:1;}}s:5:\"style\";a:1:{s:16:\"section_content1\";a:1:{s:21:\"form-box-border-color\";i:3;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:36;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:2:{s:5:\"title\";i:36;s:5:\"align\";i:20;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:23;s:21:\"typography_typography\";i:15;s:20:\"typography_font_size\";i:15;s:22:\"typography_font_weight\";i:15;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:8;}s:19:\"_section_background\";a:1:{s:17:\"_background_color\";i:8;}s:15:\"_section_border\";a:5:{s:14:\"_border_border\";i:15;s:13:\"_border_width\";i:15;s:13:\"_border_color\";i:15;s:22:\"_box_shadow_box_shadow\";i:8;s:14:\"_border_radius\";i:2;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:15;}}}}s:10:\"Side_image\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:3:{s:14:\"list_icon_nova\";i:2;s:6:\"width3\";i:2;s:5:\"wight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:9:\"sideposts\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_content\";a:3:{s:12:\"border_style\";i:3;s:5:\"image\";i:3;s:9:\"read_more\";i:1;}}s:5:\"style\";a:3:{s:21:\"sectiosdfghjkn_cesnt3\";a:6:{s:20:\"coiuytrsdfghjkleolor\";i:3;s:20:\"conoiuytrsdfghjkllor\";i:3;s:27:\"contensdfghjkt_y_typography\";i:3;s:26:\"contensdfghjkt_y_font_size\";i:3;s:28:\"contensdfghjkt_y_font_weight\";i:3;s:14:\"consdfghjkllor\";i:3;}s:14:\"section_cesnt3\";a:2:{s:12:\"coiuytreolor\";i:3;s:12:\"conoiuytrlor\";i:3;}s:17:\"sectiosdfghjksdt3\";a:5:{s:19:\"coidfghnjmkukleolor\";i:3;s:20:\"condfghjkoifghjkllor\";i:3;s:28:\"contenjdfghjkkt_y_typography\";i:1;s:29:\"contenjdfghjkkt_y_font_family\";i:1;s:29:\"contenjdfghjkkt_y_font_weight\";i:1;}}s:8:\"advanced\";a:3:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:3;}s:19:\"_section_background\";a:1:{s:17:\"_background_color\";i:3;}s:15:\"_section_border\";a:2:{s:14:\"_border_radius\";i:3;s:22:\"_box_shadow_box_shadow\";i:3;}}}}s:8:\"Category\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:10:\"item-style\";a:2:{s:11:\"title_color\";i:3;s:17:\"title_color_hover\";i:3;}}s:7:\"content\";a:1:{s:16:\"section_content5\";a:1:{s:8:\"cat_type\";i:1;}}}}s:8:\"Articles\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:8:{s:4:\"icon\";i:4;s:13:\"count_in_line\";i:2;s:13:\"sliderarticle\";i:2;s:9:\"read_more\";i:2;s:9:\"read_time\";i:2;s:7:\"cattext\";i:2;s:14:\"pageinationoff\";i:1;s:9:\"post_pers\";i:1;}}s:5:\"style\";a:4:{s:21:\"sectiosdfghjkn_cesnt3\";a:3:{s:20:\"coiuytrsdfghjkleolor\";i:4;s:27:\"contensdfghjkt_y_typography\";i:4;s:28:\"contensdfghjkt_y_font_weight\";i:4;}s:10:\"sectiosdt3\";a:1:{s:11:\"coiukleolor\";i:4;}s:8:\"secesnt3\";a:6:{s:7:\"coiulor\";i:4;s:8:\"conorlor\";i:4;s:11:\"coisdfgulor\";i:4;s:22:\"consdfgvt_y_typography\";i:4;s:21:\"consdfgvt_y_font_size\";i:4;s:23:\"consdfgvt_y_font_weight\";i:4;}s:17:\"sectiosdfghjksdt3\";a:5:{s:19:\"coidfghnjmkukleolor\";i:4;s:20:\"condfghjkoifghjkllor\";i:4;s:28:\"contenjdfghjkkt_y_typography\";i:2;s:29:\"contenjdfghjkkt_y_font_family\";i:2;s:29:\"contenjdfghjkkt_y_font_weight\";i:2;}}}}s:15:\"Archiveproducts\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:3:{s:15:\"content_section\";a:5:{s:7:\"t_color\";i:1;s:13:\"t_color_hover\";i:1;s:32:\"content_typogwseraphy_typography\";i:1;s:31:\"content_typogwseraphy_font_size\";i:1;s:33:\"content_typogwseraphy_font_weight\";i:1;}s:16:\"content_section2\";a:6:{s:6:\"t_cdor\";i:1;s:11:\"t_colorover\";i:1;s:7:\"t_c2dor\";i:1;s:12:\"t_colorov2er\";i:1;s:31:\"content_wtypodgraphy_typography\";i:1;s:32:\"content_wtypodgraphy_font_weight\";i:1;}s:17:\"content_section32\";a:2:{s:5:\"t_cdr\";i:1;s:9:\"t_colrver\";i:1;}}}}s:10:\"novaslider\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:2:{s:14:\"section_slides\";a:2:{s:6:\"slides\";i:2;s:13:\"slides_height\";i:2;}s:22:\"section_slider_options\";a:1:{s:14:\"pause_on_hover\";i:2;}}s:5:\"style\";a:1:{s:20:\"section_style_slides\";a:1:{s:17:\"content_max_width\";i:2;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:11;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:8;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:5:{s:5:\"align\";i:6;s:10:\"text_color\";i:2;s:21:\"typography_typography\";i:2;s:20:\"typography_font_size\";i:2;s:22:\"typography_font_weight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:5;}}}}s:4:\"ITEM\";a:2:{s:5:\"count\";i:24;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:6:{s:9:\"the_title\";i:24;s:17:\"the_content_title\";i:24;s:7:\"margine\";i:24;s:8:\"margine2\";i:24;s:4:\"icon\";i:24;s:13:\"border_radius\";i:24;}}s:5:\"style\";a:2:{s:16:\"section_content1\";a:11:{s:11:\"title_color\";i:24;s:17:\"title_color_hover\";i:16;s:30:\"content_typography2_typography\";i:24;s:31:\"content_typography2_font_weight\";i:24;s:12:\"title_color2\";i:24;s:18:\"title_color_hover2\";i:16;s:31:\"content_typography22_typography\";i:18;s:30:\"content_typography22_font_size\";i:16;s:32:\"content_typography22_font_weight\";i:18;s:29:\"content_typography2_font_size\";i:8;s:32:\"content_typography22_font_family\";i:2;}s:17:\"section_content13\";a:6:{s:10:\"icon-1size\";i:24;s:11:\"icon-1size2\";i:24;s:16:\"title_c2o222lor2\";i:24;s:22:\"title_colo2r_ho222ver2\";i:24;s:13:\"title_c2olor2\";i:16;s:19:\"title_colo2r_hover2\";i:16;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:8;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:8;s:7:\"link_to\";i:4;s:13:\"open_lightbox\";i:4;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:4:{s:6:\"height\";i:8;s:10:\"object-fit\";i:8;s:19:\"image_border_radius\";i:8;s:5:\"space\";i:4;}}}}s:8:\"icon-box\";a:2:{s:5:\"count\";i:12;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:13:\"selected_icon\";i:12;s:16:\"description_text\";i:12;s:8:\"position\";i:12;s:10:\"title_text\";i:10;}}s:5:\"style\";a:2:{s:18:\"section_style_icon\";a:2:{s:9:\"icon_size\";i:8;s:13:\"primary_color\";i:4;}s:21:\"section_style_content\";a:6:{s:10:\"text_align\";i:12;s:11:\"title_color\";i:4;s:17:\"description_color\";i:4;s:27:\"title_typography_typography\";i:4;s:26:\"title_typography_font_size\";i:4;s:28:\"title_typography_font_weight\";i:4;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:8;}s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:8;s:17:\"_background_color\";i:8;}s:15:\"_section_border\";a:3:{s:14:\"_border_radius\";i:8;s:27:\"_box_shadow_box_shadow_type\";i:8;s:22:\"_box_shadow_box_shadow\";i:8;}s:17:\"_section_position\";a:3:{s:14:\"_element_width\";i:12;s:9:\"_position\";i:8;s:21:\"_offset_orientation_v\";i:8;}}}}s:8:\"Servises\";a:2:{s:5:\"count\";i:8;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:4:{s:4:\"icon\";i:8;s:12:\"widget_title\";i:8;s:16:\"item_description\";i:8;s:13:\"widget_title2\";i:8;}}s:5:\"style\";a:5:{s:15:\"content_section\";a:9:{s:16:\"background_color\";i:8;s:5:\"width\";i:8;s:26:\"box_shadow_box_shadow_type\";i:8;s:21:\"box_shadow_box_shadow\";i:8;s:31:\"box_shadowhover_box_shadow_type\";i:8;s:26:\"box_shadowhover_box_shadow\";i:8;s:26:\"backgroundhover_background\";i:8;s:21:\"backgroundhover_color\";i:8;s:21:\"background_background\";i:8;}s:12:\"secjdfgksdt3\";a:2:{s:17:\"coidfuklesdfgolor\";i:8;s:16:\"condfghsdfjkllor\";i:8;}s:17:\"sectiosdfghjksdt3\";a:5:{s:19:\"coidfghnjmkukleolor\";i:8;s:20:\"condfghjkoifghjkllor\";i:8;s:28:\"contenjdfghjkkt_y_typography\";i:8;s:27:\"contenjdfghjkkt_y_font_size\";i:8;s:29:\"contenjdfghjkkt_y_font_weight\";i:8;}s:9:\"secjksdt3\";a:4:{s:13:\"coidfukleolor\";i:8;s:13:\"condfghjkllor\";i:8;s:23:\"contenjkkt_y_typography\";i:8;s:24:\"contenjkkt_y_font_weight\";i:8;}s:10:\"secjks2dt3\";a:1:{s:14:\"condfgh2jkllor\";i:8;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:13:\"section_style\";a:2:{s:16:\"background_color\";i:4;s:12:\"text_padding\";i:4;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:4;s:23:\"_element_vertical_align\";i:4;}}s:7:\"content\";a:1:{s:14:\"section_button\";a:0:{}}}}s:4:\"icon\";a:2:{s:5:\"count\";i:16;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:13:\"selected_icon\";i:16;}}}}s:7:\"counter\";a:2:{s:5:\"count\";i:16;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_counter\";a:3:{s:13:\"ending_number\";i:16;s:6:\"suffix\";i:16;s:5:\"title\";i:16;}}s:5:\"style\";a:2:{s:14:\"section_number\";a:4:{s:28:\"typography_number_typography\";i:16;s:27:\"typography_number_font_size\";i:16;s:29:\"typography_number_font_weight\";i:16;s:29:\"typography_number_font_family\";i:8;}s:13:\"section_title\";a:4:{s:27:\"typography_title_typography\";i:16;s:28:\"typography_title_font_family\";i:16;s:26:\"typography_title_font_size\";i:16;s:28:\"typography_title_font_weight\";i:16;}}}}s:8:\"Customer\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:2;}}s:5:\"style\";a:2:{s:11:\"sectintent9\";a:2:{s:14:\"coidfgukleolor\";i:2;s:10:\"condfgllor\";i:2;}s:16:\"section_content9\";a:4:{s:19:\"coidfghnjmkukleolor\";i:2;s:20:\"condfghjkoifghjkllor\";i:2;s:28:\"contenjdfghjkkt_y_typography\";i:2;s:29:\"contenjdfghjkkt_y_font_weight\";i:2;}}}}s:12:\"contact_form\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:20:\"content-contact-form\";a:1:{s:23:\"list_contact_form_email\";i:4;}}s:5:\"style\";a:1:{s:18:\"style-contact-form\";a:3:{s:17:\"placeholder_color\";i:4;s:23:\"background_button_color\";i:4;s:29:\"background_input_border_color\";i:2;}}}}s:8:\"Projects\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:21:\"sectiosdfghjkn_cesnt3\";a:5:{s:20:\"coiuytrsdfghjkleolor\";i:2;s:20:\"conoiuytrsdfghjkllor\";i:2;s:27:\"contensdfghjkt_y_typography\";i:2;s:26:\"contensdfghjkt_y_font_size\";i:2;s:28:\"contensdfghjkt_y_font_weight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:5:\"Brand\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:2;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:11:\"section_map\";a:1:{s:7:\"address\";i:2;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:1:{s:16:\"social_icon_list\";i:2;}}s:5:\"style\";a:2:{s:20:\"section_social_style\";a:6:{s:10:\"icon_color\";i:2;s:18:\"icon_primary_color\";i:2;s:20:\"icon_secondary_color\";i:2;s:9:\"icon_size\";i:2;s:12:\"icon_padding\";i:2;s:12:\"icon_spacing\";i:2;}s:20:\"section_social_hover\";a:1:{s:15:\"hover_animation\";i:2;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}s:17:\"_section_position\";a:2:{s:9:\"_position\";i:2;s:21:\"_offset_orientation_v\";i:2;}}}}s:8:\"Thetitle\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"content_section\";a:3:{s:11:\"title_color\";i:2;s:29:\"content_typography_typography\";i:2;s:30:\"content_typography_font_weight\";i:2;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:2;s:23:\"_element_vertical_align\";i:2;}}}}s:8:\"progress\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:16:\"section_progress\";a:3:{s:7:\"percent\";i:6;s:5:\"title\";i:3;s:10:\"inner_text\";i:3;}}s:5:\"style\";a:2:{s:22:\"section_progress_style\";a:3:{s:17:\"bar_border_radius\";i:6;s:31:\"bar_inner_typography_typography\";i:3;s:32:\"bar_inner_typography_font_family\";i:3;}s:13:\"section_title\";a:3:{s:21:\"typography_typography\";i:3;s:22:\"typography_font_family\";i:3;s:22:\"typography_font_weight\";i:3;}}}}s:4:\"Team\";a:2:{s:5:\"count\";i:8;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:9:\"list_icon\";i:8;}}}}s:8:\"products\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:3:{s:15:\"content_section\";a:5:{s:7:\"t_color\";i:1;s:13:\"t_color_hover\";i:1;s:32:\"content_typogwseraphy_typography\";i:1;s:31:\"content_typogwseraphy_font_size\";i:1;s:33:\"content_typogwseraphy_font_weight\";i:1;}s:16:\"content_section2\";a:4:{s:6:\"t_cdor\";i:1;s:11:\"t_colorover\";i:1;s:7:\"t_c2dor\";i:1;s:12:\"t_colorov2er\";i:1;}s:17:\"content_section32\";a:4:{s:5:\"t_cdr\";i:1;s:9:\"t_colrver\";i:1;s:6:\"t_2dor\";i:1;s:9:\"t_colo2er\";i:1;}}}}}s:7:\"wp-post\";a:4:{s:11:\"text-editor\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:9;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:2:{s:10:\"text_color\";i:4;s:5:\"align\";i:3;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:10;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:0:{}}s:11:\"Thequotebox\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"content_section\";a:3:{s:16:\"item_description\";i:2;s:11:\"before_icon\";i:2;s:10:\"after_icon\";i:2;}}s:5:\"style\";a:3:{s:16:\"content_section1\";a:1:{s:11:\"title_color\";i:2;}s:16:\"content_section2\";a:2:{s:9:\"box_color\";i:2;s:6:\"margin\";i:2;}s:16:\"content_section3\";a:2:{s:11:\"icons_color\";i:2;s:4:\"size\";i:2;}}}}}}", "no");
INSERT INTO `wp_options` VALUES("437", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("440", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("467", "Nova_customizer_polylang_settings_en", "a:3:{s:8:\"template\";s:4:\"Nova\";s:4:\"mods\";a:13:{s:18:\"nav_menu_locations\";a:8:{s:11:\"header-menu\";i:0;s:16:\"header-menu___en\";i:0;s:11:\"mobile-menu\";i:0;s:16:\"mobile-menu___en\";i:0;s:11:\"footer-menu\";i:0;s:16:\"footer-menu___en\";i:0;s:9:\"side-menu\";i:0;s:14:\"side-menu___en\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"article_template\";s:2:\"37\";s:15:\"hedaer_template\";s:3:\"852\";s:15:\"footer_template\";s:3:\"858\";s:23:\"single_archive_template\";s:3:\"780\";s:16:\"project_template\";s:3:\"767\";s:23:\"single_project_template\";s:3:\"136\";s:13:\"page_template\";s:3:\"167\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1632751798;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:24:\"archive_product_template\";s:3:\"184\";s:23:\"single_product_template\";s:3:\"280\";s:7:\"loading\";s:8:\"loading6\";}s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("597", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("726", "elementor_clear_cache", "", "yes");
INSERT INTO `wp_options` VALUES("727", "elementor_reset_api_data", "", "yes");
INSERT INTO `wp_options` VALUES("729", "elementor_enable_inspector", "", "yes");
INSERT INTO `wp_options` VALUES("730", "elementor_replace_url", "", "yes");
INSERT INTO `wp_options` VALUES("731", "elementor_rollback", "", "yes");
INSERT INTO `wp_options` VALUES("732", "elementor_re_migrate_globals_separator", "", "yes");
INSERT INTO `wp_options` VALUES("733", "elementor_re_migrate_globals", "", "yes");
INSERT INTO `wp_options` VALUES("734", "elementor_beta", "no", "yes");
INSERT INTO `wp_options` VALUES("735", "elementor_maintenance_mode_mode", "", "yes");
INSERT INTO `wp_options` VALUES("736", "elementor_maintenance_mode_exclude_mode", "logged_in", "yes");
INSERT INTO `wp_options` VALUES("737", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("738", "elementor_maintenance_mode_template_id", "1213", "yes");
INSERT INTO `wp_options` VALUES("902", "theme_mods_tower", "a:13:{s:18:\"nav_menu_locations\";a:4:{s:11:\"header-menu\";i:0;s:11:\"mobile-menu\";i:0;s:11:\"footer-menu\";i:0;s:9:\"side-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:23:\"single_project_template\";s:3:\"136\";s:15:\"header_template\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:16:\"article_template\";s:2:\"72\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_archive_template\";s:3:\"124\";s:13:\"page_template\";s:3:\"167\";s:15:\"portfolio_label\";s:21:\"نمونه کارها\";s:22:\"header_template_single\";s:2:\"52\";s:22:\"footer_template_single\";s:2:\"56\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1632754197;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("905", "tower_customizer_polylang_settings_fa", "a:3:{s:8:\"template\";s:5:\"tower\";s:4:\"mods\";a:13:{s:18:\"nav_menu_locations\";a:4:{s:11:\"header-menu\";i:0;s:11:\"mobile-menu\";i:0;s:11:\"footer-menu\";i:0;s:9:\"side-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:23:\"single_project_template\";s:3:\"136\";s:15:\"header_template\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:16:\"article_template\";s:2:\"72\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_archive_template\";s:3:\"124\";s:13:\"page_template\";s:3:\"167\";s:15:\"portfolio_label\";s:21:\"نمونه کارها\";s:22:\"header_template_single\";s:2:\"52\";s:22:\"footer_template_single\";s:2:\"56\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1632754197;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("993", "theme_mods_Oil", "a:18:{s:18:\"nav_menu_locations\";a:4:{s:11:\"header-menu\";i:0;s:11:\"mobile-menu\";i:0;s:11:\"footer-menu\";i:0;s:9:\"side-menu\";i:0;}s:18:\"custom_css_post_id\";i:1808;s:15:\"header_template\";s:2:\"52\";s:21:\"header_template_other\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:11:\"wertyjdrtyu\";s:2:\"52\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1656745447;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:21:\"archive-post-template\";s:2:\"72\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_archive_template\";s:3:\"124\";s:23:\"single_project_template\";s:3:\"136\";s:23:\"single_product_template\";s:3:\"280\";s:24:\"archive_product_template\";s:3:\"184\";s:13:\"page_template\";s:3:\"167\";s:15:\"search_template\";s:4:\"1269\";s:17:\"page_404_template\";s:4:\"1281\";s:7:\"loading\";s:8:\"loading2\";s:15:\"portfolio_label\";s:22:\"نمونه کار ها\";}", "no");
INSERT INTO `wp_options` VALUES("994", "Oil_customizer_polylang_settings_fa", "a:3:{s:8:\"template\";s:3:\"Oil\";s:4:\"mods\";a:18:{s:18:\"nav_menu_locations\";a:8:{s:11:\"header-menu\";i:0;s:16:\"header-menu___en\";i:0;s:11:\"mobile-menu\";i:0;s:16:\"mobile-menu___en\";i:0;s:11:\"footer-menu\";i:0;s:16:\"footer-menu___en\";i:0;s:9:\"side-menu\";i:0;s:14:\"side-menu___en\";i:0;}s:18:\"custom_css_post_id\";i:1808;s:15:\"header_template\";s:2:\"52\";s:21:\"header_template_other\";s:2:\"52\";s:15:\"footer_template\";s:2:\"56\";s:11:\"wertyjdrtyu\";s:2:\"52\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1655555730;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:21:\"archive-post-template\";s:2:\"72\";s:16:\"project_template\";s:3:\"139\";s:23:\"single_archive_template\";s:3:\"124\";s:23:\"single_project_template\";s:3:\"136\";s:23:\"single_product_template\";s:3:\"280\";s:24:\"archive_product_template\";s:3:\"184\";s:13:\"page_template\";s:3:\"167\";s:15:\"search_template\";s:4:\"1269\";s:17:\"page_404_template\";s:4:\"1281\";s:7:\"loading\";s:8:\"loading2\";s:15:\"portfolio_label\";s:22:\"نمونه کار ها\";}s:7:\"options\";a:2:{s:8:\"blogname\";s:19:\"پولاریس وب\";s:15:\"blogdescription\";s:32:\"هلدینگ پولاریس وب\";}}", "yes");
INSERT INTO `wp_options` VALUES("1006", "recovery_mode_email_last_sent", "1669362327", "yes");
INSERT INTO `wp_options` VALUES("1055", "rewrite_rules", "a:454:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:17:\"(en)/portfolio/?$\";s:46:\"index.php?lang=$matches[1]&post_type=portfolio\";s:12:\"portfolio/?$\";s:37:\"index.php?lang=fa&post_type=portfolio\";s:47:\"(en)/portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?lang=$matches[1]&post_type=portfolio&feed=$matches[2]\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?lang=fa&post_type=portfolio&feed=$matches[1]\";s:42:\"(en)/portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?lang=$matches[1]&post_type=portfolio&feed=$matches[2]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?lang=fa&post_type=portfolio&feed=$matches[1]\";s:34:\"(en)/portfolio/page/([0-9]{1,})/?$\";s:64:\"index.php?lang=$matches[1]&post_type=portfolio&paged=$matches[2]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:55:\"index.php?lang=fa&post_type=portfolio&paged=$matches[1]\";s:12:\"(en)/shop/?$\";s:44:\"index.php?lang=$matches[1]&post_type=product\";s:7:\"shop/?$\";s:35:\"index.php?lang=fa&post_type=product\";s:42:\"(en)/shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?lang=$matches[1]&post_type=product&feed=$matches[2]\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?lang=fa&post_type=product&feed=$matches[1]\";s:37:\"(en)/shop/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?lang=$matches[1]&post_type=product&feed=$matches[2]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?lang=fa&post_type=product&feed=$matches[1]\";s:29:\"(en)/shop/page/([0-9]{1,})/?$\";s:62:\"index.php?lang=$matches[1]&post_type=product&paged=$matches[2]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:53:\"index.php?lang=fa&post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:53:\"^(en)/wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:92:\"index.php?lang=$matches[1]&sitemap=$matches[2]&sitemap-subtype=$matches[3]&paged=$matches[4]\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:39:\"^(en)/wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:64:\"index.php?lang=$matches[1]&sitemap=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:52:\"(en)/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&category_name=$matches[2]&feed=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:47:\"(en)/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&category_name=$matches[2]&feed=$matches[3]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:28:\"(en)/category/(.+?)/embed/?$\";s:63:\"index.php?lang=$matches[1]&category_name=$matches[2]&embed=true\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:40:\"(en)/category/(.+?)/page/?([0-9]{1,})/?$\";s:70:\"index.php?lang=$matches[1]&category_name=$matches[2]&paged=$matches[3]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:48:\"(en)/category/(.+?)/wc/file/transient(/(.*))?/?$\";s:82:\"index.php?lang=$matches[1]&category_name=$matches[2]&wc/file/transient=$matches[4]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"(en)/category/(.+?)/wc-api(/(.*))?/?$\";s:71:\"index.php?lang=$matches[1]&category_name=$matches[2]&wc-api=$matches[4]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:22:\"(en)/category/(.+?)/?$\";s:52:\"index.php?lang=$matches[1]&category_name=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:49:\"(en)/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&tag=$matches[2]&feed=$matches[3]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:44:\"(en)/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&tag=$matches[2]&feed=$matches[3]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:25:\"(en)/tag/([^/]+)/embed/?$\";s:53:\"index.php?lang=$matches[1]&tag=$matches[2]&embed=true\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:37:\"(en)/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?lang=$matches[1]&tag=$matches[2]&paged=$matches[3]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:45:\"(en)/tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:72:\"index.php?lang=$matches[1]&tag=$matches[2]&wc/file/transient=$matches[4]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"(en)/tag/([^/]+)/wc-api(/(.*))?/?$\";s:61:\"index.php?lang=$matches[1]&tag=$matches[2]&wc-api=$matches[4]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:19:\"(en)/tag/([^/]+)/?$\";s:42:\"index.php?lang=$matches[1]&tag=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:50:\"(en)/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=fa&post_format=$matches[1]&feed=$matches[2]\";s:45:\"(en)/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=fa&post_format=$matches[1]&feed=$matches[2]\";s:26:\"(en)/type/([^/]+)/embed/?$\";s:61:\"index.php?lang=$matches[1]&post_format=$matches[2]&embed=true\";s:21:\"type/([^/]+)/embed/?$\";s:52:\"index.php?lang=fa&post_format=$matches[1]&embed=true\";s:38:\"(en)/type/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&post_format=$matches[2]&paged=$matches[3]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?lang=fa&post_format=$matches[1]&paged=$matches[2]\";s:20:\"(en)/type/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&post_format=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:41:\"index.php?lang=fa&post_format=$matches[1]\";s:42:\"(en)/portfolio/[^/]+/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"(en)/portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"(en)/portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"(en)/portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"(en)/portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"(en)/portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"(en)/portfolio/([^/]+)/embed/?$\";s:59:\"index.php?lang=$matches[1]&portfolio=$matches[2]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"(en)/portfolio/([^/]+)/trackback/?$\";s:53:\"index.php?lang=$matches[1]&portfolio=$matches[2]&tb=1\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:55:\"(en)/portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?lang=$matches[1]&portfolio=$matches[2]&feed=$matches[3]\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:50:\"(en)/portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?lang=$matches[1]&portfolio=$matches[2]&feed=$matches[3]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:43:\"(en)/portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?lang=$matches[1]&portfolio=$matches[2]&paged=$matches[3]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"(en)/portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?lang=$matches[1]&portfolio=$matches[2]&cpage=$matches[3]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:51:\"(en)/portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:78:\"index.php?lang=$matches[1]&portfolio=$matches[2]&wc/file/transient=$matches[4]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"(en)/portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:67:\"index.php?lang=$matches[1]&portfolio=$matches[2]&wc-api=$matches[4]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:57:\"(en)/portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"(en)/portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"(en)/portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"(en)/portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"(en)/portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?lang=$matches[1]&portfolio=$matches[2]&page=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"(en)/portfolio/[^/]+/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"(en)/portfolio/[^/]+/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"(en)/portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"(en)/portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"(en)/portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"(en)/portfolio/[^/]+/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"(en)/portfolio_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&portfolio_cat=$matches[2]&feed=$matches[3]\";s:54:\"portfolio_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:54:\"(en)/portfolio_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&portfolio_cat=$matches[2]&feed=$matches[3]\";s:49:\"portfolio_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:35:\"(en)/portfolio_cat/([^/]+)/embed/?$\";s:63:\"index.php?lang=$matches[1]&portfolio_cat=$matches[2]&embed=true\";s:30:\"portfolio_cat/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_cat=$matches[1]&embed=true\";s:47:\"(en)/portfolio_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?lang=$matches[1]&portfolio_cat=$matches[2]&paged=$matches[3]\";s:42:\"portfolio_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_cat=$matches[1]&paged=$matches[2]\";s:29:\"(en)/portfolio_cat/([^/]+)/?$\";s:52:\"index.php?lang=$matches[1]&portfolio_cat=$matches[2]\";s:24:\"portfolio_cat/([^/]+)/?$\";s:35:\"index.php?portfolio_cat=$matches[1]\";s:60:\"(en)/portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?lang=$matches[1]&portfolio_tags=$matches[2]&feed=$matches[3]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:55:\"(en)/portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?lang=$matches[1]&portfolio_tags=$matches[2]&feed=$matches[3]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:36:\"(en)/portfolio_tags/([^/]+)/embed/?$\";s:64:\"index.php?lang=$matches[1]&portfolio_tags=$matches[2]&embed=true\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:48:\"(en)/portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?lang=$matches[1]&portfolio_tags=$matches[2]&paged=$matches[3]\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:30:\"(en)/portfolio_tags/([^/]+)/?$\";s:53:\"index.php?lang=$matches[1]&portfolio_tags=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:60:\"(en)/product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&product_cat=$matches[2]&feed=$matches[3]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:55:\"(en)/product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&product_cat=$matches[2]&feed=$matches[3]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:36:\"(en)/product-category/(.+?)/embed/?$\";s:61:\"index.php?lang=$matches[1]&product_cat=$matches[2]&embed=true\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:48:\"(en)/product-category/(.+?)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&product_cat=$matches[2]&paged=$matches[3]\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:30:\"(en)/product-category/(.+?)/?$\";s:50:\"index.php?lang=$matches[1]&product_cat=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:57:\"(en)/product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&product_tag=$matches[2]&feed=$matches[3]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:52:\"(en)/product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&product_tag=$matches[2]&feed=$matches[3]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:33:\"(en)/product-tag/([^/]+)/embed/?$\";s:61:\"index.php?lang=$matches[1]&product_tag=$matches[2]&embed=true\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:45:\"(en)/product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&product_tag=$matches[2]&paged=$matches[3]\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:27:\"(en)/product-tag/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&product_tag=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:40:\"(en)/product/[^/]+/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"(en)/product/[^/]+/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"(en)/product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"(en)/product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"(en)/product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"(en)/product/[^/]+/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"(en)/product/([^/]+)/embed/?$\";s:57:\"index.php?lang=$matches[1]&product=$matches[2]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:33:\"(en)/product/([^/]+)/trackback/?$\";s:51:\"index.php?lang=$matches[1]&product=$matches[2]&tb=1\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:53:\"(en)/product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?lang=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:48:\"(en)/product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?lang=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:41:\"(en)/product/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?lang=$matches[1]&product=$matches[2]&paged=$matches[3]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:48:\"(en)/product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:64:\"index.php?lang=$matches[1]&product=$matches[2]&cpage=$matches[3]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:49:\"(en)/product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:76:\"index.php?lang=$matches[1]&product=$matches[2]&wc/file/transient=$matches[4]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"(en)/product/([^/]+)/wc-api(/(.*))?/?$\";s:65:\"index.php?lang=$matches[1]&product=$matches[2]&wc-api=$matches[4]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:55:\"(en)/product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"(en)/product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"(en)/product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"(en)/product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"(en)/product/([^/]+)(?:/([0-9]+))?/?$\";s:63:\"index.php?lang=$matches[1]&product=$matches[2]&page=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:29:\"(en)/product/[^/]+/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"(en)/product/[^/]+/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"(en)/product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"(en)/product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"(en)/product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"(en)/product/[^/]+/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:37:\"(en)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:35:\"index.php?lang=fa&&feed=$matches[1]\";s:32:\"(en)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:35:\"index.php?lang=fa&&feed=$matches[1]\";s:13:\"(en)/embed/?$\";s:38:\"index.php?lang=$matches[1]&&embed=true\";s:8:\"embed/?$\";s:29:\"index.php?lang=fa&&embed=true\";s:25:\"(en)/page/?([0-9]{1,})/?$\";s:45:\"index.php?lang=$matches[1]&&paged=$matches[2]\";s:20:\"page/?([0-9]{1,})/?$\";s:36:\"index.php?lang=fa&&paged=$matches[1]\";s:32:\"(en)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?lang=$matches[1]&&page_id=314&cpage=$matches[2]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:48:\"index.php?lang=fa&&page_id=314&cpage=$matches[1]\";s:33:\"(en)/wc/file/transient(/(.*))?/?$\";s:57:\"index.php?lang=$matches[1]&&wc/file/transient=$matches[3]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:48:\"index.php?lang=fa&&wc/file/transient=$matches[2]\";s:22:\"(en)/wc-api(/(.*))?/?$\";s:46:\"index.php?lang=$matches[1]&&wc-api=$matches[3]\";s:17:\"wc-api(/(.*))?/?$\";s:37:\"index.php?lang=fa&&wc-api=$matches[2]\";s:25:\"(en)/order-pay(/(.*))?/?$\";s:49:\"index.php?lang=$matches[1]&&order-pay=$matches[3]\";s:20:\"order-pay(/(.*))?/?$\";s:40:\"index.php?lang=fa&&order-pay=$matches[2]\";s:30:\"(en)/order-received(/(.*))?/?$\";s:54:\"index.php?lang=$matches[1]&&order-received=$matches[3]\";s:25:\"order-received(/(.*))?/?$\";s:45:\"index.php?lang=fa&&order-received=$matches[2]\";s:22:\"(en)/orders(/(.*))?/?$\";s:46:\"index.php?lang=$matches[1]&&orders=$matches[3]\";s:17:\"orders(/(.*))?/?$\";s:37:\"index.php?lang=fa&&orders=$matches[2]\";s:26:\"(en)/view-order(/(.*))?/?$\";s:50:\"index.php?lang=$matches[1]&&view-order=$matches[3]\";s:21:\"view-order(/(.*))?/?$\";s:41:\"index.php?lang=fa&&view-order=$matches[2]\";s:25:\"(en)/downloads(/(.*))?/?$\";s:49:\"index.php?lang=$matches[1]&&downloads=$matches[3]\";s:20:\"downloads(/(.*))?/?$\";s:40:\"index.php?lang=fa&&downloads=$matches[2]\";s:28:\"(en)/edit-account(/(.*))?/?$\";s:52:\"index.php?lang=$matches[1]&&edit-account=$matches[3]\";s:23:\"edit-account(/(.*))?/?$\";s:43:\"index.php?lang=fa&&edit-account=$matches[2]\";s:28:\"(en)/edit-address(/(.*))?/?$\";s:52:\"index.php?lang=$matches[1]&&edit-address=$matches[3]\";s:23:\"edit-address(/(.*))?/?$\";s:43:\"index.php?lang=fa&&edit-address=$matches[2]\";s:31:\"(en)/payment-methods(/(.*))?/?$\";s:55:\"index.php?lang=$matches[1]&&payment-methods=$matches[3]\";s:26:\"payment-methods(/(.*))?/?$\";s:46:\"index.php?lang=fa&&payment-methods=$matches[2]\";s:29:\"(en)/lost-password(/(.*))?/?$\";s:53:\"index.php?lang=$matches[1]&&lost-password=$matches[3]\";s:24:\"lost-password(/(.*))?/?$\";s:44:\"index.php?lang=fa&&lost-password=$matches[2]\";s:31:\"(en)/customer-logout(/(.*))?/?$\";s:55:\"index.php?lang=$matches[1]&&customer-logout=$matches[3]\";s:26:\"customer-logout(/(.*))?/?$\";s:46:\"index.php?lang=fa&&customer-logout=$matches[2]\";s:34:\"(en)/add-payment-method(/(.*))?/?$\";s:58:\"index.php?lang=$matches[1]&&add-payment-method=$matches[3]\";s:29:\"add-payment-method(/(.*))?/?$\";s:49:\"index.php?lang=fa&&add-payment-method=$matches[2]\";s:37:\"(en)/delete-payment-method(/(.*))?/?$\";s:61:\"index.php?lang=$matches[1]&&delete-payment-method=$matches[3]\";s:32:\"delete-payment-method(/(.*))?/?$\";s:52:\"index.php?lang=fa&&delete-payment-method=$matches[2]\";s:42:\"(en)/set-default-payment-method(/(.*))?/?$\";s:66:\"index.php?lang=$matches[1]&&set-default-payment-method=$matches[3]\";s:37:\"set-default-payment-method(/(.*))?/?$\";s:57:\"index.php?lang=fa&&set-default-payment-method=$matches[2]\";s:7:\"(en)/?$\";s:26:\"index.php?lang=$matches[1]\";s:46:\"(en)/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lang=fa&&feed=$matches[1]&withcomments=1\";s:41:\"(en)/comments/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lang=fa&&feed=$matches[1]&withcomments=1\";s:22:\"(en)/comments/embed/?$\";s:38:\"index.php?lang=$matches[1]&&embed=true\";s:17:\"comments/embed/?$\";s:29:\"index.php?lang=fa&&embed=true\";s:42:\"(en)/comments/wc/file/transient(/(.*))?/?$\";s:57:\"index.php?lang=$matches[1]&&wc/file/transient=$matches[3]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:48:\"index.php?lang=fa&&wc/file/transient=$matches[2]\";s:31:\"(en)/comments/wc-api(/(.*))?/?$\";s:46:\"index.php?lang=$matches[1]&&wc-api=$matches[3]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:37:\"index.php?lang=fa&&wc-api=$matches[2]\";s:49:\"(en)/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?lang=fa&s=$matches[1]&feed=$matches[2]\";s:44:\"(en)/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?lang=fa&s=$matches[1]&feed=$matches[2]\";s:25:\"(en)/search/(.+)/embed/?$\";s:51:\"index.php?lang=$matches[1]&s=$matches[2]&embed=true\";s:20:\"search/(.+)/embed/?$\";s:42:\"index.php?lang=fa&s=$matches[1]&embed=true\";s:37:\"(en)/search/(.+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?lang=$matches[1]&s=$matches[2]&paged=$matches[3]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?lang=fa&s=$matches[1]&paged=$matches[2]\";s:45:\"(en)/search/(.+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?lang=$matches[1]&s=$matches[2]&wc/file/transient=$matches[4]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?lang=fa&s=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"(en)/search/(.+)/wc-api(/(.*))?/?$\";s:59:\"index.php?lang=$matches[1]&s=$matches[2]&wc-api=$matches[4]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:50:\"index.php?lang=fa&s=$matches[1]&wc-api=$matches[3]\";s:19:\"(en)/search/(.+)/?$\";s:40:\"index.php?lang=$matches[1]&s=$matches[2]\";s:14:\"search/(.+)/?$\";s:31:\"index.php?lang=fa&s=$matches[1]\";s:52:\"(en)/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=fa&author_name=$matches[1]&feed=$matches[2]\";s:47:\"(en)/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=fa&author_name=$matches[1]&feed=$matches[2]\";s:28:\"(en)/author/([^/]+)/embed/?$\";s:61:\"index.php?lang=$matches[1]&author_name=$matches[2]&embed=true\";s:23:\"author/([^/]+)/embed/?$\";s:52:\"index.php?lang=fa&author_name=$matches[1]&embed=true\";s:40:\"(en)/author/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&author_name=$matches[2]&paged=$matches[3]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?lang=fa&author_name=$matches[1]&paged=$matches[2]\";s:48:\"(en)/author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:80:\"index.php?lang=$matches[1]&author_name=$matches[2]&wc/file/transient=$matches[4]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:71:\"index.php?lang=fa&author_name=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"(en)/author/([^/]+)/wc-api(/(.*))?/?$\";s:69:\"index.php?lang=$matches[1]&author_name=$matches[2]&wc-api=$matches[4]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:60:\"index.php?lang=fa&author_name=$matches[1]&wc-api=$matches[3]\";s:22:\"(en)/author/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&author_name=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:41:\"index.php?lang=fa&author_name=$matches[1]\";s:74:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:88:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:69:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:88:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:50:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:91:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&embed=true\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:82:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:62:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:98:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&paged=$matches[5]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:89:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:70:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&wc/file/transient=$matches[6]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:101:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:59:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:99:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&wc-api=$matches[6]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:90:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:44:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:80:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:71:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:61:\"(en)/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:56:\"(en)/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:37:\"(en)/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:75:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&embed=true\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:66:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&embed=true\";s:49:\"(en)/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:82:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&paged=$matches[4]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:73:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:57:\"(en)/([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:94:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&wc/file/transient=$matches[5]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:85:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:46:\"(en)/([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:83:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&wc-api=$matches[5]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:74:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:31:\"(en)/([0-9]{4})/([0-9]{1,2})/?$\";s:64:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:55:\"index.php?lang=fa&year=$matches[1]&monthnum=$matches[2]\";s:48:\"(en)/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lang=fa&year=$matches[1]&feed=$matches[2]\";s:43:\"(en)/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lang=fa&year=$matches[1]&feed=$matches[2]\";s:24:\"(en)/([0-9]{4})/embed/?$\";s:54:\"index.php?lang=$matches[1]&year=$matches[2]&embed=true\";s:19:\"([0-9]{4})/embed/?$\";s:45:\"index.php?lang=fa&year=$matches[1]&embed=true\";s:36:\"(en)/([0-9]{4})/page/?([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&year=$matches[2]&paged=$matches[3]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:52:\"index.php?lang=fa&year=$matches[1]&paged=$matches[2]\";s:44:\"(en)/([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:73:\"index.php?lang=$matches[1]&year=$matches[2]&wc/file/transient=$matches[4]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?lang=fa&year=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"(en)/([0-9]{4})/wc-api(/(.*))?/?$\";s:62:\"index.php?lang=$matches[1]&year=$matches[2]&wc-api=$matches[4]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:53:\"index.php?lang=fa&year=$matches[1]&wc-api=$matches[3]\";s:18:\"(en)/([0-9]{4})/?$\";s:43:\"index.php?lang=$matches[1]&year=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:34:\"index.php?lang=fa&year=$matches[1]\";s:32:\"(en)/.?.+?/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"(en)/.?.+?/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"(en)/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"(en)/.?.+?/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"(en)/(.?.+?)/embed/?$\";s:58:\"index.php?lang=$matches[1]&pagename=$matches[2]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:25:\"(en)/(.?.+?)/trackback/?$\";s:52:\"index.php?lang=$matches[1]&pagename=$matches[2]&tb=1\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:45:\"(en)/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&feed=$matches[3]\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:40:\"(en)/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&feed=$matches[3]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:33:\"(en)/(.?.+?)/page/?([0-9]{1,})/?$\";s:65:\"index.php?lang=$matches[1]&pagename=$matches[2]&paged=$matches[3]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:40:\"(en)/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?lang=$matches[1]&pagename=$matches[2]&cpage=$matches[3]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:41:\"(en)/(.?.+?)/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?lang=$matches[1]&pagename=$matches[2]&wc/file/transient=$matches[4]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"(en)/(.?.+?)/wc-api(/(.*))?/?$\";s:66:\"index.php?lang=$matches[1]&pagename=$matches[2]&wc-api=$matches[4]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:33:\"(en)/(.?.+?)/order-pay(/(.*))?/?$\";s:69:\"index.php?lang=$matches[1]&pagename=$matches[2]&order-pay=$matches[4]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:38:\"(en)/(.?.+?)/order-received(/(.*))?/?$\";s:74:\"index.php?lang=$matches[1]&pagename=$matches[2]&order-received=$matches[4]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:30:\"(en)/(.?.+?)/orders(/(.*))?/?$\";s:66:\"index.php?lang=$matches[1]&pagename=$matches[2]&orders=$matches[4]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:34:\"(en)/(.?.+?)/view-order(/(.*))?/?$\";s:70:\"index.php?lang=$matches[1]&pagename=$matches[2]&view-order=$matches[4]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:33:\"(en)/(.?.+?)/downloads(/(.*))?/?$\";s:69:\"index.php?lang=$matches[1]&pagename=$matches[2]&downloads=$matches[4]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:36:\"(en)/(.?.+?)/edit-account(/(.*))?/?$\";s:72:\"index.php?lang=$matches[1]&pagename=$matches[2]&edit-account=$matches[4]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:36:\"(en)/(.?.+?)/edit-address(/(.*))?/?$\";s:72:\"index.php?lang=$matches[1]&pagename=$matches[2]&edit-address=$matches[4]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:39:\"(en)/(.?.+?)/payment-methods(/(.*))?/?$\";s:75:\"index.php?lang=$matches[1]&pagename=$matches[2]&payment-methods=$matches[4]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:37:\"(en)/(.?.+?)/lost-password(/(.*))?/?$\";s:73:\"index.php?lang=$matches[1]&pagename=$matches[2]&lost-password=$matches[4]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:39:\"(en)/(.?.+?)/customer-logout(/(.*))?/?$\";s:75:\"index.php?lang=$matches[1]&pagename=$matches[2]&customer-logout=$matches[4]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:42:\"(en)/(.?.+?)/add-payment-method(/(.*))?/?$\";s:78:\"index.php?lang=$matches[1]&pagename=$matches[2]&add-payment-method=$matches[4]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:45:\"(en)/(.?.+?)/delete-payment-method(/(.*))?/?$\";s:81:\"index.php?lang=$matches[1]&pagename=$matches[2]&delete-payment-method=$matches[4]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:50:\"(en)/(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:86:\"index.php?lang=$matches[1]&pagename=$matches[2]&set-default-payment-method=$matches[4]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:47:\"(en)/.?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"(en)/.?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"(en)/.?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"(en)/.?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"(en)/(.?.+?)(?:/([0-9]+))?/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&page=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:32:\"(en)/[^/]+/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"(en)/[^/]+/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"(en)/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"(en)/[^/]+/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"(en)/([^/]+)/embed/?$\";s:54:\"index.php?lang=$matches[1]&name=$matches[2]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:25:\"(en)/([^/]+)/trackback/?$\";s:48:\"index.php?lang=$matches[1]&name=$matches[2]&tb=1\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:45:\"(en)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:40:\"(en)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:33:\"(en)/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:40:\"(en)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:41:\"(en)/([^/]+)/wc/file/transient(/(.*))?/?$\";s:73:\"index.php?lang=$matches[1]&name=$matches[2]&wc/file/transient=$matches[4]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"(en)/([^/]+)/wc-api(/(.*))?/?$\";s:62:\"index.php?lang=$matches[1]&name=$matches[2]&wc-api=$matches[4]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:47:\"(en)/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"(en)/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:79:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc/file/transient=$matches[4]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"(en)/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"(en)/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:68:\"index.php?lang=$matches[1]&attachment=$matches[2]&wc-api=$matches[4]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"(en)/([^/]+)(?:/([0-9]+))?/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&page=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:21:\"(en)/[^/]+/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"(en)/[^/]+/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"(en)/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"(en)/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"(en)/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"(en)/[^/]+/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("1223", "woocommerce_catalog_columns", "3", "yes");
INSERT INTO `wp_options` VALUES("1224", "woocommerce_catalog_rows", "1", "yes");
INSERT INTO `wp_options` VALUES("1286", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("2051", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1658772196;s:7:\"version\";s:5:\"5.6.1\";s:11:\"count_valid\";i:4;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("2307", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3012", "secret_key", "01kVa{sn9U^IE.XXo;K*duxTM<#=)o1pu0M{QAx*BhHTpWhn>p=a$!rVxZal&~YI", "no");
INSERT INTO `wp_options` VALUES("3629", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"alirza.sh826@gmail.com\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759630056;}", "off");
INSERT INTO `wp_options` VALUES("3769", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("3802", "woocommerce_task_list_hidden_lists", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3844", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("3915", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("3916", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("3917", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("4225", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("4522", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("4699", "theme_mods_twentytwentytwo", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1650544363;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("4867", "litespeed.conf.__activation", "-1", "yes");
INSERT INTO `wp_options` VALUES("4868", "litespeed.purge.queue", "-1", "yes");
INSERT INTO `wp_options` VALUES("4869", "litespeed.purge.queue2", "-1", "yes");
INSERT INTO `wp_options` VALUES("4870", "litespeed.cloud._summary", "{\"curr_request.ver\":0,\"news.utime\":1654788521,\"curr_request.news\":1654788521,\"last_request.ver\":1656827528}", "yes");
INSERT INTO `wp_options` VALUES("4871", "litespeed.conf._version", "4.6", "yes");
INSERT INTO `wp_options` VALUES("4872", "litespeed.conf.hash", "aX6pVNOFBCaHuWcIuIMcGid1ZB5f2dsL", "yes");
INSERT INTO `wp_options` VALUES("4873", "litespeed.conf.auto_upgrade", "", "yes");
INSERT INTO `wp_options` VALUES("4874", "litespeed.conf.api_key", "", "yes");
INSERT INTO `wp_options` VALUES("4875", "litespeed.conf.server_ip", "", "yes");
INSERT INTO `wp_options` VALUES("4876", "litespeed.conf.guest", "", "yes");
INSERT INTO `wp_options` VALUES("4877", "litespeed.conf.guest_optm", "", "yes");
INSERT INTO `wp_options` VALUES("4878", "litespeed.conf.news", "1", "yes");
INSERT INTO `wp_options` VALUES("4879", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"PTST\",\"HeadlessChrome\"]", "yes");
INSERT INTO `wp_options` VALUES("4880", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "yes");
INSERT INTO `wp_options` VALUES("4881", "litespeed.conf.cache", "1", "yes");
INSERT INTO `wp_options` VALUES("4882", "litespeed.conf.cache-priv", "1", "yes");
INSERT INTO `wp_options` VALUES("4883", "litespeed.conf.cache-commenter", "1", "yes");
INSERT INTO `wp_options` VALUES("4884", "litespeed.conf.cache-rest", "1", "yes");
INSERT INTO `wp_options` VALUES("4885", "litespeed.conf.cache-page_login", "1", "yes");
INSERT INTO `wp_options` VALUES("4886", "litespeed.conf.cache-favicon", "1", "yes");
INSERT INTO `wp_options` VALUES("4887", "litespeed.conf.cache-resources", "1", "yes");
INSERT INTO `wp_options` VALUES("4888", "litespeed.conf.cache-mobile", "", "yes");
INSERT INTO `wp_options` VALUES("4889", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "yes");
INSERT INTO `wp_options` VALUES("4890", "litespeed.conf.cache-browser", "", "yes");
INSERT INTO `wp_options` VALUES("4891", "litespeed.conf.cache-exc_useragents", "[]", "yes");
INSERT INTO `wp_options` VALUES("4892", "litespeed.conf.cache-exc_cookies", "[]", "yes");
INSERT INTO `wp_options` VALUES("4893", "litespeed.conf.cache-exc_qs", "[]", "yes");
INSERT INTO `wp_options` VALUES("4894", "litespeed.conf.cache-exc_cat", "[]", "yes");
INSERT INTO `wp_options` VALUES("4895", "litespeed.conf.cache-exc_tag", "[]", "yes");
INSERT INTO `wp_options` VALUES("4896", "litespeed.conf.cache-force_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("4897", "litespeed.conf.cache-force_pub_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("4898", "litespeed.conf.cache-priv_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("4899", "litespeed.conf.cache-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4900", "litespeed.conf.cache-exc_roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("4901", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "yes");
INSERT INTO `wp_options` VALUES("4902", "litespeed.conf.cache-ttl_pub", "604800", "yes");
INSERT INTO `wp_options` VALUES("4903", "litespeed.conf.cache-ttl_priv", "1800", "yes");
INSERT INTO `wp_options` VALUES("4904", "litespeed.conf.cache-ttl_frontpage", "604800", "yes");
INSERT INTO `wp_options` VALUES("4905", "litespeed.conf.cache-ttl_feed", "604800", "yes");
INSERT INTO `wp_options` VALUES("4906", "litespeed.conf.cache-ttl_rest", "604800", "yes");
INSERT INTO `wp_options` VALUES("4907", "litespeed.conf.cache-ttl_browser", "31557600", "yes");
INSERT INTO `wp_options` VALUES("4908", "litespeed.conf.cache-ttl_status", "[\"403 3600\",\"404 3600\",\"500 3600\"]", "yes");
INSERT INTO `wp_options` VALUES("4909", "litespeed.conf.cache-login_cookie", "", "yes");
INSERT INTO `wp_options` VALUES("4910", "litespeed.conf.cache-vary_group", "[]", "yes");
INSERT INTO `wp_options` VALUES("4911", "litespeed.conf.purge-upgrade", "1", "yes");
INSERT INTO `wp_options` VALUES("4912", "litespeed.conf.purge-stale", "", "yes");
INSERT INTO `wp_options` VALUES("4913", "litespeed.conf.purge-post_all", "", "yes");
INSERT INTO `wp_options` VALUES("4914", "litespeed.conf.purge-post_f", "1", "yes");
INSERT INTO `wp_options` VALUES("4915", "litespeed.conf.purge-post_h", "1", "yes");
INSERT INTO `wp_options` VALUES("4916", "litespeed.conf.purge-post_p", "1", "yes");
INSERT INTO `wp_options` VALUES("4917", "litespeed.conf.purge-post_pwrp", "1", "yes");
INSERT INTO `wp_options` VALUES("4918", "litespeed.conf.purge-post_a", "1", "yes");
INSERT INTO `wp_options` VALUES("4919", "litespeed.conf.purge-post_y", "", "yes");
INSERT INTO `wp_options` VALUES("4920", "litespeed.conf.purge-post_m", "1", "yes");
INSERT INTO `wp_options` VALUES("4921", "litespeed.conf.purge-post_d", "", "yes");
INSERT INTO `wp_options` VALUES("4922", "litespeed.conf.purge-post_t", "1", "yes");
INSERT INTO `wp_options` VALUES("4923", "litespeed.conf.purge-post_pt", "1", "yes");
INSERT INTO `wp_options` VALUES("4924", "litespeed.conf.purge-timed_urls", "[]", "yes");
INSERT INTO `wp_options` VALUES("4925", "litespeed.conf.purge-timed_urls_time", "", "yes");
INSERT INTO `wp_options` VALUES("4926", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "yes");
INSERT INTO `wp_options` VALUES("4927", "litespeed.conf.esi", "", "yes");
INSERT INTO `wp_options` VALUES("4928", "litespeed.conf.esi-cache_admbar", "1", "yes");
INSERT INTO `wp_options` VALUES("4929", "litespeed.conf.esi-cache_commform", "1", "yes");
INSERT INTO `wp_options` VALUES("4930", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "yes");
INSERT INTO `wp_options` VALUES("4931", "litespeed.conf.util-instant_click", "", "yes");
INSERT INTO `wp_options` VALUES("4932", "litespeed.conf.util-no_https_vary", "", "yes");
INSERT INTO `wp_options` VALUES("4933", "litespeed.conf.debug-disable_all", "", "yes");
INSERT INTO `wp_options` VALUES("4934", "litespeed.conf.debug", "", "yes");
INSERT INTO `wp_options` VALUES("4935", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "yes");
INSERT INTO `wp_options` VALUES("4936", "litespeed.conf.debug-level", "", "yes");
INSERT INTO `wp_options` VALUES("4937", "litespeed.conf.debug-filesize", "3", "yes");
INSERT INTO `wp_options` VALUES("4938", "litespeed.conf.debug-cookie", "", "yes");
INSERT INTO `wp_options` VALUES("4939", "litespeed.conf.debug-collaps_qs", "", "yes");
INSERT INTO `wp_options` VALUES("4940", "litespeed.conf.debug-inc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4941", "litespeed.conf.debug-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4942", "litespeed.conf.db_optm-revisions_max", "0", "yes");
INSERT INTO `wp_options` VALUES("4943", "litespeed.conf.db_optm-revisions_age", "0", "yes");
INSERT INTO `wp_options` VALUES("4944", "litespeed.conf.optm-css_min", "", "yes");
INSERT INTO `wp_options` VALUES("4945", "litespeed.conf.optm-css_comb", "", "yes");
INSERT INTO `wp_options` VALUES("4946", "litespeed.conf.optm-css_comb_ext_inl", "1", "yes");
INSERT INTO `wp_options` VALUES("4947", "litespeed.conf.optm-ucss", "", "yes");
INSERT INTO `wp_options` VALUES("4948", "litespeed.conf.optm-ucss_inline", "", "yes");
INSERT INTO `wp_options` VALUES("4949", "litespeed.conf.optm-ucss_whitelist", "[]", "yes");
INSERT INTO `wp_options` VALUES("4950", "litespeed.conf.optm-ucss_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4951", "litespeed.conf.optm-css_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4952", "litespeed.conf.optm-js_min", "", "yes");
INSERT INTO `wp_options` VALUES("4953", "litespeed.conf.optm-js_comb", "", "yes");
INSERT INTO `wp_options` VALUES("4954", "litespeed.conf.optm-js_comb_ext_inl", "1", "yes");
INSERT INTO `wp_options` VALUES("4955", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "yes");
INSERT INTO `wp_options` VALUES("4956", "litespeed.conf.optm-html_min", "", "yes");
INSERT INTO `wp_options` VALUES("4957", "litespeed.conf.optm-html_lazy", "[]", "yes");
INSERT INTO `wp_options` VALUES("4958", "litespeed.conf.optm-qs_rm", "", "yes");
INSERT INTO `wp_options` VALUES("4959", "litespeed.conf.optm-ggfonts_rm", "", "yes");
INSERT INTO `wp_options` VALUES("4960", "litespeed.conf.optm-css_async", "", "yes");
INSERT INTO `wp_options` VALUES("4961", "litespeed.conf.optm-ccss_per_url", "", "yes");
INSERT INTO `wp_options` VALUES("4962", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "yes");
INSERT INTO `wp_options` VALUES("4963", "litespeed.conf.optm-ccss_sep_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("4964", "litespeed.conf.optm-css_async_inline", "1", "yes");
INSERT INTO `wp_options` VALUES("4965", "litespeed.conf.optm-css_font_display", "", "yes");
INSERT INTO `wp_options` VALUES("4966", "litespeed.conf.optm-js_defer", "", "yes");
INSERT INTO `wp_options` VALUES("4967", "litespeed.conf.optm-emoji_rm", "", "yes");
INSERT INTO `wp_options` VALUES("4968", "litespeed.conf.optm-noscript_rm", "", "yes");
INSERT INTO `wp_options` VALUES("4969", "litespeed.conf.optm-ggfonts_async", "", "yes");
INSERT INTO `wp_options` VALUES("4970", "litespeed.conf.optm-exc_roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("4971", "litespeed.conf.optm-ccss_con", "", "yes");
INSERT INTO `wp_options` VALUES("4972", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "yes");
INSERT INTO `wp_options` VALUES("4973", "litespeed.conf.optm-gm_js_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4974", "litespeed.conf.optm-dns_prefetch", "[]", "yes");
INSERT INTO `wp_options` VALUES("4975", "litespeed.conf.optm-dns_prefetch_ctrl", "", "yes");
INSERT INTO `wp_options` VALUES("4976", "litespeed.conf.optm-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("4977", "litespeed.conf.optm-guest_only", "1", "yes");
INSERT INTO `wp_options` VALUES("4978", "litespeed.conf.object", "", "yes");
INSERT INTO `wp_options` VALUES("4979", "litespeed.conf.object-kind", "", "yes");
INSERT INTO `wp_options` VALUES("4980", "litespeed.conf.object-host", "localhost", "yes");
INSERT INTO `wp_options` VALUES("4981", "litespeed.conf.object-port", "11211", "yes");
INSERT INTO `wp_options` VALUES("4982", "litespeed.conf.object-life", "360", "yes");
INSERT INTO `wp_options` VALUES("4983", "litespeed.conf.object-persistent", "1", "yes");
INSERT INTO `wp_options` VALUES("4984", "litespeed.conf.object-admin", "1", "yes");
INSERT INTO `wp_options` VALUES("4985", "litespeed.conf.object-transients", "1", "yes");
INSERT INTO `wp_options` VALUES("4986", "litespeed.conf.object-db_id", "0", "yes");
INSERT INTO `wp_options` VALUES("4987", "litespeed.conf.object-user", "", "yes");
INSERT INTO `wp_options` VALUES("4988", "litespeed.conf.object-pswd", "", "yes");
INSERT INTO `wp_options` VALUES("4989", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "yes");
INSERT INTO `wp_options` VALUES("4990", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "yes");
INSERT INTO `wp_options` VALUES("4991", "litespeed.conf.discuss-avatar_cache", "", "yes");
INSERT INTO `wp_options` VALUES("4992", "litespeed.conf.discuss-avatar_cron", "", "yes");
INSERT INTO `wp_options` VALUES("4993", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "yes");
INSERT INTO `wp_options` VALUES("4994", "litespeed.conf.optm-localize", "", "yes");
INSERT INTO `wp_options` VALUES("4995", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "yes");
INSERT INTO `wp_options` VALUES("4996", "litespeed.conf.media-lazy", "", "yes");
INSERT INTO `wp_options` VALUES("4997", "litespeed.conf.media-lazy_placeholder", "", "yes");
INSERT INTO `wp_options` VALUES("4998", "litespeed.conf.media-placeholder_resp", "", "yes");
INSERT INTO `wp_options` VALUES("4999", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "yes");
INSERT INTO `wp_options` VALUES("5000", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "yes");
INSERT INTO `wp_options` VALUES("5001", "litespeed.conf.media-lqip", "", "yes");
INSERT INTO `wp_options` VALUES("5002", "litespeed.conf.media-lqip_qual", "4", "yes");
INSERT INTO `wp_options` VALUES("5003", "litespeed.conf.media-lqip_min_w", "150", "yes");
INSERT INTO `wp_options` VALUES("5004", "litespeed.conf.media-lqip_min_h", "150", "yes");
INSERT INTO `wp_options` VALUES("5005", "litespeed.conf.media-placeholder_resp_async", "1", "yes");
INSERT INTO `wp_options` VALUES("5006", "litespeed.conf.media-iframe_lazy", "", "yes");
INSERT INTO `wp_options` VALUES("5007", "litespeed.conf.media-add_missing_sizes", "", "yes");
INSERT INTO `wp_options` VALUES("5008", "litespeed.conf.media-lazy_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5009", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "yes");
INSERT INTO `wp_options` VALUES("5010", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5011", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5012", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5013", "litespeed.conf.media-lazy_uri_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5014", "litespeed.conf.media-lqip_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5015", "litespeed.conf.img_optm-auto", "", "yes");
INSERT INTO `wp_options` VALUES("5016", "litespeed.conf.img_optm-cron", "1", "yes");
INSERT INTO `wp_options` VALUES("5017", "litespeed.conf.img_optm-ori", "1", "yes");
INSERT INTO `wp_options` VALUES("5018", "litespeed.conf.img_optm-rm_bkup", "", "yes");
INSERT INTO `wp_options` VALUES("5019", "litespeed.conf.img_optm-webp", "1", "yes");
INSERT INTO `wp_options` VALUES("5020", "litespeed.conf.img_optm-lossless", "", "yes");
INSERT INTO `wp_options` VALUES("5021", "litespeed.conf.img_optm-exif", "1", "yes");
INSERT INTO `wp_options` VALUES("5022", "litespeed.conf.img_optm-webp_replace", "", "yes");
INSERT INTO `wp_options` VALUES("5023", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"video.poster\"]", "yes");
INSERT INTO `wp_options` VALUES("5024", "litespeed.conf.img_optm-webp_replace_srcset", "", "yes");
INSERT INTO `wp_options` VALUES("5025", "litespeed.conf.img_optm-jpg_quality", "82", "yes");
INSERT INTO `wp_options` VALUES("5026", "litespeed.conf.crawler", "", "yes");
INSERT INTO `wp_options` VALUES("5027", "litespeed.conf.crawler-usleep", "500", "yes");
INSERT INTO `wp_options` VALUES("5028", "litespeed.conf.crawler-run_duration", "400", "yes");
INSERT INTO `wp_options` VALUES("5029", "litespeed.conf.crawler-run_interval", "600", "yes");
INSERT INTO `wp_options` VALUES("5030", "litespeed.conf.crawler-crawl_interval", "302400", "yes");
INSERT INTO `wp_options` VALUES("5031", "litespeed.conf.crawler-threads", "3", "yes");
INSERT INTO `wp_options` VALUES("5032", "litespeed.conf.crawler-timeout", "30", "yes");
INSERT INTO `wp_options` VALUES("5033", "litespeed.conf.crawler-load_limit", "1", "yes");
INSERT INTO `wp_options` VALUES("5034", "litespeed.conf.crawler-sitemap", "", "yes");
INSERT INTO `wp_options` VALUES("5035", "litespeed.conf.crawler-drop_domain", "1", "yes");
INSERT INTO `wp_options` VALUES("5036", "litespeed.conf.crawler-map_timeout", "120", "yes");
INSERT INTO `wp_options` VALUES("5037", "litespeed.conf.crawler-roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("5038", "litespeed.conf.crawler-cookies", "[]", "yes");
INSERT INTO `wp_options` VALUES("5039", "litespeed.conf.misc-heartbeat_front", "", "yes");
INSERT INTO `wp_options` VALUES("5040", "litespeed.conf.misc-heartbeat_front_ttl", "60", "yes");
INSERT INTO `wp_options` VALUES("5041", "litespeed.conf.misc-heartbeat_back", "", "yes");
INSERT INTO `wp_options` VALUES("5042", "litespeed.conf.misc-heartbeat_back_ttl", "60", "yes");
INSERT INTO `wp_options` VALUES("5043", "litespeed.conf.misc-heartbeat_editor", "", "yes");
INSERT INTO `wp_options` VALUES("5044", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "yes");
INSERT INTO `wp_options` VALUES("5045", "litespeed.conf.cdn", "", "yes");
INSERT INTO `wp_options` VALUES("5046", "litespeed.conf.cdn-ori", "[]", "yes");
INSERT INTO `wp_options` VALUES("5047", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "yes");
INSERT INTO `wp_options` VALUES("5048", "litespeed.conf.cdn-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("5049", "litespeed.conf.cdn-quic", "", "yes");
INSERT INTO `wp_options` VALUES("5050", "litespeed.conf.cdn-cloudflare", "", "yes");
INSERT INTO `wp_options` VALUES("5051", "litespeed.conf.cdn-cloudflare_email", "", "yes");
INSERT INTO `wp_options` VALUES("5052", "litespeed.conf.cdn-cloudflare_key", "", "yes");
INSERT INTO `wp_options` VALUES("5053", "litespeed.conf.cdn-cloudflare_name", "", "yes");
INSERT INTO `wp_options` VALUES("5054", "litespeed.conf.cdn-cloudflare_zone", "", "yes");
INSERT INTO `wp_options` VALUES("5055", "litespeed.conf.cdn-mapping", "[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]", "yes");
INSERT INTO `wp_options` VALUES("5056", "litespeed.conf.cdn-attr", "[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]", "yes");
INSERT INTO `wp_options` VALUES("5058", "litespeed.gui.lscwp_whm_install", "-1", "yes");
INSERT INTO `wp_options` VALUES("5059", "litespeed.gui.dismiss", "-1", "yes");
INSERT INTO `wp_options` VALUES("5060", "litespeed.gui._summary", "{\"new_version\":1651153340,\"score\":1651758140}", "yes");
INSERT INTO `wp_options` VALUES("5061", "litespeed.data.upgrading", "-1", "yes");
INSERT INTO `wp_options` VALUES("5062", "litespeed.admin_display.messages", "[\"<div class=\\\"notice notice-success is-dismissible\\\"><p>\\u067e\\u0627\\u06a9\\u0633\\u0627\\u0632\\u06cc \\u062a\\u0645\\u0627\\u0645 \\u06a9\\u0634 \\u0645\\u0648\\u0641\\u0642 \\u0628\\u0648\\u062f.<\\/p><\\/div>\"]", "yes");
INSERT INTO `wp_options` VALUES("5063", "litespeed.admin_display.msg_pin", "-1", "yes");
INSERT INTO `wp_options` VALUES("5065", "wpsh_pro_license_status", "0", "yes");
INSERT INTO `wp_options` VALUES("5068", "litespeed.optimize.timestamp_purge_css", "1654862697", "yes");
INSERT INTO `wp_options` VALUES("5091", "minify_html_active", "yes", "yes");
INSERT INTO `wp_options` VALUES("5092", "minify_javascript", "yes", "yes");
INSERT INTO `wp_options` VALUES("5093", "minify_html_comments", "yes", "yes");
INSERT INTO `wp_options` VALUES("5094", "minify_html_xhtml", "no", "yes");
INSERT INTO `wp_options` VALUES("5095", "minify_html_relative", "no", "yes");
INSERT INTO `wp_options` VALUES("5096", "minify_html_scheme", "no", "yes");
INSERT INTO `wp_options` VALUES("5097", "minify_html_utf8", "no", "yes");
INSERT INTO `wp_options` VALUES("5207", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("5210", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `wp_options` VALUES("5320", "wpp_settings", "a:17:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"persian_date\";s:7:\"disable\";s:20:\"disable_widget_block\";s:7:\"disable\";s:12:\"submenu_move\";s:7:\"disable\";s:8:\"dev_mode\";s:7:\"disable\";s:12:\"enable_fonts\";s:7:\"disable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:6:\"enable\";}", "yes");
INSERT INTO `wp_options` VALUES("5321", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5322", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5758", "Oil_customizer_polylang_settings_en", "a:3:{s:8:\"template\";s:3:\"Oil\";s:4:\"mods\";a:18:{s:18:\"nav_menu_locations\";a:8:{s:11:\"header-menu\";i:0;s:16:\"header-menu___en\";i:0;s:11:\"mobile-menu\";i:0;s:16:\"mobile-menu___en\";i:0;s:11:\"footer-menu\";i:0;s:16:\"footer-menu___en\";i:0;s:9:\"side-menu\";i:0;s:14:\"side-menu___en\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:15:\"header_template\";s:4:\"1291\";s:21:\"header_template_other\";s:4:\"1291\";s:15:\"footer_template\";s:4:\"1299\";s:11:\"wertyjdrtyu\";s:2:\"52\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1650546833;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:21:\"archive-post-template\";s:3:\"871\";s:16:\"project_template\";s:3:\"767\";s:23:\"single_archive_template\";s:3:\"780\";s:23:\"single_project_template\";s:3:\"772\";s:23:\"single_product_template\";s:3:\"280\";s:24:\"archive_product_template\";s:3:\"184\";s:13:\"page_template\";s:3:\"167\";s:7:\"loading\";s:8:\"loading2\";s:15:\"portfolio_label\";s:8:\"Projects\";s:15:\"search_template\";s:4:\"1276\";s:17:\"page_404_template\";s:4:\"1285\";}s:7:\"options\";a:2:{s:8:\"blogname\";s:11:\"Polaris Web\";s:15:\"blogdescription\";s:20:\"Polaris Web Holding \";}}", "yes");
INSERT INTO `wp_options` VALUES("5948", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("5949", "revslider_server_refresh", "1760930569", "yes");
INSERT INTO `wp_options` VALUES("5950", "revslider-update-check-short", "1761557219", "yes");
INSERT INTO `wp_options` VALUES("5951", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("5952", "revslider-update-hash", "f89cc4cd7cf396645adb141c085b283a", "yes");
INSERT INTO `wp_options` VALUES("5953", "revslider-latest-version", "6.7.38", "yes");
INSERT INTO `wp_options` VALUES("5954", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("5955", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-c.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("5956", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-c.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-c.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("5957", "rs-addons-counter", "33", "yes");
INSERT INTO `wp_options` VALUES("5958", "revslider-addons", "O:8:\"stdClass\":33:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("5959", "revslider-library-check", "1761557219", "yes");
INSERT INTO `wp_options` VALUES("5960", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "yes");
INSERT INTO `wp_options` VALUES("5961", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "off");
INSERT INTO `wp_options` VALUES("5962", "revslider-templates-check", "1761557220", "yes");
INSERT INTO `wp_options` VALUES("5963", "revslider-templates-hash", "42da1d3fd549004a80ff524485ae9caa", "yes");
INSERT INTO `wp_options` VALUES("5964", "rs-templates-new", "", "off");
INSERT INTO `wp_options` VALUES("5965", "rs-templates", "{\"hash\":\"e4d27ba1fec29e4694c39096dacb6dfa\",\"slider\":{\"0\":{\"id\":\"1\",\"title\":\"Classic Carousel\",\"alias\":\"classic-carousel\",\"zip\":\"classic-carousel.zip\",\"uid\":\"146a01dd380c0cdee85c4456ee68cd84\",\"img\":\"classic-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/carousel-slider-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=carousel-slider-plugin\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">Our classic, full-width carousel example. Drag, swipe or click to navigate!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-22 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"1\":{\"id\":\"2\",\"title\":\"Classic Slider\",\"alias\":\"classicslider\",\"zip\":\"classicslider.zip\",\"uid\":\"a0d6a9248c9066b404ba0f1cdadc5cf2\",\"img\":\"classicslider\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-slideshow-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-slideshow-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\" <span class=\\\"ttm_content\\\">A classic slideshow example with timer, bullets and arrow navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"2\":{\"id\":\"3\",\"title\":\"Content Tabs\",\"alias\":\"contenttabs\",\"zip\":\"contenttabs.zip\",\"uid\":\"e02e91604b690123a3d07a65582c4fd0\",\"img\":\"contenttabs\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-tabs-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-tabs-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1024\",\"height\":\"600\",\"description\":\" <span class=\\\"ttm_content\\\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"3\":{\"id\":\"4\",\"title\":\"Facebook Feed\",\"alias\":\"facebook-feed\",\"zip\":\"facebook-feed.zip\",\"uid\":\"5506431d5b1babcb25dcf52c508d42e3\",\"img\":\"facebook-feed\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-facebook-feed\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-facebook-feed\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Facebook Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"4\":{\"id\":\"5\",\"title\":\"Fashion\",\"alias\":\"fashion\",\"zip\":\"fashion.zip\",\"uid\":\"4f4b914d6db35e19101ff003c4e7ea3a\",\"img\":\"fashion\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-one-page-slider-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-one-page-slider-theme\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"  <span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"5\":{\"id\":\"6\",\"title\":\"Flickr Gallery\",\"alias\":\"flickr-gallery\",\"zip\":\"flickr-gallery.zip\",\"uid\":\"ad85cfac7acfa678e6a1b8febfee51ed\",\"img\":\"flickr-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-flickr-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-flickr-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"640\",\"description\":\" <span class=\\\"ttm_content\\\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"7\":{\"id\":\"8\",\"title\":\"Highlight Carousel\",\"alias\":\"highlight-carousel\",\"zip\":\"highlight-carousel.zip\",\"uid\":\"ada52163f723a942f782351fa0396b3d\",\"img\":\"highlight-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-swipe-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-swipe-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"720\",\"description\":\"  <span class=\\\"ttm_content\\\">A swipe-controlled carousel with an additional tab-based navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"8\":{\"id\":\"9\",\"title\":\"Highlight Showcase\",\"alias\":\"highlight-showcase\",\"zip\":\"highlight-showcase.zip\",\"uid\":\"2bfe0bd410fb48fec9d942eab1e21530\",\"img\":\"highlight-showcase\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-parallax-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"720\",\"description\":\"<span class=\\\"ttm_content\\\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"9\":{\"id\":\"10\",\"title\":\"Image Hero\",\"alias\":\"image-hero\",\"zip\":\"imagehero.zip\",\"uid\":\"7db18781d44f2adc28c962440894aac1\",\"img\":\"imagehero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-hero-image\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-image\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A commonly used full-width image hero block with texts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"10\":{\"id\":\"11\",\"title\":\"Instagram Gallery\",\"alias\":\"insta-gallery\",\"zip\":\"insta-gallery.zip\",\"uid\":\"711732b0d42ec2b57818a2b9b1d86cba\",\"img\":\"insta-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-instagram-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-instagram-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"640\",\"height\":\"640\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Instagram Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"11\":{\"id\":\"12\",\"title\":\"Levano Restaurant Bar\",\"alias\":\"levanorestaurantbar\",\"zip\":\"levanorestaurantbar.zip\",\"uid\":\"4178f837db67d1b2eb6cb5840bbd0b42\",\"img\":\"levanorestaurantbar\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-front-page-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-front-page-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"12\":{\"id\":\"13\",\"title\":\"Main Feature Slider\",\"alias\":\"mainfeature\",\"zip\":\"mainfeature.zip\",\"uid\":\"1e002a3230ab00095bedc6f60393ee7f\",\"img\":\"mainfeature\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"750\",\"description\":\" <span class=\\\"ttm_content\\\">A slightly stripped down version of the main preview slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"13\":{\"id\":\"14\",\"title\":\"Media Gallery Two\",\"alias\":\"media-gallery-two\",\"zip\":\"media-gallery-two.zip\",\"uid\":\"d002f1b1b55805f9322c264c5504ba5a\",\"img\":\"media-gallery-two\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-media-gallery-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery-slider\",\"version\":\"1.0.1\",\"required\":\"6.2.22\",\"width\":\"1230\",\"height\":\"692\",\"description\":\"<span class=\\\"ttm_content\\\">A media gallery example with Vimeo, HTML5 and Youtube videos.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change media and titles.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"14\":{\"id\":\"15\",\"title\":\"Media Carousel Autoplay\",\"alias\":\"media-carousel-autoplay\",\"zip\":\"media-carousel-autoplay.zip\",\"uid\":\"393d7875b1cc9d933378b35e4f645d76\",\"img\":\"media-carousel-autoplay\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-media-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"720\",\"height\":\"405\",\"description\":\"<span class=\\\"ttm_content\\\">A media carousel with \\\"autoplay\\\" activated. Swipe or click tabs to navigate the slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change media and caption texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"15\":{\"id\":\"16\",\"title\":\"News Background Video\",\"alias\":\"news-background-video\",\"zip\":\"news-bg-video.zip\",\"uid\":\"a0efe44ac3af0f958b3f84c816a08272\",\"img\":\"news-bg-video\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A hero block with HTML5 background video that plays when entering the screen.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"16\":{\"id\":\"17\",\"title\":\"News Gallery\",\"alias\":\"news-gallery\",\"zip\":\"news-gallery.zip\",\"uid\":\"3a069c3b286dbb9ee435563f747e3300\",\"img\":\"news-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-rotator\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-rotator\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A news gallery slideshow with tab navigation. Great for any blog!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"17\":{\"id\":\"18\",\"title\":\"News Gallery Post Based\",\"alias\":\"news-gallery-post-based\",\"zip\":\"news-gallery-post-based.zip\",\"uid\":\"32fe05b1039c29ab9420bfd15aec5488\",\"img\":\"news-gallery-post-based\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-post-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-post-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by WordPress posts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Post-Based Slider\\\"<\\/a>. Make sure to select the post type you want to display in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"18\":{\"id\":\"19\",\"title\":\"News Hero\",\"alias\":\"news-hero\",\"zip\":\"news-hero.zip\",\"uid\":\"96a0385538a17c8c81ed8175740f70ea\",\"img\":\"news-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A image hero block with ken burns effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"19\":{\"id\":\"20\",\"title\":\"News Video\",\"alias\":\"news-video\",\"zip\":\"news-video.zip\",\"uid\":\"f901e9e16e0363248156c2209eb584e9\",\"img\":\"news-video\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A Vimeo background video hero block with play \\/ pause buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the video and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"20\":{\"id\":\"21\",\"title\":\"Newsletter Hero\",\"alias\":\"newsletter-hero\",\"zip\":\"newsletter-hero.zip\",\"uid\":\"6290a9864d8c4c6311784586ed1cc5fe\",\"img\":\"newsletter-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-newsletter-signup\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-newsletter-signup\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This hero block uses a custom styled Mailchimp newsletter signup field.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/how-to-setup-mailchimp-for-the-newsletter-hero-template\\/\\\" target=\\\"_blank\\\">Mailchimp code<\\/a>.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"21\":{\"id\":\"22\",\"title\":\"Not Generic\",\"alias\":\"notgeneric\",\"zip\":\"notgeneric.zip\",\"uid\":\"9d87ba95e02210a9f82387add2ceadf9\",\"img\":\"notgeneric\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-fullscreen-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a layer based navigation and sleek content elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"22\":{\"id\":\"23\",\"title\":\"Photography\",\"alias\":\"photography\",\"zip\":\"photography.zip\",\"uid\":\"1b2072547afb75e49f33b016751ed360\",\"img\":\"photography\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photography-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photography-slider\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"23\":{\"id\":\"24\",\"title\":\"Photography Carousel\",\"alias\":\"photography-carousel\",\"zip\":\"photography-carousel.zip\",\"uid\":\"9a84b859ba23dc49ba8784e3a86545fa\",\"img\":\"photography-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1024\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"24\":{\"id\":\"25\",\"title\":\"Search Form Hero\",\"alias\":\"search-form-hero\",\"zip\":\"search-form-hero.zip\",\"uid\":\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\",\"img\":\"search-form-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-search-form-hero\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-search-form-hero\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This hero block uses a custom styled input field to show search results on a WordPress site.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"25\":{\"id\":\"26\",\"title\":\"Showcase Carousel\",\"alias\":\"showcasecarousel\",\"zip\":\"showcasecarousel.zip\",\"uid\":\"c5ca218398331bd2c064efc2f62eae56\",\"img\":\"showcasecarousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-cover-flow-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-flow-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"600\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A fancy carousel that rotates, fades and scales slider items.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content carousel. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"26\":{\"id\":\"27\",\"title\":\"Sports Hero\",\"alias\":\"sports-hero\",\"zip\":\"sportshero.zip\",\"uid\":\"8de7a145f32a362d618d2595ffa2f724\",\"img\":\"sportshero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-image-hero\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-image-hero\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"720\",\"description\":\"<span class=\\\"ttm_content\\\">An sports themed image hero block with buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"28\":{\"id\":\"29\",\"title\":\"Vimeo Gallery\",\"alias\":\"vimeo-gallery\",\"zip\":\"vimeo-gallery.zip\",\"uid\":\"fa824ce1ff3942ec268fc9eda60df539\",\"img\":\"vimeo-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-vimeo-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-vimeo-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"692\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Vimeo Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"29\":{\"id\":\"30\",\"title\":\"Vimeo Hero\",\"alias\":\"vimeohero\",\"zip\":\"vimeohero.zip\",\"uid\":\"c575575f96173d88589cddcb06120b77\",\"img\":\"vimeohero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-hero-vimeo\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-vimeo\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A commonly used Vimeo video background hero block.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"30\":{\"id\":\"31\",\"title\":\"Web Product Dark\",\"alias\":\"web-product-dark\",\"zip\":\"web-product-dark.zip\",\"uid\":\"39b872cf0608e63c3a503e58374dc30a\",\"img\":\"web-product-dark\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-frontpage-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-frontpage-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"31\":{\"id\":\"32\",\"title\":\"Web Product Dark Hero\",\"alias\":\"web-product-dark-hero\",\"zip\":\"web-product-dark-hero.zip\",\"uid\":\"b6784e8925221f36677217979d26e6f0\",\"img\":\"web-product-dark-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-header-image\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern hero block with three common devices. The screens of each device can be changed easily!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"32\":{\"id\":\"33\",\"title\":\"Web Product Light Hero\",\"alias\":\"web-product-light-hero\",\"zip\":\"web-product-light-hero.zip\",\"uid\":\"428e65d6aaa6ef775429989d50516492\",\"img\":\"web-product-light-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/hero-image-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-image-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern hero block with three common devices. The screens of each device can be changed easily!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"33\":{\"id\":\"34\",\"title\":\"Web Product Light\",\"alias\":\"webproductlight\",\"zip\":\"webproductlight.zip\",\"uid\":\"fa23dab5bf1139c6393828647a9de4e0\",\"img\":\"webproductlight\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-cover-page\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-page\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"34\":{\"id\":\"35\",\"title\":\"Youtube Gallery\",\"alias\":\"youtube-gallery\",\"zip\":\"youtube-gallery.zip\",\"uid\":\"ee9e4928ac74f5f0c0b697ce708f5aa7\",\"img\":\"youtube-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-youtube-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"YouTube Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"35\":{\"id\":\"36\",\"title\":\"Youtube Hero\",\"alias\":\"youtubehero\",\"zip\":\"youtubehero.zip\",\"uid\":\"e0b2c12a45841bdf21cb96305f2c85bf\",\"img\":\"youtubehero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-youtube-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-header\",\"version\":\"1.0.3\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A YouTube video background hero block.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/enable-sound-for-the-youtube-hero-template\\/\\\" target=\\\"_blank\\\">enable sound for the background video<\\/a><br \\/><br \\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"36\":{\"id\":\"37\",\"title\":\"Scroll Effect\",\"alias\":\"scroll-effect\",\"zip\":\"scroll-effect.zip\",\"uid\":\"417f59e9db87aa7e47c8509eb88d4af6\",\"img\":\"scrolleffect\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/big-bold-fullscreen-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=big-bold-fullscreen-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a unique scroll effect and big, bold text.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"37\":{\"id\":\"38\",\"title\":\"Content Zoom\",\"alias\":\"content-zoom\",\"zip\":\"content-zoom.zip\",\"uid\":\"42ef8cdb70d42ec6ff6fa3b69a027b5f\",\"img\":\"contentzoom\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/content-zoom-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=content-zoom-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A very unique full-width slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"38\":{\"id\":\"39\",\"title\":\"Food Carousel\",\"alias\":\"food-carousel\",\"zip\":\"food-carousel.zip\",\"uid\":\"a7bf54527b6658a0a308c70c729779fe\",\"img\":\"foodcarousel\\/slider_cover.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/food-carousel-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-carousel-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A fancy carousel with detail content on each slide. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to show and hide layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"40\":{\"id\":\"41\",\"title\":\"Travel Static Captions\",\"alias\":\"travel-static-captions\",\"zip\":\"travel-static-captions.zip\",\"uid\":\"bbe7d61c7c741ebc7aa1ce1082b0cb71\",\"img\":\"travel-static-captions\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/travel-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=travel-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A slideshow example with static captions layers above a rotating image background.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"41\":{\"id\":\"42\",\"title\":\"Concept\",\"alias\":\"concept\",\"zip\":\"concept.zip\",\"uid\":\"47cb06083e87503762f6746725117a3c\",\"img\":\"concept\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"42\":{\"id\":\"43\",\"title\":\"True Fullscreen\",\"alias\":\"fullscreen-button\",\"zip\":\"fullscreen-button.zip\",\"uid\":\"618a43bdf89333b555531f6d6ecde359\",\"img\":\"fullscreen-button\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-sidebar-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-sidebar-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A slider with a full-screen button that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change the background images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"43\":{\"id\":\"44\",\"title\":\"Creative Freedom\",\"alias\":\"creativefreedom\",\"zip\":\"creativefreedom.zip\",\"uid\":\"8902bf6c93126c2c6323626b9e872621\",\"img\":\"creativefreedom\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-touch-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-touch-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images, videos and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"44\":{\"id\":\"45\",\"title\":\"3D Parallax Scene\",\"alias\":\"parallaxscene\",\"zip\":\"parallaxscene.zip\",\"uid\":\"51566f1ce649708e97a0f5dfaf05ea19\",\"img\":\"parallaxscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-3d-parallax\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-parallax\",\"version\":\"1.0.2\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"700\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"45\":{\"id\":\"46\",\"title\":\"Wow Factor\",\"alias\":\"slidingoverlays\",\"zip\":\"slidingoverlays.zip\",\"uid\":\"18002d17e8bc7ca61b0951f5305a759e\",\"img\":\"slidingoverlays\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/responsive-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=responsive-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax effect full-screen slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"46\":{\"id\":\"47\",\"title\":\"3D Web Product\",\"alias\":\"web-product-light-hero-3d\",\"zip\":\"web-product-light-hero-3d.zip\",\"uid\":\"efd345c5da805414093e46066cefd751\",\"img\":\"web-product-light-hero-3d\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-3d-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-scene\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1400\",\"height\":\"668\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"47\":{\"id\":\"48\",\"title\":\"WooCommerce Big\",\"alias\":\"woobig\",\"zip\":\"woobig.zip\",\"uid\":\"bfb09a39656c7c80e86b468fc5b3403c\",\"img\":\"woobig\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/woocommerce-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1200\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"WooCommerce Slider\\\"<\\/a>. Make sure to select the products you want to show in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\",\"woocommerce\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"48\":{\"id\":\"49\",\"title\":\"WooCommerce Small\",\"alias\":\"woocommercesmall\",\"zip\":\"woocommercesmall.zip\",\"uid\":\"b17c2adcc5c4c4b68a7ac6fee32fa030\",\"img\":\"woocommercesmall\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/woocommerce-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"400\",\"height\":\"266\",\"description\":\" <span class=\\\"ttm_content\\\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"WooCommerce Slider\\\"<\\/a>. Make sure to select the products you want to show in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\",\"woocommerce\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"49\":{\"id\":\"50\",\"title\":\"Restaurant Header\",\"alias\":\"finedining\",\"zip\":\"finedining.zip\",\"uid\":\"03481a9e258501fbe3888b48830ea845\",\"img\":\"finedining\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/restaurant-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-hero-header\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen hero block slider that shows different background layers on button hover using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"50\":{\"id\":\"51\",\"title\":\"Agency Website Header\",\"alias\":\"agency-intro\",\"zip\":\"agency-intro.zip\",\"uid\":\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\",\"img\":\"agency-intro\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/agency-website-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=agency-website-hero-header\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"51\":{\"id\":\"52\",\"title\":\"Team Slider\",\"alias\":\"ourteam\",\"zip\":\"ourteam.zip\",\"uid\":\"d8eb1fec07a79202d1118bb17f70c233\",\"img\":\"ourteam\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/thumbnail-hover-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.4\",\"width\":\"1400\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-thumbnails-for-our-team-template\\/\\\" target=\\\"_blank\\\">modify the thumbnails<\\/a><br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"52\":{\"id\":\"53\",\"title\":\"Team Carousel\",\"alias\":\"our-team-carousel\",\"zip\":\"our-team-carousel.zip\",\"uid\":\"37656d5dcab1f265c025cb2a3d669809\",\"img\":\"ourteamcarousel\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/thumbnail-hover-carousel-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-carousel-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.4\",\"width\":\"1000\",\"height\":\"800\",\"description\":\" <span class=\\\"ttm_content\\\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content carousel. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-thumbnails-for-our-team-template\\/\\\" target=\\\"_blank\\\">modify the thumbnails<\\/a><br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"53\":{\"id\":\"54\",\"title\":\"4K Youtube Slider\",\"alias\":\"betteryoutube\",\"zip\":\"betteryoutube.zip\",\"uid\":\"d7c5fef9f257037d7a148038aa2a1857\",\"img\":\"betteryoutube\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\",\"version\":\"1.0.2\",\"required\":\"5.1.4\",\"width\":\"1200\",\"height\":\"675\",\"description\":\" <span class=\\\"ttm_content\\\">A full-screen youtube gallery with 4K videos as an example. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to breathe life into navigation elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change videos and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"54\":{\"id\":\"55\",\"title\":\"Agency Website Header\",\"alias\":\"agencywebsiteheader\",\"zip\":\"agencywebsiteheader.zip\",\"uid\":\"c11d272c87277a7a38d9e7fd13e27947\",\"img\":\"agencywebsiteheader\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-hero-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-hero-slider\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A very unique full-screen slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"55\":{\"id\":\"56\",\"title\":\"Coming Soon\",\"alias\":\"comingsoon\",\"zip\":\"comingsoon.zip\",\"uid\":\"0f89edf995512e6d6e864a2ee7221829\",\"img\":\"comingsoon\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/coming-soon-wordpress-under-construction-site\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-wordpress-under-construction-site\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that can be used as a \\\"Coming Soon\\\" page. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve various interaction possibilities.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\nInstructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/change-date-for-coming-soon-template\\/\\\" target=\\\"_blank\\\">how to change the date.<\\/a><br \\/><br \\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"56\":{\"id\":\"57\",\"title\":\"Christmas Snow Scene\",\"alias\":\"snowscene\",\"zip\":\"snowscene.zip\",\"uid\":\"a747bf0837caff86c62419a746690209\",\"img\":\"snowscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/christmas-snow-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=christmas-snow-scene\",\"version\":\"1.0.5\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A slider with multiple christmas themed slides and a neat snow fall effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"57\":{\"id\":\"58\",\"title\":\"Rock Band Music\",\"alias\":\"rockband\",\"zip\":\"rockband.zip\",\"uid\":\"5f557a5fad2fd6ca982a6ae6e9619637\",\"img\":\"rockband\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/rock-band-music-theme-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rock-band-music-theme-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A rock band themed hero block slider with an embedded SoundCloud element.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"58\":{\"id\":\"59\",\"title\":\"Sleek Landing Page\",\"alias\":\"sleeklandingpage\",\"zip\":\"sleeklandingpage.zip\",\"uid\":\"07f7f2608936a8ae226213b7d99eee3f\",\"img\":\"sleeklandingpage\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/landing-page-free-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-free-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-22 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"59\":{\"id\":\"60\",\"title\":\"App Landing Page\",\"alias\":\"applandingpage\",\"zip\":\"applandingpage.zip\",\"uid\":\"38eb600893c1484ab8fd2a3dce3678d7\",\"img\":\"applandingpage\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/app-landing-page-free-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-landing-page-free-template\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"60\":{\"id\":\"61\",\"title\":\"Desk Scene\",\"alias\":\"deskscene\",\"zip\":\"deskscene.zip\",\"uid\":\"172a1a89a3e3b333cb4dbeb238f534c5\",\"img\":\"deskscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/hero-desk-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-desk-scene\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A beautiful desk scene with a cool reveal effect when scrolling down.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"61\":{\"id\":\"62\",\"title\":\"Clean News Slider\",\"alias\":\"cleannewsslider\",\"zip\":\"cleannewsslider.zip\",\"uid\":\"82c3f521fe31b80984be0f19e1a9899e\",\"img\":\"cleannewsslider\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A slideshow example with clean content and thumbnail navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"62\":{\"id\":\"63\",\"title\":\"Image Gallery\",\"alias\":\"imagegallery\",\"zip\":\"imagegallery.zip\",\"uid\":\"cef1d75357df2cb53b990c74a214813e\",\"img\":\"imagegallery\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1000\",\"height\":\"667\",\"description\":\"<span class=\\\"ttm_content\\\">A photo gallery suitable to display your images using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"63\":{\"id\":\"64\",\"title\":\"Standard WP Gallery\",\"alias\":\"standard-wp-gallery\",\"zip\":\"standard-wp-gallery.zip\",\"uid\":\"632035b8a27652d8081dbdfa343dc93d\",\"img\":\"standard-wp-gallery\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1000\",\"height\":\"667\",\"description\":\"<span class=\\\"ttm_content\\\">A photo gallery that uses the \\\"Standard WP Gallery\\\" add-on to display images.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">Please follow the setup guide on the \\\"Standard WP Gallery\\\" add-on page.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-gallery-addon\\\\\\/revslider-gallery-addon.php\\\",\\\"name\\\":\\\"WP Gallery AddOn\\\",\\\"url\\\":\\\"http:\\\\\\/\\\\\\/revolution.themepunch.com\\\\\\/wordpress-photo-gallery-plugin\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"64\":{\"id\":\"65\",\"title\":\"Clean News Post Based\",\"alias\":\"clean-news-post-based\",\"zip\":\"clean-news-post-based.zip\",\"uid\":\"f4cf5bbe51afa5a361754bb081cbabf2\",\"img\":\"clean-news-post-based\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1200\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by WordPress posts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Post-Based Slider\\\"<\\/a>. Make sure to select the post type you want to display in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"65\":{\"id\":\"66\",\"title\":\"Interactive Whiteboard\",\"alias\":\"interactivewhiteboard\",\"zip\":\"interactivewhiteboard.zip\",\"uid\":\"058b4af535d6c6c7bcec5225845e3eb4\",\"img\":\"interactivewhiteboard\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=interactive-whiteboard-animation-free-addon\",\"version\":\"1.0.5\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider from the Whiteboard add-on preview.<br\\/><a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve certain effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This slider template requires the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/whiteboard-addon\\/\\\" target=\\\"_blank\\\">Whiteboard add-on<\\/a> to be installed. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-whiteboard-addon\\\\\\/revslider-whiteboard-addon.php\\\",\\\"name\\\":\\\"Whiteboard AddOn\\\",\\\"url\\\":\\\"http:\\\\\\/\\\\\\/revolution.themepunch.com\\\\\\/interactive-whiteboard-animation-free-addon\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"66\":{\"id\":\"68\",\"title\":\"Innovation Slider\",\"alias\":\"innovation\",\"zip\":\"innovation.zip\",\"uid\":\"d3440b69126d9c186fddc713b18b0002\",\"img\":\"innovation\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider-plugin-2016\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2016\",\"version\":\"1.0.5\",\"required\":\"5.2.3.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with an elegant fade-out parallax effect. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images, videos and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-03-29 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"67\":{\"id\":\"69\",\"title\":\"Dark Content Block - Menu\",\"alias\":\"dark-fullsite-block-menu\",\"zip\":\"packs\\/dark-fullsite-block-menu.zip\",\"uid\":\"bf4bd226719d3c3d3146592976e31ca1\",\"img\":\"dark-fullsite-block-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"68\":{\"id\":\"70\",\"title\":\"Dark Content Block - Hero\",\"alias\":\"dark-fullsite-block-1\",\"zip\":\"packs\\/dark-fullsite-block-1.zip\",\"uid\":\"d8859245fe600288ca932dc29aca751f\",\"img\":\"dark-fullsite-block-1\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"69\":{\"id\":\"71\",\"title\":\"Dark Content Block - About\",\"alias\":\"dark-fullsite-block-2-about\",\"zip\":\"packs\\/dark-fullsite-block-2-about.zip\",\"uid\":\"298401901521a197a8294c1b4f73df3e\",\"img\":\"dark-fullsite-block-2-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"70\":{\"id\":\"72\",\"title\":\"Dark Content Block - Services\",\"alias\":\"dark-fullsite-block-3-services\",\"zip\":\"packs\\/dark-fullsite-block-3-services.zip\",\"uid\":\"8da3ed605472ed6a26c745fb52f85f82\",\"img\":\"dark-fullsite-block-3-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"71\":{\"id\":\"73\",\"title\":\"Dark Content Block - Products\",\"alias\":\"dark-fullsite-block-4-products\",\"zip\":\"packs\\/dark-fullsite-block-4-products.zip\",\"uid\":\"99e4f40399d20261a6131043d0e50b0c\",\"img\":\"dark-fullsite-block-4-products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\\r\\n\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"72\":{\"id\":\"74\",\"title\":\"Dark Content Block - Testimonials\",\"alias\":\"dark-fullsite-block-5-testimonials\",\"zip\":\"packs\\/dark-fullsite-block-5-testimonials.zip\",\"uid\":\"2f9121e0eedd51afe85e233d0743acab\",\"img\":\"dark-fullsite-block-5-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"73\":{\"id\":\"75\",\"title\":\"Dark Content Block - Callout\",\"alias\":\"dark-fullsite-block-6-callout\",\"zip\":\"packs\\/dark-fullsite-block-6-callout.zip\",\"uid\":\"55fbecb113ff21f050be7adc08637329\",\"img\":\"dark-fullsite-block-6-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"74\":{\"id\":\"76\",\"title\":\"Dark Content Block - Footer\",\"alias\":\"dark-fullsite-block-7-footer\",\"zip\":\"packs\\/dark-fullsite-block-7-footer.zip\",\"uid\":\"2ff517f5c7c54e3e0c2dd733cfd3400e\",\"img\":\"dark-fullsite-block-7-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"75\":{\"id\":\"77\",\"title\":\"Light Content Block - Menu\",\"alias\":\"fullsite-block-menu\",\"zip\":\"packs\\/fullsite-block-menu.zip\",\"uid\":\"8010971f34387d5f94a1f4e577ef382a\",\"img\":\"fullsite-block-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"76\":{\"id\":\"78\",\"title\":\"Light Content Block - Hero\",\"alias\":\"fullsite-block1\",\"zip\":\"packs\\/fullsite-block1.zip\",\"uid\":\"45bf7179843e01ce112e8ec754b0455c\",\"img\":\"fullsite-block1\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"77\":{\"id\":\"79\",\"title\":\"Light Content Block - About\",\"alias\":\"fullsite-block-2-about\",\"zip\":\"packs\\/fullsite-block-2-about.zip\",\"uid\":\"8402b460638a746d36433cb161440b7d\",\"img\":\"fullsite-block-2-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"78\":{\"id\":\"80\",\"title\":\"Light Content Block - Services\",\"alias\":\"fullsite-block-3-services\",\"zip\":\"packs\\/fullsite-block-3-services.zip\",\"uid\":\"7b8cea27f4d6ae17c5e1eae12457bd06\",\"img\":\"fullsite-block-3-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"79\":{\"id\":\"81\",\"title\":\"Light Content Block - Products\",\"alias\":\"fullsite-block-4-products\",\"zip\":\"packs\\/fullsite-block-4-products.zip\",\"uid\":\"d148935362d7122636cda0635eae4be7\",\"img\":\"fullsite-block-4-products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"80\":{\"id\":\"82\",\"title\":\"Light Content Block - Testimonials\",\"alias\":\"fullsite-block-5-testimonials\",\"zip\":\"packs\\/fullsite-block-5-testimonials.zip\",\"uid\":\"06255bfd421e40f71fa8197b839dbf03\",\"img\":\"fullsite-block-5-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"81\":{\"id\":\"83\",\"title\":\"Light Content Block - Callout\",\"alias\":\"fullsite-block-6-callout\",\"zip\":\"packs\\/fullsite-block-6-callout.zip\",\"uid\":\"8a88c3447676b613ec5db2fe5d63315c\",\"img\":\"fullsite-block-6-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"82\":{\"id\":\"84\",\"title\":\"Light Content Block - Footer\",\"alias\":\"fullsite-block-7-footer\",\"zip\":\"packs\\/fullsite-block-7-footer.zip\",\"uid\":\"34300b4407a2093eb2e1e08868fa8319\",\"img\":\"fullsite-block-7-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"83\":{\"id\":\"85\",\"title\":\"Tech Journal\",\"alias\":\"techjournal\",\"zip\":\"techjournal.zip\",\"uid\":\"7f92d70d1c108378f915b18c2ceb71d6\",\"img\":\"techjournal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5.1\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with navigation direction-based transitions.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"84\":{\"id\":\"86\",\"title\":\"Car Dealership\",\"alias\":\"cardealership\",\"zip\":\"cardealership.zip\",\"uid\":\"bb010838855a8ae4d1dd68e139bf169e\",\"img\":\"cardealership\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/car-dealership-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=car-dealership-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.1\",\"width\":\"1240\",\"height\":\"650\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with navigation direction-based transitions.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"85\":{\"id\":\"87\",\"title\":\"FullScreen Menu Slider\",\"alias\":\"fullscreenmenu\",\"zip\":\"fullscreenmenu.zip\",\"uid\":\"6de81d74c4bf193e2e274d43038adc85\",\"img\":\"fullscreenmenu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-fullscreen-menu\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-menu\",\"version\":\"1.0.1\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that contains a menu with slide blur effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"86\":{\"id\":\"88\",\"title\":\"Creative Frontpage\",\"alias\":\"creativefrontpage\",\"zip\":\"creativefrontpage.zip\",\"uid\":\"0636cb368af3bcaa2f68eb0ebefe6439\",\"img\":\"creativefrontpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with hidden slides that are triggered via  <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"95\":{\"id\":\"97\",\"title\":\"Focus Parallax Effect\",\"alias\":\"focusparallax\",\"zip\":\"focusparallax.zip\",\"uid\":\"13bd15fb3ddf8b9841cb55b89389cc73\",\"img\":\"focusparallax\\/slide1.jpg\",\"preview\":\" https:\\/\\/revolution.themepunch.com\\/parallax-effect-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-effect-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with mouse controlled parallax effects. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"96\":{\"id\":\"98\",\"title\":\"Duotone Slider\",\"alias\":\"duotone\",\"zip\":\"duotone.zip\",\"uid\":\"494862ceb6cb7c6658ad7cd36848cccd\",\"img\":\"duotone\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-header-image-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.4\",\"width\":\"1200\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with unique parallax scroll effect. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"97\":{\"id\":\"99\",\"title\":\"Minimal Menu\",\"alias\":\"r_menu\",\"zip\":\"packs\\/r_menu.zip\",\"uid\":\"30d6a6895db1a5f29b1679061551c9f0\",\"img\":\"r_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"110\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"98\":{\"id\":\"100\",\"title\":\"Minimal Hero\",\"alias\":\"rhero\",\"zip\":\"packs\\/r_hero.zip\",\"uid\":\"b8b46186956f6e66ad0c08e4532bbbde\",\"img\":\"r_hero\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"700\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"99\":{\"id\":\"101\",\"title\":\"Minimal About\",\"alias\":\"r_about\",\"zip\":\"packs\\/r_about.zip\",\"uid\":\"343010c4b4c03f92888c3e9e95bc2bb1\",\"img\":\"r_about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"100\":{\"id\":\"102\",\"title\":\"Minimal Products\",\"alias\":\"r_products\",\"zip\":\"packs\\/r_products.zip\",\"uid\":\"dda93e85c6a4456d132040147f087f39\",\"img\":\"r_products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"1100\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"101\":{\"id\":\"103\",\"title\":\"Minimal Info\",\"alias\":\"r_info\",\"zip\":\"packs\\/r_info.zip\",\"uid\":\"d6e368e8fd4862174af6c980389ae530\",\"img\":\"r_info\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"102\":{\"id\":\"104\",\"title\":\"Inspiration Header\",\"alias\":\"inspirationheader\",\"zip\":\"inspirationheader.zip\",\"uid\":\"69f04b2be0b618fa7e184af83b86b7e7\",\"img\":\"inspirationheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme-header\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This full-screen hero slider features sequentially animated texts and cool parallax elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"103\":{\"id\":\"105\",\"title\":\"Magazine Slider\",\"alias\":\"magazineposts\",\"zip\":\"magazineposts.zip\",\"uid\":\"c562f3457e4edbd030959f7c5e6e0f7c\",\"img\":\"magazineposts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-magazine-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-magazine-slider\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1400\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"104\":{\"id\":\"106\",\"title\":\"News Header\",\"alias\":\"explorationheader\",\"zip\":\"explorationheader.zip\",\"uid\":\"8f20d5a868c90ded08b835fb9e8307d7\",\"img\":\"explorationheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-news-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-header\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> to add links to buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"105\":{\"id\":\"107\",\"title\":\"Minimal Website Package\",\"alias\":\"minimal-website-package\",\"zip\":\"\",\"uid\":\"minimal-website-package\",\"img\":\"packages\\/template_group_1_1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"110\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"107\":{\"id\":\"109\",\"title\":\"Dark Content Block Package\",\"alias\":\"dark-fullsite-block-package\",\"zip\":\"\",\"uid\":\"dark-fullsite-block-package\",\"img\":\"packages\\/template_group_4.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"108\":{\"id\":\"110\",\"title\":\"Light Content Block Package\",\"alias\":\"fullsite-block-package\",\"zip\":\"\",\"uid\":\"fullsite-block-package\",\"img\":\"packages\\/template_group_3.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"109\":{\"id\":\"111\",\"title\":\"Typewriter Effect\",\"alias\":\"typewritereffect\",\"zip\":\"typewritereffect.zip\",\"uid\":\"d6f8bae06cc4a7b158d680c01e59ddc2\",\"img\":\"typewritereffect\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-typewriter-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-typewriter-effect\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider from the Typewriter add-on preview.<br\\/><a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This slider template requires the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\\\" target=\\\"_blank\\\">Typewriter add-on<\\/a> to be installed. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"110\":{\"id\":\"112\",\"title\":\"Blend Mode Header\",\"alias\":\"blendmodeheader\",\"zip\":\"blendmodeheader.zip\",\"uid\":\"2e44e976596d757aab40ffa28086dcf9\",\"img\":\"blendmodeheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/blend-mode-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blend-mode-hero-header\",\"version\":\"1.0.1\",\"required\":\"6.7.34\",\"width\":\"1240\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"111\":{\"id\":\"113\",\"title\":\"Themeplicity Menu\",\"alias\":\"themeplicity_menu\",\"zip\":\"packs\\/themeplicity_menu.zip\",\"uid\":\"7d5c1e75eaafa63683895a32a62f4ce0\",\"img\":\"themeplicity_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"90\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"112\":{\"id\":\"114\",\"title\":\"Themeplicity Header\",\"alias\":\"themeplicity_header\",\"zip\":\"packs\\/themeplicity_header.zip\",\"uid\":\"907091e4d58acc7d12f802de2f280b7d\",\"img\":\"themeplicity_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"113\":{\"id\":\"115\",\"title\":\"Themeplicity Offer\",\"alias\":\"themeplicity_offer\",\"zip\":\"packs\\/themeplicity_offer.zip\",\"uid\":\"1bd8f9aa2f3e340449664c65ba17fb51\",\"img\":\"themeplicity_offer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"330\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"114\":{\"id\":\"116\",\"title\":\"Themeplicity What We Do\",\"alias\":\"themeplicity_whatwedo\",\"zip\":\"packs\\/themeplicity_whatwedo.zip\",\"uid\":\"aa800a44b5a3eab30414dde1f32bfed7\",\"img\":\"themeplicity_whatwedo\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"813\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"115\":{\"id\":\"117\",\"title\":\"Themeplicity Projects\",\"alias\":\"themeplicity_projects\",\"zip\":\"packs\\/themeplicity_projects.zip\",\"uid\":\"5f61b3a13033ba6a51a18270163e0a50\",\"img\":\"themeplicity_projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"813\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"116\":{\"id\":\"118\",\"title\":\"Themeplicity Whats Great\",\"alias\":\"themeplicity_whatsgreat\",\"zip\":\"packs\\/themeplicity_whatsgreat.zip\",\"uid\":\"ce9faf8c55ed2e33e091b23667e7173b\",\"img\":\"themeplicity_whatsgreat\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"117\":{\"id\":\"119\",\"title\":\"Themeplicity Tables\",\"alias\":\"themeplicity_tables\",\"zip\":\"packs\\/themeplicity_tables.zip\",\"uid\":\"f28bb4cd20ec1f29a1de7da5ad09c293\",\"img\":\"themeplicity_tables\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1059\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"118\":{\"id\":\"120\",\"title\":\"Themeplicity Contactform\",\"alias\":\"themeplicity_contactform\",\"zip\":\"packs\\/themeplicity_contactform.zip\",\"uid\":\"3e59da970f534490774fa8e053f5b5ed\",\"img\":\"themeplicity_contactform\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1067\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"119\":{\"id\":\"121\",\"title\":\"Themeplicity Footer\",\"alias\":\"themeplicity_footer\",\"zip\":\"packs\\/themeplicity_footer.zip\",\"uid\":\"89eeb0b4b852c5f743e1bd76e3e8f2ef\",\"img\":\"themeplicity_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"780\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"120\":{\"id\":\"122\",\"title\":\"Themeplicity Package\",\"alias\":\"themeplicity-package\",\"zip\":\"\",\"uid\":\"themeplicity-package\",\"img\":\"packages\\/templatepack_themeplicity.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"121\":{\"id\":\"123\",\"title\":\"Nice And Clean Menu\",\"alias\":\"NiceAndClean_Menu\",\"zip\":\"packs\\/NiceAndClean_Menu.zip\",\"uid\":\"3f8c01e26c7446428e045c4b1180776d\",\"img\":\"NiceAndClean_Menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"90\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"122\":{\"id\":\"124\",\"title\":\"Nice And Clean Header\",\"alias\":\"NiceAndClean_Header\",\"zip\":\"packs\\/NiceAndClean_Header.zip\",\"uid\":\"76931033addb20a62557c2845a4d6a11\",\"img\":\"NiceAndClean_Header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"123\":{\"id\":\"125\",\"title\":\"Nice And Clean Services\",\"alias\":\"NiceAndClean_Services\",\"zip\":\"packs\\/NiceAndClean_Services.zip\",\"uid\":\"02f72ec606800c8215bcadea09624e87\",\"img\":\"NiceAndClean_Services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"360\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"124\":{\"id\":\"126\",\"title\":\"Nice And Clean About\",\"alias\":\"NiceAndClean_About\",\"zip\":\"packs\\/NiceAndClean_About.zip\",\"uid\":\"9510f6fdbb8e9473e8c22f692a6bc89f\",\"img\":\"NiceAndClean_About\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"125\":{\"id\":\"127\",\"title\":\"Nice And Clean Video\",\"alias\":\"niceandclean_video\",\"zip\":\"packs\\/niceandclean_video.zip\",\"uid\":\"2bb9e1ad329435cc500542d0c7025e15\",\"img\":\"niceandclean_video\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"126\":{\"id\":\"128\",\"title\":\"Nice And Clean Highlights\",\"alias\":\"niceandclean_highlights\",\"zip\":\"packs\\/niceandclean_highlights.zip\",\"uid\":\"ff396af163a79d2d5b35db17c1ea7aa6\",\"img\":\"niceandclean_highlights\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"127\":{\"id\":\"129\",\"title\":\"Nice And Clean Projects\",\"alias\":\"NiceAndClean_Projects\",\"zip\":\"packs\\/NiceAndClean_Projects.zip\",\"uid\":\"1e6695959ef83f8975b52289c08a4d44\",\"img\":\"NiceAndClean_Projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"600\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"128\":{\"id\":\"130\",\"title\":\"Nice And Clean TextBlocks\",\"alias\":\"niceandclean_textblocks\",\"zip\":\"packs\\/niceandclean_textblocks.zip\",\"uid\":\"1f33eb839c96ea3225faff1c8d382b05\",\"img\":\"niceandclean_textblocks\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"129\":{\"id\":\"131\",\"title\":\"Nice And Clean CallOut\",\"alias\":\"niceandclean_callout\",\"zip\":\"packs\\/niceandclean_callout.zip\",\"uid\":\"54d4d9bcf79d357de0e614700e909863\",\"img\":\"niceandclean_callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"130\":{\"id\":\"132\",\"title\":\"Nice And Clean Footer\",\"alias\":\"niceandclean_footer\",\"zip\":\"packs\\/niceandclean_footer.zip\",\"uid\":\"5492d7f72b3771a4e754f91bda063b15\",\"img\":\"niceandclean_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"400\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">For using the social sharing buttons, please install the social sharing add-on.<br><br><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"131\":{\"id\":\"134\",\"title\":\"80s Style Intro\",\"alias\":\"80s\",\"zip\":\"80s.zip\",\"uid\":\"98881ab51f71b2fbdb220752d321b15a\",\"img\":\"80s\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/80s-style-intro\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=80s-style-intro\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This intro hero block takes you back to the 80\'s with some funky effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and text.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"132\":{\"id\":\"135\",\"title\":\"Blur Effect Slider\",\"alias\":\"blurslider\",\"zip\":\"blurslider.zip\",\"uid\":\"83bd6e1ccef83f03c944fa05b0a2d879\",\"img\":\"blurslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/blur-effect-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blur-effect-slider\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider makes use of the brand new blur effects available with version 5.3.1.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change the background images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"133\":{\"id\":\"136\",\"title\":\"Coming Soon Add-On\",\"alias\":\"ComingSoonAddon\",\"zip\":\"ComingSoonAddon.zip\",\"uid\":\"51258492055b940099eb96ba52901fa9\",\"img\":\"ComingSoonAddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coming-soon-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-add-on\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider template makes use of the brand new Coming Soon Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-maintenance-addon\\\\\\/revslider-maintenance-addon.php\\\",\\\"name\\\":\\\"Coming Soon & Maintenance AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/revslider-doc\\\\\\/add-coming-soon-maintenance\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"134\":{\"id\":\"137\",\"title\":\"Nice And Clean Package\",\"alias\":\"nice-and-clean-package\",\"zip\":\"\",\"uid\":\"nice-and-clean-package\",\"img\":\"packages\\/templatepack_niceandclean.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"135\":{\"id\":\"138\",\"title\":\"Snow Effect Add-On\",\"alias\":\"snowaddon\",\"zip\":\"snowaddon.zip\",\"uid\":\"7408d8567b8af5716eaabd390422e51b\",\"img\":\"snowaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/snow-effect-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=snow-effect-add-on\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \\\"Holiday Snow\\\" Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"136\":{\"id\":\"139\",\"title\":\"Particle Effect One\",\"alias\":\"particle-effect-one\",\"zip\":\"particle-effect-one.zip\",\"uid\":\"a4611c906e35ca60f617da86217b5299\",\"img\":\"particle-effect-one\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-effect-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \\\"BLEND MODE IMAGE\\\" layer and go to \\\"advanced style -> filters -> blend mode\\\".<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Increase Engagement with Particle Effects and Blend Mode [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-increase-engagement-with-particle-effects-and-blend-mode\\/\",\"guide_img\":\"tutorial\\/particle-effect-one.png\",\"active\":\"1\",\"installed\":false},\"137\":{\"id\":\"140\",\"title\":\"Particle Effect Two\",\"alias\":\"particle-effect-two\",\"zip\":\"particle-effect-two.zip\",\"uid\":\"b8ecbf43374a69e4ab329ea834862ef8\",\"img\":\"particle-effect-two\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-effect-intro\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-intro\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"138\":{\"id\":\"141\",\"title\":\"Particle Effect Three\",\"alias\":\"particle-effect-three\",\"zip\":\"particle-effect-three.zip\",\"uid\":\"b33bc2c5655d8d51cd17c3740f72e748\",\"img\":\"particle-effect-three\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-background-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-background-effect\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \\\"BLEND IMAGE\\\" layer and go to \\\"advanced style -> filters -> blend mode\\\".<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"139\":{\"id\":\"142\",\"title\":\"Portfolio Viewer\",\"alias\":\"portfolioviewer\",\"zip\":\"portfolioviewer.zip\",\"uid\":\"9ac7230ff5b880fb6c8f28fbbc123b3b\",\"img\":\"portfolioviewer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-portfolio-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-portfolio-plugin\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The navigation for the slides is found in the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">Static Layers<\\/a>.<\\/span><span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"140\":{\"id\":\"143\",\"title\":\"App Showcase\",\"alias\":\"appshowcase\",\"zip\":\"appshowcase.zip\",\"uid\":\"082aef931b0369080bc30c3a2a0c331f\",\"img\":\"appshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-showcase-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-showcase-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template shows off our new \\\"Polyfold Effects\\\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-polyfold-addon\\\\\\/revslider-polyfold-addon.php\\\",\\\"name\\\":\\\"Polyfold Scroll Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"141\":{\"id\":\"144\",\"title\":\"Gravity Design Hero\",\"alias\":\"gravitydesign\",\"zip\":\"gravitydesign.zip\",\"uid\":\"7bdbe73a6e5bf290cb4412708ac4134d\",\"img\":\"gravitydesign\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider-plugin-2017\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2017\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \\\"Particle Effects\\\" Add-on to be installed.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create an Exciting Action Shot for Your Hero Image [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-an-exciting-action-shot-for-your-hero-image\\/\",\"guide_img\":\"tutorial\\/gravitydesign.png\",\"active\":\"1\",\"installed\":false},\"142\":{\"id\":\"145\",\"title\":\"404 Error Page\",\"alias\":\"404errorpage\",\"zip\":\"404errorpage.zip\",\"uid\":\"2dc62d802b42b73088651cac17d0c486\",\"img\":\"404errorpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/404-error-page-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"{\\\"1\\\":{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}}\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"143\":{\"id\":\"146\",\"title\":\"Carousel Gallery\",\"alias\":\"carouselgallery\",\"zip\":\"carouselgallery.zip\",\"uid\":\"041838fd32923c40e15c998f0ea19526\",\"img\":\"carouselgallery\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-carousel-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-carousel-gallery\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"144\":{\"id\":\"147\",\"title\":\"Filmstrip Effect\",\"alias\":\"filmstrip\",\"zip\":\"filmstrip.zip\",\"uid\":\"7bd142f272cc15d86998a79520e9e581\",\"img\":\"filmstrip\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/filmstrip-add-on-slider\\/ ?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content= \",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\\r\\n There is lots of customization options like animation speed and direction.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-filmstrip-addon\\\\\\/revslider-filmstrip-addon.php\\\",\\\"name\\\":\\\"Background FilmStrip AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"145\":{\"id\":\"148\",\"title\":\"Space Opera\",\"alias\":\"spaceopera\",\"zip\":\"spaceopera.zip\",\"uid\":\"a2c8bffcb138a86c0f373adebb6de046\",\"img\":\"spaceopera\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/space-opera-presentation\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=space-opera-presentation\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"146\":{\"id\":\"149\",\"title\":\"Website Intro\",\"alias\":\"websiteintro\",\"zip\":\"websiteintro.zip\",\"uid\":\"348df76d999456aa19be58c9df56ae20\",\"img\":\"websiteintro\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/website-intro-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=website-intro-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create a Slider Animation Effect Your Visitors Won\\u2019t Forget [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-a-slider-animation-effect\\/\",\"guide_img\":\"tutorial\\/websiteintro.png\",\"active\":\"1\",\"installed\":false},\"147\":{\"id\":\"150\",\"title\":\"Mask Showcase\",\"alias\":\"maskshowcase\",\"zip\":\"maskshowcase.zip\",\"uid\":\"fc943c31e2da9c63b252aeabf554d128\",\"img\":\"maskshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-mask-showcase\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-mask-showcase\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"148\":{\"id\":\"151\",\"title\":\"Parallax Zoom Slices\",\"alias\":\"parallaxzoomslices\",\"zip\":\"parallaxzoomslices.zip\",\"uid\":\"83537cae05709ddb9bcb7375470a5894\",\"img\":\"parallaxzoomslices\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-zoom-slices-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-zoom-slices-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"149\":{\"id\":\"152\",\"title\":\"Double Exposure Effect\",\"alias\":\"doubleexposureeffect\",\"zip\":\"doubleexposureeffect.zip\",\"uid\":\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\",\"img\":\"doubleexposureeffect\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-double-exposure-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-double-exposure-effect\",\"version\":\"1.0.1\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"150\":{\"id\":\"153\",\"title\":\"Mountain Parallax Header\",\"alias\":\"mountainparallaxheader\",\"zip\":\"mountainparallaxheader.zip\",\"uid\":\"8dc64663f317a2abdf179bbe341d016e\",\"img\":\"mountainparallaxheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/mountain-wordpress-parallax-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=mountain-wordpress-parallax-header\",\"version\":\"1.0.0\",\"required\":\"5.4.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Place Text Behind Objects in Your Hero Image [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/place-text-behind-objects\\/\",\"guide_img\":\"tutorial\\/mountainparallaxheader.png\",\"active\":\"1\",\"installed\":false},\"151\":{\"id\":\"154\",\"title\":\"GoodNews One-Pager Package\",\"alias\":\"goodnews-one-pager-package\",\"zip\":\"\",\"uid\":\"goodnews-one-pager-package\",\"img\":\"packages\\/templatepack_goodnews_one_pager.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.4.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\",\"slider\",\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"152\":{\"id\":\"155\",\"title\":\"GoodNews Menu\",\"alias\":\"goodnewsmenu\",\"zip\":\"packs\\/goodnewsmenu.zip\",\"uid\":\"4cbc82501ff340fcdc0acf7eb3ba2640\",\"img\":\"goodnewsmenu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"153\":{\"id\":\"156\",\"title\":\"GoodNews Header\",\"alias\":\"goodnewsheader\",\"zip\":\"packs\\/goodnewsheader.zip\",\"uid\":\"c6660b6bdbf596f38466f569596f5259\",\"img\":\"goodnewsheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"154\":{\"id\":\"157\",\"title\":\"GoodNews Whats Hot\",\"alias\":\"goodnewswhatshot\",\"zip\":\"packs\\/goodnewswhatshot.zip\",\"uid\":\"cb841ce64a99a6644adab049cf5405cd\",\"img\":\"goodnewswhatshot\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"155\":{\"id\":\"158\",\"title\":\"GoodNews Featured\",\"alias\":\"goodnewsfeatured\",\"zip\":\"packs\\/goodnewsfeatured.zip\",\"uid\":\"00bde4b09e3700da7183999eaf137ccc\",\"img\":\"goodnewsfeatured\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.3\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"156\":{\"id\":\"159\",\"title\":\"GoodNews Spotlight\",\"alias\":\"goodnewsspotlight\",\"zip\":\"packs\\/goodnewsspotlight.zip\",\"uid\":\"138076241a828e1c5764379944755f2b\",\"img\":\"goodnewsspotlight\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.4\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"157\":{\"id\":\"160\",\"title\":\"GoodNews Carousel\",\"alias\":\"goodnewscarousel\",\"zip\":\"packs\\/goodnewscarousel.zip\",\"uid\":\"d29d4460a6015e30d08d2714232d3768\",\"img\":\"goodnewscarousel\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"158\":{\"id\":\"161\",\"title\":\"GoodNews Callout\",\"alias\":\"goodnewscallout\",\"zip\":\"packs\\/goodnewscallout.zip\",\"uid\":\"d9568b3193e96577fae630b3a6728785\",\"img\":\"goodnewscallout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"159\":{\"id\":\"162\",\"title\":\"GoodNews Footer\",\"alias\":\"goodnewsfooter\",\"zip\":\"packs\\/goodnewsfooter.zip\",\"uid\":\"34f43f891cb8d55375149dc4bbc38298\",\"img\":\"goodnewsfooter\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"160\":{\"id\":\"163\",\"title\":\"GoodNews Content Page Package\",\"alias\":\"goodnews-content-page-package\",\"zip\":\"\",\"uid\":\"goodnews-content-page-package\",\"img\":\"packages\\/templatepack_goodnews_content_page_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"161\":{\"id\":\"164\",\"title\":\"GoodNews Menu Back\",\"alias\":\"goodnewsmenuback\",\"zip\":\"packs\\/goodnewsmenuback.zip\",\"uid\":\"1340d1aeefba497a7d404d12a1fceed4\",\"img\":\"goodnewsmenuback\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"162\":{\"id\":\"165\",\"title\":\"GoodNews Blog Header\",\"alias\":\"goodnewsblogheader\",\"zip\":\"packs\\/goodnewsblogheader.zip\",\"uid\":\"abc4d7c1e48475c6def05f1f6d8bf564\",\"img\":\"goodnewsblogheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"163\":{\"id\":\"166\",\"title\":\"GoodNews Blog Content\",\"alias\":\"goodnewsblogcontent\",\"zip\":\"packs\\/goodnewsblogcontent.zip\",\"uid\":\"bbf34563da6db2779c29599b503b07e9\",\"img\":\"goodnewsblogcontent\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"164\":{\"id\":\"167\",\"title\":\"GoodNews Testimonials\",\"alias\":\"goodnewstestimonials\",\"zip\":\"packs\\/goodnewstestimonials.zip\",\"uid\":\"606b7336e86f69c567542d3f43712b56\",\"img\":\"goodnewstestimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"165\":{\"id\":\"168\",\"title\":\"GoodNews Blog Footer\",\"alias\":\"goodnewsblogfooter\",\"zip\":\"packs\\/goodnewsblogfooter.zip\",\"uid\":\"1fb88aecfb116fde67ce8d52bd3b5f05\",\"img\":\"goodnewsblogfooter\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"166\":{\"id\":\"169\",\"title\":\"Before After Slider\",\"alias\":\"beforeafterslider\",\"zip\":\"beforeafterslider.zip\",\"uid\":\"6e615091a1fc3037c24b985ce5136fb2\",\"img\":\"beforeafterslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/before-after-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=before-after-slider\",\"version\":\"1.0.1\",\"required\":\"5.4.3.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider for our Before \\/ After Add-On that allows you to create unique presentations with a comparing functionality.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">How to install <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\\\" target=\\\"_blank\\\">Add-Ons<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-beforeafter-addon\\\\\\/revslider-beforeafter-addon.php\\\",\\\"name\\\":\\\"Before After AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"167\":{\"id\":\"170\",\"title\":\"Product Showcase\",\"alias\":\"productshowcase\",\"zip\":\"productshowcase.zip\",\"uid\":\"a43447670260aaa7e8ff66cedfddb57a\",\"img\":\"productshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-product-showcase-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-product-showcase-slider\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"168\":{\"id\":\"171\",\"title\":\"Overexposure Transition\",\"alias\":\"overexposuretransition\",\"zip\":\"overexposuretransition.zip\",\"uid\":\"13f16bbe6c6d646c7d0cb817a0d3d181\",\"img\":\"overexposuretransition\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/overexposure-transition-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=overexposure-transition-effect\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">How to install <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\\\" target=\\\"_blank\\\">Add-Ons<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"169\":{\"id\":\"172\",\"title\":\"Parallax Scroll\",\"alias\":\"parallaxscroll\",\"zip\":\"parallaxscroll.zip\",\"uid\":\"82546ee2f6af6c6682852f495109b3c3\",\"img\":\"parallaxscroll\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-scroll\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-scroll\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">A strikingly colourful header for your website with super smooth parallax effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"170\":{\"id\":\"173\",\"title\":\"TechCo One-Pager Package\",\"alias\":\"techco-one-pager-package\",\"zip\":\"\",\"uid\":\"techco-one-pager-package\",\"img\":\"packages\\/techco_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"171\":{\"id\":\"174\",\"title\":\"TechCo Menu\",\"alias\":\"techco-menu\",\"zip\":\"packs\\/techco-menu.zip\",\"uid\":\"55e5efee828cdf1ff7e2d3b90a301ea9\",\"img\":\"techco-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"172\":{\"id\":\"175\",\"title\":\"TechCo Header\",\"alias\":\"techco-header\",\"zip\":\"packs\\/techco-header.zip\",\"uid\":\"fb574d1376de9b1e408c91f51e6497d7\",\"img\":\"techco-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"173\":{\"id\":\"176\",\"title\":\"TechCo About\",\"alias\":\"techco-about\",\"zip\":\"packs\\/techco-about.zip\",\"uid\":\"ba216da8231e55118d87e37d2358812c\",\"img\":\"techco-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"174\":{\"id\":\"177\",\"title\":\"TechCo Services\",\"alias\":\"techco-services\",\"zip\":\"packs\\/techco-services.zip\",\"uid\":\"ef4a8ddbb5e1136133f7bc1227248e22\",\"img\":\"techco-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"175\":{\"id\":\"178\",\"title\":\"TechCo Video\",\"alias\":\"techco-video\",\"zip\":\"packs\\/techco-video.zip\",\"uid\":\"d7bb92281d05f39f9bc9eca71f90e402\",\"img\":\"techco-video\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"176\":{\"id\":\"179\",\"title\":\"TechCo Prices\",\"alias\":\"techco-prices\",\"zip\":\"packs\\/techco-prices.zip\",\"uid\":\"6291f404efbea12bb181352aba71ef11\",\"img\":\"techco-prices\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"177\":{\"id\":\"180\",\"title\":\"TechCo Testimonials\",\"alias\":\"techco-testimonials\",\"zip\":\"packs\\/techco-testimonials.zip\",\"uid\":\"3460bd51f6b80599266fecb7fbb918be\",\"img\":\"techco-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"178\":{\"id\":\"181\",\"title\":\"TechCo Footer\",\"alias\":\"techco-footer\",\"zip\":\"packs\\/techco-footer.zip\",\"uid\":\"640abcd549137520461a4a71ff758a3b\",\"img\":\"techco-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"179\":{\"id\":\"182\",\"title\":\"Live Weather\",\"alias\":\"weather\",\"zip\":\"weather.zip\",\"uid\":\"aab92e69374e4c7b8c6741fe02e574b9\",\"img\":\"weather\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-live-weather-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-live-weather-add-on\",\"version\":\"1.0.3\",\"required\":\"5.4.5.2\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-weather-addon\\\\\\/revslider-weather-addon.php\\\",\\\"name\\\":\\\"Live Weather AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"180\":{\"id\":\"183\",\"title\":\"360 Panorama Tour\",\"alias\":\"360panorama\",\"zip\":\"360panorama.zip\",\"uid\":\"332720fdacdbb38f65e8327a2a96c52d\",\"img\":\"360panorama\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/360-degree-real-estate-virtual-tour\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=360-degree-real-estate-virtual-tour\",\"version\":\"1.0.0\",\"required\":\"5.4.5.2\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">An example template for our Panorama 360 tour add-on, created for the real estate market.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-panorama-addon\\\\\\/revslider-panorama-addon.php\\\",\\\"name\\\":\\\"Panorama AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"181\":{\"id\":\"184\",\"title\":\"Duotone Add-on\",\"alias\":\"duotone-add-on\",\"zip\":\"duotone-add-on.zip\",\"uid\":\"a428c6f363b3146e96d20a6f44958922\",\"img\":\"duotone-add-on\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-duotone-effect-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-duotone-effect-add-on\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-duotonefilters-addon\\\\\\/revslider-duotonefilters-addon.php\\\",\\\"name\\\":\\\"Duotone AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"182\":{\"id\":\"185\",\"title\":\"Reveal Add-on\",\"alias\":\"reveal-add-on\",\"zip\":\"reveal-add-on.zip\",\"uid\":\"7fa7525d8ff7fa7365cb98a437e88e32\",\"img\":\"reveal-add-on\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-content-reveal-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-reveal-effect\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"202\":{\"id\":\"211\",\"title\":\"Immersion One Page\",\"alias\":\"immersion-one-page-package\",\"zip\":\"\",\"uid\":\"immersion-one-page-package\",\"img\":\"packages\\/immersion_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"203\":{\"id\":\"212\",\"title\":\"Immersion Header\",\"alias\":\"immersion_header\",\"zip\":\"packs\\/immersion_header.zip\",\"uid\":\"853da51256308b341ecd030bd4883229\",\"img\":\"immersion_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"204\":{\"id\":\"213\",\"title\":\"Immersion Mountains\",\"alias\":\"immersion-mountains\",\"zip\":\"packs\\/immersion-mountains.zip\",\"uid\":\"817167eb3fe22b7e065ba210cbe6d53c\",\"img\":\"immersion-mountains\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"205\":{\"id\":\"214\",\"title\":\"Immersion Product\",\"alias\":\"immersion-product\",\"zip\":\"packs\\/immersion-product.zip\",\"uid\":\"64134f263484d2bbcd7ef088ffbbfb4b\",\"img\":\"immersion-product\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"206\":{\"id\":\"215\",\"title\":\"Immersion Design\",\"alias\":\"immersion-design\",\"zip\":\"packs\\/immersion-design.zip\",\"uid\":\"91e1d77c1a2826438763804f4d02bc26\",\"img\":\"immersion-design\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"207\":{\"id\":\"216\",\"title\":\"Immersion Phototgraphy\",\"alias\":\"immersion-photography\",\"zip\":\"packs\\/immersion-photography.zip\",\"uid\":\"e3ddf0c577b09740f5cbf2e38ffd684d\",\"img\":\"immersion-photography\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"208\":{\"id\":\"217\",\"title\":\"Immersion Grid\",\"alias\":\"immersion-grid\",\"zip\":\"packs\\/immersion-grid.zip\",\"uid\":\"b6903868189bb83b2c7a852fde3a7dc3\",\"img\":\"immersion-grid\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.1\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"209\":{\"id\":\"218\",\"title\":\"Funky Intro Slider\",\"alias\":\"funkyslider\",\"zip\":\"funkyslider.zip\",\"uid\":\"2d4187e3fdad19b976be335253c8925d\",\"img\":\"funkyslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/funky-intro-slider-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=funky-intro-slider-wordpress-plugin\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"210\":{\"id\":\"219\",\"title\":\"Clear View Magazine\",\"alias\":\"clear-view-magazine-package\",\"zip\":\"\",\"uid\":\"clear-view-magazine-package\",\"img\":\"packages\\/clear_view_magazine_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"211\":{\"id\":\"220\",\"title\":\"Clear View Menu\",\"alias\":\"clearview_menu\",\"zip\":\"packs\\/clearview_menu.zip\",\"uid\":\"eaecee5fa5f3c3a7f4d2a96c4616a353\",\"img\":\"clearview_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"212\":{\"id\":\"221\",\"title\":\"Clear View Header\",\"alias\":\"clearview_header\",\"zip\":\"packs\\/clearview_header.zip\",\"uid\":\"25e3dd80ad130875d7438a07952cb0cd\",\"img\":\"clearview_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"213\":{\"id\":\"222\",\"title\":\"Clear View Mission\",\"alias\":\"clearview_mission\",\"zip\":\"packs\\/clearview_mission.zip\",\"uid\":\"35b2092a49fd2beb549342e69097eb5b\",\"img\":\"clearview_mission\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"214\":{\"id\":\"223\",\"title\":\"Clear View Slider\",\"alias\":\"clear-view-slider\",\"zip\":\"packs\\/clear-view-slider.zip\",\"uid\":\"d2e17edffce16ed78c54b0ef23fd7e05\",\"img\":\"clear-view-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"215\":{\"id\":\"224\",\"title\":\"Clear View News\",\"alias\":\"clear-view-news\",\"zip\":\"packs\\/clear-view-news.zip\",\"uid\":\"5698d3131ba141e9afcfd2906739dd00\",\"img\":\"clear-view-news\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"216\":{\"id\":\"225\",\"title\":\"Clear View Clients\",\"alias\":\"clear-view-clients\",\"zip\":\"packs\\/clear-view-clients.zip\",\"uid\":\"b95616a94832e22bdfac5ce60232be1b\",\"img\":\"clear-view-clients\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"217\":{\"id\":\"226\",\"title\":\"Clear View Contact\",\"alias\":\"clear-view-contact\",\"zip\":\"packs\\/clear-view-contact.zip\",\"uid\":\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\",\"img\":\"clear-view-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"218\":{\"id\":\"227\",\"title\":\"Clear View Post Page\",\"alias\":\"clear-view-post-page-package\",\"zip\":\"\",\"uid\":\"clear-view-post-page-package\",\"img\":\"packages\\/clear_view_post_page_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"219\":{\"id\":\"228\",\"title\":\"Clear View Single Menu\",\"alias\":\"clear-view-single-menu\",\"zip\":\"packs\\/clear-view-single-menu.zip\",\"uid\":\"1e80f81982f8a4ea763482d4fa99d321\",\"img\":\"clear-view-single-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"220\":{\"id\":\"229\",\"title\":\"Clear View Single Header\",\"alias\":\"clear-view-single-header\",\"zip\":\"packs\\/clear-view-single-header.zip\",\"uid\":\"c8d717627be6cd5e70922ab609694dbf\",\"img\":\"clear-view-single-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"221\":{\"id\":\"230\",\"title\":\"Clear View Single Media\",\"alias\":\"clear-view-single-media\",\"zip\":\"packs\\/clear-view-single-media.zip\",\"uid\":\"c480368ded2a64f0cdd44f1674213814\",\"img\":\"clear-view-single-media\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"222\":{\"id\":\"231\",\"title\":\"Clear View Single More\",\"alias\":\"clear-view-single-more\",\"zip\":\"packs\\/clear-view-single-more.zip\",\"uid\":\"9c693190df26218366d1f77e10cf550a\",\"img\":\"clear-view-single-more\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"223\":{\"id\":\"232\",\"title\":\"Clear View Single Contact\",\"alias\":\"clear-view-single-contact\",\"zip\":\"packs\\/clear-view-single-contact.zip\",\"uid\":\"73c0a889f2b654a87b5aba1ff76fbc5c\",\"img\":\"clear-view-single-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"224\":{\"id\":\"233\",\"title\":\"Clean Landing Page\",\"alias\":\"cleanlandingpage\",\"zip\":\"cleanlandingpage.zip\",\"uid\":\"727a3680d312f22c6a5998ebdb9afe52\",\"img\":\"cleanlandingpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clean-landing-page-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clean-landing-page-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"225\":{\"id\":\"234\",\"title\":\"Clear Cut\",\"alias\":\"clearcut\",\"zip\":\"clearcut.zip\",\"uid\":\"07f43c00e9b4d3057a03cdb3385ad2b7\",\"img\":\"clearcut\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-cut-portfolio-website-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-cut-portfolio-website-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"226\":{\"id\":\"235\",\"title\":\"Wonderstruck One-Pager\",\"alias\":\"wonderstruck-one-pager-package\",\"zip\":\"\",\"uid\":\"wonderstruck-one-pager-package\",\"img\":\"packages\\/wonderstruck-one-pager-overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"227\":{\"id\":\"236\",\"title\":\"Wonderstruck Menu\",\"alias\":\"wonderstruck_menu\",\"zip\":\"packs\\/wonderstruck_menu.zip\",\"uid\":\"0a976e9aaae59c4f795b38f59f5a08d8\",\"img\":\"wonderstruck_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"228\":{\"id\":\"237\",\"title\":\"Wonderstruck Header\",\"alias\":\"wonderstruck_header\",\"zip\":\"packs\\/wonderstruck_header.zip\",\"uid\":\"e1379f77a902960a0ce12d44d85a9e0a\",\"img\":\"wonderstruck_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"229\":{\"id\":\"238\",\"title\":\"Wonderstruck About\",\"alias\":\"wonderstruck_about\",\"zip\":\"packs\\/wonderstruck_about.zip\",\"uid\":\"d207fb140fd328acc3038300ea52082a\",\"img\":\"wonderstruck_about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"230\":{\"id\":\"239\",\"title\":\"Wonderstruck Works\",\"alias\":\"wonderstruck-works\",\"zip\":\"packs\\/wonderstruck-works.zip\",\"uid\":\"4476935097e27d92454b0011b7700c1d\",\"img\":\"wonderstruck-works\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"231\":{\"id\":\"240\",\"title\":\"Wonderstruck Contact\",\"alias\":\"wonderstruck-contact\",\"zip\":\"packs\\/wonderstruck-contact.zip\",\"uid\":\"9e4911521f77bce2b8efa40f4c2adc22\",\"img\":\"wonderstruck-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"232\":{\"id\":\"241\",\"title\":\"Bubble Morph\",\"alias\":\"bubblemorph\",\"zip\":\"bubblemorph.zip\",\"uid\":\"1102d6f5460ab82cb612cbe9f1d9514b\",\"img\":\"bubblemorph\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/bubble-morph-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=bubble-morph-effect-add-on-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-bubblemorph-addon\\\\\\/revslider-bubblemorph-addon.php\\\",\\\"name\\\":\\\"BubbleMorph AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"233\":{\"id\":\"242\",\"title\":\"Distortion AddOn\",\"alias\":\"distortionaddon\",\"zip\":\"distortionaddon.zip\",\"uid\":\"0ad46c9929bb2fa6316f1e6ced301aaf\",\"img\":\"distortionaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/distortion-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=distortion-effect-add-on-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-liquideffect-addon\\\\\\/revslider-liquideffect-addon.php\\\",\\\"name\\\":\\\"Distortion Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"234\":{\"id\":\"243\",\"title\":\"Club Flyer\",\"alias\":\"clubflyer\",\"zip\":\"clubflyer.zip\",\"uid\":\"dab73b9904d0e643a35b0475980998bd\",\"img\":\"clubflyer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/club-flyer-landing-page-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=club-flyer-landing-page-template-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-explodinglayers-addon\\\\\\/revslider-explodinglayers-addon.php\\\",\\\"name\\\":\\\"Exploding Layers AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"235\":{\"id\":\"244\",\"title\":\"Paintbrush AddOn\",\"alias\":\"paintbrushaddon\",\"zip\":\"paintbrushaddon.zip\",\"uid\":\"c85c48a6742b4bf72a2590cc1b50f6a0\",\"img\":\"paintbrushaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/paintbrush-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=paintbrush-effect-add-on-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-paintbrush-addon\\\\\\/revslider-paintbrush-addon.php\\\",\\\"name\\\":\\\"Paintbrush AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Unique Paintbrush Effect to Your Website with Slider Revolution [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/unique-paintbrush-effect\\/\",\"guide_img\":\"tutorial\\/paintbrushaddon.png\",\"active\":\"1\",\"installed\":false},\"236\":{\"id\":\"245\",\"title\":\"Parallax One-Pager\",\"alias\":\"parallax-one-pager-package\",\"zip\":\"\",\"uid\":\"parallax-one-pager-package\",\"img\":\"packages\\/parallax-one-pager-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"237\":{\"id\":\"246\",\"title\":\"Parallax Header\",\"alias\":\"parallax_header\",\"zip\":\"packs\\/parallax_header.zip\",\"uid\":\"32bf4a0f5136853bd6bd366275a7a60b\",\"img\":\"parallax_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"238\":{\"id\":\"247\",\"title\":\"Parallax Content\",\"alias\":\"parallax_content\",\"zip\":\"packs\\/parallax_content.zip\",\"uid\":\"a25c5fb8f74757476ab4dc038e56f90d\",\"img\":\"parallax_content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"239\":{\"id\":\"248\",\"title\":\"Parallax Footer\",\"alias\":\"parallax_footer\",\"zip\":\"packs\\/parallax_footer.zip\",\"uid\":\"665dff9ea6eaf162a2a1f160f51a9ddb\",\"img\":\"parallax_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"240\":{\"id\":\"249\",\"title\":\"Le Chef Restaurant\",\"alias\":\"le-chef-restaurant\",\"zip\":\"\",\"uid\":\"le-chef-restaurant-package\",\"img\":\"packages\\/le-chef-restaurant-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"241\":{\"id\":\"250\",\"title\":\"Le Chef Menu\",\"alias\":\"le-chef-menu\",\"zip\":\"packs\\/le-chef-menu.zip\",\"uid\":\"2f2a6a333431fefe4a7b3b6a982b2ff5\",\"img\":\"le-chef-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"242\":{\"id\":\"251\",\"title\":\"Le Chef Header\",\"alias\":\"le-chef-header\",\"zip\":\"packs\\/le-chef-header.zip\",\"uid\":\"06450ca3be5a4a8959f3752ab974e574\",\"img\":\"le-chef-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"243\":{\"id\":\"252\",\"title\":\"Le Chef Philosophy\",\"alias\":\"le-chef-philosophy\",\"zip\":\"packs\\/le-chef-philosophy.zip\",\"uid\":\"a532fd029addeb18106e751409b8e20a\",\"img\":\"le-chef-philosophy\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"244\":{\"id\":\"253\",\"title\":\"Le Chef Food\",\"alias\":\"le-chef-food\",\"zip\":\"packs\\/le-chef-food.zip\",\"uid\":\"cd4b6a2cb5de2dd20a0e8ba0c35451df\",\"img\":\"le-chef-food\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"245\":{\"id\":\"254\",\"title\":\"Le Chef La Carte\",\"alias\":\"le-chef-la-carte\",\"zip\":\"packs\\/le-chef-la-carte.zip\",\"uid\":\"6f312749679c3ba52c41189a6b8bf729\",\"img\":\"le-chef-la-carte\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"246\":{\"id\":\"255\",\"title\":\"Le Chef Footer\",\"alias\":\"le-chef-footer\",\"zip\":\"packs\\/le-chef-footer.zip\",\"uid\":\"12fc241e8e5b9e5df9758c43448e2907\",\"img\":\"le-chef-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"247\":{\"id\":\"256\",\"title\":\"News Magazine Slider\",\"alias\":\"news-magazine-slider\",\"zip\":\"news-magazine-slider.zip\",\"uid\":\"31f2c1506babb1fef459401f051d2d52\",\"img\":\"news-magazine-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/news-magazine-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=news-magazine-slider-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"248\":{\"id\":\"257\",\"title\":\"Real Estate Slider\",\"alias\":\"real-estate-slider\",\"zip\":\"real-estate-slider.zip\",\"uid\":\"739ce6336e46815094387c9448e6c804\",\"img\":\"real-estate-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/real-estate-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-slider-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"249\":{\"id\":\"258\",\"title\":\"Fashion Header\",\"alias\":\"fashion-header\",\"zip\":\"fashion-header.zip\",\"uid\":\"24ece4e7f4d31cd90377c62abbd9e25a\",\"img\":\"fashion-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/fashion-shop-header-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fashion-shop-header-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \\\"Bubble Morph\\\" effect makes this module stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-bubblemorph-addon\\\\\\/revslider-bubblemorph-addon.php\\\",\\\"name\\\":\\\"BubbleMorph AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"250\":{\"id\":\"259\",\"title\":\"Seasonal Offer\",\"alias\":\"seasonaloffer\",\"zip\":\"seasonaloffer.zip\",\"uid\":\"caf2f17f8fd64f2f89dcb3c8dd238457\",\"img\":\"seasonaloffer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/seasonal-offer-christmas-header-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=seasonal-offer-christmas-header-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"251\":{\"id\":\"260\",\"title\":\"Barber Shop\",\"alias\":\"barber-shop\",\"zip\":\"\",\"uid\":\"barber-shop-package\",\"img\":\"packages\\/barber-shop-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"252\":{\"id\":\"261\",\"title\":\"Barber Shop Header\",\"alias\":\"barber-shop-header\",\"zip\":\"packs\\/barber-shop-header.zip\",\"uid\":\"71c995d36d39a0e8a04cffdf753f2ba2\",\"img\":\"barber-shop-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"253\":{\"id\":\"262\",\"title\":\"Barber Shop Mobile Menu\",\"alias\":\"barber-shop-mobile-menu\",\"zip\":\"packs\\/barber-shop-mobile-menu.zip\",\"uid\":\"762c6fb5c6306f37becb1e55773c2592\",\"img\":\"barber-shop-mobile-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"254\":{\"id\":\"263\",\"title\":\"Barber Shop First Screen\",\"alias\":\"barber-shop-first-screen\",\"zip\":\"packs\\/barber-shop-first-screen.zip\",\"uid\":\"acf70bfd64cff2c3c2ea5585223575da\",\"img\":\"barber-shop-first-screen\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"255\":{\"id\":\"264\",\"title\":\"Barber Shop About\",\"alias\":\"barber-shop-about\",\"zip\":\"packs\\/barber-shop-about.zip\",\"uid\":\"bc8b63cfc7f8c34173b4fd5b082fc05a\",\"img\":\"barber-shop-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"256\":{\"id\":\"265\",\"title\":\"Barber Shop Services\",\"alias\":\"barber-shop-services\",\"zip\":\"packs\\/barber-shop-services.zip\",\"uid\":\"d65121d6f84fabd812a2b621b768e10e\",\"img\":\"barber-shop-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"257\":{\"id\":\"266\",\"title\":\"Barber Shop Barbers\",\"alias\":\"barber-shop-barbers\",\"zip\":\"packs\\/barber-shop-barbers.zip\",\"uid\":\"003e9fec9693072119c8f8d8b6690c4d\",\"img\":\"barber-shop-barbers\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"258\":{\"id\":\"267\",\"title\":\"Barber Shop Contacts\",\"alias\":\"barber-shop-contacts\",\"zip\":\"packs\\/barber-shop-contacts.zip\",\"uid\":\"cdcc08f5d6c90dbcfd0502bda2401643\",\"img\":\"barber-shop-contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"259\":{\"id\":\"268\",\"title\":\"Barber Shop Footer\",\"alias\":\"barber-shop-footer\",\"zip\":\"packs\\/barber-shop-footer.zip\",\"uid\":\"26ca5ae0de7cdbb2ca19348b6e01eda0\",\"img\":\"barber-shop-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"260\":{\"id\":\"269\",\"title\":\"Fitness Club\",\"alias\":\"fitness-club-template\",\"zip\":\"fitness-club-template.zip\",\"uid\":\"14ea10d68d6aad1df62b3becf71df754\",\"img\":\"fitness-club-template\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/fitness-club-header-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fitness-club-header-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Fitness Club Header is the perfect introduction to your fitness themed website. Showcase your current offers or service portfolio with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"261\":{\"id\":\"270\",\"title\":\"Soccer School\",\"alias\":\"soccer-school\",\"zip\":\"soccer-school.zip\",\"uid\":\"9906b48812aff67097f990eeee42dd41\",\"img\":\"soccer-school\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/soccer-club-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=soccer-club-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Soccer Club Header is the perfect introduction to your Soccer School themed website. Showcase your current offers or service portfolio with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"262\":{\"id\":\"271\",\"title\":\"Music Band\",\"alias\":\"music-band-template\",\"zip\":\"music-band-template.zip\",\"uid\":\"91e79657bf1b1812f8114a00ab8e0eb4\",\"img\":\"music-band-template\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/music-band-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=music-band-template-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"5.4.8.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Music Band Header is the perfect introduction to your Music Band themed website. Showcase your current songs, albums and videos with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"263\":{\"id\":\"272\",\"title\":\"Restaurant Menu\",\"alias\":\"restaurant-menu\",\"zip\":\"restaurant-menu.zip\",\"uid\":\"078809cffb21b6c4d3f5aaa2daeb193d\",\"img\":\"restaurant-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/restaurant-menu-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-menu-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Restaurant Menu Header is the perfect introduction to your Restaurant themed website. Showcase your current dishes with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create a Digital Menu Teaser for Your Foodie Website [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-a-digital-menu-teaser-for-your-foodie-website\\/\",\"guide_img\":\"tutorial\\/restaurant-menu.png\",\"active\":\"1\",\"installed\":false},\"264\":{\"id\":\"273\",\"title\":\"Cinematic Slider\",\"alias\":\"cinematic-slider\",\"zip\":\"cinematic-slider.zip\",\"uid\":\"c53e7dcbb6b656ae7b4c91d333589838\",\"img\":\"cinematic-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/cinematic-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Bold texts and a cinematic transition effect make this slider stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"265\":{\"id\":\"274\",\"title\":\"3D Parallax Cubes\",\"alias\":\"3d-parallax-cubes\",\"zip\":\"3d-parallax-cubes.zip\",\"uid\":\"c5b809a1829f8f809c9a768cd3d6b3cb\",\"img\":\"3d-parallax-cubes\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/3d-parallax-cubes-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=3d-parallax-cubes-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This amazing 3D cubes parallax effect can be an eye-opening intro for your website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"266\":{\"id\":\"275\",\"title\":\"Medicare Medical Services Website\",\"alias\":\"medicare-medical-services-website\",\"zip\":\"\",\"uid\":\"medicare-medical-services-website-package\",\"img\":\"packages\\/medicare_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"267\":{\"id\":\"276\",\"title\":\"Medicare Menu\",\"alias\":\"medicare-menu\",\"zip\":\"packs\\/medicare-menu.zip\",\"uid\":\"0e4ca8fc281e20251b3fffa19d470fed\",\"img\":\"medicare-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"268\":{\"id\":\"277\",\"title\":\"Medicare Header\",\"alias\":\"medicare-header\",\"zip\":\"packs\\/medicare-header.zip\",\"uid\":\"03e8ade247d8c96f548bc0515f34043f\",\"img\":\"medicare-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"269\":{\"id\":\"278\",\"title\":\"Medicare About\",\"alias\":\"medicare-about\",\"zip\":\"packs\\/medicare-about.zip\",\"uid\":\"a3ab9e89155ef2542820343f30b29f72\",\"img\":\"medicare-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"270\":{\"id\":\"279\",\"title\":\"Medicare Highlight\",\"alias\":\"medicare-highlight\",\"zip\":\"packs\\/medicare-highlight.zip\",\"uid\":\"c3c8a74e5402489f1a85a0c83890ef1f\",\"img\":\"medicare-highlight\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"271\":{\"id\":\"280\",\"title\":\"Medicare Services\",\"alias\":\"medicare-services\",\"zip\":\"packs\\/medicare-services.zip\",\"uid\":\"8869b0834d4649dcc3221bed65980806\",\"img\":\"medicare-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"272\":{\"id\":\"281\",\"title\":\"Medicare Doctors\",\"alias\":\"medicare-doctors\",\"zip\":\"packs\\/medicare-doctors.zip\",\"uid\":\"2c9d57afd64244b5f7e30b0d87c842f9\",\"img\":\"medicare-doctors\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"273\":{\"id\":\"282\",\"title\":\"Medicare Research\",\"alias\":\"medicare-research\",\"zip\":\"packs\\/medicare-research.zip\",\"uid\":\"31e84a91fc8b8d5296e715e539a076d0\",\"img\":\"medicare-research\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"274\":{\"id\":\"283\",\"title\":\"Medicare Why Choose\",\"alias\":\"medicare-whychoose\",\"zip\":\"packs\\/medicare-whychoose.zip\",\"uid\":\"6dad61c672127de9e35884caa45d49a0\",\"img\":\"medicare-whychoose\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"275\":{\"id\":\"284\",\"title\":\"Medicare Contact\",\"alias\":\"medicare-contact\",\"zip\":\"packs\\/medicare-contact.zip\",\"uid\":\"89bc35ad8beb62a149c42262ae49a270\",\"img\":\"medicare-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"276\":{\"id\":\"285\",\"title\":\"Medicare Footer\",\"alias\":\"medicare-footer\",\"zip\":\"packs\\/medicare-footer.zip\",\"uid\":\"ccf63e5233b3d63009e5ee90db51b37b\",\"img\":\"medicare-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"10\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"277\":{\"id\":\"286\",\"title\":\"Coffee Joint Website\",\"alias\":\"coffee-joint-website\",\"zip\":\"\",\"uid\":\"coffee-joint-website-package\",\"img\":\"packages\\/coffee_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"278\":{\"id\":\"287\",\"title\":\"Coffee Menu\",\"alias\":\"coffee-menu\",\"zip\":\"packs\\/coffee-menu.zip\",\"uid\":\"81195cad7be3f5180a267b34ce8cf966\",\"img\":\"coffee-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"279\":{\"id\":\"288\",\"title\":\"Coffee Header\",\"alias\":\"coffee-header\",\"zip\":\"packs\\/coffee-header.zip\",\"uid\":\"5eed8adb9d3ae12168ad4735ac63eb20\",\"img\":\"coffee-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"280\":{\"id\":\"289\",\"title\":\"Coffee Philosophy\",\"alias\":\"coffee-philosophy\",\"zip\":\"packs\\/coffee-philosophy.zip\",\"uid\":\"76b5ccae3fa87fd0f991b87e7ae71c27\",\"img\":\"coffee-philosophy\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"281\":{\"id\":\"290\",\"title\":\"Coffee Carte\",\"alias\":\"coffee-carte\",\"zip\":\"packs\\/coffee-carte.zip\",\"uid\":\"470214ddd2cec585629fb79a0fd908d6\",\"img\":\"coffee-carte\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"282\":{\"id\":\"291\",\"title\":\"Coffee Teaser\",\"alias\":\"coffee-teaser\",\"zip\":\"packs\\/coffee-teaser.zip\",\"uid\":\"2ed868896c92a7bfb6431803c79e8486\",\"img\":\"coffee-teaser\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"283\":{\"id\":\"292\",\"title\":\"Coffee Find Us\",\"alias\":\"coffee-findus\",\"zip\":\"packs\\/coffee-findus.zip\",\"uid\":\"96d3784473dfa64bce9e1e4101919927\",\"img\":\"coffee-findus\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"284\":{\"id\":\"293\",\"title\":\"Coffee Footer\",\"alias\":\"coffee-footer\",\"zip\":\"packs\\/coffee-footer.zip\",\"uid\":\"6027c25e87a5fe7fd8727a51c0967915\",\"img\":\"coffee-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"285\":{\"id\":\"294\",\"title\":\"Minimal Portfolio Website\",\"alias\":\"minimal-portfolio-website\",\"zip\":\"\",\"uid\":\"minimal-portfolio-website\",\"img\":\"packages\\/minimal_portfolio_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"286\":{\"id\":\"295\",\"title\":\"Minimal Portfolio\",\"alias\":\"minimal-portfolio\",\"zip\":\"packs\\/minimal-portfolio.zip\",\"uid\":\"183b97b301d5ff0b171c067a87c8a3f5\",\"img\":\"minimal-portfolio\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"287\":{\"id\":\"296\",\"title\":\"Minimal Portfolio Modal\",\"alias\":\"minimal-portfolio-modal\",\"zip\":\"packs\\/minimal-portfolio-modal.zip\",\"uid\":\"6874e6cec3663670f209a8d8a4f26b16\",\"img\":\"minimal-portfolio-modal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"288\":{\"id\":\"297\",\"title\":\"Angled Business Website\",\"alias\":\"angled-business-website\",\"zip\":\"\",\"uid\":\"angled-business-website-package\",\"img\":\"packages\\/angled_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"289\":{\"id\":\"298\",\"title\":\"Angled Menu\",\"alias\":\"angled-menu\",\"zip\":\"packs\\/angled-menu.zip\",\"uid\":\"2fe0c4682d1231ee3918be9e4fcb1837\",\"img\":\"angled-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"290\":{\"id\":\"299\",\"title\":\"Angled Header\",\"alias\":\"angled-header\",\"zip\":\"packs\\/angled-header.zip\",\"uid\":\"09462601d4edca8dff899de6f666dc47\",\"img\":\"angled-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"291\":{\"id\":\"300\",\"title\":\"Angled News\",\"alias\":\"angled-news\",\"zip\":\"packs\\/angled-news.zip\",\"uid\":\"b315105763ed91214cb2f0ac12615729\",\"img\":\"angled-news\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"292\":{\"id\":\"301\",\"title\":\"Angled Services\",\"alias\":\"angled-services\",\"zip\":\"packs\\/angled-services.zip\",\"uid\":\"7605651c1487e1a6c32edc70017be8ad\",\"img\":\"angled-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"293\":{\"id\":\"302\",\"title\":\"Angled Success\",\"alias\":\"angled-success\",\"zip\":\"packs\\/angled-success.zip\",\"uid\":\"9e3fa974a42ecf80e1ec6ff991fca430\",\"img\":\"angled-success\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"294\":{\"id\":\"303\",\"title\":\"Angled Footer\",\"alias\":\"angled-footer\",\"zip\":\"packs\\/angled-footer.zip\",\"uid\":\"aed4eaa2f7883351ba9c9947feef153e\",\"img\":\"angled-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"295\":{\"id\":\"304\",\"title\":\"Angled Content Modal\",\"alias\":\"angled-content-modal\",\"zip\":\"packs\\/angled-content-modal.zip\",\"uid\":\"4ddc74515fdf84f974217e4ed47a7c66\",\"img\":\"angled-content-modal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"296\":{\"id\":\"312\",\"title\":\"Retouch Before and After\",\"alias\":\"Retouch\",\"zip\":\"Retouch.zip\",\"uid\":\"58894991f1abd8b448c8d353b1b5fe76\",\"img\":\"Retouch\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/retouch-before-after-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=retouch-before-after-slider\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Retouch Slider is the perfect way to compare your photos before and after retouching.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-beforeafter-addon\\\\\\/revslider-beforeafter-addon.php\\\",\\\"name\\\":\\\"Before After AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"297\":{\"id\":\"313\",\"title\":\"Tech Slider\",\"alias\":\"tech-slider\",\"zip\":\"tech-slider.zip\",\"uid\":\"a98e2b264f00a1116d21808c6a543162\",\"img\":\"tech-slider\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/tech-showcase-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=tech-showcase-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This classic slider module with sleek device mockups features a smooth parallax effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"298\":{\"id\":\"314\",\"title\":\"Peak Agency Website\",\"alias\":\"peak-agency-website\",\"zip\":\"\",\"uid\":\"peak-agency-website-package\",\"img\":\"packages\\/peak_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"299\":{\"id\":\"315\",\"title\":\"Peak Header\",\"alias\":\"peak-header\",\"zip\":\"packs\\/peak-header.zip\",\"uid\":\"b721bd612e9fbc5182418ad3fd7d0808\",\"img\":\"peak-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"300\":{\"id\":\"316\",\"title\":\"Peak About\",\"alias\":\"peak-about\",\"zip\":\"packs\\/peak-about.zip\",\"uid\":\"7e68b1012fb03490d45c7f79e8cb1b19\",\"img\":\"peak-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"301\":{\"id\":\"317\",\"title\":\"Peak Portfolio\",\"alias\":\"peak-portfolio\",\"zip\":\"packs\\/peak-portfolio.zip\",\"uid\":\"6198d1885ba9e95221c33e404f21bdbc\",\"img\":\"peak-portfolio\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"302\":{\"id\":\"318\",\"title\":\"Peak Footer\",\"alias\":\"peak-footer\",\"zip\":\"packs\\/peak-footer.zip\",\"uid\":\"2dead6897ad3b3a709b380d81242f76b\",\"img\":\"peak-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"304\":{\"id\":\"320\",\"title\":\"Portfolio Welcome\",\"alias\":\"portfolio-welcome\",\"zip\":\"packs\\/portfolio-welcome.zip\",\"uid\":\"97336b8785e4a7b27facaf1547e0464d\",\"img\":\"portfolio-welcome\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"305\":{\"id\":\"321\",\"title\":\"Portfolio About\",\"alias\":\"portfolio-about\",\"zip\":\"packs\\/portfolio-about.zip\",\"uid\":\"5d3a4724fd453de5313ceb6696c1db62\",\"img\":\"portfolio-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"306\":{\"id\":\"322\",\"title\":\"Portfolio Works Title\",\"alias\":\"portfolio-works-title\",\"zip\":\"packs\\/portfolio-works-title.zip\",\"uid\":\"cbb5c6e875cc1f25b463fdf89cabef28\",\"img\":\"portfolio-works-title\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"307\":{\"id\":\"323\",\"title\":\"Portfolio Works Content\",\"alias\":\"portfolio-works-content\",\"zip\":\"packs\\/portfolio-works-content.zip\",\"uid\":\"5c87311128c7794ffa6ee07ea0648082\",\"img\":\"portfolio-works-content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"308\":{\"id\":\"324\",\"title\":\"Portfolio Contacts\",\"alias\":\"portfolio-contacts\",\"zip\":\"packs\\/portfolio-contacts.zip\",\"uid\":\"bd81feffad83b69218f7e837478038e5\",\"img\":\"portfolio-contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"309\":{\"id\":\"325\",\"title\":\"App Studio Website\",\"alias\":\"app-studio-website\",\"zip\":\"\",\"uid\":\"app-studio-website-package\",\"img\":\"packages\\/App_Studio_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"310\":{\"id\":\"326\",\"title\":\"App Studio Welcome\",\"alias\":\"App-Studio-Welcome\",\"zip\":\"packs\\/App-Studio-Welcome.zip\",\"uid\":\"2ce0f3c54214b04e6c3a9becfd59730c\",\"img\":\"App-Studio-Welcome\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"311\":{\"id\":\"327\",\"title\":\"App Studio Services\",\"alias\":\"App-Studio-Services\",\"zip\":\"packs\\/App-Studio-Services.zip\",\"uid\":\"5df7776271ec69d2f9edaa6b842715a9\",\"img\":\"App-Studio-Services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.3\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false,\"is_new\":true},\"312\":{\"id\":\"328\",\"title\":\"App Studio About\",\"alias\":\"App-Studio-About\",\"zip\":\"packs\\/App-Studio-About.zip\",\"uid\":\"af8b84dc116c629df7bd89fc69271a2e\",\"img\":\"App-Studio-About\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<s