<?php get_header(); ?>
<?php

if(get_post_type() == 'post'){
    $id = get_theme_mod( 'archive-post-template' );
    if ($id) {
        get_site_templates( $id );
    } else { ?>
        <section class="last-article">
            <div class="container">
                <div class="row">
                    <div id="article" class="title-article">
                        <h1>مقالات <br> &nbsp;____</h1>
                        <p>آخرین مقالات ما را بخوانید</p>
                    </div>
                </div>
                <div class="row box-item-article">

                    <?php if (have_posts() ) : ?>
                        <?php while (have_posts() ) :the_post(); ?>
                            <div class="item-article col-md-6 col-lg-4">

                                <div class="article-img">
                                    <?php the_post_thumbnail( 'articlethumb' ); ?>
                                    <div class="item-article-img">
                                        <a href="<?php the_permalink(); ?>"><i class="fas fa-link"></i></a>
                                    </div>
                                </div>
                                <div class="text_box-article">
                                    <a href="<?php the_permalink(); ?>"><h2><?php the_title();?></h2></a>
                                </div>
                                <div class="option-item">
                                    <div class="date-item">
                                        <i class="far fa-calendar"></i>
                                        <span><?php the_time('j F Y'); ?></span>
                                    </div>
                                    <div class="folder-item">
                                        <i class="far fa-folder-open"></i>
                                        <span>‏<?php the_category(' , ');?></span>
                                    </div>
                                </div>
                            </div>

                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                    <?php else : ?>
                        <p><?php _e( 'متاسفانه مقاله ای وجود ندارد.' ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <section>
            <div class="nember-page">
                <?php echo the_posts_pagination( array( 'mid_size' => 6 ) ); ?>
            </div>
        </section>

    <?php } }elseif(get_post_type() == 'portfolio') { ?>
    <?php $id = get_theme_mod( 'project_template' );
    if ($id) {
        get_site_templates( $id );
    } else { ?>
        <?php get_header();?>
        <section>
            <div class="container">
                <div id="project" class="project-us-title-project">
                    <h2>پروژه ها <br> &nbsp;____</h2>
                    <h3 class="last-project">آخرین پروژه ها انجام شده</h3>
                </div>
                <div class="row box-project-all">
                    <?php
                    $the_query = new WP_Query( array( 'post_type' => 'portfolio','posts_per_page'=> 3 ) ); ?>
                    <?php if ( $the_query->have_posts() ) : ?>
                        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                            <div class=" col-xs-6 col-sm-6 col-md-4 col-lg-3">
                                <div class="box-project">
                                    <?php the_post_thumbnail( 'servicethumb-icon' ); ?>
                                    <div class="item-box-img-project">
                                        <div class="item-box-icon">
                                            <p><?php the_title(); ?></p>
                                            <a class="box-icon-search-project" href="#"><i class="fas fa-search"></i></a>
                                            <a class="box-icon-link-project" href="<?php the_permalink(); ?>"><i class="fas fa-link"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                    <?php else : ?>
                        <p><?php _e( 'متاسفانه مقاله ای وجود ندارد.' ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <section>
            <div class="nember-page">
                <a href="#"><span>قبلی</span></a>
                <a href="#"><span>1</span></a>
                <a href="#"><span>2</span></a>
                <a href="#"><span>3</span></a>
                <a href="#"><span>4</span></a>
                <a href="#"><span>5</span></a>
                <a href="#"><span>6</span></a>
                <a href="#"><span>بعدی</span></a>
            </div>
        </section>
    <?php }  } get_footer(); ?>
