<?php
if(! class_exists('polaris_Customizer')) {
    require_once get_template_directory().'/inc/woocommerce-templates.php';
}
function load_filess()
{ ?>
    <style>
        :root {
            --preloaderbac : <?php echo get_theme_mod('preloader_bac','#020D26') ?>;
            --preloaderspan1 : <?php echo get_theme_mod('preloader_color1','#ff5e14') ?>;
            --preloaderspan2 : <?php echo get_theme_mod('preloader_color2','#ff5e14') ?>;
        }
    </style>
    <?php

    wp_enqueue_style('slick', get_template_directory_uri() . '/css/slick.css');
    wp_enqueue_style( 'slick-theme', get_template_directory_uri() . '/css/slick-theme.css' );
    wp_enqueue_style('boots3trap', get_template_directory_uri() . '/css/swiper-bundle.css');
    wp_enqueue_style('main-style', get_template_directory_uri() . '/css/style.css');
    wp_enqueue_style('main-style2', get_template_directory_uri() . 'style.css');
    wp_enqueue_style('main-style3', get_template_directory_uri() . '/includes/assets/css/style.css');
    if ( !is_rtl()) { // Replace condition with your language code.
        wp_enqueue_style( 'nova-ltr-style', get_template_directory_uri() . '/includes/assets/css/style-ltr.css' );
    }
    wp_enqueue_style('responsive-style', get_template_directory_uri() . '/css/responsive.css');
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.min.rtl.css');

    wp_enqueue_script('jquery-min', get_template_directory_uri() . '/js/jquery.min.js');
    wp_enqueue_script('slickjs', get_template_directory_uri() . '/js/slick.min.js');
    wp_enqueue_script('jquery-m3in', get_template_directory_uri() . '/js/swiper-bundle.js');
    wp_enqueue_script('bootstrap-min', get_template_directory_uri() . '/js/bootstrap.min.js');
    wp_enqueue_script('main-js', get_template_directory_uri() . '/js/main.js');
    $value = array(
        'ajax_url' => admin_url( 'admin-ajax.php' )
    );
    wp_localize_script( 'ajax-functions', 'ajax', $value );
}

add_action('wp_enqueue_scripts', 'load_filess');

function configmenus() {
    register_nav_menus(
        array(
            'header-menu' => __( 'منوی هدر' ),
            'mobile-menu' => __( 'منوی موبایل' ),
            'footer-menu' => __( 'منوی فوتر ' ),
            'side-menu' => __( 'منوی سایدبار سینگل ' )
        )
    );
}
add_action( 'init', 'configmenus' );
add_theme_support( 'post-thumbnails' );
add_image_size( 'articlethumb', 350, 215, true );
add_image_size( 'articlethumb-side', 100, 50, true );
add_image_size( 'servicethumb-icon', 80, 80, true );
add_image_size( 'image-single-article', 833.25, 400, true );
add_image_size( 'image-article-box', 340, 235.73, true );
add_image_size( 'image-project', 656, 490, true );
add_image_size( 'image-project-box', 250, 200, true );

function woocommerce_support(){
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');
}
add_action('after_setup_theme','woocommerce_support');
add_theme_support( 'title-tag' );

function get_site_templates($id) {
    $template_content = elementor()->frontend->get_builder_content_for_display( $id );
    if (empty($template_content)) {
        $out= 'empty';
        return $out;
    }
    echo $template_content;
}
function elementor() {
    return \Elementor\Plugin::$instance;
}
function elementor_post_type_categories(){
    $args = array(
        'post_type' => 'elementor_library',
        'posts_per_page' => '-1'
    );
    $templates = get_posts($args);

    $options = array(
        '' => 'پیش فرض',
    );


    if ( ! empty( $templates ) && ! is_wp_error( $templates ) ){
        foreach ( $templates as $template ) {
            $options[ $template->ID ] = $template->post_title;
        }
    }
    return $options;
}
function the_portfolio_cat() {
    $terms = get_the_terms( get_the_ID(),'portfolio_cat');
    if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
        foreach ($terms as $term) {
            echo '<a href="'.get_term_link($term->slug, 'portfolio_cat').'">'.$term->name.'</a>';
        }
    }
}

function the_portfolio_tags()
{
    $terms = get_the_terms(get_the_ID(), 'portfolio_tags');
    if (!is_wp_error($terms) && !empty($terms)) {
        foreach ($terms as $term) {
            echo '<a href="' . get_term_link($term->slug, 'portfolio_tags') . '">' . $term->name . '</a>';
        }
    }
}

function the_product_cats() {
    $terms = get_the_terms( get_the_ID(),'product_cat');
    if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
        foreach ($terms as $term) {
            echo '<a href="'.get_term_link($term->slug, 'product_cat').'">'.$term->name.'</a>';
        }
    }
}

function the_product_tags()
{
    $terms = get_the_terms(get_the_ID(), 'product_tag');
    if (!is_wp_error($terms) && !empty($terms)) {
        foreach ($terms as $term) {
            echo '<a href="' . get_term_link($term->slug, 'product_tag') . '">' . $term->name . '</a>';
        }
    }
}
function prefix_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<p class="menu-item-description">' . $item->description . '</p>' . $args->link_after . '</a>', $item_output );
    }

    return $item_output;
}

add_filter('woocommerce_add_to_cart_fragments', 'iconic_cart_count_fragments', 10, 1);
function iconic_cart_count_fragments($fragments)
{
    $fragments['span.cart-count'] = '<span class="cart-count">' . WC()->cart->get_cart_contents_count() . '</span>';
    return $fragments;
}
function wmpudev_enqueue_icon_stylesheet()
{
    wp_register_style('fontawesome', 'http:////maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css');
    wp_enqueue_style('fontawesome');
}

add_action('wp_enqueue_scripts', 'wmpudev_enqueue_icon_stylesheet');

add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );

        require get_template_directory() . '/inc/customizer.php';
        require get_template_directory() . '/inc/post-type.php';
        require get_template_directory() . '/inc/customizer-polylang.php';
require get_template_directory().'/inc/post-view.php';
require get_template_directory().'/inc/meta-boxe.php';
require get_template_directory().'/breadcrumb.php';
require get_template_directory().'/includes/polarisweb.php';
