<?php
function polaris_add_post_tutor_metabox() {

    add_meta_box(
        'polaris_post_tutor',
        'زمان خواندن',
        'polaris_post_tutor_metabox',
        'post'
    );
}
add_action('add_meta_boxes', 'polaris_add_post_tutor_metabox');
function polaris_post_tutor_metabox( $post ){ ?>

    <?php wp_nonce_field( basename( __FILE__ ), 'polaris_post_tutor_nonce' ); ?>

    <p>
        <label for="polaris-post-tutor">زمان خواندن: </label>
        <br />
        <input class="widefat" type="text" name="polaris-post-tutor" id="polaris-post-tutor"
               value="<?php echo esc_attr( get_post_meta( $post->ID, 'polaris_post_tutor', true ) ); ?>" size="36" />
    </p>
<?php }
add_action('save_post', 'polaris_save_post_tutor_metabox', 10, 2);

function polaris_save_post_tutor_metabox($post_id, $post)
{

    // Verify the Nonce
    if (!isset($_POST['polaris_post_tutor_nonce'])
        || !wp_verify_nonce($_POST['polaris_post_tutor_nonce'], basename(__FILE__))) {
        return $post_id;
    }

    $meta_value = isset($_POST['polaris-post-tutor']) ? sanitize_html_class($_POST['polaris-post-tutor']) : '';

    update_post_meta($post_id, 'polaris_post_tutor', $meta_value);
}
