<?php
// Register Custom Post Type
function portfolio() {
    $portfolio_text = get_theme_mod( 'portfolio_text_breadcrumb' );
    $labels = array(
        'name'                  => _x( 'نمونه کار', 'Post Type General Name', 'text_domain' ),
        'singular_name'         => _x( 'نمونه کار', 'Post Type Singular Name', 'text_domain' ),
        'menu_name'             => __( 'نمونه کار', 'text_domain' ),
        'name_admin_bar'        => __( 'نمونه کار', 'text_domain' ),
        'archives'              => __( 'بایگانی نمونه کار ها', 'text_domain' ),
        'attributes'            => __( 'ویژگی نمونه کار ها', 'text_domain' ),
        'parent_item_colon'     => __( 'والد نمونه کار ها:', 'text_domain' ),
        'all_items'             => __( 'همه نمونه کار ها', 'text_domain' ),
        'add_new_item'          => __( 'افزودن نمونه کار جدید', 'text_domain' ),
        'add_new'               => __( 'افزودن نمونه کار', 'text_domain' ),
        'new_item'              => __( 'نمومه کار جدید', 'text_domain' ),
        'edit_item'             => __( 'ویرایش نمونه کار', 'text_domain' ),
        'update_item'           => __( 'بروز کردن نمونه کار', 'text_domain' ),
        'view_item'             => __( 'نمایش نمونه کار', 'text_domain' ),
        'view_items'            => __( 'نمایش نمونه کار ها', 'text_domain' ),
        'search_items'          => __( 'جستجو در نمونه کار ها', 'text_domain' ),
        'not_found'             => __( 'پیدا نشد', 'text_domain' ),
        'not_found_in_trash'    => __( 'در سطل زباله یافت نمی شود', 'text_domain' ),
        'featured_image'        => __( 'تصویر شاخص', 'text_domain' ),
        'set_featured_image'    => __( 'تنظیم تصویر برجسته', 'text_domain' ),
        'remove_featured_image' => __( 'حذف تصویر شاخص', 'text_domain' ),
        'use_featured_image'    => __( 'به عنوان تصویر برجسته استفاده کنید', 'text_domain' ),
        'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
        'uploaded_to_this_item' => __( 'در این مورد بارگذاری شده است', 'text_domain' ),
        'items_list'            => __( 'لیست نمونه کار ها', 'text_domain' ),
        'items_list_navigation' => __( 'پیمایش لیست نمونه کار ها', 'text_domain' ),
        'filter_items_list'     => __( 'لیست موارد را فیلتر کنید', 'text_domain' ),
    );
    $args = array(
        'label'                 => __( 'نمونه کار', 'text_domain' ),
        'description'           => __( 'Post Type Description', 'text_domain' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'thumbnail', 'custom-fields', 'comments' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'portfolio', $args );

}
add_action( 'init', 'portfolio', 0 );


// Register Custom Taxonomy
function portfolio_cat() {

    $labels = array(
        'name'                       => _x( 'دسته بندی', 'Taxonomy General Name', 'text_domain' ),
        'singular_name'              => _x( 'دسته بندی', 'Taxonomy Singular Name', 'text_domain' ),
        'menu_name'                  => __( 'دسته بندی', 'text_domain' ),
        'all_items'                  => __( 'همه نمونه کار ها', 'text_domain' ),
        'parent_item'                => __( 'والد نمونه کار ', 'text_domain' ),
        'parent_item_colon'          => __( 'والد نمونه کار ها:', 'text_domain' ),
        'new_item_name'              => __( 'افزودن نمونه کار جدید', 'text_domain' ),
        'add_new_item'               => __( 'افزودن نمونه کار جدید', 'text_domain' ),
        'edit_item'                  => __( 'ویرایش نمونه کار', 'text_domain' ),
        'update_item'                => __( 'بروز کردن نمونه کار', 'text_domain' ),
        'view_item'                  => __( 'نمایش نمونه کار', 'text_domain' ),
        'separate_items_with_commas' => __( 'موارد را با ویرگول جدا کنید', 'text_domain' ),
        'add_or_remove_items'        => __( 'اضاف یا حذف کردن نمونه کار', 'text_domain' ),
        'choose_from_most_used'      => __( 'از پرکاربردترین ها را انتخاب کنید', 'text_domain' ),
        'popular_items'              => __( 'نمونه کار های محبوب', 'text_domain' ),
        'search_items'               => __( 'جستجو در نمونه کار ها', 'text_domain' ),
        'not_found'                  => __( 'پیدا نشد', 'text_domain' ),
        'no_terms'                   => __( 'بدون نمونه کار', 'text_domain' ),
        'items_list'                 => __( 'لیست نمونه کار ها', 'text_domain' ),
        'items_list_navigation'      => __( 'پیمایش لیست نمونه کار ها', 'text_domain' ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
    );
    register_taxonomy( 'portfolio_cat', array( 'portfolio' ), $args );

}
add_action( 'init', 'portfolio_cat', 0 );
function portfolio_tags() {

    $labels = array(
        'name'                       => _x( 'تگ ها', 'Taxonomy General Name', 'text_domain' ),
        'singular_name'              => _x( 'تگ ها', 'Taxonomy Singular Name', 'text_domain' ),
        'menu_name'                  => __( 'برچسب', 'text_domain' ),
        'all_items'                  => __( 'همه نمونه کار ها', 'text_domain' ),
        'parent_item'                => __( 'والد نمونه کار', 'text_domain' ),
        'parent_item_colon'          => __( 'والد نمونه کار:', 'text_domain' ),
        'new_item_name'              => __( 'افزودن نمونه کار جدید', 'text_domain' ),
        'add_new_item'               => __( 'افزودن نمونه کار جدید', 'text_domain' ),
        'edit_item'                  => __( 'ویرایش نمونه کار', 'text_domain' ),
        'update_item'                => __( 'بروز کردن نمونه کار', 'text_domain' ),
        'view_item'                  => __( 'نمایش نمونه کار', 'text_domain' ),
        'separate_items_with_commas' => __( 'موارد را با ویرگول جدا کنید', 'text_domain' ),
        'add_or_remove_items'        => __( 'اضاف یا حذف نمونه کار', 'text_domain' ),
        'choose_from_most_used'      => __( 'از پرکاربردترین ها را انتخاب کنید', 'text_domain' ),
        'popular_items'              => __( 'نمونه کار های محبوب', 'text_domain' ),
        'search_items'               => __( 'جستجو نمونه کار', 'text_domain' ),
        'not_found'                  => __( 'پیدا نشد', 'text_domain' ),
        'no_terms'                   => __( 'بدون نمونه کار', 'text_domain' ),
        'items_list'                 => __( 'لیست نمونه کار', 'text_domain' ),
        'items_list_navigation'      => __( 'پیمایش لیست نمونه کار', 'text_domain' ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => false,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
    );
    register_taxonomy( 'portfolio_tags', array( 'portfolio' ), $args );

}
add_action( 'init', 'portfolio_tags', 0 );
?>