<?php

namespace NovaAddons;
/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.2.0
 */
class Plugin {

    /**
     * Instance
     *
     * @since 1.2.0
     * @access private
     * @static
     *
     * @var Plugin The single instance of the class.
     */
    private static $_instance = null;

    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     *
     * @since 1.2.0
     * @access public
     *
     * @return Plugin An instance of the class.
     */
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * widget_scripts
     *
     * Load required plugin core files.
     *
     * @since 1.2.0
     * @access public
     */
    public function widget_scripts() {

    }

    public function widget_styles() {
        wp_register_style( 'test1', get_template_directory_uri() . '/includes/assets/css/test1.css' );

    }

    /**
     * Include Widgets files
     *
     * Load widgets files
     *
     * @since 1.2.0
     * @access private
     */
    private function include_widgets_files() {
        require_once( __DIR__ . '/widgets/title-box.php' );
        require_once( __DIR__ . '/widgets/articles.php' );
        require_once( __DIR__ . '/widgets/related-articles.php' );
        require_once( __DIR__ . '/widgets/projects.php' );
        require_once( __DIR__ . '/widgets/related-projects.php' );
        require_once( __DIR__ . '/widgets/services.php' );
        require_once( __DIR__ . '/widgets/servisestwo.php' );
        require_once( __DIR__ . '/widgets/menu.php' );
        require_once( __DIR__ . '/widgets/sideposts.php' );
        require_once( __DIR__ . '/widgets/header.php' );
        require_once( __DIR__ . '/widgets/header-menu.php' );
        require_once( __DIR__ . '/widgets/login-page.php' );
        require_once( __DIR__ . '/widgets/language.php' );
        require_once( __DIR__ . '/widgets/search.php' );
        require_once( __DIR__ . '/widgets/category.php' );
        require_once( __DIR__ . '/widgets/side-image.php' );
        require_once( __DIR__ . '/widgets/breadcrumb.php' );
        require_once( __DIR__ . '/widgets/post-thumbnail.php' );
        require_once( __DIR__ . '/widgets/the-content.php' );
        require_once( __DIR__ . '/widgets/the-title.php' );
        require_once( __DIR__ . '/widgets/post-information.php' );
        require_once( __DIR__ . '/widgets/next-prev.php' );
        require_once( __DIR__ . '/widgets/comments.php' );
        require_once( __DIR__ . '/widgets/share.php' );
        require_once( __DIR__ . '/widgets/icon-list.php' );
        require_once( __DIR__ . '/widgets/player.php' );
        require_once( __DIR__ . '/widgets/contact-us.php' );
        require_once( __DIR__ . '/widgets/quote-box.php' );
        require_once( __DIR__ . '/widgets/team.php' );
        require_once( __DIR__ . '/widgets/search-page.php' );
        require_once( __DIR__ . '/widgets/mobilebottomnav.php' );
        require_once( __DIR__ . '/widgets/back-to-up.php' );
        require_once( __DIR__ . '/widgets/mobile-menu.php' );
        require_once( __DIR__ . '/widgets/brand-slider.php' );
        require_once( __DIR__ . '/widgets/customers-comment.php' );

        if ( class_exists( 'WooCommerce' ) ) {
            require_once( __DIR__ . '/widgets/products-archive.php' );
            require_once( __DIR__ . '/widgets/woocommerce-pages.php' );
            require_once( __DIR__ . '/widgets/products.php' );
            require_once( __DIR__ . '/widgets/add-to-cart.php' );
            require_once( __DIR__ . '/widgets/product-price.php' );
            require_once( __DIR__ . '/widgets/product-gallery.php' );
            require_once( __DIR__ . '/widgets/product-rating.php' );
            require_once( __DIR__ . '/widgets/product-related.php' );
            require_once( __DIR__ . '/widgets/product-excerpt.php' );
            require_once( __DIR__ . '/widgets/product-tabs.php' );
            require_once( __DIR__ . '/widgets/product-meta.php' );
            require_once( __DIR__ . '/widgets/products.php' );
            require_once( __DIR__ . '/widgets/mini-cart.php' );

        }
    }

    /**
     * Register Widgets
     *
     * Register new Elementor widgets.
     *
     * @since 1.2.0
     * @access public
     */
    public function register_widgets() {
        // Its is now safe to include Widgets files
        $this->include_widgets_files();

        // Register Widgets
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Titlebox() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Articles() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Relatedarticles() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Projects() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Relatedprojects() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Servises() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Servisestwo() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Menu() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Sideposts() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Header() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Headermenu() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Login() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Language() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Search() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Category() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Side_image() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Breadcrumb() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Post_thumnail() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Thetitle() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Content() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Postinformation() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Pre_next_page() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Comments() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Share() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\ITEM() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Player() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Contact_form() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Customer() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Brand() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Mobilemenu() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Back() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Thequotebox() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Team() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Searchpage() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Bottomnav() );


        if ( class_exists( 'WooCommerce' ) ) {
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTS() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Minicart() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\WOOCOMERCEPAGES() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\ADDTOCART() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTPRICE() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTIMAGE() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTRATING() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\RELATEDPRODUCT() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTEXCERPT() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTTABS() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTMETA() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\PRODUCTS() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Archiveproducts() );

        }
    }

    /**
     *  Plugin class constructor
     *
     * Register plugin action hooks and filters
     *
     * @since 1.2.0
     * @access public
     */
    public function __construct() {
        // Register widgets
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
    }
}

// Instantiate Plugin Class
Plugin::instance();
