<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class ADDTOCART extends Widget_Base {

	public function get_name() {
		return 'add-to-cart';
	}

	public function get_title() {
		return __( 'افزودن به سبد خرید', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-add-to-cart';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از دکمه افزودن به سبد خرید و متغیرهای محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'more-result-color',
			[
				'label'     => __( 'رنگ متن دکمه افزودن به سبد خرید', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} form.cart button' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'more-result-background',
				'label' => __( 'پس زمینه دکمه افزودن به سبد خرید', 'plugin-domain' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} form.cart button',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'more-result-typography',
				'label'    => __( 'تایپوگرافی دکمه افزودن به سبد خرید', 'plugin-domain' ),
				
				'selector' => '{{WRAPPER}} form.cart button',
			]
		);

		$this->add_responsive_control(
			'more-result-border-radius',
			[
				'label' => __( 'گردی گوشه های دکمه افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} form.cart button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <form class="variations_form cart">
                <table class="variations" cellspacing="0">
                    <tbody>
                    <tr>
                        <td class="label"><label for="%d8%b3%d8%a7%db%8c%d8%b2">سایز</label></td>
                        <td class="value">
                            <select>
                                <option value="">یک گزینه را انتخاب کنید</option>
                                <option value="100" class="attached enabled">100</option>
                                <option value="500" class="attached enabled">500</option>
                                <option value="300" class="attached enabled">300</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label"><label for="%d8%b1%d9%86%da%af">رنگ</label></td>
                        <td class="value">
                            <select>
                                <option value="">یک گزینه را انتخاب کنید</option>
                                <option value="آبی" class="attached enabled">آبی</option>
                                <option value="قرمز" class="attached enabled">قرمز</option>
                            </select>
                            <a class="reset_variations" href="#" style="visibility: hidden;">پاک کردن</a></td>
                    </tr>
                    </tbody>
                </table>
                <div class="single_variation_wrap">
                    <div class="woocommerce-variation single_variation" style="">
                        <div class="woocommerce-variation-description"></div>
                        <div class="woocommerce-variation-price"><span class="price"><span class="woocommerce-Price-amount amount"><bdi>300000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span></span></div>
                        <div class="woocommerce-variation-availability"><p class="stock in-stock">50 در انبار</p>
                        </div>
                    </div>
                    <div class="woocommerce-variation-add-to-cart variations_button woocommerce-variation-add-to-cart-disabled">
                        <div class="quantity">
                            <label class="screen-reader-text" for="quantity_6108f49794007">پیچ گوشتی برقی دوسو چهارسو
                                فرا ابزار پارس عدد</label>
                            <input type="number" class="input-text qty text" step="1" min="1" max="50" name="quantity" value="1" title="تعداد" size="4" placeholder=""
                                   inputmode="numeric">
                        </div>
                        <button type="submit" class="single_add_to_cart_button button alt wc-variation-selection-needed">
                            افزودن به سبد خرید
                        </button>
                    </div>
                </div>

            </form>
		<?php } else {
			global $product;

			if ( ! is_a( $product, 'WC_Product' ) ) {
				return;
			}
			woocommerce_template_single_add_to_cart();
		}
	}

	protected function content_template() {
	}
}

