<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Back extends Widget_Base
{

    public function get_name()
    {
        return 'Back';
    }

    public function get_title()
    {
        return __('دکمه بازگشت به بالا', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-arrow-up';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),

            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'sedsction_content',
            [
                'label' => __('محتوا', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'icgcbxxgbxoncolor' );
        $this->start_controls_tab( 'orignxdgbdzfginal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'back_to_up_background',
            [
                'label' => __( 'بکگراند باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} #back' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hovgxbxgber', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'back_to_up_background_hover',
            [
                'label' => __( 'هاور بکگراند باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} #back:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'icgbxoncolor' );
        $this->start_controls_tab( 'origfginal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'back_toackground',
            [
                'label' => __( 'خط دور باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} #back' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hovggber', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'back_to_up_back_hover',
            [
                'label' => __( 'هاور خط دور باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} #back:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'رنگ آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} #back svg' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} #back i' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <div id="back">
            <div class="back-icon-up">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
        </div>

    <?php }


    protected function _content_template()
    {
    }
}
