<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brand extends Widget_Base
{

    public function get_name()
    {
        return 'Brand';
    }

    public function get_title()
    {
        return __('اسلایدر برند', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-logo';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'brand-pic',
            [
                'label' => __( 'تصویر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],


            ]
        );
        $repeater->add_control(
            'widget_title',
            [
                'label' => __( 'نام برند', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __( 'Link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'list',
            [
                'label' => __( 'Repeater List', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Title #1', 'plugin-domain' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'plugin-domain' ),
                    ],
                    [
                        'list_title' => __( 'Title #2', 'plugin-domain' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'plugin-domain' ),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secttent9',
            [
                'label' => __('متن برند', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );

        $this->add_control(
            'coidfghnj41mkukleolor',
            [
                'label' => __( 'رنگ متن زیر برند', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .brand-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjd41fghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .brand-name',
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <?php	if ( $settings['list'] ) { ?>
        <div class="swiper-container brand-slider">
            <div class="swiper-wrapper">
                <?php	foreach (  $settings['list'] as $item ) { ?>
                    <div class="swiper-slide">
                            <a href="<?php echo $item['website_link']['url'];?>" class="brand-box">
                                <div class="brand-picture">
                                <img src="<?php echo $item['brand-pic']['url']; ?>" alt="">
                                </div>
                                <div class="brand-name">
                                <?php echo $item['widget_title'];?>
                                </div>
                            </a>
                    </div>
                <?php } ?>
            </div>
        </div>





    <?php
    }
    }

    protected function _content_template()
    {
    }
}
