<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Breadcrumb extends Widget_Base
{

    public function get_name()
    {
        return 'Breadcrumb';
    }

    public function get_title()
    {
        return __('نقشه راه هدر', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-custom-css';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'home-tcvbnmitle',
            [
                'label' => __( 'عنوان صفحه اصلی', 'polaris' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '', 'polaris' ),
            ]
        );

        $this->add_control(
            'search-sxdcfvghjtitle',
            [
                'label' => __( 'عنوان صفحه جستجو', 'polaris' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'نتایج یافت شده برای', 'polaris' ),
            ]
        );

        $this->add_control(
            'error-sdfghjkltitle',
            [
                'label' => __( 'عنوان صفحه خطای 404', 'polaris' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'خطای 404', 'polaris' ),
            ]
        );

        $this->add_control(
            'page-nav-sdfghjktitle',
            [
                'label' => __( 'عنوان صفحه بندی', 'polaris' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'صفحه', 'polaris' ),
            ]
        );
        $this->add_control(
            'text_align',
            [
                'label' => __( 'موقعیت', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'چپ', 'plugin-domain' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'وسط', 'plugin-domain' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'راست', 'plugin-domain' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'sectionsdfghjk_style',
            [
                'label' => __('استایل', 'polaris'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'this_tisdfghjkltle_color',
            [
                'label' => __( 'رنگ متن', 'polaris' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .site-breadcrumb span' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .site-breadcrumb span a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce-breadcrumb a' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'this_currentsdftgyujil_title_color',
            [
                'label' => __( 'رنگ متن صفحه فعلی', 'polaris' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} span.breadcrumbs__current' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce-breadcrumb' => 'color: {{VALUE}} !important',

                ],
            ]
        );        $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'content_typosdfghjkgraphy3',
            'label' => __( 'تایپوگرافی متن', 'polaris' ),
            
            'selector' => '{{WRAPPER}} .site-breadcrumb span',
        ]
    );
        $this->add_control(
            'sep_cosdfghjlor',
            [
                'label' => __( 'رنگ جداکننده', 'polaris' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .site-breadcrumb svg g path' => 'fill: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();


        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <nav class="site-breadcrumb" style="text-align: <?php echo $settings['text_align'];?>"><?php
            if (class_exists( 'WooCommerce' )){
            if (is_cart() || is_checkout() || is_account_page() || is_product_category() || is_shop() || is_product()) {
            woocommerce_breadcrumb();
            } else { if ($settings['home-title'] == false) {$home_text='<i class="fas fa-home" aria-hidden></i>';}else{$home_text=$settings['home-title'];} ?>
                <?php site_breadcrumb($home_text,$settings['search-title'],$settings['error-title'],$settings['page-title']); }}
            else{
                if ($settings['home-title'] == false) {$home_text='<i class="fas fa-home" aria-hidden></i>';}else{$home_text=$settings['home-title'];} ?>
                <?php site_breadcrumb($home_text,$settings['search-title'],$settings['error-title'],$settings['page-title']);
            }
            ?>

                </nav>
    <?php }


    protected function _content_template()
    {
    }
}
