<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Category extends Widget_Base
{

    public function get_name()
    {
        return 'Category';
    }

    public function get_title()
    {
        return __('دسته بندی', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-posts-justified';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content5',
            [
                'label' => __('تنظیمات محتوای باکس', 'NOVA'),
            ]
        );
        $this->add_control(
            'cat_type',
            [
                'label' => __( 'نوع دسته بندی', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'post',
                'options' => [
                    'portfolio'  => __( 'نمونه کار ها', 'NOVA' ),
                    'post' => __( 'مقالات', 'NOVA' ),
                    'product' => __( 'محصولات', 'NOVA' ),

                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'item-style',
            [
                'label' => __('استایل آیتم ها', 'NOVA'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ متن', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .NOVA-categories ul li a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .NOVA-categories ul li' => 'color: {{VALUE}} !important'
                ],
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label' => __( 'رنگ هاور متن', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .NOVA-categories ul li:hover a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .NOVA-categories ul li:hover' => 'color: {{VALUE}} !important'
                ],
            ]
        );

        $this->add_control(
            'title_color_active',
            [
                'label' => __( 'رنگ فعال متن', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .NOVA-categories ul li.current-cat a' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'text-typography',
                'label' => __( 'تایپو گرافی متن ها', 'NOVA' ),
               
                'selector' => '{{WRAPPER}} .NOVA-categories ul li',
            ]
        );

        $this->add_control(
            'item-border',
            [
                'label' => __( 'رنگ خط بین آیتم ها', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .NOVA-categories ul li' => 'border-bottom-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();
   
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $cat_types=$settings['cat_type'];
        switch ($cat_types) {
            case 'post':?>
                <div class="NOVA-categories">

                    <ul>
                        <?php wp_list_categories( array(
                            'post_type' => 'post',
                            'orderby'    => 'name',
                            'show_count' => true,
                            'title_li' => '',
                        ) ); ?>
                    </ul>
                </div>
                <?php  break;
            case 'portfolio':?>
                <div class="NOVA-categories">
                    <ul>
                        <?php wp_list_categories( array(
                            'post_type' => 'portfolio',
                            'taxonomy' => 'portfolio_cat',
                            'orderby'    => 'name',
                            'show_count' => true,
                            'title_li' => '',
                        ) ); ?>
                    </ul>
                </div>
                <?php

                break;

            case 'product':?>
                <div class="NOVA-categories">
                    <ul>
                        <?php wp_list_categories( array(
                            'post_type' => 'product',
                            'taxonomy' => 'product_cat',
                            'orderby'    => 'name',
                            'show_count' => true,
                            'title_li' => '',
                        ) ); ?>
                    </ul>
                </div>
                <?php

                break; }
    }


    protected function _content_template()
    {
    }
}
