<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Comments extends Widget_Base
{

    public function get_name()
    {
        return 'Comments';
    }

    public function get_title()
    {
        return __('کامنت', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-comments';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content1',
            [
                'label' => __('دکمه', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->start_controls_tabs( 'p_clor' );
        $this->start_controls_tab( 'originals', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ بکگراند دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #commentform #submit' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color_hover',
            [
                'label' => __( 'رنگ هاور بکگراند دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #commentform #submit:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'p_sdaclor' );
        $this->start_controls_tab( 'origsadinals', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'titasdle_color',
            [
                'label' => __( 'رنگ متن دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #commentform #submit' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hovasder', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_asdcolor_hover',
            [
                'label' => __( 'رنگ هاور متن دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #commentform #submit:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

    comments_template();
    if (is_rtl()) {
        $placeholdername = 'علیرضا';
        $placeholdercomment = 'دیدگاه شما';

    }
    elseif (!is_rtl()){
        $placeholdername = 'Alex';
        $placeholdercomment = 'your comment';
    }
    ?> <script>
        document.getElementById("comment").setAttribute("placeholder","<?php echo $placeholdercomment;?>");
        document.getElementById("author").setAttribute("placeholder","<?php echo $placeholdername;?>");
    document.getElementById("email").setAttribute("placeholder","example@mail.com");
    document.getElementById("url").setAttribute("placeholder","website.com");</script>
<?php
    }


    protected function _content_template()
    {
    }
}
