<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Contact_form extends Widget_Base
{

    public function get_name()
    {
        return 'contact_form';
    }

    public function get_title()
    {
        return __('فرم تماس', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-form-horizontal';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content-contact-form',
            [
                'label' => __('محتوا', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list_contact_form_email',
            [
                'label'   => __( 'انتخاب فرم', 'Nova' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => cf7_forms(),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style-contact-form',
            [
                'label' => __('استایل', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'placeholder_color',
            [
                'label' => __( 'رنگ متن پیش فرض', 'Nova' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6a8695',
               
                'selectors' => [
                    '{{WRAPPER}} .box-information-contact span input::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .wpcf7-form p span textarea::placeholder' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'background_input_color',
            [
                'label' => __( 'رنگ پس زمینه ورودی ها', 'Nova' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f4f4f4',
               
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form p span textarea' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .box-information-contact span input' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'label' => __( 'تایپوگرافی ورودی ها', 'Nova' ),
               
                'selector' => '{{WRAPPER}} .wpcf7-form p span textarea,.box-information-contact span input',
            ]
        );
        $this->add_control(
            'background_input_border_color',
            [
                'label' => __( 'رنگ حاشیه ورودی ها', 'Nova' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#eeeeee',
               
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form p span textarea' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .box-information-contact span input' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'background_button_color',
            [
                'label' => __( 'رنگ پس زمینه دکمه', 'Nova' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FE5A0E',
               
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'border-radius-button',
            [
                'label' => __( 'انحنای حاشیه', 'Nova' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __( 'تایپوگرافی دکمه', 'Nova' ),
               
                'selector' => '{{WRAPPER}} .wpcf7-submit',
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $short_cod = $settings['short-cod-contact-form'];?>
<div class="contact-form"><?php
        echo do_shortcode('[contact-form-7 id="' . $settings['list_contact_form_email'] . '"]');
    ?></div><?php
    }


    protected function _content_template()
    {
    }
}
