<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Customer extends Widget_Base
{

    public function get_name()
    {
        return 'Customer';
    }

    public function get_title()
    {
        return __('کامنت مشتریان', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-facebook-comments';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }
    

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'commentstyle',
            [
                'label' => esc_html__( 'نوع کامنت', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'first'  => esc_html__( 'نوع اول', 'plugin-name' ),
                    'twice' => esc_html__( 'نوع دوم', 'plugin-name' ),
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __( 'تصویر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],


            ]
        );
        $repeater->add_control(
            'widget_title',
            [
                'label' => __( 'نام مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $repeater->add_control(
            'widget_title3',
            [
                'label' => __( 'سمت مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $repeater->add_control(
            'widget_title2',
            [
                'label' => __( 'نظر مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => __( 'Repeater List', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Title #1', 'plugin-domain' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'plugin-domain' ),
                    ],
                    [
                        'list_title' => __( 'Title #2', 'plugin-domain' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'plugin-domain' ),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectintent9',
            [
                'label' => __('باکس', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poikuytrr' );
        $this->start_controls_tab( 'oripdfitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfgukleolor',
            [
                'label' => __( 'رنگ باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-comment' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfgllor',
            [
                'label' => __( 'رنگ هاور باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-comment:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content9',
            [
                'label' => __('نام مشتری', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ نام مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-name span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور نام مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-comment:hover .customer-name span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .customer-name span',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'secti_content9',
            [
                'label' => __('سمت مشتری', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfgjkuytrr' );
        $this->start_controls_tab( 'oripdfgjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmleolor',
            [
                'label' => __( 'رنگ سمت مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-set span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkfghjkllor',
            [
                'label' => __( 'رنگ هاور سمت مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-comment:hover .customer-set span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjhjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .customer-set span',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'secttent9',
            [
                'label' => __('نظر مشتری', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfg41hjkuytrr' );
        $this->start_controls_tab( 'oripdfghj41oitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnj41mkukleolor',
            [
                'label' => __( 'رنگ نظر مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-note' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuyt41dfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoi41fghjkllor',
            [
                'label' => __( 'رنگ هاور نظر مشتری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .customer-comment:hover .customer-note' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjd41fghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .customer-note',
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <?php	if ( $settings['list'] ) { ?>
        <div class="swiper-container customer-slider">
            <div class="swiper-wrapper">
                <?php	foreach (  $settings['list'] as $item ) {
                    if ($settings['commentstyle']=='first'){
                    ?>
                    <div class="swiper-slide">
                            <div class="customer-comment">
                                <div class="customer-info">
                                <div class="customer-picture">
                                <img src="<?php echo $item['image']['url']; ?>" alt="">
                                </div>
                                    <div class="customer-textinfo">
                                <div class="customer-name">
                                <span><?php echo $item['widget_title'];?></span>
                                </div>
                                    <div class="customer-set">
                                        <span><?php echo $item['widget_title3'];?></span>
                                    </div>
                                    </div>
                                </div>
                                <div class="customer-note">
                                <p><?php echo $item['widget_title2'];?></p>
                                </div>
                            </div>
                    </div>
                <?php }elseif ($settings['commentstyle']=='twice'){?>
                        <div class="swiper-slide">
                            <div class="customer-comment" style="text-align: center;">
                                <div class="customer-note">
                                <p><?php echo $item['widget_title2'];?></p>
                                </div>
                                <div class="customer-info" style="justify-content: center;">
                                    <div class="customer-picture">
                                        <img style="width: 50px !important;height: 50px !important;" src="<?php echo $item['image']['url']; ?>" alt="">
                                    </div>
                                    <div class="customer-textinfo">
                                        <div class="customer-name">
                                            <span><?php echo $item['widget_title'];?></span>
                                        </div>
                                        <div class="customer-set">
                                            <span><?php echo $item['widget_title3'];?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                        <?php
                    }

                } ?>
            </div>
        </div>
    <?php } ?>
<?php    }


    protected function _content_template()
    {
    }
}
