<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Headermenu extends Widget_Base
{

    public function get_name()
    {
        return 'Headermenu';
    }

    public function get_title()
    {
        return __('منو هدر', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-nav-menu';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );

        $this->add_control(
            'menu_list',
            [
                'label'   => __( 'انتخاب منو', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => Nova_menu(),
            ]
        );



        $this->end_controls_section();
        $this->start_controls_section(
            'section_cesnt3',
            [
                'label' => __('منو', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiuytrr' );
        $this->start_controls_tab( 'oripoiuytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytreolor',
            [
                'label' => __( 'رنگ متن منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrlor',
            [
                'label' => __( 'رنگ هاور متن منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'oripoi2uytrls', [ 'label' => __( 'فعلی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuyt3reolor',
            [
                'label' => __( 'رنگ متن منو فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li.current_page_item>a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'poiuyfgdfgdftrr' );
        $this->start_controls_tab( 'hoiuygertfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytdfrlor',
            [
                'label' => __( 'رنگ هاور خط منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu > ul > li:hover::after' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'oripoi2tgerfuytrls', [ 'label' => __( 'فعلی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytre3reolor',
            [
                'label' => __( 'رنگ خط منو فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li.current_page_item::after' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>a',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectisnt3',
            [
                'label' => __('زیرمنو', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiytrr' );
        $this->start_controls_tab( 'oripoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cytreolor',
            [
                'label' => __( 'رنگ متن زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoifrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coytrlor',
            [
                'label' => __( 'رنگ هاور متن زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contet_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a',
            ]
        );
        $this->start_controls_tabs( 'poiyjhgftrr' );
        $this->start_controls_tab( 'oriitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cyeolor',
            [
                'label' => __( 'رنگ متن توضیحات زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hofrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coyrlor',
            [
                'label' => __( 'رنگ هاور متن توضیحات زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover a p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contsdfget_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a p',
            ]
        );
        $this->start_controls_tabs( 'poiythgfdrr' );
        $this->start_controls_tab( 'orisgoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cdflor',
            [
                'label' => __( 'رنگ آیکون زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosdfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coytor',
            [
                'label' => __( 'رنگ هاور آیکون زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
                $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
                        <div class="header-menu">
                            <div class="main-menu <?php echo $settings['menu_type']; ?>">

                                <?php
                                $nav_menu      = $settings['menu_list'];
                                $nav_menu_args = array(
                                    'fallback_cb' => '',
                                    'menu'        => $nav_menu,
                                    'container'   => ' ',
                                    'menu_class'  => 'Nova-nav-menu',
                                );
                                wp_nav_menu( $nav_menu_args ); ?>
                            </div>
                        </div>


        <?php
    }


    protected function _content_template()
    {
    }
}
