<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Header extends Widget_Base
{

    public function get_name()
    {
        return 'Header';
    }

    public function get_title()
    {
        return __('هدر', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-header';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );

        $this->add_control(
            'menu_list',
            [
                'label'   => __( 'انتخاب منو', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => Nova_menu(),
            ]
        );
        $this->add_control(
            'show_cart',
            [
                'label' => __( 'نمایش سبد خرید', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'show_account',
            [
                'label' => __( 'نمایش حساب کاربری', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'box-title',
            [
                'label' => __( 'عنوان سبد خرید', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'سبد خرید', 'plugin-domain' ),
                'condition' => ['show_cart' => 'yes'],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sec7cesnt3',
            [
                'label' => __('هدر', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );

       $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'background2',
            'label' => __( 'هدر فیکس', 'plugin-domain' ),
            'types' => [ 'classic', 'gradient', 'video' ],
            'selector' => '{{WRAPPER}} .fixed-header',
        ]
    );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_wertyuiop',
            [
                'label' => __('تنظیمات چند زبانه', 'polaris'),
            ]
        );
        $this->add_responsive_control(
            'multiple_language',
            [
                'label' => __( 'امکان چند زبانه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_flags',
            [
                'label' => __( 'نمایش پرچم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['multiple_language' => 'yes'],

            ]
        );

        $this->add_control(
            'show_names',
            [
                'label' => __( 'نمایش نام زبان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['multiple_language' => 'yes'],

            ]
        );

        $this->add_control(
            'show_current',
            [
                'label' => __( 'مخفی کردن پرچم فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['multiple_language' => 'yes'],

            ]
        );
        $this->add_responsive_control(
            'icon-1size',
            [
                'label' => __( 'اندازه ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .changebutton i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .changebutton svg' => 'width: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_cesnt3',
            [
                'label' => __('منو', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiuytrr' );
        $this->start_controls_tab( 'oripoiuytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytreolor',
            [
                'label' => __( 'رنگ متن منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-box .header-menu .main-menu>ul>li>a' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrlor',
            [
                'label' => __( 'رنگ هاور متن منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-box .header-menu .main-menu>ul>li>a:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'oripoi2uytrls', [ 'label' => __( 'فعلی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuyt3reolor',
            [
                'label' => __( 'رنگ متن منو فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-box .header-menu .main-menu>ul>li.current_page_item>a' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'dfsfduytrr' );
        $this->start_controls_tab( 'hoiusdfdgdfgfytfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuysddgdffdftrlor',
            [
                'label' => __( 'رنگ هاور نشانگر متن منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .fixed-header .main-menu > ul > li:hover::before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .fixed-header .main-menu > ul > li:hover::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'oripoisdf2uytrls', [ 'label' => __( 'فعلی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiusdfyt3reolor',
            [
                'label' => __( 'رنگ هاور نشانگر منو فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .fixed-header .header-menu .main-menu>ul>li.current_page_item>a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>a',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sec7ce5656565snt3',
            [
                'label' => __('منو موبایل', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->add_control(
            'coiuyt398989898reolor',
            [
                'label' => __( 'رنگ بکگراند منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .header-box .mobilem-menu-content' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'coiu787878787yt3reolor',
            [
                'label' => __( 'رنگ آیکون منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .header-box .mobilem-menu-content .menu-trigger span' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectisnt3',
            [
                'label' => __('زیرمنو', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiytrr' );
        $this->start_controls_tab( 'oripoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cytreolor',
            [
                'label' => __( 'رنگ متن زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoifrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coytrlor',
            [
                'label' => __( 'رنگ هاور متن زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contet_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a',
            ]
        );
        $this->start_controls_tabs( 'poiyjhgftrr' );
        $this->start_controls_tab( 'oriitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cyeolor',
            [
                'label' => __( 'رنگ متن توضیحات زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hofrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coyrlor',
            [
                'label' => __( 'رنگ هاور متن توضیحات زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover a p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contsdfget_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li a p',
            ]
        );
        $this->start_controls_tabs( 'poiythgfdrr' );
        $this->start_controls_tab( 'orisgoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'cdflor',
            [
                'label' => __( 'رنگ آیکون زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosdfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coytor',
            [
                'label' => __( 'رنگ هاور آیکون زیر منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .header-menu .main-menu>ul>li>ul.sub-menu li:hover::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'sectisndft3',
            [
                'label' => __('سبد خرید', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poisdfuytrrsd' );
        $this->start_controls_tab( 'hdxxs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conodftrlor',
            [
                'label' => __( 'رنگ بکگراند ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'orip2uytrls', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuolor',
            [
                'label' => __( 'رنگ هاور بکگراند ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'poisrrsd' );
        $this->start_controls_tab( 'hdoiuyxxs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conlor',
            [
                'label' => __( 'رنگ ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'orrls', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuoloiuor',
            [
                'label' => __( 'رنگ هاور ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'cart-box-background697',
                'label' => __( 'پس زمینه باکس', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .sidecart',

            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'cart-box-style',
            [
                'label' => __( 'تنظیمات باکس سبد خرید', 'polaris' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'list-typography745',
                'label' => __( 'تایپوگرافی متن عنوان', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .sidecart h4',
            ]
        );

        $this->add_control(
            'title-box-color',
            [
                'label'     => __( 'رنگ متن عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .sidecart h4' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'title-box-line-color',
            [
                'label'     => __( 'رنگ خط زیر عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .sidecart .is-divider' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'cart-box-background785',
                'label' => __( 'پس زمینه باکس', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .sidecart',

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'cart-items',
            [
                'label' => __( 'آیتم های سبد خرید', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image-size',
            [
                'label'      => __( 'سایز تصویر', 'plugin-domain' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 30,
                        'max'  => 150,
                        'step' => 1,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 55,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'image-border-radius',
            [
                'label' => __( 'گردی گوشه های تصویر', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image-spacing',
            [
                'label'      => __( 'فاصله تصویر', 'plugin-domain' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'margin-inline-end:{{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_product_typography',
                'label'    => __( 'تایپوگرافی عنوان', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li a:not(.remove)',
            ]
        );

        $this->add_control(
            'title-product-color',
            [
                'label'     => __( 'رنگ عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li a:not(.remove)' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_product_typography',
                'label'    => __( 'تایپوگرافی قیمت', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li .quantity',
            ]
        );

        $this->add_control(
            'price-product-color',
            [
                'label'     => __( 'رنگ قیمت', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li .quantity' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'product-line-color',
            [
                'label'     => __( 'رنگ خط بین آیتم ها', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li' => 'border-bottom-color: {{VALUE}} !important',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'total-btns',
            [
                'label' => __( 'جمع کل و دکمه ها', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'total-background',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p'=>'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total-bt-color',
            [
                'label'     => __( 'رنگ خط بالا', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total.total' => 'border-top-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total-text-color',
            [
                'label'     => __( 'رنگ متن جمع کل', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p.woocommerce-mini-cart__total.total' => 'color: {{VALUE}}',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'total-text-typography',
                'label'    => __( 'تایپوگرافی متن جمع کل', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p.woocommerce-mini-cart__total.total',
            ]
        );

        $this->add_control(
            'total-btns-color',
            [
                'label'     => __( 'رنگ متن دکمه ها', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p a' => 'color: {{VALUE}}',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'total-btns-background',
                'label' => __( 'پس زمینه دکمه ها', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'total-btns-typography',
                'label'    => __( 'تایپوگرافی دکمه ها', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p a',
            ]
        );

        $this->add_control(
            'total-btns-border-radius',
            [
                'label' => __( 'گردی گوشه های دکمه ها', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_contengft',
            [
                'label' => __('چند زبانه', 'polaris'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['multiple_language' => 'yes'],

            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li a span' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .change-lang ul li a span',
            ]
        );
        $this->start_controls_tabs( 'b_ol2or' );
        $this->start_controls_tab( 'oria2lse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_cl2ore',
            [
                'label' => __( 'بکگراند باکس ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosve2rse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_co2lver',
            [
                'label' => __( 'هاور بکگراند باکس ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_osdfl2or' );
        $this->start_controls_tab( 'orisdfa2lse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_clsdf2ore',
            [
                'label' => __( 'رنگ ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosvsdfe2rse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_csdfo2lver',
            [
                'label' => __( 'رنگ هاور ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_olor' );
        $this->start_controls_tab( 'orialse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_clore',
            [
                'label' => __( 'بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li ul li' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosverse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_colver',
            [
                'label' => __( 'هاور بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li ul li:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'sect1tesdfgnt3',
            [
                'label' => __( 'آیکن ورود', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'se1icon' );
        $this->start_controls_tab( 'no1-icon', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'sear1lor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            's1eaac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover1on', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'se1r',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '1rcback',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        $this->end_controls_section();
        $this->start_controls_section(
        'section_icon',
        [
            'label' => __( 'سرچ', 'text-domain' ),
        ]
    );



        $this->add_control(
            'icon',
            [
                'label' => __( 'آیکن تاگل', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-search',
                    'library' => 'solid',
                ],

            ]
        );

        $this->add_control(
            'search-placeholder',
            [
                'label' => __( 'متن نگهدارنده', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'جستجو کنید', 'plugin-domain' ),
            ]
        );

        $this->add_control(
            'show-list',
            [
                'label' => __( 'نمایش لیست پست تایپ ها', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'search-in',
            [
                'label' => __( 'جستجو در', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'post' => [
                        'title' => __( 'مقالات', 'plugin-domain' ),
                    ],
                    'portfolio' => [
                        'title' => __( 'نمونه کارها', 'plugin-domain' ),
                    ],
                    'product' => [
                        'title' => __( 'محصولات', 'plugin-domain' ),
                    ],
                ],
                'default' => 'article',
                'toggle' => false,
                'condition' => [
                    'show-list' => ''
                ]
            ]
        );

        $this->add_control(
            'search-list-article',
            [
                'label' => __( 'عنوان مقالات در لیست بازشونده', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'مقالات', 'plugin-domain' ),
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'search-list-portfolio',
            [
                'label' => __( 'عنوان نمونه کارها در لیست بازشونده', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'نمونه کارها', 'plugin-domain' ),
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]

        );


        $this->add_control(
            'search-list-products',
            [
                'label'   => __( 'عنوان محصولات در لیست بازشونده', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'محصولات', 'plugin-domain' ),
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content1',
            [
                'label' => __( 'تنظیمات باکس سرچ', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'form-box-border-color',
            [
                'label'     => __( 'رنگ کادر', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} #select-post-type-for-search' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form.product > ul' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'list-text-color',
            [
                'label'     => __( 'رنگ متن لیست', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} #select-post-type-for-search' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'list-bac-color',
            [
                'label'     => __( 'رنگ پس زمینه لیست', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} #select-post-type-for-search' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'list-typography222',
                'label' => __( 'تایپوگرافی لیست', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} #select-post-type-for-search',
                'condition' => [
                    'show-list' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'input-text-color',
            [
                'label'     => __( 'رنگ متن ورودی', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input-bac-color',
            [
                'label'     => __( 'رنگ پس زمینه کادر متن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'input-typography',
                'label' => __( 'تایپوگرافی متن ورودی', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .site-search-form input',
            ]
        );




        $this->end_controls_section();


        $this->start_controls_section(
            'section_condfgtent3',
            [
                'label' => __( 'آیکن جستجو', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'search-icon' );
        $this->start_controls_tab( 'normal-search-icon', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'searlor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'seaac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover-search-icon', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'search-icocolor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'searcback',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content3',
            [
                'label' => __( 'آیکن جستجو در فرم', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'search-icon22' );
        $this->start_controls_tab( 'normal-search-icon22', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'search-icon-color',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form button .spinner-border' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search-icon-bac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover-search-icon45', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'search-icon-hover-color',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form button:hover .spinner-border' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search-icon-hover-back',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
     <?php
if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
    <div class="fixed-header" style="position: static;">

            <?php } else { ?>
    <div class="fixed-header">

    <?php
}?>
        <div class="container">
<div class="header-box">
   <div class="right-of-header">
    <div class="header-menu">
        <div class="main-menu <?php echo $settings['menu_type']; ?>">

            <?php
            $nav_menu      = $settings['menu_list'];
            $nav_menu_args = array(
                'fallback_cb' => '',
                'menu'        => $nav_menu,
                'container'   => ' ',
                'menu_class'  => 'Nova-nav-menu',
            );
            wp_nav_menu( $nav_menu_args ); ?>
        </div>
    </div>
       <div class="mobilem-menu-content">
       <button class="menu-trigger" id="menu01">
           <span></span>
           <span></span>
           <span></span>
       </button>
       <div class="mobile-menu">
           <div class="nova-mobile-menu">
               <?php
               $nav_menu      = $settings['menu_list'];
               $nav_menu_args = array(
                   'fallback_cb' => '',
                   'menu'        => $nav_menu,
                   'container'   => ' ',
                   'menu_class'  => 'nova-mobile-menu-ul',
               );
               wp_nav_menu( $nav_menu_args ); ?>
           </div>
           <div class="menu-closer">
               <div class="close-icon">
                   &#10005;
               </div>
           </div>

       </div>
       <div class="menu-background"></div>
   </div>
   </div>
    <div class="left-of-header">
                        <?php if ('yes' === $settings['show_account']) {?>
        <div class="login-area"> <?php
        if (is_user_logged_in()) {
        $current_user = wp_get_current_user(); ?>
        <div class="user-is-login">
            <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
                <img src="<?php echo get_avatar_url($current_user->ID, 90); ?>" class="u-avatar"></a>
        </div>
    <?php } else{ ?>
                <div class="user-isnt-login">
            <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">

            <i class="fas fa-user nav-link"></i>
            </a>
                </div>
            <?php
        }?>
    </div>
                <?php } if ('yes' === $settings['show_cart']) {
                                    if ( class_exists( 'WooCommerce' ) ) {
                            ?>
        <div class="my-cart">
                <div class="cart-icon"> <i class="fas fa-shopping-cart " aria-hidden>
                    <span id="mini-cart-count" class="cart-count"><?php echo is_object( WC()->cart ) ? WC()->cart->get_cart_contents_count() : ''; ?></span>
                    </i></div>
                <div class="close-side-cart"></div>
                <div class="sidecart woocommerce">
                    <div class="cart-popup-title text-center">
                        <h4 class="uppercase"><?php echo $settings['box-title']; ?></h4>
                        <div class="is-divider"></div>
                    </div>
                    <div class="widget_shopping_cart_content">
                        <?php
                        global $product;
                        if ( is_a( $product, 'WC_Product' ) ) {
                            woocommerce_mini_cart();
                        } ?>
                    </div>
                </div>
<div class="sidecart-back"></div>

        </div>
        <?php } } if ('yes' === $settings['multiple_language']) {
        if ('yes' === $settings['show_flags']) {
            $show_flag = 1;
        } else {
            $show_flag = 0;
        }
        if ('yes' === $settings['show_names']) {
            $show_name = 1;
        } else {
            $show_name = 0;
        }
        if ('yes' === $settings['show_current']) {
            $show_current = 1;
        } else {
            $show_current = 0;
        } ?>
        <div class="change-lang">
            <ul>
                <li class="changebutton">
                    <i aria-hidden="true" class="fas fa-globe-americas"></i>
                    <ul class="langlist">
                        <?php if ( function_exists( 'pll_the_languages') ) {
                                pll_the_languages(array('show_flags' => $show_flag, 'show_names' => $show_name, 'hide_current' => $show_current));

                        } ?>
                    </ul>
                </li>
            </ul>
        </div>
<?php } ?>

        <div class="search-icon">
        <i class="fa fa-search"></i>
        </div>
        <form class="site-search-form opensearch" action="<?php echo home_url('/'); if (function_exists('pll_the_languages') && pll_default_language()!=pll_current_language()){ echo pll_current_language().'/';} ?>" method="get">
    <input type="text" name="s" value="<?php the_search_query(); ?>" placeholder="<?php echo $settings['search-placeholder']; ?>">
    <button type="submit" name="button"> <i class="fas fa-search" aria-hidden></i> </button>
    <input type="hidden" id="get-post-type-value" name="post_type" value="post" />
    </form>

        <div class="site-search-form-back"></div>
    </div>
    </div>

        </div>
        </div>


        <?php
    }


    protected function _content_template()
    {
    }
}
