<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ITEM extends Widget_Base
{

    public function get_name()
    {
        return 'ITEM';
    }

    public function get_title()
    {
        return __('آیتم لیست', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-post-list';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'the_title',
            [
                'label' => __( 'متن', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'the_content_title',
            [
                'label' => __( 'توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'آیکون', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'website_linkonoff',
            [
                'label' => __( 'لینک', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __( 'Link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => ['website_linkonoff' => 'yes']
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => __( 'گردی گوشه ها', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .icon-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'margine',
            [
                'label' => __( 'فاصله بین ایکون و توضیحات', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-list' => 'margin-inline-end: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->add_control(
            'margine2',
            [
                'label' => __( 'فاصله بین متن و توضیح', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-of-item h5' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content134',
            [
                'label' => __('متن', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->start_controls_tabs( 'p_clor' );
        $this->start_controls_tab( 'originals', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ متن', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color_hover',
            [
                'label' => __( 'رنگ هاور متن', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box:hover h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography2',
                'label' => __( 'Typography', 'plugin-domain' ),
            
                'selector' => '{{WRAPPER}} .item-box h5',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_content123',
            [
                'label' => __('توضیح', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );
        $this->start_controls_tabs( 'p_clor22' );
        $this->start_controls_tab( 'originals2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color2',
            [
                'label' => __( 'رنگ توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2ver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_color_hover2',
            [
                'label' => __( 'رنگ هاور توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box:hover h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography22',
                'label' => __( 'Typography', 'plugin-domain' ),
            
                'selector' => '{{WRAPPER}} .item-box h6',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content13',
            [
                'label' => __('آیکون', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'icon-1size',
            [
                'label' => __( 'اندازه ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-list i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .icon-list svg' => 'width: {{SIZE}}{{UNIT}} !important;height: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->add_control(
            'icon-1size2',
            [
                'label' => __( 'ابعاد باکس ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-list' => 'width: {{SIZE}}{{UNIT}} !important; height: {{SIZE}}{{UNIT}} !important;min-width: {{SIZE}}{{UNIT}} !important; min-height: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->start_controls_tabs( 'p_clo2222r22' );
        $this->start_controls_tab( 'origi2n222a23ls2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_c2o222lor2',
            [
                'label' => __( 'رنگ ایکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box .icon-list i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-box .icon-list svg' => 'fill: {{VALUE}}',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2sgdffgve222r23', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_colo2r_hodgfgghhg222ver2',
            [
                'label' => __( 'رنگ هاور ایکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-box:hover .icon-list i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-box:hover .icon-list svg' => 'fill: {{VALUE}}',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'p_clo2r22' );
        $this->start_controls_tab( 'origi2na23ls2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'plugin-name' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .item-box .icon-list',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2vrytrdtghbsdfber23', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'backgroundds',
                'label' => esc_html__( 'Background', 'plugin-name' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .item-box:hover .icon-list',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__( 'Box Shadow', 'plugin-name' ),
                'selector' => '{{WRAPPER}} .item-box .icon-list',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <a                 <?php if ('yes' === $settings['website_linkonoff']) { ?>
        href="<?php echo $settings['website_link']['url']; }?>" class="item-box">
            <div class="icon-list">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
            <div class="content-of-item">
                <?php if ($settings['the_title']){?>
                    <h5><?php echo $settings['the_title'];?></h5><?php } if ($settings['the_content_title']){?>
                    <h6><?php echo $settings['the_content_title'];?></h6><?php } ?>
            </div>
        </a>
    <?php }


    protected function _content_template()
    {
    }
}
