<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Language extends Widget_Base
{

    public function get_name()
    {
        return 'Language';
    }

    public function get_title()
    {
        return __('چندزبانه', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-editor-code';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {


        $this->start_controls_section(
            'section_wertyuiop',
            [
                'label' => __('تنظیمات چند زبانه', 'polaris'),
            ]
        );

        $this->add_control(
            'show_flags',
            [
                'label' => __( 'نمایش پرچم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'show_names',
            [
                'label' => __( 'نمایش نام زبان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'show_current',
            [
                'label' => __( 'مخفی کردن پرچم فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_responsive_control(
            'icon-1size',
            [
                'label' => __( 'اندازه ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .changebutton i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .changebutton svg' => 'width: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_contengft',
            [
                'label' => __('چند زبانه', 'polaris'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li a span' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .change-lang ul li a span',
            ]
        );
        $this->start_controls_tabs( 'b_ol2or' );
        $this->start_controls_tab( 'oria2lse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_cl2ore',
            [
                'label' => __( 'بکگراند باکس ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosve2rse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_co2lver',
            [
                'label' => __( 'هاور بکگراند باکس ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_osdfl2or' );
        $this->start_controls_tab( 'orisdfa2lse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_clsdf2ore',
            [
                'label' => __( 'رنگ ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosvsdfe2rse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_csdfo2lver',
            [
                'label' => __( 'رنگ هاور ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang > ul > li:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_olor' );
        $this->start_controls_tab( 'orialse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_clore',
            [
                'label' => __( 'بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li ul li' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosverse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_colver',
            [
                'label' => __( 'هاور بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .change-lang ul li ul li:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
                        <?php
                            if ('yes' === $settings['show_flags']) {
                                $show_flag = 1;
                            } else {
                                $show_flag = 0;
                            }
                            if ('yes' === $settings['show_names']) {
                                $show_name = 1;
                            } else {
                                $show_name = 0;
                            }
                            if ('yes' === $settings['show_current']) {
                                $show_current = 1;
                            } else {
                                $show_current = 0;
                            } ?>
                            <div class="change-lang">
                                <ul>
                                    <li class="changebutton">
                                        <i aria-hidden="true" class="fas fa-globe-americas"></i>
                                        <ul class="langlist">
                                            <?php if ( function_exists( 'pll_the_languages') ) {

                                                    pll_the_languages(array('show_flags' => $show_flag, 'show_names' => $show_name, 'hide_current' => $show_current));
                                                
                                            } ?>
                                        </ul>
                                    </li>
                                </ul>
                            </div>


        <?php
    }


    protected function _content_template()
    {
    }
}
