<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Login extends Widget_Base
{

    public function get_name()
    {
        return 'Login';
    }

    public function get_title()
    {
        return __('لاگین', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-lock-user';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {


        $this->start_controls_section(
            'sect1tesdfgnt3',
            [
                'label' => __( 'آیکن ورود', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'se1icon' );
        $this->start_controls_tab( 'no1-icon', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'sear1lor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            's1eaac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover1on', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'se1r',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '1rcback',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-isnt-login a:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
                    <div class="login-area"> <?php
                            if (is_user_logged_in()) {
                                $current_user = wp_get_current_user(); ?>
                                <div class="user-is-login">
                                    <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
                                        <img src="<?php echo get_avatar_url($current_user->ID, 90); ?>" class="u-avatar"></a>
                                </div>
                            <?php } else{ ?>
        <div class="user-isnt-login">
        <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">

                                    <i class="fas fa-user nav-link"></i>
                                </a>
        </div>
                                <?php
                            }?>
                        </div>
        <?php
    }


    protected function _content_template()
    {
    }
}
