<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Menu extends Widget_Base
{

    public function get_name()
    {
        return 'menu';
    }

    public function get_title()
    {
        return __('منو', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-menu-bar';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'محتوا', 'Nova' ),
            ]
        );

        $this->add_control(
            'menu_list',
            [
                'label'   => __( 'انتخاب منو', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => Nova_menu(),
            ]
        );
        $this->add_control(
            'menu_type',
            [
                'label'   => __( 'جهت منو', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => __( 'افقی', 'plugin-domain' ),
                    'vertical'   => __( 'عمودی', 'plugin-domain' ),
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'تنظیمات منو', 'plugin-name' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'رنگ منو', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .main-menu.vertical ul li.menu-item-has-children::after' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label'     => __( 'رنگ هاور منو', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li:hover > a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .main-menu ul li a::before' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .main-menu.vertical ul li.menu-item-has-children:hover::after' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'title_color_active',
            [
                'label'     => __( 'رنگ منو فعال', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .main-menu.horizontal ul li.current-menu-item > a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .main-menu.horizontal ul li.current_page_item > a' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_responsive_control(
            'menu-spacing',
            [
                'label'      => __( 'فاصله بین آبتم ها', 'plugin-domain' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 1,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .main-menu > ul > li' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2);margin-left: calc({{SIZE}}{{UNIT}} / 2)',
                ],
                'condition' => [
                    'menu_type' => 'horizontal'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'label'    => __( 'تایپوگرافی منو', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .main-menu ul li a',
            ]
        );
        $this->add_control(
            'border_ho_color',
            [
                'label'     => __( 'رنگ خط هاور', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .horizontal.main-menu > ul > li::before' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .horizontal.main-menu > ul > li::after' => 'background: {{VALUE}} !important',
                ],
                'condition' => [
                    'menu_type' => 'horizontal'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section3',
            [
                'label' => __( 'تنظیمات زیر منو', 'plugin-name' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'menu_type' => 'horizontal'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'submenu-background',
                'label' => __( 'پس زمینه', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .horizontal.main-menu ul > li > ul',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'خط حاشیه', 'plugin-domain' ),
                'selector' => '{{WRAPPER}} .horizontal.main-menu ul > li > ul',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'سایه کادر', 'plugin-domain' ),
                'selector' => '{{WRAPPER}} .horizontal.main-menu ul > li > ul',
            ]
        );

        $this->add_control(
            'title_colorse',
            [
                'label'     => __( 'رنگ متن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .horizontal.main-menu ul > li > ul > li a' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'title_colorse_hover',
            [
                'label'     => __( 'رنگ هاور متن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .horizontal.main-menu ul > li > ul > li:hover > a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .horizontal.main-menu ul > li > ul > li::before' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();



    }


    protected function render() {
        $settings = $this->get_settings_for_display(); ?>
        <div class="main-menu <?php echo $settings['menu_type']; ?>">

            <?php
            $nav_menu      = $settings['menu_list'];
            $nav_menu_args = array(
                'fallback_cb' => '',
                'menu'        => $nav_menu,
                'container'   => ' ',
                'menu_class'  => 'loop-nav-menu',
            );
            wp_nav_menu( $nav_menu_args ); ?>
        </div>
    <?php }

    protected function _content_template() {
    }
}
