<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Minicart extends Widget_Base
{

    public function get_name()
    {
        return 'Minicart';
    }

    public function get_title()
    {
        return __('سبد خرید', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-archive-posts';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );

        $this->add_control(
            'box-title',
            [
                'label' => __( 'عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'سبد خرید', 'plugin-domain' ),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectisndft3',
            [
                'label' => __('سبد خرید', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poisdfuytrrsd' );
        $this->start_controls_tab( 'hdxxs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conodftrlor',
            [
                'label' => __( 'رنگ بکگراند ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'orip2uytrls', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuolor',
            [
                'label' => __( 'رنگ هاور بکگراند ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'poisrrsd' );
        $this->start_controls_tab( 'hdoiuyxxs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conlor',
            [
                'label' => __( 'رنگ ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'orrls', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuoloiuor',
            [
                'label' => __( 'رنگ هاور ایکون سبد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'cart-box-background',
                'label' => __( 'پس زمینه باکس', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .sidecart',

            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'cart-box-style',
            [
                'label' => __( 'تنظیمات باکس سبد خرید', 'polaris' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'list-typography',
                'label' => __( 'تایپوگرافی متن عنوان', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .sidecart h4',
            ]
        );

        $this->add_control(
            'title-box-color',
            [
                'label'     => __( 'رنگ متن عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .sidecart h4' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'title-box-line-color',
            [
                'label'     => __( 'رنگ خط زیر عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .sidecart .is-divider' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'cart-box-background258',
                'label' => __( 'پس زمینه باکس', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .sidecart',

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'cart-items',
            [
                'label' => __( 'آیتم های سبد خرید', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image-size',
            [
                'label'      => __( 'سایز تصویر', 'plugin-domain' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 30,
                        'max'  => 150,
                        'step' => 1,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 55,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'image-border-radius',
            [
                'label' => __( 'گردی گوشه های تصویر', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image-spacing',
            [
                'label'      => __( 'فاصله تصویر', 'plugin-domain' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li img' => 'margin-inline-end:{{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_product_typography',
                'label'    => __( 'تایپوگرافی عنوان', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li a:not(.remove)',
            ]
        );

        $this->add_control(
            'title-product-color',
            [
                'label'     => __( 'رنگ عنوان', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li a:not(.remove)' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_product_typography',
                'label'    => __( 'تایپوگرافی قیمت', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li .quantity',
            ]
        );

        $this->add_control(
            'price-product-color',
            [
                'label'     => __( 'رنگ قیمت', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li .quantity' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'product-line-color',
            [
                'label'     => __( 'رنگ خط بین آیتم ها', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart.cart_list.product_list_widget li' => 'border-bottom-color: {{VALUE}} !important',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'total-btns',
            [
                'label' => __( 'جمع کل و دکمه ها', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'total-background',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p'=>'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total-bt-color',
            [
                'label'     => __( 'رنگ خط بالا', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total.total' => 'border-top-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total-text-color',
            [
                'label'     => __( 'رنگ متن جمع کل', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p.woocommerce-mini-cart__total.total' => 'color: {{VALUE}}',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'total-text-typography',
                'label'    => __( 'تایپوگرافی متن جمع کل', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p.woocommerce-mini-cart__total.total',
            ]
        );

        $this->add_control(
            'total-btns-color',
            [
                'label'     => __( 'رنگ متن دکمه ها', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p a' => 'color: {{VALUE}}',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'total-btns-background',
                'label' => __( 'پس زمینه دکمه ها', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'total-btns-typography',
                'label'    => __( 'تایپوگرافی دکمه ها', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .widget_shopping_cart_content > p a',
            ]
        );

        $this->add_control(
            'total-btns-border-radius',
            [
                'label' => __( 'گردی گوشه های دکمه ها', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content > p a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

                        <div class="my-cart">
                                <div class="cart-icon"> <i class="fas fa-shopping-cart " aria-hidden>
                                        <span id="mini-cart-count" class="cart-count"><?php echo is_object( WC()->cart ) ? WC()->cart->get_cart_contents_count() : ''; ?></span>
                                    </i></div>
                                <div class="close-side-cart"></div>
                                <div class="sidecart woocommerce">
                                    <div class="cart-popup-title text-center">
                                        <h4 class="uppercase"><?php echo $settings['box-title']; ?></h4>
                                        <div class="is-divider"></div>
                                    </div>
                                    <div class="widget_shopping_cart_content">
                                        <?php
                                        global $product;
                                        if ( is_a( $product, 'WC_Product' ) ) {
                                            woocommerce_mini_cart();
                                        } ?>
                                    </div>
                                </div>
                                <div class="sidecart-back"></div>
                        </div>

        <?php
    }


    protected function _content_template()
    {
    }
}
