<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Mobilemenu extends Widget_Base
{

    public function get_name()
    {
        return 'Mobilemenu';
    }

    public function get_title()
    {
        return __('منو موبایل', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-menu-bar';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'menu_list',
            [
                'label'   => __( 'انتخاب منو', 'plugin-domain' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => Nova_menu(),
            ]
        );
        $this->add_control(
            'coiuy8reolor',
            [
                'label' => __( 'رنگ بکگراند منو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .mobilem-menu-content' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'رنگ آیکون منو', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-trigger span' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_wertyuiop',
            [
                'label' => __('تنظیمات چند زبانه', 'polaris'),
            ]
        );

        $this->add_control(
            'show_langs',
            [
                'label' => __( 'نمایش چندزبانه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'show_flags',
            [
                'label' => __( 'نمایش پرچم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'show_names',
            [
                'label' => __( 'نمایش نام زبان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'show_current',
            [
                'label' => __( 'مخفی کردن پرچم فعلی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'your-plugin' ),
                'label_off' => __( 'مخفی', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <div class="mobilem-menu-content">
    <button class="menu-trigger" id="menu01">
            <span></span>
            <span></span>
            <span></span>
        </button>
<div class="mobile-menu">
        <div class="menu-mobile">
            <?php
            $nav_menu      = $settings['menu_list'];
            $nav_menu_args = array(
                'fallback_cb' => '',
                'menu'        => $nav_menu,
                'container'   => ' ',
                'menu_class'  => 'nova-mobile-menu-ul',
            );
            wp_nav_menu( $nav_menu_args ); ?>
        </div>
    <?php
    if ('yes' === $settings['show_flags']) {
        $show_flag = 1;
    } else {
        $show_flag = 0;
    }
    if ('yes' === $settings['show_names']) {
        $show_name = 1;
    } else {
        $show_name = 0;
    }
    if ('yes' === $settings['show_current']) {
        $show_current = 1;
    } else {
        $show_current = 0;
    }  if ($settings['show_langs'] == 'yes'){?>
    <div class="menumobilelang">
                    <?php if ( function_exists( 'pll_the_languages') ) {

                        pll_the_languages(array('show_flags' => $show_flag, 'show_names' => $show_name, 'hide_current' => $show_current));

                    } ?>
    </div>
    <?php }?>
    <div class="menu-closer">
        <div class="close-icon">
            &#10005;
        </div>
    </div>

</div>
        <div class="menu-background"></div>
        </div>
        <style>

.menumobilelang li{
    background: #e6e6e6;
    padding: 10px;
    border-radius: 5px;
}
.menumobilelang{
    position: absolute;
    z-index: 10000;
    bottom: 0;
    height: 85px;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    flex-wrap: wrap;
    gap: 5px;
}
            .mobile-menu-icon span {
                display: block;
                height: 3px;
                width: 30px;
                background: #333333;
                opacity: 1;
                -webkit-transform: rotate(0);
                -moz-transform: rotate(0);
                -o-transform: rotate(0);
                transform: rotate(0);
                -webkit-transition: 0.25s ease-in-out;
                -moz-transition: 0.25s ease-in-out;
                -o-transition: 0.25s ease-in-out;
                transition: 0.25s ease-in-out;
                outline: 0 !important;
                border-radius: 10px;
                margin-bottom: 7px;
            }
            .mobile-menu-icon span:last-child {
                margin-bottom: 0;
            }
            .menu-mobile {
                height: 100%;
                width: 100%;
                background: #ffffff;
                padding-top:125px;
            }
            .fixed-header .top-of-mobile-menu {
                opacity: 0;
                display: none;
            }

            .mobile-menu-is-open {
                right: 0;
            }
            .mobile-menu-back {
                display: block;
                position: fixed;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                z-index: 999;
                background-color: rgba(0, 0, 0, 0.5);
                -webkit-animation: fade 0.5s;
                animation: fade 0.5s;
                visibility: hidden;
                opacity: 0;
                transition: 0.3s;
            }
            .mobile-menu-back-is-show {
                visibility: visible;
                opacity: 1;
            }
            .menu-mobile ul {
                padding: 0;
            }
            .menu-mobile{
                height: 100%;
                overflow-y: scroll;
                padding-bottom: 85px;
            }
            .mobile-lang li {
                border-bottom: none !important;
            }
            .menu-mobile  ul  li {
                margin: 0;
            }
            .menu-mobile > ul > li {
                border-bottom: 1px dashed #9d9d9d;
                margin: 0;
                padding:0;
            }
            .menu-mobile > ul > li:last-child {
                border-bottom: none;
            }
            .menu-mobile ul li a {
                color: #252525;
                padding: 14px;
                text-decoration: none;
                text-align: right;
                font-size: 14px;
                display: block;
            }
            .menu-mobile > ul > li > ul {
                display: none;
            }
            .menu-mobile .menu-item-has-children {
                position: relative;
            }
            .menu-mobile .menu-item-has-children::after {
                content: "";
                position: absolute;
                top: 15px;
                left: 25px;
                transition: 0.3s;
                width: 0;
                height: 0;
                border-top: 10px solid transparent;
                border-bottom: 10px solid transparent;

                border-right:10px solid #000000;
            }
            .menu-mobile .open-sub-menu::after {
                transform: rotate(-90deg);
            }
            .menu-mobile ul li.menu-item-has-children ul {
                background: #D2D2D2;
            }
            .menu-mobile ul li.menu-item-has-children ul li {
                border-bottom: 1px dashed #194688;
                list-style: none;
            }
            .menu-mobile ul li.menu-item-has-children ul li:last-child {
                border-bottom: none;
            }
            .mobile-menu-icon-open{
                margin-right: 15px;
            }


        </style>
<script>
    jQuery(document).ready(function (e) {
        e("body").on("click", ".menu-mobile ul li.menu-item-has-children", function () {
        event.stopPropagation(),
        event.target === this &&
        (e(this).find("li > ul").is(":visible") && (e(this).find("li > ul").slideUp(), e(this).find("li").removeClass("open-sub-menu")), e(this).find("ul:first").slideToggle(), e(this).toggleClass("open-sub-menu"));

    });
    });
</script>
<?php
    }


    protected function _content_template()
    {
    }
}
