<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Bottomnav extends Widget_Base
{

    public function get_name()
    {
        return 'Bottomnav';
    }

    public function get_title()
    {
        return __('ناوبری موبایل', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-nav-menu';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content85',
            [
                'label' => __('تنظیمات منو موبایل', 'Nova'),

            ]
        );
        $this->add_control(
            'menu_type',
            [
                'label' => esc_html__( 'نوع منو', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'first',
                'options' => [
                    'first'  => esc_html__( 'منوی اول', 'plugin-name' ),
                    'second' => esc_html__( 'منوی دوم', 'plugin-name' ),
                    'third' => esc_html__( 'منوی سوم', 'plugin-name' ),
                ],
            ]
        );
        $this->add_control(
            'icon_count',
            [
                'label' => esc_html__( 'تعداد آیکون ها', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'five',
                'options' => [
                    'three'  => esc_html__( 'سه تایی', 'plugin-name' ),
                    'five' => esc_html__( 'پنج تایی', 'plugin-name' ),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_co5454ntent5',
            [
                'label' => __('پیکربندی آیکون راست', 'Nova'),

            ]
        );
        $this->add_control(
            'firsticon',
            [
                'label' => esc_html__( 'Icon', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-home',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'firstlink',
            [
                'label' => esc_html__( 'Link', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'plugin-name' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sect545499ent85',
            [
                'label' => __('پیکربندی آیکون دوم', 'Nova'),
                'condition' => ['icon_count' => 'five'],
            ]
        );
        $this->add_control(
            'twiceicon',
            [
                'label' => esc_html__( 'Icon', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-list',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'twicelink',
            [
                'label' => esc_html__( 'Link', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'plugin-name' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            's87875',
            [
                'label' => __('پیکربندی آیکون وسط', 'Nova'),

            ]
        );
        $this->add_control(
            'absoluteicon',
            [
                'label' => esc_html__( 'Icon', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'absolutelink',
            [
                'label' => esc_html__( 'Link', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'plugin-name' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_contdfdffdfdent85',
            [
                'label' => __('پیکربندی آیکون چهارم', 'Nova'),
                'condition' => ['icon_count' => 'five'],
            ]
        );
        $this->add_control(
            'forthicon',
            [
                'label' => esc_html__( 'Icon', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-whatsapp',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'forthlink',
            [
                'label' => esc_html__( 'Link', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'plugin-name' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_co1212ntent85',
            [
                'label' => __('پیکربندی آیکون چپ', 'Nova'),

            ]
        );
        $this->add_control(
            'fivethicon',
            [
                'label' => esc_html__( 'Icon', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-instagram',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'fivethlink',
            [
                'label' => esc_html__( 'Link', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'plugin-name' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_background',
            [
                'label' => esc_html__( 'بکگراند منو', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mobile-bottom-links' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .footer_path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'plugin-name' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .absolute-button-mobile-nav a',
                'condition' => ['menu_type' => 'first'],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background2',
                'label' => esc_html__( 'Background', 'plugin-name' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #homebut',
                'condition' => ['menu_type' => 'second'],
            ]
        );
        $this->add_control(
            'icons_color',
            [
                'label' => esc_html__( 'رنگ آیکون ها', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .menu-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tab-link i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'absicons_color',
            [
                'label' => esc_html__( 'رنگ آیکون وسط', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .absmenu-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} #homebut i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .third-absolute i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $menu = $settings['menu_type'];
        $icon_count = $settings['icon_count'];
        switch ($menu){
            case "first":
                if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                    ?>
                    <div class="isineditmode" style="text-align: center;">
                        <h5 style="text-align: center;">پیشنمایش منو در سایت شما</h5>
                        <div class="mobile-bottom-navigation ineditmode" style="position: static;">
                            <div class="mobile-bottom-links">
                                <div class="bottmboxone">
                                    <div class="first-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['firstlink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                    <?php if ($icon_count == 'five'){?>
                                        <div class="second-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['twicelink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                    <?php }?>
                                </div>
                                <div class="absolute-button-mobile-nav absmenu-icon">
                                    <a href="<?=$settings['absolutelink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </div>
                                <div class="bottmboxtwo">
                                    <?php if ($icon_count == 'five'){?>
                                        <div class="thirth-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['forthlink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                    <?php }?>
                                    <div class="fourth-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['fivethlink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                else{?>
                    <div class="mobile-bottom-navigation">
                        <div class="mobile-bottom-links">
                            <div class="bottmboxone">
                                <div class="first-button-mobile-nav menu-icon">
                                    <a href="<?=$settings['firstlink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </div>
                                <?php if ($icon_count == 'five'){?>
                                    <div class="second-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['twicelink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                <?php }?>
                            </div>
                            <div class="absolute-button-mobile-nav absmenu-icon">
                                <a href="<?=$settings['absolutelink']['url'];?>">
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            </div>
                            <div class="bottmboxtwo">
                                <?php if ($icon_count == 'five'){?>
                                    <div class="thirth-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['forthlink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                <?php }?>
                                <div class="fourth-button-mobile-nav menu-icon">
                                    <a href="<?=$settings['fivethlink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
                break;
            case "second":
                if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                    ?>
                    <div class="isineditmode" style="text-align: center;">
                        <h5 style="text-align: center;">پیشنمایش منو در سایت شما</h5>
                        <div style="width: 100%;overflow: hidden;margin-top: 20px;height: 135px;display: flex;align-items: center;justify-content: center;">
                            <div id="toolbar-bottom" class="toolbar tabbar toolbar-bottom ineditmode" style="position:static;">
                                <nav id="nav" class="toolbar-inner">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="768" height="50" viewBox="0 0 768 50">
                                        <path class="footer_path" d="M-15,0H345c12.855,0,16.965,20,39,20,22.238,0,25.921-20,39-20H828V95H-15V0Z"></path>
                                    </svg>
                                    <a class="tab-link" href="<?=$settings['firstlink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>                    <?php if ($icon_count == 'five'){?>
                                    <a class="tab-link" href="<?=$settings['twicelink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a><?php }?>
                                    <a id="homebut" class="tab-link active" href="<?=$settings['absolutelink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>                    <?php if ($icon_count == 'five'){?>
                                    <a class="tab-link" href="<?=$settings['forthlink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a><?php }?>
                                    <a class="tab-link" href="<?=$settings['fivethlink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                else{?>
                    <div id="toolbar-bottom" class="toolbar tabbar toolbar-bottom ">
                        <nav id="nav" class="toolbar-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" width="768" height="50" viewBox="0 0 768 50">
                                <path class="footer_path" d="M-15,0H345c12.855,0,16.965,20,39,20,22.238,0,25.921-20,39-20H828V95H-15V0Z"></path>
                            </svg>
                            <a class="tab-link" href="<?=$settings['firstlink']['url'];?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>                    <?php if ($icon_count == 'five'){?>
                                <a class="tab-link" href="<?=$settings['twicelink']['url'];?>">
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            <?php }?>
                            <a id="homebut" class="tab-link active" href="<?=$settings['absolutelink']['url'];?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>                    <?php if ($icon_count == 'five'){?>
                            <a class="tab-link" href="<?=$settings['forthlink']['url'];?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a><?php }?>
                            <a class="tab-link" href="<?=$settings['fivethlink']['url'];?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        </nav>
                    </div>
                    <?php
                }
                break;
            case "third":
                if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                    ?>
                    <div class="isineditmode" style="text-align: center;">
                        <h5 style="text-align: center;">پیشنمایش منو در سایت شما</h5>
                        <div class="third-menu">
                            <div class="mobile-bottom-navigation ineditmode" style="position: static;">
                                <div class="mobile-bottom-links">
                                    <div class="bottmboxone">
                                        <div class="first-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['firstlink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                        <?php if ($icon_count == 'five'){?>
                                            <div class="second-button-mobile-nav menu-icon">
                                                <a href="<?=$settings['twicelink']['url'];?>">
                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                </a>
                                            </div>
                                        <?php }?>
                                    </div>
                                    <div class="third-absolute menu-icon">
                                        <a href="<?=$settings['absolutelink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                    <div class="bottmboxtwo menu-icon">
                                        <?php if ($icon_count == 'five'){?>
                                            <div class="thirth-button-mobile-nav">
                                                <a href="<?=$settings['forthlink']['url'];?>">
                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                </a>
                                            </div>
                                        <?php }?>
                                        <div class="fourth-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['fivethlink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
                else{?>
                    <div class="third-menu">
                        <div class="mobile-bottom-navigation">
                            <div class="mobile-bottom-links">
                                <div class="bottmboxone">
                                    <?php if ($icon_count == 'five'){?>
                                        <div class="first-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['firstlink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['firsticon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                    <?php }?>
                                    <div class="second-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['twicelink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['twiceicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="third-absolute menu-icon">
                                    <a href="<?=$settings['absolutelink']['url'];?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['absoluteicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </div>
                                <div class="bottmboxtwo">
                                    <?php if ($icon_count == 'five'){?>
                                        <div class="thirth-button-mobile-nav menu-icon">
                                            <a href="<?=$settings['forthlink']['url'];?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['forthicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                        </div>
                                    <?php }?>
                                    <div class="fourth-button-mobile-nav menu-icon">
                                        <a href="<?=$settings['fivethlink']['url'];?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['fivethicon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php      }
                break;
        }
        ?>
        <style>
            .mobile-bottom-navigation {
                width: 100%;
                position: fixed;
                bottom: 0;
                right: 0;
                height: 90px;
                align-items: center;
                padding-top: 30px;
                display: none;
                z-index:1000;
            }
            @media screen and (max-width: 776px) {
                .mobile-bottom-navigation {
                    display: flex;
                }
            }
            .first-button-mobile-nav a , .second-button-mobile-nav a , .thirth-button-mobile-nav a , .fourth-button-mobile-nav a {
                width: 100%;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100%;
                color: red;
                outline: none;
                text-decoration: none;
            }

            .absolute-button-mobile-nav a{
                width: 60px;
                height: 60px;
                display: flex;
                background:red;
                border-radius: 10px;
                box-shadow: 0 -6px 7px 4px #00000010;
                align-items: center;
                justify-content: center;
                color: red;
                outline: none;
                text-decoration: none;
            }

            .absolute-button-mobile-nav{
                position: absolute;
                width: 80px;
                height: 100px;
                display: flex;
                align-items: flex-start;
                justify-content: center;
                right: 50%;
                transform: translateX(50%);
            }
            .mobile-bottom-navigation i{
                font-size: 25px;
            }
            .mobile-bottom-navigation img{
                position: absolute;
                width: 100%;
                z-index: 1000;
                right: 0;
                top: 0;
            }
            .mobile-bottom-links{
                position: relative;
                width: 100%;
                z-index: 1001;
                right: 0;
                bottom: -3px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                background: red;
                box-shadow: 0 -6px 7px 4px #00000010;
                height: 100%;
            }
            .gravity-theme input[type="submit"]{
                background:#666cde;
                color:#FFFFFF;
                border-radius: 7px;
                border: none;
                padding: 10px 15px;
            }
            .side-search-area input{
                box-shadow: 0px 0px 10px 7px rgba(0, 0, 0, 0.05);
            }
            .bottmboxone , .bottmboxtwo{
                width: 40%;
                display: flex;
                align-items: center;
                justify-content: space-around;
            }

            .isineditmode{
                box-shadow: 0px 0px 10px 7px rgba(0, 0, 0, 0.05);
                border-radius: 7px;
                background: #ffffff;
                padding: 50px;
            }
            /**************************************************************************twicemenu*********************************************************/
            .toolbar-bottom {
                top: auto;
            }
            .toolbar {
                top: 56px;
            }
            .toolbar {
                position: fixed;
            }
            .navbar ~ .toolbar {
                z-index: 499;
            }
            .toolbar-bottom {
                bottom: 0;
                top: auto;
            }
            .tabbar {
                z-index: 1000;
                bottom: auto;
                top: 0;
            }
            .toolbar {
                left: 0;
                bottom: 0;
                height: 48px;
                font-size: 14px;
            }
            .toolbar {
                width: 100%;
                box-sizing: border-box;
                top: auto;
                margin: 0;
                z-index: 500;
                -webkit-backface-visibility: hidden;
                backface-visibility: hidden;
                color: #fff;display: none !important;
            }
            nav#nav {
                display: flex;
                width: 100%;
                max-width: 760px !important;
                margin: 0 auto;
                position: relative;
                z-index: 1;
                font-size: 17px;
            }

            nav#nav {
                background: transparent;
            }
            .footer_path {
                fill-rule: evenodd;
            }
            nav > svg {
                -webkit-filter: drop-shadow(0 1px 9px rgba(0, 0, 0, 0.09));
                filter: drop-shadow(0 -1px 6px rgba(0, 0, 0, 0.2));
                position: absolute;
                right: 50%;
                bottom: -2px;
                -moz-transform: translateX(50%);
                -webkit-transform: translateX(50%);
                -o-transform: translateX(50%);
                -ms-transform: translateX(50%);
                transform: translateX(50%);
            }
            .tabbar .toolbar-inner {
                padding-left: 0;
                padding-right: 0;
            }
            .toolbar-inner {
                background-color: transparent;
            }

            .toolbar-inner {
                -webkit-box-pack: justify;
                -ms-flex-pack: justify;
                -webkit-justify-content: space-between;
                justify-content: space-between;
            }

            .toolbar-inner {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                box-sizing: border-box;
                display: -webkit-box;
                display: -ms-flexbox;
                display: -webkit-flex;
                display: flex;
                -webkit-box-align: center;
                -ms-flex-align: center;
                -webkit-align-items: center;
                align-items: center;
            }



            .tabbar a.tab-link {
                -webkit-transition-duration: .3s;
                transition-duration: .3s;
                overflow: hidden;
                color: #7b7b91;
                position: relative;
                text-decoration: none;
            }
            .tab-link i {
                font-size: 23px;
                padding-bottom: 3px;
            }
            .tabbar a.link, .tabbar a.tab-link {
                height: 100%;
                width: 100%;
                box-sizing: border-box;
                padding-left: 0;
                padding-right: 0;
                display: -webkit-box;
                display: -ms-flexbox;
                display: -webkit-flex;
                display: flex;
                -webkit-box-pack: center;
                -ms-flex-pack: center;
                -webkit-justify-content: center;
                justify-content: center;
                -webkit-box-align: center;
                -ms-flex-align: center;
                -webkit-align-items: center;
                align-items: center;
                -ms-flex: 1;
                -webkit-box-orient: vertical;
                -moz-box-orient: vertical;
                -ms-flex-direction: column;
                -webkit-flex-direction: column;
                flex-direction: column;
                font-size: 14px;
                text-transform: uppercase;
            }

            .toolbar a {
                -webkit-box-flex: 1;
                -webkit-flex-shrink: 1;
                -ms-flex: 0 1 auto;
                flex-shrink: 1;
                position: relative;
                white-space: nowrap;
                text-overflow: ellipsis;
            }
            .tab-link{
                -webkit-user-select: none;
                user-select: none;
            }


            .tabbar a.tab-link {
                color: #7b7b91;
            }
            .toolbaricontext {
                font-size: 12px;
                padding-top: 0;
                margin: 0;
            }
            #homebut .toolbaricontext {
                padding-top: 2px;
            }
            a#homebut {
                padding-top: 0;
                margin-right: 0;
            }

            a#homebut {
                position: absolute;
                right: 50%;
                top: -35px;
                -moz-transform: translateX(50%);
                -webkit-transform: translateX(50%);
                -o-transform: translateX(50%);
                -ms-transform: translateX(50%);
                transform: translateX(50%);
                width: 47px;
                height: 47px;
                color: #FFF;
                text-align: center;
                border-radius: 50%;
                font-size: 20px;
                line-height: 50px;
                z-index: 50;
            }

            .tabbar a.tab-link.active {
                color: #fff;
            }

            a#homebut {
                color: #fff !important;
            }

            .tabbar a.link, .tabbar a.tab-link {
                font-size: 17px;
                text-transform: uppercase;
                padding-top: 2px;
                margin-right: 3%;
            }
            .toolbar-inner svg {
                height: 54px;
            }
            nav#nav {
                font-size: 17px;
            }
            @media only screen and (max-width: 600px) {
                .wa__btn_popup{
                    bottom:60px !important;
                    right: 15px !important;
                }
                .toolbar {
                    display: block !important;
                }
            }
            .ineditmode{
                display: block !important;
            }
        </style>
    <?php }
    protected function content_template() {

    }
}
