<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Pre_next_page extends Widget_Base
{

    public function get_name()
    {
        return 'pre_next_page';
    }

    public function get_title()
    {
        return __('عوض کردن پست', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-post-navigation';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'b_for' );
        $this->start_controls_tab( 'orflse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'color',
            [
                'label' => __( 'رنگ متن باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .pre-post a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .next-post a' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hovesdfrse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'contfolor',
            [
                'label' => __( 'رنگ هاور متن باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .pre-post-slide:hover .pre-post a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .next-post-slide:hover .next-post a' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_colffor' );
        $this->start_controls_tab( 'originafflse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conteffffft_color',
            [
                'label' => __( 'رنگ آیکون باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .icon-pre-post a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .icon-next-post a' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoverse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'content_csfsdfolor',
            [
                'label' => __( 'رنگ هاور آیکون باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .next-post-slide:hover .icon-next-post a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .pre-post-slide:hover .icon-pre-post a' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'b_cor' );
        $this->start_controls_tab( 'orilse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'conteft_color',
            [
                'label' => __( 'رنگ بکگراند باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .pre-post-slide .icon-pre-post a' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .next-post-slide .icon-next-post a' => 'background: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hovse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conteolor',
            [
                'label' => __( 'رنگ هاور بکگراند باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .next-post-slide:hover .icon-next-post a' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .pre-post-slide:hover .icon-pre-post a' => 'background: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography2',
                'label' => __( 'قبل', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .pre-post a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography22',
                'label' => __( 'بعد', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .next-post a',
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <?php if (get_next_post() || get_previous_post()){?>
        <div class="post-next-pre">
            <div class="next-post-slide">
                <div class="icon-next-post">
                    <?php next_post_link( '%link', __( '<i class="fa fa-angle-right"></i>', 'twentyeleven' ) ); ?>
                </div>
                <div class="next-post">
                    <?php
                    $next_post = get_next_post();
                    $nid = $next_post->ID ;
                    $permalink = get_permalink($nid);
                    ?>
                    <span><a href="<?php echo $permalink; ?>"><?php echo $next_post->post_title; ?></a></span>
                </div>

            </div>
            <div class="pre-post-slide">
                <div class="pre-post">
                    <?php
                    $prev_post = get_previous_post();
                    $id = $prev_post->ID ;
                    $permalink = get_permalink( $id );
                    ?>
                    <span><a href="<?php echo $permalink; ?>"><?php echo $prev_post->post_title; ?></a></span>
                </div>
                <div class="icon-pre-post">
                    <?php previous_post_link( '%link', __( '<i class="fa fa-angle-left"></i>', 'twentyeleven' ) ); ?>
                </div>
            </div>
        </div>
    <?php }}


    protected function _content_template()
    {
    }
}
