<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Player extends Widget_Base
{

    public function get_name()
    {
        return 'Player';
    }

    public function get_title()
    {
        return __('پخش کننده ویدیو ', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-play-o';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),

            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __( 'Link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sehjksdt3',
            [
                'label' => __('آیکون', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'kuytrr' );
        $this->start_controls_tab( 'orhjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkolor',
            [
                'label' => __( 'رنگ آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .border-one svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .border-one i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdf5s', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghj5jkllor',
            [
                'label' => __( 'رنگ هاور آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .player-icon:hover .border-one svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .player-icon:hover .border-one i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('خط اول', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ خط اول', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .border-one' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور خط اول', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .player-icon:hover .border-one' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'sectjksdt3',
            [
                'label' => __('خط دوم', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiljkuytrr' );
        $this->start_controls_tab( 'orioitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidkleolor',
            [
                'label' => __( 'رنگ خط دوم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .border-one' => 'border-two: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hohjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjjkllor',
            [
                'label' => __( 'رنگ هاور خط دوم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .player-icon:hover .border-two' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'sehjksdt3',
            [
                'label' => __('خط سوم', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'kuytrr' );
        $this->start_controls_tab( 'orhjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkolor',
            [
                'label' => __( 'رنگ خط سوم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .border-three' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdf5s', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghj5jkllor',
            [
                'label' => __( 'رنگ هاور خط سوم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .player-icon:hover .border-three' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <div class="video-player" id="videosplayer">
            <video class="videopanel" controls="controls">
                <source src="<?php echo $settings['website_link']['url']?>" type="video/mp4" />
            </video>
        </div>
        <div class="player-icon" id="all-of-player">
            <div class="border-one">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
            <div class="border-two"></div>
            <div class="border-three"></div>
        </div>
        <div class="video-backgrounde" id="video-background">


        </div>
        <div class="video-backgrounde2" id="video-background">


        </div>
    <?php }


    protected function _content_template()
    {
    }
}
