<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Postinformation extends Widget_Base
{

    public function get_name()
    {
        return 'Postinformation';
    }

    public function get_title()
    {
        return __('اطلاعات پست', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-post-info';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'محتوا', 'polaris' ),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'infomation_case',
            [
                'label'   => __( 'نوع را انتخاب کنید', 'polaris' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'views'     => __( 'بازدید ها', 'polaris' ),
                    'categorys' => __( 'دسته بندی ها', 'polaris' ),
                    'author'    => __( 'نویسنده', 'polaris' ),
                    'date'      => __( 'تاریخ', 'polaris' ),
                    'tags'      => __( 'تگ ها', 'polaris' ),

                ],
            ]
        );
        $repeater->add_control(
            'information_model',
            [
                'label'   => __( 'نوع قرارگیری', 'polaris' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'cut',
                'options' => [
                    'hundred'     => __( 'یکپارچه', 'polaris' ),
                    'cut' => __( 'جدا', 'polaris' ),

                ],
            ]
        );
        $repeater->add_control(
            'cat_title', [
                'label' => __( 'عنوان کنار آیتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'categorys'],

            ]
        );
        $repeater->add_control(
            'list_title', [
                'label' => __( 'عنوان کنار آیتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'date'],

            ]
        );
        $repeater->add_control(
            'list_title2', [
                'label' => __( 'عنوان کنار آیتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'author'],

            ]
        );
        $repeater->add_control(
            'list_title4', [
                'label' => __( 'عنوان کنار آیتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'views'],

            ]
        );
        $repeater->add_control(
            'list_title5', [
                'label' => __( 'عنوان کنار آیتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'tags'],

            ]
        );
        $repeater->add_control(
            'list_title9', [
                'label' => __( 'عنوان بازدید', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'views'],

            ]
        );
        $repeater->add_control(
            'list_title10', [
                'label' => __( 'عنوان بدون بازدید', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '' , 'plugin-domain' ),
                'label_block' => true,
                'condition' => ['infomation_case' => 'views'],

            ]
        );

        $repeater->add_control(
            'icon-on-off',
            [
                'label' => __( 'آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'icon',
            [
                'label'   => __( 'آیکون', 'text-domain' ),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => ['icon-on-off' => 'yes'],
            ]
        );

        $this->add_control(
            'list',
            [
                'label'       => __( 'آیتم ها', 'polaris' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'list_title'   => __( 'Title #1', 'polaris' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'polaris' ),
                    ],
                    [
                        'list_title'   => __( 'Title #2', 'polaris' ),
                        'list_content' => __( 'Item content. Click the edit button to change this text.', 'polaris' ),
                    ],
                ],
                'title_field' => '{{{ infomation_case }}}',
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'استایل', 'plugin-name' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_cvvgjhgolor',
            [
                'label'     => __( 'رنگ عنوان ایتم', 'polaris' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .all-information > div p' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contelhvjbnt_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} div p',
            ]
        );
        $this->start_controls_tabs( 'poisdfghujkluytrr' );
        $this->start_controls_tab( 'oripoisdfghjkluytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytrsdfghjkleolor',
            [
                'label' => __( 'ایتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .all-information > div span a' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .all-information > div span'   => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytsdfghjklfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrsdfghjkllor',
            [
                'label' => __( 'رنگ هاور ایتم', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .all-information > div span a:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .all-information > div span:hover'   => 'color: {{VALUE}} !important',                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} div span',
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => __( 'رنگ آیکن', 'polaris' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .all-information > div i' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
$settings = $this->get_settings_for_display();
$post_meta = get_post_meta(get_the_ID());
?>
<div class="all-information">
    <?php if ( $settings['list'] ) {
        foreach ( $settings['list'] as $item ) {
            $favcolor = $item['infomation_case'];
            $view = $item['list_title9'];
            $withoutview = $item['list_title10'];
            switch ( $favcolor ) {
                case "date": ?>
                    <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                        <?php if ($item['icon-on-off'] == 'yes'){ ?>
                        <div class="icon">
                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>
                <?php }?>
                        <p><?php echo $item['list_title'];?></p><span><?php the_time('Y/m/d');?></span>
                    </div>
                    <?php
                    break;
                case "author":
                    if (have_posts()){while (have_posts()){the_post();
                        ?>
                        <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                            <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                <div class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                            <?php }?>
                            <p><?php echo $item['list_title2'];?></p><span><a><?php the_author('');?></a></span>
                        </div>
                        <?php
                    }}wp_reset_postdata();
                    break;
                case "categorys":
                    if ( is_singular( 'post' ) ) {
                        if ( has_category() ) {
                            ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>
                                    <p><?php echo $item['cat_title'];?></p>
                                <span><?php the_category( ' ' ); ?></span></div>
                        <?php }
                    } elseif ( is_singular( 'portfolio' ) ) {
                        if ( has_term( '', 'portfolio_cat' ) ) {
                            ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>
                                <p><?php echo $item['cat_title'];?></p>

                                <span><?php the_portfolio_cat(); ?></span></div>
                        <?php }
                    }
                    elseif ( is_singular( 'product' ) ) {
                        if ( has_term( '', 'product_cat' ) ) {
                            ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>

                                <p><?php echo $item['cat_title'];?></p>

                                <span><?php the_product_cats();?></span></div>
                        <?php }
                    }
                    break;

                case "tags":
                    if (is_singular('post')) {
                        if (has_tag()){ ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>
                                <p><?php echo $item['list_title5']; ?></p><div class="tags-box">
                                            <span>
                                              <?php the_tags(' ' , ' ');?>
                                            </span>
                                </div></div>
                        <?php } }elseif (is_singular('portfolio')) {
                        if (has_term('' , 'portfolio_tags')){
                            ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>
            <p><?php echo $item['list_title5']; ?></p><div class="tags-box">
<span>
<?php the_portfolio_tags();?>
</span>
                                </div></div>
                            <?php
                        } }
                    elseif (is_singular('product')) {
                        if (has_term('' , 'product_tag')){
                            ?>
                            <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                                <?php if ($item['icon-on-off'] == 'yes'){ ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php }?>
                                <p><?php echo $item['list_title5']; ?></p><div class="tags-box">
<span>
<?php the_product_tags();?>
</span>
                                </div></div>
                            <?php
                        } }
                    break;
                case "views":?>
                    <div class="<?php if ($item['information_model']=='cut') { echo'post-information'; } else { echo 'post-informationview';}?>">
                        <?php if ($item['icon-on-off'] == 'yes'){ ?>
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </div>
                        <?php }?>
                        <p><?php echo $item['list_title4'];?></p><span><?php echo wpb_get_post_views(get_the_ID(),$view , $withoutview);?></span>
                    </div>

                    <?php break;
            }
            ?>
        <?php } ?>
    <?php } ?>
</div>
<?php
    }


    protected function _content_template()
    {
    }
}
