<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class PRODUCTEXCERPT extends Widget_Base
{

    public function get_name()
    {
        return 'PRODUCTEXCERPT';
    }

    public function get_title()
    {
        return __('توضیح کوتاه محصول', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-product-description';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {

	    $this->start_controls_section(
		    'content_section',
		    [
			    'label' => __( 'محتوا', 'Nova' ),
			    'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		    ]
	    );

	    $this->add_control(
		    'important_note',
		    [
			    'label'           => __( '', 'Nova' ),
			    'type'            => \Elementor\Controls_Manager::RAW_HTML,
			    'raw'             => __( 'این صرفا یک پیش نمایش از توضبحات کوتاه محصول برای استایل دهی است.', 'Nova' ),
			    'content_classes' => 'info-text-controller',
		    ]
	    );

	    $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'استایل', 'Nova' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'excerpt_color',
            [
                'label' => __( 'رنگ توضیح کوتاه محصول', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => __( 'تایپوگرافی متن', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .excerpt',
            ]
        );

        $this->end_controls_section();
    }


    protected function render() {?>
        <div class="excerpt">
            <?php
	    if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
	        echo 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.';
        }else {
		    the_excerpt();
	    }?>
        </div>
    <?php }



    protected function _content_template()
    {
    }
}
