<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class PRODUCTIMAGE extends Widget_Base {

	public function get_name() {
		return 'PRODUCTIMAGE';
	}

	public function get_title() {
		return __( 'تصویر محصول', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-images';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}


	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از چینش تصاویر محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'تصاویر', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'border',
				'label'    => __( 'حاشیه تصاویر', 'Nova' ),
				'selector' => '{{WRAPPER}} ol.flex-control-nav.flex-control-thumbs li img,{{WRAPPER}} .flex-viewport',
			]
		);

		$this->add_responsive_control(
			'border-radius-images',
			[
				'label'      => __( 'گردی لبه های تصاویر', 'Nova' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .flex-viewport'                                 => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} ol.flex-control-nav.flex-control-thumbs li img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'small-image-size',
			[
				'label'      => __( 'سایز تصاویر کوچک', 'Nova' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 30,
						'max'  => 150,
						'step' => 1,
					]
				],
				'default'    => [
					'unit' => 'px',
					'size' => 85,
				],
				'selectors'  => [
					'{{WRAPPER}} ol.flex-control-nav.flex-control-thumbs li img' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'bubble-style_section',
			[
				'label' => __( 'حباب تخفیف', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'onsale-text-size',
			[
				'label'      => __( 'سایز متن', 'Nova' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors'  => [
					'{{WRAPPER}} .onsale' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'onsale-dimensions',
			[
				'label'      => __( 'ابعاد حباب', 'Nova' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 30,
						'max'  => 80,
						'step' => 1,
					],

				],
				'default'    => [
					'unit' => 'px',
					'size' => 45,
				],
				'selectors'  => [
					'{{WRAPPER}} .onsale' => 'width: {{SIZE}}{{UNIT}} !important;height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'border-radius-onsale',
			[
				'label'      => __( 'گردی لبه ها', 'Nova' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .onsale' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'onsale-color',
			[
				'label'     => __( 'رنگ متن', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'onsale-bac',
			[
				'label'     => __( 'رنگ پس زمینه', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->end_controls_section();
	}


	protected function render() {

		$settings = $this->get_settings_for_display();
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			?>
            <span class="onsale">3%</span>
            <div class="woocommerce-product-gallery woocommerce-product-gallery--with-images woocommerce-product-gallery--columns-4 images"
                 data-columns="4" style="opacity: 1; transition: opacity 0.25s ease-in-out 0s;">

                <div class="flex-viewport" style="overflow: hidden; position: relative; height: 370px;">
                    <figure class="woocommerce-product-gallery__wrapper"
                            style="width: 600%; transition-duration: 0s; transform: translate3d(0px, 0px, 0px);">
                        <div data-thumb="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                             data-thumb-alt=""
                             class="woocommerce-product-gallery__image flex-active-slide"
                             style="width: 605px; margin-right: 0px; float: right; display: block;"><a
                                    href="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"><img
                                        src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        class="wp-post-image"
                                        alt="" loading="lazy" title="about" data-caption=""
                                        data-src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image_width="460" data-large_image_height="370"
                                        srcset="<?= get_template_directory_uri().'/img/placeholder.png'; ?> 460w, http://flexy.test/wp-content/uploads/2019/05/about-300x241.png 300w"
                                        sizes="(max-width: 460px) 100vw, 460px" draggable="false" width="460"
                                        height="370"></a>
                        </div>
                        <div data-thumb="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                             data-thumb-alt=""
                             class="woocommerce-product-gallery__image"
                             style="width: 605px; margin-right: 0px; float: right; display: block;"><a
                                    href="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"><img
                                        src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>" class="" alt=""
                                        loading="lazy" title="side" data-caption=""
                                        data-src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image_width="321" data-large_image_height="298"
                                        srcset="<?= get_template_directory_uri().'/img/placeholder.png'; ?> 321w, <?= get_template_directory_uri().'/img/placeholder.png'; ?> 300w"
                                        sizes="(max-width: 321px) 100vw, 321px" draggable="false" width="321"
                                        height="298"></a>
                        </div>
                        <div data-thumb="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                             data-thumb-alt="" class="woocommerce-product-gallery__image"
                             style="width: 605px; margin-right: 0px; float: right; display: block; position: relative; overflow: hidden;">
                            <a href="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"><img
                                        src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        class=""
                                        alt="" loading="lazy" title="single-min" data-caption=""
                                        data-src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                                        data-large_image_width="620" data-large_image_height="300"
                                        srcset="<?= get_template_directory_uri().'/img/placeholder.png'; ?> 600w, <?= get_template_directory_uri().'/img/placeholder.png'; ?> 300w, <?= get_template_directory_uri().'/img/placeholder.png'; ?> 620w"
                                        sizes="(max-width: 600px) 100vw, 600px" draggable="false" width="600"
                                        height="290"></a><img
                                    role="presentation" alt=""
                                    src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>" class="zoomImg"
                                    style="position: absolute; top: -9.87644px; left: -13.3264px; opacity: 0; width: 620px; height: 300px; border: medium none; max-width: none; max-height: none;">
                        </div>
                    </figure>
                </div>
                <ol class="flex-control-nav flex-control-thumbs">
                    <li><img src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>" class="flex-active"
                             draggable="false"></li>
                    <li><img src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>" draggable="false"
                             class="">
                    </li>
                    <li><img src="<?= get_template_directory_uri().'/img/placeholder.png'; ?>"
                             draggable="false"
                             class=""></li>
                </ol>
            </div>

		<?php } else {
			global $product;

			$product = wc_get_product();

			if ( empty( $product ) ) {
				return;
			}

			wc_get_template( 'loop/sale-flash.php' );

			wc_get_template( 'single-product/product-image.php' );
					}
	}

	protected function _content_template() {
	}
}
