<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class PRODUCTMETA extends Widget_Base {

	public function get_name() {
		return 'PRODUCTMETA';
	}

	public function get_title() {
		return __( 'متای محصول', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-meta';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از چینش متاهای محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'رنگ عنوان', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_meta' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'value_color',
			[
				'label'     => __( 'رنگ مقدار', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_meta a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .product_meta span span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'content_typography',
				'label'    => __( 'تایپو گرافی متن', 'Nova' ),
				'selector' => '{{WRAPPER}} .product_meta a',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography12',
                'label'    => __( 'تایپو گرافی مقدار', 'Nova' ),
                'selector' => '{{WRAPPER}} .product_meta span span',
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <div class="product_meta">
                <span class="sku_wrapper">شناسه محصول: <span class="sku">2425837</span></span>
                <span class="posted_in">دسته: <a
                            href="http://flexy.test/product-category/%d8%aa%d8%ac%d9%87%db%8c%d8%b2%d8%a7%d8%aa/?customize_changeset_uuid=9eaf31ef-069c-4790-8ab4-c077285f6949&amp;customize_autosaved=on&amp;customize_messenger_channel=preview-1"
                            rel="tag">تجهیزات</a></span>
                <span class="tagged_as">برچسب: <a
                            href="http://flexy.test/product-tag/%d8%a8%d8%b1%da%86%d8%b3%d8%a8-%d8%af%d9%88/?customize_changeset_uuid=9eaf31ef-069c-4790-8ab4-c077285f6949&amp;customize_autosaved=on&amp;customize_messenger_channel=preview-1"
                            rel="tag">برچسب دو</a>, <a
                            href="http://flexy.test/product-tag/%d8%a8%d8%b1%da%86%d8%b3%d8%a8-%d8%b3%d9%87/?customize_changeset_uuid=9eaf31ef-069c-4790-8ab4-c077285f6949&amp;customize_autosaved=on&amp;customize_messenger_channel=preview-1"
                            rel="tag">برچسب سه</a></span>
            </div>
		<?php } else {
			global $product;

			$product = wc_get_product();

			if ( empty( $product ) ) {
				return;
			}
			woocommerce_template_single_meta();
		}
	}


	protected function _content_template() {
	}
}
