<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class PRODUCTPRICE extends Widget_Base {

	public function get_name() {
		return 'PRODUCTPRICE';
	}

	public function get_title() {
		return __( 'قیمت محصول', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-price';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از قیمت محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Content', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'price_color',
			[
				'label'     => __( 'رنگ قیمت', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} span.woocommerce-Price-amount' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'price_typography',
				'label'    => __( 'تایپ.گرافی متن قیمت', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} p.price',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		echo '<div class="Nova-single-price">';
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <p class="price">
                <del aria-hidden="true">
                    <span class="woocommerce-Price-amount amount">
                        <bdi>370000
                            <span class="woocommerce-Price-currencySymbol"> تومان</span>
                        </bdi>
                    </span>
                </del>
                <ins>
                    <span class="woocommerce-Price-amount amount">
                        <bdi>360000
                            <span class="woocommerce-Price-currencySymbol"> تومان</span>
                        </bdi>
                    </span>
                </ins>
            </p>
		<?php } else {
			global $product;
			$product = wc_get_product();

			if ( empty( $product ) ) {
				return;
			}

			wc_get_template( '/single-product/price.php' );
			?>

		<?php }
		echo '</div>';
	}


	protected function _content_template() {
	}
}
