<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class PRODUCTRATING extends Widget_Base {

	public function get_name() {
		return 'PRODUCTRATING';
	}

	public function get_title() {
		return __( 'امتیاز محصول', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-rating';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}


	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از چینش تعداد نظرات و امتیاز محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Content', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'star-color',
			[
				'label'     => __( 'رنگ ستاره های امتیاز', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .star-rating span' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .star-rating::before' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'comment_count_typography',
				'label'    => __( 'تایپوگرافی متن تعداد نظرات', 'Nova' ),
				'selector' => '{{WRAPPER}} .woocommerce-product-rating .woocommerce-review-link',
			]
		);
		$this->add_control(
			'comment_count_color',
			[
				'label'     => __( 'رنگ متن تعداد نظرات', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .woocommerce-review-link' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <div class="woocommerce-product-rating">
                <div class="star-rating" role="img" aria-label="امتیاز 4.00 از 5"><span
                            style="width:80%">امتیازدهی <strong class="rating">4.00</strong> از 5 در <span
                                class="rating">3</span> امتیازدهی مشتری</span></div>
                <a href="#reviews" class="woocommerce-review-link" rel="nofollow">(دیدگاه <span class="count">3</span>
                    کاربر)</a>
            </div>

		<?php } else {
			if ( ! post_type_supports( 'product', 'comments' ) ) {
				return;
			}

			global $product;
			$product = wc_get_product();

			if ( empty( $product ) ) {
				return;
			}

			wc_get_template( 'single-product/rating.php' );


		}
	}


	protected function _content_template() {
	}
}
