<?php

namespace NovaAddons\Widgets;

use Elementor\Core\Schemes\Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class PRODUCTTABS extends Widget_Base {

	public function get_name() {
		return 'PRODUCTTABS';
	}

	public function get_title() {
		return __( 'تب های صفحه محصول', 'Nova' );
	}


	public function get_icon() {
		return 'eicon-product-tabs';
	}


	public function get_categories() {
		return [ 'Nova_cat' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'important_note',
			[
				'label'           => __( '', 'Nova' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __( 'این صرفا یک پیش نمایش از چینش تب های محصول برای استایل دهی است.', 'Nova' ),
				'content_classes' => 'info-text-controller',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tab-style',
			[
				'label' => __( 'تنظیمات تب های بالای', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label'   => __( 'چینش', 'Nova' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'end'    => [
						'title' => __( 'پایان', 'Nova' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'Nova' ),
						'icon'  => 'fa fa-align-center',
					],
					'start'  => [
						'title' => __( 'آغاز', 'Nova' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'default' => 'start',
				'toggle'  => false,
				'selectors'  => [
					'{{WRAPPER}} .tabs.wc-tabs' => 'justify-content:{{VALUE}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'tab-spacing',
			[
				'label'      => __( 'فاسله تب از پایین', 'Nova' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					]
				],
				'default'    => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors'  => [
					'{{WRAPPER}} .tabs.wc-tabs' => 'margin-bottom:{{SIZE}}{{UNIT}} !important;',
				],
			]
		);




		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'tab-item-typography',
				'label'    => __( 'تایپوگرافی متن تب ها', 'Nova' ),
				'selector' => '{{WRAPPER}} .tabs.wc-tabs li a',
			]
		);

		$this->start_controls_tabs( 'tabs' );
		$this->start_controls_tab( 'normal-tabs-item', [ 'label' => __( 'عادی', 'Nova' ) ] );
		$this->add_control(
			'tab-color',
			[
				'label'     => __( 'رنگ عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab-bac',
			[
				'label'     => __( 'رنگ پس زمینه عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'hover-tabs-item', [ 'label' => __( 'هاور', 'Nova' ) ] );
		$this->add_control(
			'tab-color-hover',
			[
				'label'     => __( 'رنگ عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab-hover-bac',
			[
				'label'     => __( 'رنگ پس زمینه عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li:hover a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'active-tabs-item', [ 'label' => __( 'فعال', 'Nova' ) ] );
		$this->add_control(
			'tab-color-active',
			[
				'label'     => __( 'رنگ عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li.active a'  => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'tab-active-bac',
			[
				'label'     => __( 'رنگ پس زمینه عنوان تب ', 'Nova' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs.wc-tabs li.active a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();


		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'محتوا', 'Nova' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'titles_color',
			[
				'label'     => __( 'رنگ عنوان ها', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-tabs.wc-tabs-wrapper h2' => 'color: {{VALUE}}',
					'{{WRAPPER}} #reply-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocommerce-product-attributes-item__label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocommerce-review__author' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'titles_typography',
				'label'    => __( 'تایپوگرافی عنوان ها', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .woocommerce-review__author,{{WRAPPER}} .woocommerce-product-attributes-item__label,{{WRAPPER}} #reply-title,{{WRAPPER}} .woocommerce-tabs.wc-tabs-wrapper h2',
			]
		);

		$this->add_control(
			'text-color',
			[
				'label'     => __( 'رنگ متن ها', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .woocommerce-Tabs-panel--description p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocommerce-product-attributes p' => 'color: {{VALUE}}',
					'{{WRAPPER}} ol.commentlist li .comment_container .description p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocommerce-review__published-date' => 'color: {{VALUE}}',
					'{{WRAPPER}} .woocommerce-review__verified' => 'color: {{VALUE}}',
					'{{WRAPPER}} #review_form #respond p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .comment-notes' => 'color: {{VALUE}}',
					'{{WRAPPER}} #commentform label' => 'color: {{VALUE}}',
					'{{WRAPPER}} #email-notes' => 'color: {{VALUE}}',
					'{{WRAPPER}} #review_form #respond textarea' => 'color: {{VALUE}}',
					'{{WRAPPER}} .comment-form .author-meta input' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'text_typography',
				'label'    => __( 'تایپوگرافی متن ها', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} #review_form #respond textarea,{{WRAPPER}} #email-notes,{{WRAPPER}} #commentform label,{{WRAPPER}} .comment-notes,{{WRAPPER}} #review_form #respond p,{{WRAPPER}} .woocommerce-review__verified,{{WRAPPER}} .woocommerce-review__published-date,{{WRAPPER}} ol.commentlist li .comment_container .description p,{{WRAPPER}} .woocommerce-product-attributes p , {{WRAPPER}} .woocommerce-Tabs-panel--description p ,{{WRAPPER}}  .comment-form .author-meta input',
			]
		);

		$this->add_control(
			'input-active-color',
			[
				'label'     => __( 'رنگ فعال حاشیه ورودی متن ها', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-form-comment textarea.active,{{WRAPPER}} .comment-form-author input.active, {{WRAPPER}} .comment-form-email input.active' => 'border-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'comment-bac',
			[
				'label'     => __( 'رنگ پس زمینه باکس نطرات', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ol.commentlist li .comment_container' => 'background: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'stars-color',
			[
				'label'     => __( 'رنگ ستاره ها', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} ol.commentlist li .comment_container .star-rating, ol.commentlist li .comment_container .star-rating::before, .stars a' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'style_submit',
			[
				'label' => __( 'دکمه ارسال', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'submit-color',
			[
				'label'     => __( 'رنگ متن دکمه ارسال', 'plugin-domain' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .form-submit button#submit' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'submit-background',
				'label' => __( 'پس زمینه دکمه ارسال', 'plugin-domain' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .form-submit button#submit',
			]
		);

		$this->add_responsive_control(
			'submit-border-radius',
			[
				'label' => __( 'گردی گوشه های دکمه ارسال', 'plugin-domain' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .form-submit button#submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <div class="woocommerce-tabs wc-tabs-wrapper">
                <ul class="tabs wc-tabs" role="tablist">
                    <li class="description_tab" id="tab-title-description" role="tab" aria-controls="tab-description">
                        <a href="#tab-description">
                            توضیحات </a>
                    </li>
                    <li class="additional_information_tab active" id="tab-title-additional_information" role="tab"
                        aria-controls="tab-additional_information">
                        <a href="#tab-additional_information">
                            اطلاعات بیشتر </a>
                    </li>
                    <li class="reviews_tab" id="tab-title-reviews" role="tab" aria-controls="tab-reviews">
                        <a href="#tab-reviews">
                            نظرات (3) </a>
                    </li>
                </ul>
                <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--description panel entry-content wc-tab"
                     id="tab-description" role="tabpanel" aria-labelledby="tab-title-description"
                ">

                <h2>توضیحات</h2>

                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها
                    و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و
                    کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد. کتابهای زیادی در شصت و سه درصد گذشته، حال و
                    آینده شناخت فراوان جامعه و متخصصان را می طلبد تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه
                    ای علی الخصوص طراحان خلاقی و فرهنگ پیشرو در </p>
            </div>
            <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--additional_information panel entry-content wc-tab"
                 id="tab-additional_information" role="tabpanel" aria-labelledby="tab-title-additional_information">

                <h2>اطلاعات بیشتر</h2>

                <table class="woocommerce-product-attributes shop_attributes">
                    <tbody>
                    <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_%d8%b3%d8%a7%db%8c%d8%b2">
                        <th class="woocommerce-product-attributes-item__label">سایز</th>
                        <td class="woocommerce-product-attributes-item__value"><p>100, 500, 300</p>
                        </td>
                    </tr>
                    <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_%d8%b1%d9%86%da%af">
                        <th class="woocommerce-product-attributes-item__label">رنگ</th>
                        <td class="woocommerce-product-attributes-item__value"><p>آبی, قرمز</p>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--reviews panel entry-content wc-tab"
                 id="tab-reviews" role="tabpanel" aria-labelledby="tab-title-reviews">
                <div id="reviews" class="woocommerce-Reviews">
                    <div id="comments">
                        <h2 class="woocommerce-Reviews-title">
                            3 دیدگاه برای <span>این محصول</span></h2>

                        <ol class="commentlist">

                            <li class="review byuser comment-author-admin-flexy bypostauthor even thread-even depth-1">

                                <div id="comment-25" class="comment_container">

                                    <img alt=""
                                         src="http://1.gravatar.com/avatar/1b890af8de0515019ecede2a810ac42e?s=60&amp;d=mm&amp;r=g"
                                         srcset="http://1.gravatar.com/avatar/1b890af8de0515019ecede2a810ac42e?s=120&amp;d=mm&amp;r=g 2x"
                                         class="avatar avatar-60 photo" loading="lazy" width="60" height="60">
                                    <div class="comment-text">

                                        <div class="star-rating" role="img" aria-label="امتیاز 2 از 5"><span
                                                    style="width:40%">امتیاز <strong
                                                        class="rating">2</strong> از 5</span></div>
                                        <p class="meta">
                                            <strong class="woocommerce-review__author">پیمان جلیلی</strong>
                                            <em class="woocommerce-review__verified verified">(خریدار محصول)</em> <span
                                                    class="woocommerce-review__dash">–</span>
                                            <time class="woocommerce-review__published-date"
                                                  datetime="2021-08-03T05:46:33+00:00">03/08/2021
                                            </time>
                                        </p>

                                        <div class="description"><p>جنس عالی و درجه یک</p>
                                        </div>
                                    </div>
                                </div>
                            </li><!-- #comment-## -->
                        </ol>

                    </div>

                    <div id="review_form_wrapper">
                        <div id="review_form">
                            <div id="respond" class="comment-respond">
                                <span id="reply-title" class="comment-reply-title">دیدگاه خود را بنویسید <small><a
                                                rel="nofollow" id="cancel-comment-reply-link"
                                                href="/product/%d9%be%db%8c%da%86-%da%af%d9%88%d8%b4%d8%aa%db%8c-%d8%a8%d8%b1%d9%82%db%8c-%d8%af%d9%88%d8%b3%d9%88-%da%86%d9%87%d8%a7%d8%b1%d8%b3%d9%88-%d9%81%d8%b1%d8%a7-%d8%a7%d8%a8%d8%b2%d8%a7%d8%b1-%d9%be%d8%a7/#respond"
                                                style="display:none;">لغو پاسخ</a></small></span>
                                <form action="http://flexy.test/wp-comments-post.php" method="post" id="commentform"
                                      class="comment-form" _lpchecked="1"><p class="comment-notes"><span
                                                id="email-notes">نشانی ایمیل شما منتشر نخواهد شد.</span> بخش‌های
                                        موردنیاز علامت‌گذاری شده‌اند <span class="required">*</span></p>
                                    <div class="comment-form-rating"><label for="rating">امتیاز شما&nbsp;<span
                                                    class="required">*</span></label>
                                        <p class="stars"><span>							<a class="star-1"
                                                                                              href="#">1</a>							<a
                                                        class="star-2" href="#">2</a>							<a
                                                        class="star-3" href="#">3</a>							<a
                                                        class="star-4" href="#">4</a>							<a
                                                        class="star-5" href="#">5</a>						</span></p>
                                        <select name="rating" id="rating" required="" style="display: none;">
                                            <option value="">رای دهید</option>
                                            <option value="5">عالی</option>
                                            <option value="4">خوب</option>
                                            <option value="3">متوسط</option>
                                            <option value="2">نه خیلی بد</option>
                                            <option value="1">خیلی بد</option>
                                        </select></div>
                                    <p class="comment-form-comment"><label for="comment" class="">دیدگاه شما&nbsp;<span
                                                    class="required">*</span></label><textarea id="comment"
                                                                                               name="comment" cols="45"
                                                                                               rows="8" required=""
                                                                                               class=""></textarea></p>
                                    <div class="author-meta"><p class="comment-form-author"><label for="author"
                                                                                                   class="top">نام&nbsp;<span
                                                        class="required">*</span></label><input id="author"
                                                                                                name="author"
                                                                                                type="text"
                                                                                                value="peyman" size="30"
                                                                                                required=""
                                                                                                class="active"></p>
                                        <p class="comment-form-email"><label for="email" class="top">ایمیل&nbsp;<span
                                                        class="required">*</span></label><input id="email" name="email"
                                                                                                type="email"
                                                                                                value="jalili.peyman.2014@gmail.com"
                                                                                                size="30" required=""
                                                                                                class="active"></p>
                                        <p class="form-submit">
                                            <button name="submit" type="submit" id="submit"
                                                    class="submit active primary-button">ثبت
                                            </button>
                                            <input name="submit" type="submit" id="submit" class="submit" value="ثبت">
                                            <input type="hidden" name="comment_post_ID" value="2360"
                                                   id="comment_post_ID">
                                            <input type="hidden" name="comment_parent" id="comment_parent" value="0">
                                        </p>
                                    </div>

                                    <p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent"
                                                                                   name="wp-comment-cookies-consent"
                                                                                   type="checkbox" value="yes"
                                                                                   checked="checked"> <label
                                                for="wp-comment-cookies-consent">ذخیره نام، ایمیل و وبسایت من در مرورگر
                                            برای زمانی که دوباره دیدگاهی می‌نویسم.</label></p>
                                </form>
                            </div><!-- #respond -->
                        </div>
                    </div>

                    <div class="clear"></div>
                </div>
            </div>

            </div>
		<?php } else {
			global $product;

			$product = wc_get_product();

			if ( empty( $product ) ) {
				return;
			}

			setup_postdata( $product->get_id() );

			wc_get_template( 'single-product/tabs/tabs.php' );

			// On render widget from Editor - trigger the init manually.
			if ( wp_doing_ajax() ) {
				?>
                <script>
                    jQuery('.wc-tabs-wrapper, .woocommerce-tabs, #rating').trigger('init');
                </script>
				<?php
			}

		}
	}


	protected function _content_template() {
	}
}
