<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Archiveproducts extends Widget_Base
{

    public function get_name()
    {
        return 'Archiveproducts';
    }

    public function get_title()
    {
        return __('آرشیو محصولات', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-products';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'عنوان', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'title_color' );
        $this->start_controls_tab( 'original', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_color',
            [
                'label' => __( 'رنگ عنوان', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product h2' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hover', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_color_hover',
            [
                'label' => __( 'رنگ هاور عنوان', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover h2' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typogwseraphy',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} li.product h2',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_section2',
            [
                'label' => __( 'افزودن به سبد خرید', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'ftle_color' );
        $this->start_controls_tab( 'dfinal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_cdor',
            [
                'label' => __( 'رنگ متن دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colorover',
            [
                'label' => __( 'رنگ هاور متن دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button:hover   ' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->start_controls_tabs( 'ftl2e_color' );
        $this->start_controls_tab( 'dfi2nal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_c2dor',
            [
                'label' => __( 'رنگ بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hv2er', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colorov2er',
            [
                'label' => __( 'رنگ هاور بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button:hover   ' => 'background: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_wtypodgraphy',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} li.product .button',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section32',
            [
                'label' => __( 'قیمت', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'ftleolor' );
        $this->start_controls_tab( 'dinal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_cdr',
            [
                'label' => __( 'رنگ متن قیمت', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .price span.woocommerce-Price-amount' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colrver',
            [
                'label' => __( 'رنگ هاور متن قیمت', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover .price span.woocommerce-Price-amount   ' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .price span.woocommerce-Price-amount',
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

if ( woocommerce_product_loop() ) {

    /**
     * Hook: woocommerce_before_shop_loop.
     *
     * @hooked woocommerce_output_all_notices - 10
     * @hooked woocommerce_result_count - 20
     * @hooked woocommerce_catalog_ordering - 30
     */
    do_action( 'woocommerce_before_shop_loop' );

    woocommerce_product_loop_start();

    if ( wc_get_loop_prop( 'total' ) ) {
        while ( have_posts() ) {
            the_post();

            /**
             * Hook: woocommerce_shop_loop.
             */
            do_action( 'woocommerce_shop_loop' );

            wc_get_template_part( 'content', 'product' );
        }
    }

    woocommerce_product_loop_end();

    /**
     * Hook: woocommerce_after_shop_loop.
     *
     * @hooked woocommerce_pagination - 10
     */
    do_action( 'woocommerce_after_shop_loop' );
} else {
    /**
     * Hook: woocommerce_no_products_found.
     *
     * @hooked wc_no_products_found - 10
     */
    do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

    }


    protected function _content_template()
    {
    }
}
