<?php

namespace NOVAAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

class PRODUCTS extends Widget_Base {


    public function get_name() {
        return 'products';
    }

    public function get_title() {
        return 'محصولات';
    }

    public function get_icon() {
        return 'eicon-products';
    }

    public function get_categories() {
        return [ 'Nova_cat' ];
    }

    protected function register_controls() {
        $this->register_general_post_grid_controls();
    }

    protected function register_general_post_grid_controls() {

        $this->start_controls_section(
            'content_sectiovbn',
            [
                'label' => __( 'عنوان', 'plugin-name' ),
            ]
        );
        $this->add_control(
            'productslider',
            [
                'label' => __( 'اسلایدر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control(
            'product_count',
            [
                'label'   => __( 'تعداد پست ها', 'NOVA' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '4'
            ]
        );
        $this->add_responsive_control(
            'column_count',
            [
                'label'   => __( 'تعداد پست ها در ردیف', 'NOVA' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '4'
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'عنوان', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'title_color' );
        $this->start_controls_tab( 'original', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_color',
            [
                'label' => __( 'رنگ عنوان', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product h2' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hover', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_color_hover',
            [
                'label' => __( 'رنگ هاور عنوان', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover h2' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typogwseraphy',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} li.product h2',
            ]
        );
        $this->start_controls_tabs( 'tisdftle_color' );
        $this->start_controls_tab( 'origsdfinal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_cdfolor',
            [
                'label' => __( 'رنگ خط دور باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hosdfver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colorsdf_hover',
            [
                'label' => __( 'رنگ هاور خط دور باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover   ' => 'border-color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section2',
            [
                'label' => __( 'افزودن به سبد خرید', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'ftle_color' );
        $this->start_controls_tab( 'dfinal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_cdor',
            [
                'label' => __( 'رنگ متن دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colorover',
            [
                'label' => __( 'رنگ هاور متن دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button:hover   ' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->start_controls_tabs( 'ftl2e_color' );
        $this->start_controls_tab( 'dfi2nal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_c2dor',
            [
                'label' => __( 'رنگ بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hv2er', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colorov2er',
            [
                'label' => __( 'رنگ هاور بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product .button:hover   ' => 'background: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_wtypodgraphy',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} li.product .button',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section32',
            [
                'label' => __( 'باکس قیمت', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'ftleolor' );
        $this->start_controls_tab( 'dinal', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_cdr',
            [
                'label' => __( 'رنگ متن قیمت', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .price span.woocommerce-Price-amount' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ver', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colrver',
            [
                'label' => __( 'رنگ هاور متن قیمت', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover .price span.woocommerce-Price-amount   ' => 'color: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .price span.woocommerce-Price-amount',
            ]
        );
        $this->start_controls_tabs( 'ftlesdfcolor' );
        $this->start_controls_tab( 'dfi2al', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            't_2dor',
            [
                'label' => __( 'رنگ بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .price span.woocommerce-Price-amount' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'h2er', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            't_colo2er',
            [
                'label' => __( 'رنگ هاور بکگراند دکمه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} li.product:hover .price span.woocommerce-Price-amount   ' => 'background: {{VALUE}} !important',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



    }

    protected function render()
    {
        $settings = $this->get_settings();
        $product_count = $settings['product_count'];
        $column_count = $settings['column_count'];
        if ($settings['productslider'] == '') {
            echo do_shortcode('[products limit="' . $product_count . '" columns="' . $column_count . '"]');
        }
        elseif ($settings['productslider'] == 'yes'){ ?>
            <div class="productsliders"><?php
            echo do_shortcode('[products limit="' . $product_count . '" columns="' . $column_count . '"]');
            ?>

            </div>
            <script>
                jQuery(document).ready(function () {
                    var swiper = new Swiper(".productsliderss", {
                        navigation: { nextEl: ".swiper-button-next", prevEl: ".swiper-button-prev" },
                        slidesPerView: 3,
                        spaceBetween: 35,
                        breakpoints: {
                            320:
                                { slidesPerView: 1,
                                    spaceBetween: 60
                                },
                            768:
                                { slidesPerView: 2,
                                    spaceBetween: 30
                                },
                            1200:
                                { slidesPerView: 4,
                                    spaceBetween: 30
                                }
                        },
                        pagination: {
                            el: ".swiper-pagination",
                            clickable: true,
                        },
                    });
                });
            </script>
            <?php
        }
    }

    protected function _content_template() {


    }
}
