<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Projects extends Widget_Base
{

    public function get_name()
    {
        return 'Projects';
    }

    public function get_title()
    {
        return __('پروژه ها', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-inner-section';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }




    protected function register_controls()
    {
        $this->start_controls_section(
            'section_con3tent',
            [
                'label' => __('محتوا', 'nova'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'تصویر شاخص پیشفرض', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'cat_picker',
            [
                'label' => __( 'انتخاب دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'port_cat',
            [
                'label' => __( 'دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'defult' => '',
                'multiple' => true,
                'options' => the_portfolio_cat_pol(),
                'condition' => ['cat_picker' => 'yes'],
            ]
        );
        $this->add_control(
            'count_in_line',
            [
                'label' => __('تعداد در هر ردیف', 'plugin-domain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '6' => __('2', 'plugin-domain'),
                    '4' => __('3', 'plugin-domain'),

                ],
            ]
        );
        $this->add_control(
            'post_per',
            [
                'label' => __( 'تعداد پست در برگه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'slider',
            [
                'label' => __( 'اسلایدر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'pageinationoff',
            [
                'label' => __( 'شمارنده صفحه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['slider' => ''],

            ]
        );
        $this->add_control(
            'next_title',
            [
                'label' => __( 'متن صفحه بعد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'صفحه بعد',
                'condition' => ['pageinationoff' => 'yes' , 'slider' => ''],

            ]

        );
        $this->add_control(
            'before_title',
            [
                'label' => __( 'متن صفحه قبل', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'صفحه قبل',
                'condition' => ['pageinationoff' => 'yes' , 'slider' => ''],

            ]
        );





        $this->end_controls_section();

        $this->start_controls_section(
            'sectiosdfghjkn_cesnt3',
            [
                'label' => __('نام پروژه', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poisdfghujkluytrr' );
        $this->start_controls_tab( 'oripoisdfghjkluytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytrsdfghjkleolor',
            [
                'label' => __( 'رنگ متن نام پروژه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .project-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytsdfghjklfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrsdfghjkllor',
            [
                'label' => __( 'رنگ هاور متن نام پروژه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .project-box:hover .project-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contensdfghjkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .project-name',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secesnt3',
            [
                'label' => __('دسته بندی', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'pytrr' );
        $this->start_controls_tab( 'uytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiulor',
            [
                'label' => __( 'رنگ متن دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .portfolio-categroy a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conorlor',
            [
                'label' => __( 'رنگ هاور متن دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .project-box:hover .portfolio-categroy a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cont_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .portfolio-categroy',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('تاریخ', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .project-time' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .project-box:hover .project-time' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .project-time',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_cent3',
            [
                'label' => __('شمارنده صفحه', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'phgfdr' );
        $this->start_controls_tab( 'oris', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'pxamn',
            [
                'label' => __( 'بکگراند صفحه عادی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a ' => 'background: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hlxs', [ 'label' => __( 'اکتیو', 'plugin-domain' ) ] );
        $this->add_control(
            'sre',
            [
                'label' => __( 'بکگراند صفحه فعال', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li span ' => 'background: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hvxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'pxdre',
            [
                'label' => __( 'بکگراند هاور صفحه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a:hover ' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .page-numbers li span:hover ' => 'background: {{VALUE}} !important',

                ],


            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'por' );
        $this->start_controls_tab( 'orixs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'px',
            [
                'label' => __( 'رنگ متن شمارنده عادی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hxsfd', [ 'label' => __( 'اکتیو', 'plugin-domain' ) ] );
        $this->add_control(
            'p2re',
            [
                'label' => __( 'رنگ متن شمارنده ی فعال', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li.active-li a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( '3rfesf', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'pe',
            [
                'label' => __( 'رنگ هاور متن شمارنده صفحه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li:hover a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $post_per = $settings['post_per'];
       $port_cat = $settings['port_cat'];
       if (!is_tax()) {
                ?>
                <div class="projectboxes">
                    <div class="all-of-projectbox row <?php if ($settings['slider'] == 'yes'){ echo 'swiper-container projectslider';}?>">
          <?php if ($settings['slider'] == 'yes'){ ?><div class="swiper-wrapper"><?php }
                            if ($settings['cat_picker'] == 'yes'){
                                $project_archive = new \WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => $post_per, 'tax_query' => array(array('taxonomy' => 'portfolio_cat', 'field' => 'term_id', 'terms' => $port_cat))));

                            }else{
                                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                                $project_archive = new \WP_Query( array(
                                    'post_type' => 'portfolio',
                                    'posts_per_page' => $post_per,
                                    'paged' => $paged,
                                ) );
                            }
                            ?>
                        <?php


                        if ($project_archive->have_posts()) :
                            while ($project_archive->have_posts()) : $project_archive->the_post(); ?>
                    <div class="<?php if ($settings['slider'] == 'yes'){echo 'swiper-slide';}else{ ?>col-lg-<?php echo $settings['count_in_line'];?> col-sm-6 col-12 <?php } ?>">
                                        <div class="project-box">
                                            <div class="portfolio-image">
                                                <?php if (has_post_thumbnail()){ ?>
                                                <a href="<?php the_permalink(); ?>">  <img src="<?php the_post_thumbnail_url( 'category-thumb' ); ?>" width="333.4" height="250" alt="portfolio">
                                                    <div class="portfolio-cover">
                                                    </div>
                                                    </a><?php }else { ?>
                                                    <a href="<?php the_permalink(); ?>"><?php echo '<img src="' . $settings['image']['url'] . '" alt="portfolio">';?>
                                                    <div class="portfolio-cover">

                                                    </div>
                                                    </a><?php } ?>
                                            </div>
                                            <a href=" <?php
                                            if (has_post_thumbnail()){
                                                the_post_thumbnail_url( 'category-thumb' );
                                            }
                                            else
                                            { echo $settings['image']['url']; }?>" class="light-zoom"><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 469.333 469.333" style="enable-background:new 0 0 469.333 469.333;" xml:space="preserve">
                                        <g>
                                            <g>
                                                <g>
                                                    <path d="M160,0H10.667C4.771,0,0,4.771,0,10.667V160c0,5.896,4.771,10.667,10.667,10.667H32c5.896,0,10.667-4.771,10.667-10.667
                                                        V42.667H160c5.896,0,10.667-4.771,10.667-10.667V10.667C170.667,4.771,165.896,0,160,0z"></path>
                                                    <path d="M458.667,0H309.333c-5.896,0-10.667,4.771-10.667,10.667V32c0,5.896,4.771,10.667,10.667,10.667h117.333V160
                                                        c0,5.896,4.771,10.667,10.667,10.667h21.333c5.896,0,10.667-4.771,10.667-10.667V10.667C469.333,4.771,464.563,0,458.667,0z"></path>
                                                    <path d="M458.667,298.667h-21.333c-5.896,0-10.667,4.771-10.667,10.667v117.333H309.333c-5.896,0-10.667,4.771-10.667,10.667
                                                        v21.333c0,5.896,4.771,10.667,10.667,10.667h149.333c5.896,0,10.667-4.771,10.667-10.667V309.333
                                                        C469.333,303.437,464.563,298.667,458.667,298.667z"></path>
                                                    <path d="M160,426.667H42.667V309.333c0-5.896-4.771-10.667-10.667-10.667H10.667C4.771,298.667,0,303.437,0,309.333v149.333
                                                        c0,5.896,4.771,10.667,10.667,10.667H160c5.896,0,10.667-4.771,10.667-10.667v-21.333
                                                        C170.667,431.438,165.896,426.667,160,426.667z"></path>
                                                </g>
                                            </g>
                                        </g>
                                    </svg></a>
                                            <a href="<?php the_permalink();?>" class="project-name"><?php the_title();?></a>
                                            <div class="project-time"><?php the_time('F j , Y');?></div>
                                            <?php if ( has_term( '', 'portfolio_cat' ) ) { ?><div class="portfolio-categroy"><?php echo the_portfolio_cat(' ');?></div><?php } ?>
                                        </div>
                                </div>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        <?php else : ?>
                            <p><?php esc_html_e('متاسفانه محتوایی پیدا نشد'); ?></p>
                        <?php endif; ?>
                            <?php if ($settings['slider'] == 'yes'){ ?></div>
                    </div> <div class="swiper-button-nextse" style="left: -10px;right: auto;"><i class="arrow left"></i> </div>
                    <div class="swiper-button-prevse" style="right: -10px;left: auto;"><i class="arrow right"></i></div>
                    <div class="pageeinatione"><div class="swiper-paginatione"></div>
                    </div>
                    <?php } ?>

                    </div>

                <?php if( $project_archive->found_posts ) { ?>
                    <?php if ('yes' === $settings['pageinationoff']) { ?>
                        <div class="pageination">
                            <?php
                            $nexttitle= $settings['next_title'];
                            $prevtitle= $settings['before_title'];
                            echo paginate_links( array(
                                'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                                'total'        => $project_archive->max_num_pages,
                                'current'      => max( 1, get_query_var( 'paged' ) ),
                                'format'       => '?paged=%#%',
                                'show_all'     => false,
                                'type'         => 'list',
                                'end_size'     => 2,
                                'mid_size'     => 2,
                                'prev_next'    => true,
                                'prev_text'    => $prevtitle,
                                'next_text'    => $nexttitle,
                                'add_args'     => false,
                                'add_fragment' => '',
                            ) );
                            ?>
                        </div>
                    <?php }?>
                <?php } ?>

        <?php }
        if (is_tax()) {
                if (have_posts()) :?>
                    <div class="all-of-projrctbox row">
                        <?php
                        while (have_posts()) : the_post(); ?>
                            <div class="col-lg-<?php echo $settings['count_in_line']; ?> col-sm-6 col-12">
                                <div class="project-box">
                                    <div class="portfolio-image">
                                        <?php if (has_post_thumbnail()){ ?>
                                        <a href="<?php the_permalink(); ?>">  <img src="<?php the_post_thumbnail_url( 'category-thumb' ); ?>" width="333.4" height="250" alt="portfolio">
                                            <div class="portfolio-cover">
                                            </div>
                                            </a><?php }else { ?>
                                            <a href="<?php the_permalink(); ?>"><?php echo '<img src="' . $settings['image']['url'] . '" alt="portfolio">';?>
                                            <div class="portfolio-cover">

                                            </div>
                                            </a><?php } ?>
                                    </div>
                                    <a href=" <?php
                                    if (has_post_thumbnail()){
                                        the_post_thumbnail_url( 'category-thumb' );
                                    }
                                    else
                                    { echo $settings['image']['url']; }?>" class="light-zoom"><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 469.333 469.333" style="enable-background:new 0 0 469.333 469.333;" xml:space="preserve">
                                        <g>
                                            <g>
                                                <g>
                                                    <path d="M160,0H10.667C4.771,0,0,4.771,0,10.667V160c0,5.896,4.771,10.667,10.667,10.667H32c5.896,0,10.667-4.771,10.667-10.667
                                                        V42.667H160c5.896,0,10.667-4.771,10.667-10.667V10.667C170.667,4.771,165.896,0,160,0z"></path>
                                                    <path d="M458.667,0H309.333c-5.896,0-10.667,4.771-10.667,10.667V32c0,5.896,4.771,10.667,10.667,10.667h117.333V160
                                                        c0,5.896,4.771,10.667,10.667,10.667h21.333c5.896,0,10.667-4.771,10.667-10.667V10.667C469.333,4.771,464.563,0,458.667,0z"></path>
                                                    <path d="M458.667,298.667h-21.333c-5.896,0-10.667,4.771-10.667,10.667v117.333H309.333c-5.896,0-10.667,4.771-10.667,10.667
                                                        v21.333c0,5.896,4.771,10.667,10.667,10.667h149.333c5.896,0,10.667-4.771,10.667-10.667V309.333
                                                        C469.333,303.437,464.563,298.667,458.667,298.667z"></path>
                                                    <path d="M160,426.667H42.667V309.333c0-5.896-4.771-10.667-10.667-10.667H10.667C4.771,298.667,0,303.437,0,309.333v149.333
                                                        c0,5.896,4.771,10.667,10.667,10.667H160c5.896,0,10.667-4.771,10.667-10.667v-21.333
                                                        C170.667,431.438,165.896,426.667,160,426.667z"></path>
                                                </g>
                                            </g>
                                        </g>
                                    </svg></a>
                                    <a href="<?php the_permalink();?>" class="project-name"><?php the_title();?></a>
                                    <div class="project-time"><?php the_time('F j , Y');?></div>
                                    <?php if ( has_term( '', 'portfolio_cat' ) ) { ?><div class="portfolio-categroy"><?php echo the_portfolio_cat('');?></div><?php } ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <p><?php esc_html_e('متاسفانه محتوایی پیدا نشد'); ?></p>
                <?php endif;?>
                <div class="pagination">
                    <?php the_posts_pagination( array(
                        'type' => 'list',
                        'prev_text' => __( 'صفحه قبل', 'nova' ),
                        'next_text' => __( 'صفحه بعد', 'nova' ),
                        'screen_reader_text' => __( ' '),

                    ) ); ?>
                </div>
            <?php
        }
    }

    protected function _content_template()
    {
    }
}
