<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Thequotebox extends Widget_Base
{

    public function get_name()
    {
        return 'Thequotebox';
    }

    public function get_title()
    {
        return __('باکس متن', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-blockquote';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'item_description',
            [
                'label' => __( 'Description', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => __( 'Default description', 'plugin-domain' ),
                'placeholder' => __( 'Type your description here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'before_icon',
            [
                'label' => __( 'آیکون قبل متن', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'after_icon',
            [
                'label' => __( 'آیکون بعد متن', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section1',
            [
                'label' => __( 'متن', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ متن', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .quote-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .quote-box p',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_section2',
            [
                'label' => __( 'باکس', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_color',
            [
                'label' => __( 'بکگراند باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .quote-box' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'margin',
            [
                'label' => __( 'حاشیه باکس', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .quote-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section3',
            [
                'label' => __( 'آیکون', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icons_color',
            [
                'label' => __( 'رنگ ایکون ها', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .quote-box i' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .quote-box svg' => 'fill: {{VALUE}} !important',

                ],
            ]
        );
        $this->add_control(
            'size',
            [
                'label' => __( 'سایز آیکون ها', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .before-paragraph i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .after-paragraph i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .before-paragraph svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .after-paragraph svg' => 'width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <div class="quote-box">
            <div class="before-paragraph"><?php \Elementor\Icons_Manager::render_icon( $settings['before_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
            <p><?php echo $settings['item_description'];?></p>
            <div class="after-paragraph"><?php \Elementor\Icons_Manager::render_icon( $settings['after_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
        </div>
    <?php }


    protected function _content_template()
    {
    }
}
