<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Searchpage extends Widget_Base
{

    public function get_name()
    {
        return 'Searchpage';
    }

    public function get_title()
    {
        return __('نتایج سرچ', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-site-search';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'تصویر شاخص پیشفرض', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'post_pers',
            [
                'label' => __( 'تعداد پست در برگه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 3,
            ]
        );

        $this->add_control(
            'read_more',
            [
                'label' => __( 'متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ادامه مطلب',

            ]
        );
        $this->add_control(
            'cattext',
            [
                'label' => __( 'متن دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'دسته بندی',

            ]
        );
        $this->add_control(
            'count_in_line',
            [
                'label' => __( 'تعداد در هر ردیف', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '6'  => __( '2', 'plugin-domain' ),
                    '4' => __( '3', 'plugin-domain' ),

                ],
            ]
        );

        $this->add_control(
            'read_time',
            [
                'label' => __( 'متن باکس شناور', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'دقیقه مطالعه',

            ]
        );
        $this->add_control(
            'sliderarticle',
            [
                'label' => __( 'اسلایدر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'pageinationoff',
            [
                'label' => __( 'شمارنده صفحه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['sliderarticle' => '']

            ]
        );
        $this->add_control(
            'next_title',
            [
                'label' => __( 'متن صفحه بعد', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'صفحه بعد',
                'condition' => ['pageinationoff' => 'yes' , 'sliderarticle' => ''],

            ]

        );
        $this->add_control(
            'before_title',
            [
                'label' => __( 'متن صفحه قبل', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'صفحه قبل',
                'condition' => ['pageinationoff' => 'yes' , 'sliderarticle' => ''],

            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjkn_cesnt3',
            [
                'label' => __('نام مقاله', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poisdfghujkluytrr' );
        $this->start_controls_tab( 'oripoisdfghjkluytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytrsdfghjkleolor',
            [
                'label' => __( 'رنگ متن نام مقاله', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytsdfghjklfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrsdfghjkllor',
            [
                'label' => __( 'رنگ هاور متن نام مقاله', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-box:hover .article-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contensdfghjkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-name',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdt3',
            [
                'label' => __('متن خلاصه', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiluytrr' );
        $this->start_controls_tab( 'oripoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiukleolor',
            [
                'label' => __( 'رنگ متن خلاصه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoifghjkllor',
            [
                'label' => __( 'رنگ هاور متن خلاصه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-box:hover .article-excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-excerpt p',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secesnt3',
            [
                'label' => __('دسته بندی', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'pytrr' );
        $this->start_controls_tab( 'uytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiulor',
            [
                'label' => __( 'رنگ متن عنوان دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .cat-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conorlor',
            [
                'label' => __( 'رنگ هاور متن عنوان دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-box:hover .cat-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cont_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .cat-title',
            ]
        );
        $this->start_controls_tabs( 'pytsdfgrr' );
        $this->start_controls_tab( 'uytsdfgrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coisdfgulor',
            [
                'label' => __( 'رنگ متن دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-category a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .article-category ' => 'color: {{VALUE}}',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiusdfgxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'coNOdfgrlor',
            [
                'label' => __( 'رنگ هاور متن دسته بندی', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-category a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .article-category:hover' => 'color: {{VALUE}}',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'consdfgvt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-category',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('تاریخ', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-date' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-box:hover .article-date' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-date',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_cesnt3',
            [
                'label' => __('ادامه مطلب', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiuytrr' );
        $this->start_controls_tab( 'oripoiuytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytreolor',
            [
                'label' => __( 'رنگ متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrlor',
            [
                'label' => __( 'رنگ هاور متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-box:hover .article-more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-more',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdsnt3',
            [
                'label' => __('باکس شناور', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->add_control(
            'coiuythjkleolor',
            [
                'label' => __( 'رنگ متن باکس شناور', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-read-time span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'conoiuykllor',
            [
                'label' => __( 'رنگ آیکون باکس شناور', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .article-read-time svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .article-read-time i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contjkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .article-read-time',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_cent3',
            [
                'label' => __('شمارنده صفحه', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'phgfdr' );
        $this->start_controls_tab( 'oris', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'pxamn',
            [
                'label' => __( 'بکگراند صفحه عادی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a ' => 'background: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hlxs', [ 'label' => __( 'اکتیو', 'plugin-domain' ) ] );
        $this->add_control(
            'sre',
            [
                'label' => __( 'بکگراند صفحه فعال', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li span ' => 'background: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hvxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'pxdre',
            [
                'label' => __( 'بکگراند هاور صفحه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a:hover ' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .page-numbers li span:hover ' => 'background: {{VALUE}} !important',

                ],


            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs( 'por' );
        $this->start_controls_tab( 'orixs', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'px',
            [
                'label' => __( 'رنگ متن شمارنده عادی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hxs', [ 'label' => __( 'اکتیو', 'plugin-domain' ) ] );
        $this->add_control(
            'p2re',
            [
                'label' => __( 'رنگ متن شمارنده ی فعال', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li.active-li a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'pe',
            [
                'label' => __( 'رنگ هاور متن شمارنده صفحه', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .page-numbers li:hover a' => 'color: {{VALUE}} !important',
                ],


            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
            $post_pers=$settings['post_pers']; ?>
            <?php
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
            $blog_archive = new \WP_Query( array(
                'post_type' => 'post',
                'posts_per_page' => $post_pers,
                'paged' => $paged
            ) );
            ?>
        <div class="row <?php if ($settings['sliderarticle'] == 'yes'){ echo 'swiper-container articlesliderr';}?>" id="contentofartarch">
            <?php if ($settings['sliderarticle'] == 'yes'){ ?><div class="swiper-wrapper"><?php } ?>

            <?php if ( have_posts() ) : ?>
                <?php while ( have_posts() ) : the_post(); ?>
                    <div class="<?php if ($settings['sliderarticle'] == 'yes'){echo 'swiper-slide';}else{ ?>col-lg-<?php echo $settings['count_in_line'];?> col-md-6 col-12 <?php } ?>">
                        <div class="article-box">
                            <div class="article-picture">
                                <?php if (has_post_thumbnail()){ ?>
                                <a href="<?php the_permalink(); ?>">  <img src="<?php the_post_thumbnail_url( 'category-thumb' ); ?>" width="333.4" height="250" alt="article">
                                    <div class="article-cover">
                                    </div>
                                    </a><?php }else { ?>
                                    <a href="<?php the_permalink(); ?>"><?php echo '<img src="' . $settings['image']['url'] . '" alt="article">';?>
                                    <div class="article-cover">

                                    </div>
                                    </a><?php } ?>
                            </div>
                            <?php $post_meta = get_post_meta(get_the_ID());?>
                            <p><?php if (get_post_meta(get_the_ID(),'customer-name')) {?>
                                    <span class="article-read-time"><?php
                                        \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']);
                                        echo $post_meta['customer-name'][0];?>
                      <span><?php echo $settings['read_time'];?></span>
                    </span>
                                <?php } ?> </p>

                            <div class="article-content">
                                <a href="<?php the_permalink();?>" class="article-name">
                                    <?php the_title();?>
                                </a>
                                <div class="article-excerpt">
                                    <?php echo the_excerpt();?>
                                </div>
                                <div class="article-category">
                                    <div class="cat-title"><?php echo $settings['cattext'];?></div>

                                    <?php echo the_category( ' , ');?>
                                </div>
                            </div>
                            <div class="article-info">
                                <div class="article-date"><?php the_time('F j , Y');?></div>
                                <a href="<?php the_permalink();?>" class="article-more"><?php echo $settings['read_more'];?><span>&#8592;</span></a>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php else : ?>
                <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
            <?php endif; ?>
            <?php if ($settings['sliderarticle'] == 'yes'){ ?></div>
                </div> <div class="swiper-button-next" style="left: -10px;right: auto;"><i class="arrow left"></i> </div>
                <div class="swiper-button-prev" style="right: -10px;left: auto;"><i class="arrow right"></i></div>
                <div class="pageeinatione"><div class="swiper-pagination"></div>
                </div>
            <?php } ?>

            <?php if( $blog_archive->found_posts ) { ?>

                <?php if ('yes' === $settings['pageinationoff']) { ?>
                    <div class="pageination" style="width: 100%;">

                        <?php

                        $nexttitle= $settings['next_title'];
                        $prevtitle= $settings['before_title'];
                        echo paginate_links( array(
                            'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                            'total'        => $blog_archive->max_num_pages,
                            'current'      => max( 1, get_query_var( 'paged' ) ),
                            'format'       => '?paged=%#%',
                            'show_all'     => false,
                            'type'         => 'list',
                            'end_size'     => 2,
                            'mid_size'     => 2,
                            'prev_next'    => true,
                            'prev_text'    => $prevtitle,
                            'next_text'    => $nexttitle,
                            'add_args'     => false,
                            'add_fragment' => '',
                        ) );
                        ?>
                    </div>
                <?php } } }




    protected function _content_template()
    {
    }
}
