<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Search extends Widget_Base
{

    public function get_name()
    {
        return 'Search';
    }

    public function get_title()
    {
        return __('سرچ', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-search';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {



$this->start_controls_section(
        'section_icon',
        [
            'label' => __( 'سرچ', 'text-domain' ),
        ]
    );

        $this->add_control(
            'search_type',
            [
                'label' => __( 'نوع سرچ', 'NOVA' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'modal',
                'options' => [
                    'modal'  => __( 'ایکن مودال', 'NOVA' ),
                    'open' => __( 'باز', 'NOVA' ),

                ],
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __( 'آیکن تاگل', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-search',
                    'library' => 'solid',
                ],

            ]
        );

        $this->add_control(
            'search-placeholder',
            [
                'label' => __( 'متن نگهدارنده', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'جستجو کنید', 'plugin-domain' ),
            ]
        );



        $this->end_controls_section();
        $this->start_controls_section(
            'section_content1',
            [
                'label' => __( 'تنظیمات باکس سرچ', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'form-box-border-color',
            [
                'label'     => __( 'رنگ کادر', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'defult'=>'#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} #select-post-type-for-search' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form.product > ul' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch input' => 'border-color: {{VALUE}}',
                ],
            ]
        );






        $this->add_control(
            'input-text-color',
            [
                'label'     => __( 'رنگ متن ورودی', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch input' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input-bac-color',
            [
                'label'     => __( 'رنگ پس زمینه کادر متن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'defult'=>'#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .site-search-form input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch input' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'input-typography',
                'label' => __( 'تایپوگرافی متن ورودی', 'plugin-domain' ),
                
                'selector' => '{{WRAPPER}} .site-search-form input',
            ]
        );




        $this->end_controls_section();


        $this->start_controls_section(
            'section_condfgtent3',
            [
                'label' => __( 'آیکن جستجو', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'search-icon' );
        $this->start_controls_tab( 'normal-search-icon', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'searlor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'seaac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover-search-icon', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'search-icocolor',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .opensearch button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'searcback',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search-icon:hover' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .opensearch button:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content3',
            [
                'label' => __( 'آیکن جستجو در فرم', 'polaris' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'search-icon4343' );
        $this->start_controls_tab( 'normal-search-icon223', [ 'label' => __( 'عادی', 'polaris' ) ] );

        $this->add_control(
            'search-icon-color',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form button .spinner-border' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search-icon-bac',
            [
                'label'     => __( 'رنگ پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'hover-search-icon9842', [ 'label' => __( 'هاور', 'polaris' ) ] );

        $this->add_control(
            'search-icon-hover-color',
            [
                'label'     => __( 'رنگ آیکن', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .site-search-form button:hover .spinner-border' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search-icon-hover-back',
            [
                'label'     => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .site-search-form button:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );



        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <?php if ($settings['search_type'] == 'modal'){?>
                           <div class="search-icon">
                            <i class="fa fa-search"></i>
                        </div><?php } ?>
                        <form class="<?php if ($settings['search_type'] == 'modal'){ echo 'site-search-form '; } elseif ($settings['search_type'] == 'open' ){ echo 'opensearch ';} ?>" action="<?php echo home_url('/'); if (function_exists('pll_the_languages') && pll_default_language()!=pll_current_language()){ echo pll_current_language().'/';} ?>" method="get">
                            <input type="text" name="s" value="<?php the_search_query(); ?>" placeholder="<?php echo $settings['search-placeholder']; ?>">
                            <button type="submit" name="button"> <i class="fas fa-search" aria-hidden></i> </button>

                            <?php if ( class_exists( 'WooCommerce' ) && get_bloginfo('language')=='fa-IR'  ) { ?>
                                <input type="hidden" id="get-post-type-value" name="post_type" value="post" />
                            <?php } else {?>
                                <input type="hidden" id="get-post-type-value" name="post_type" value="post" />
                            <?php } ?>

                        </form>
                        <div class="site-search-form-back"></div>


        <?php
    }


    protected function _content_template()
    {
    }
}
