<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Servises extends Widget_Base
{

    public function get_name()
    {
        return 'Servises';
    }

    public function get_title()
    {
        return __('باکس خدمات', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'widget_title',
            [
                'label' => __( 'Title', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'item_description',
            [
                'label' => __( 'Description', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => __( 'Default description', 'plugin-domain' ),
                'placeholder' => __( 'Type your description here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'read_more_but',
            [
                'label' => __( 'دکمه ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'widget_title2',
            [
                'label' => __( 'Title', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['read_more_but' => 'yes'],
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __( 'Link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => ['read_more_but' => 'yes'],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Background', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services-box::before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'backgroundhover',
                'label' => __( 'هاور بکگراند', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services-box:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'underbackground',
                'label' => __( 'بکگراند لایه زیرین', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services-box::after',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'سایه باکس', 'plugin-domain' ),
                'selector' => '{{WRAPPER}} .services-box',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadowhover',
                'label' => __( 'سایه هاور باکس', 'plugin-domain' ),
                'selector' => '{{WRAPPER}} .services-box:hover',
            ]
        );
        $this->add_control(
            'width',
            [
                'label' => __( 'Width', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .service-icon svg' => 'width: {{SIZE}}{{UNIT}} !important;height: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secjdfgksdt3',
            [
                'label' => __('آیکون', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'posdfijkuytrr' );
        $this->start_controls_tab( 'oripdsdfgftrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfuklesdfgolor',
            [
                'label' => __( 'رنگ آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .service-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .service-icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .float-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .float-icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiusdfhjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghsdfjkllor',
            [
                'label' => __( 'رنگ هاور آیکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .services-box:hover .service-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .services-box:hover .service-icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .services-box:hover .float-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .services-box:hover .float-icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'iconbackgroundorg',
                'label' => __( 'بکگراند هاور ایکون', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services-box .service-icon::after',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'iconbackground',
                'label' => __( 'بکگراند ایکون', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services-box:hover .service-icon::after',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'drghntenjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .service-content',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('عنوان', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ متن عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .service-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور متن عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .services-box:hover .service-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .service-name',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secjksdt3',
            [
                'label' => __('توضیح', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poijkuytrr' );
        $this->start_controls_tab( 'oripdftrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfukleolor',
            [
                'label' => __( 'رنگ متن توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .service-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuhjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkllor',
            [
                'label' => __( 'رنگ هاور متن توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .services-box:hover .service-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .service-content',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'secjks2dt3',
            [
                'label' => __('ادامه مطلب', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );

        $this->add_control(
            'condfgh2jkllor',
            [
                'label' => __( 'رنگ ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .services-box .service' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cont2enjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .service-content',
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>

        <div class="services-box">
    <div class="service-icon">
        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </div>
    <div class="service-name">
<?php echo $settings['widget_title'];?>
    </div>
    <div class="service-content">
<?php echo $settings['item_description'];?>
    </div>
    <div class="float-icon">
        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </div>
           <?php if ($settings['read_more_but'] == 'yes') {?>
        <a class="service" href="<?php echo $settings['website_link']['url'];?>"><?php echo $settings['widget_title2'];?></a>
        <?php }?>

        </div>

<?php }


    protected function _content_template()
    {
    }
}
