<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Servisestwo extends Widget_Base
{

    public function get_name()
    {
        return 'Servisestwo';
    }

    public function get_title()
    {
        return __('باکس خدمات دوم', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'تصویر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'widget_title',
            [
                'label' => __( 'Title', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'item_description',
            [
                'label' => __( 'Description', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => __( 'Default description', 'plugin-domain' ),
                'placeholder' => __( 'Type your description here', 'plugin-domain' ),
            ]
        );
        $this->add_control(
            'read_more_but',
            [
                'label' => __( 'دکمه ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'your-plugin' ),
                'label_off' => __( 'Hide', 'your-plugin' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'widget_title2',
            [
                'label' => __( 'Title', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['read_more_but' => 'yes'],
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __( 'Link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => ['read_more_but' => 'yes'],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content2',
            [
                'label' => __('تصویر', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => __( 'گردی گوشه ها', 'plugin-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'margine',
            [
                'label' => __( 'ارتفاع تصویر', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-image img' => 'height: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'section_content23',
            [
                'label' => __('عنوان', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'p_clo2222r22' );
        $this->start_controls_tab( 'origi2n222a23ls2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_c2o222lor2',
            [
                'label' => __( 'رنگ عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicetwo-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2sgdffgve222r23', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_colo2r_hodgfgghhg222ver2',
            [
                'label' => __( 'رنگ هاور عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicestwo-box:hover .servicetwo-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography22',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .servicetwo-name',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_conten3t23',
            [
                'label' => __('توضیحات', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'p_clo222232r22' );
        $this->start_controls_tab( 'origi2n22232a23ls2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_c2o222lor322',
            [
                'label' => __( 'رنگ عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicetwo-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2sgdffgv23e222r23', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_colo2r_hofgghhg22322ver2',
            [
                'label' => __( 'رنگ هاور عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicestwo-box:hover .servicetwo-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typograp23hy22',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .servicetwo-content',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_conten33t23',
            [
                'label' => __('دکمه', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'p_clo2222325r22' );
        $this->start_controls_tab( 'origi2n22232a234ls2', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'title_c2o222l43or322',
            [
                'label' => __( 'رنگ دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicetwobutton' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'ho2sgdffg5v23e222r23', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'title_colo2r_hofgghhg223242ver2',
            [
                'label' => __( 'رنگ هاور دکمه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servicetwobutton:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typograp23h3y22',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),

                'selector' => '{{WRAPPER}} .servicetwobutton',
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>

        <div class="servicestwo-box">
            <div class="service-image">
               <img src="<?=$settings['image']['url'];?>" width="100%">
            </div>
            <h3 class="servicetwo-name">
                <?php echo $settings['widget_title'];?>
            </h3>
            <div class="servicetwo-content">
                <?php echo $settings['item_description'];?>
            </div>
            <div class="float-icon">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
            <?php if ($settings['read_more_but'] == 'yes') {?>
                <a class="servicetwobutton" href="<?php echo $settings['website_link']['url'];?>"><?php echo $settings['widget_title2'];?></a>
            <?php }?>

        </div>

    <?php }


    protected function _content_template()
    {
    }
}
