<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Share extends Widget_Base
{

    public function get_name()
    {
        return 'Share';
    }

    public function get_title()
    {
        return __('اشتراک گداری', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-share';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );

        $this->add_control(
            'linkedin_control',
            [
                'label' => __( 'امکان ارسال در لینکدین', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );

        $this->add_control(
            'linkedin_title',
            [
                'label' => __( 'متن لینکدین', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['linkedin_control' => 'active'],

            ]
        );
        $this->add_control(
            'whatsapp_control',
            [
                'label' => __( 'امکان ارسال در واتساپ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'whatsapp_title',
            [
                'label' => __( 'متن واتساپ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['whatsapp_control' => 'active'],

            ]
        );
        $this->add_control(
            'telegram_control',
            [
                'label' => __( 'امکان ارسال در تلگرام', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'telegram_title',
            [
                'label' => __( 'متن تلگرام', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['telegram_control' => 'active'],

            ]
        );
        $this->add_control(
            'mail_control',
            [
                'label' => __( 'امکان ارسال با ایمیل', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'mail_title',
            [
                'label' => __( 'متن ایمیل', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['mail_control' => 'active'],

            ]
        );
        $this->add_control(
            'reddit_control',
            [
                'label' => __( 'امکان ارسال با رددیت', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'reddit_title',
            [
                'label' => __( 'متن رددیت', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['reddit_control' => 'active'],

            ]
        );
        $this->add_control(
            'twitter_control',
            [
                'label' => __( 'امکان ارسال با توییتر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'twitter_title',
            [
                'label' => __( 'متن توییتر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['twitter_control' => 'active'],

            ]
        );
        $this->add_control(
            'facebook_control',
            [
                'label' => __( 'امکان ارسال با فیسبوک', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'facebook_title',
            [
                'label' => __( 'متن فیسبوک', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['facebook_control' => 'active'],

            ]
        );
        $this->add_control(
            'pinterest_control',
            [
                'label' => __( 'امکان ارسال با پینترست', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'active',
                'options' => [
                    'active'  => __( 'فعال', 'plugin-domain' ),
                    'deactive' => __( 'غیرفعال', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'pinterest_title',
            [
                'label' => __( 'متن پینترست', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['pinterest_control' => 'active'],

            ]
        );
        $this->add_control(
            'title_of_share',
            [
                'label' => __( 'متن بالای باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'اشتراک گذاری', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
                'condition' => ['share_style' => 'popup'],
            ]
        );
        $this->add_control(
            'link_copy_title',
            [
                'label' => __( 'متن کپی لینک', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'کپی لینک', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_svdconte2nt1',
            [
                'label' => __('باکس ایکون', 'polaris'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'lor' );
        $this->start_controls_tab( 'orfsalse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_cfre',
            [
                'label' => __( 'بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .social-box' => 'background: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hverse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_coler',
            [
                'label' => __( 'هاور بکگراند باکس', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .social-box:hover' => 'background: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'size',
            [
                'label' => __( 'ابعاد باکس', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 35,
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-box' => 'height: {{SIZE}}{{UNIT}} !important; width: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );
        $this->add_control(
            'p_c2oler',
            [
                'label' => __( 'بکگراند عنوان شبکه اجتماعی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .social-span' => 'background: {{VALUE}} !important',

                ],
            ]
        );
        $this->add_control(
            'p_col3er',
            [
                'label' => __( 'رنگ متن عنوان شبکه اجتماعی', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .social-span' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography1',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .social-span',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_svdcontent1',
            [
                'label' => __('آیکون', 'polaris'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'b_codsflor' );
        $this->start_controls_tab( 'originfsalse', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'p_cfsolore',
            [
                'label' => __( 'رنگ آیکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .social-share' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .link-share' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hfsoverse', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'p_color_hofsver',
            [
                'label' => __( 'رنگ هاور آیکون', 'plugin-domain' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#bbbbbb',
                'selectors' => [
                    '{{WRAPPER}} .social-share:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .link-share:hover' => 'color: {{VALUE}} !important',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'siza',
            [
                'label' => __( 'اندازه ایکون', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1500,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 35,
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-share i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .link-share i' => 'font-size: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
<div class="social-share">
    <div class="linedin-control <?php echo $settings['linkedin_control'];?>">
        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['linkedin_title'];?></span>
            <i class="fa-linkedin fab"></i>
        </a>
    </div>
    <div class="telegram-control <?php echo $settings['telegram_control'];?>">
        <a href="https://t.me/share/url?url=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['telegram_title'];?></span>
            <i class="fa-telegram fab"></i>
        </a>
    </div>
    <div class="whatsapp-cotrol <?php echo $settings['whatsapp_control'];?>">
        <a href="https://web.whatsapp.com/send?text=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['whatsapp_title'];?></span>
            <i class="fa-whatsapp fab"></i>
        </a>
    </div>
    <div class="mail-control <?php echo $settings['mail_control'];?>">
        <a href="https://mail.google.com/mail/u/0/?view=cm&to&body=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['mail_title'];?></span>
            <i class="fas fa-envelope"></i>
        </a>
    </div>
    <div class="reddit-control <?php echo $settings['reddit_control'];?>">
        <a href="https://reddit.com/submit?url=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['reddit_title'];?></span>
            <i class="fab fa-reddit"></i>
        </a>
    </div>
    <div class="pinterest-control <?php echo $settings['pinterest_control'];?>">
        <a href="https://pinterest.com/pin/create/bookmarklet/?media=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['pinterest_title'];?></span>
            <i class="fab fa-pinterest"></i>
        </a>
    </div>
    <div class="facebook-control <?php echo $settings['facebook_control'];?>">
        <a href="http://www.facebook.com/share.php?u=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['facebook_title'];?></span>
            <i class="fab fa-facebook-f"></i>
        </a>
    </div>
    <div class="twitter-control <?php echo $settings['twitter_control'];?>">
        <a href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>" class="social-share social-box">
            <span class="social-span"><?php echo $settings['twitter_title'];?></span>
            <i class="fab fa-twitter"></i>
        </a>
    </div>
    <div class="link-share social-box">
        <span class="social-span"><?php echo $settings['link_copy_title'];?></span>
        <i class="fas fa-copy"></i>
    </div>


</div>
<?php
    }


    protected function _content_template()
    {
    }
}
