<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Side_image extends Widget_Base
{

    public function get_name()
    {
        return 'Side_image';
    }

    public function get_title()
    {
        return __('تصویر سایدبار', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-image-box';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'polaris'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'image-banner',
            [
                'label' => __( 'Choose Image', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );
        $repeater->add_control(
            'website_link',
            [
                'label' => __( 'لینک تصویر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],

            ]
        );
        $repeater->add_control(
            'alt_image',
            [
                'label' => __( 'alt تصویر', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( ' ', 'plugin-domain' ),


            ]
        );
        $this->add_control(
            'list_icon_nova',
            [
                'label' => __( 'Repeater List', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Title #1', 'plugin-domain' ),
                    ],
                    [
                        'list_title' => __( 'Title #2', 'plugin-domain' ),
                    ],
                ],

            ]
        );



        $this->add_responsive_control(
            'wight',
            [
                'label' => __( 'ارتفاع تصویر', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .side-image img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
              


            ]
        );

        $this->add_responsive_control(
            'width3',
            [
                'label' => __( 'عرض تصویر', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .side-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
               


            ]
        );
        $this->end_controls_section();



    }


    protected function render() {
        $settings = $this->get_settings_for_display(); ?>
        <div class="side-image"><?php
            foreach (  $settings['list_icon_nova'] as $item ) { ?>
                <a href="<?php echo $item['website_link']['url']?>">
                    <img style="margin-bottom: 5px;object-fit: cover;border-radius: 3px;" src="<?php echo $item['image-banner']['url'];?>" alt="<?php echo $item['alt_image'];?>">
                </a>
            <?php } ?>

        </div>
    <?php }

    protected function _content_template() {
    }
}
