<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sideposts extends Widget_Base
{

    public function get_name()
    {
        return 'sideposts';
    }

    public function get_title()
    {
        return __('پست های سایدبار', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-posts-group';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'تصویر شاخص پیشفرض', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'posttype',
            [
                'label' => __( 'نوع پست', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'post',
                'options' => [
                    'post'  => __( 'مقالات', 'plugin-domain' ),
                    'portfolio' => __( 'نمونه کارها', 'plugin-domain' ),
                    'product' => __( 'محصولات', 'plugin-domain' ),

                ],
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => __( 'متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ادامه مطلب',

            ]
        );
        $this->add_control(
            'post_pers',
            [
                'label' => __( 'تعداد پست در برگه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'border_style',
            [
                'label' => __( 'نوع خط زیر باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'solid'  => __( 'یکپارچه', 'plugin-domain' ),
                    'dashed' => __( 'خط چین', 'plugin-domain' ),
                    'dotted' => __( 'نقطه ای', 'plugin-domain' ),
                    'double' => __( 'دوبل', 'plugin-domain' ),
                    'none' => __( 'هیچ', 'plugin-domain' ),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjkn_cesnt3',
            [
                'label' => __('نام مقاله', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poisdfghujkluytrr' );
        $this->start_controls_tab( 'oripoisdfghjkluytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytrsdfghjkleolor',
            [
                'label' => __( 'رنگ متن نام مقاله', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .article-nameside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytsdfghjklfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrsdfghjkllor',
            [
                'label' => __( 'رنگ هاور متن نام مقاله', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .side-posts-box:hover .article-nameside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contensdfghjkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .article-nameside',
            ]
        );
        $this->add_control(
            'consdfghjkllor',
            [
                'label' => __( 'رنگ خط زیر باکس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .side-posts-box' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_cesnt3',
            [
                'label' => __('ادامه مطلب', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poiuytrr' );
        $this->start_controls_tab( 'oripoiuytrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coiuytreolor',
            [
                'label' => __( 'رنگ متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .article-moreside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytfrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'conoiuytrlor',
            [
                'label' => __( 'رنگ هاور متن ادامه مطلب', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .side-posts-box:hover .article-moreside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .article-moreside',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('تاریخ', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->start_controls_tabs( 'poildfghjkuytrr' );
        $this->start_controls_tab( 'oripdfghjoitrls', [ 'label' => __( 'عادی', 'plugin-domain' ) ] );
        $this->add_control(
            'coidfghnjmkukleolor',
            [
                'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .article-dateside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'hoiuytdfghjkrdxxs', [ 'label' => __( 'هاور', 'plugin-domain' ) ] );
        $this->add_control(
            'condfghjkoifghjkllor',
            [
                'label' => __( 'رنگ هاور متن تاریخ', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .side-posts-box:hover .article-dateside' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .article-dateside',
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
            $post_pers=$settings['post_pers'];
        $posttype=$settings['posttype'];
            ?>
            <?php
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
            $blog_archive = new \WP_Query( array(
                'post_type' => $posttype,
                'posts_per_page' => $post_pers,
                'paged' => $paged
            ) );
            ?>
              <?php if ( $blog_archive->have_posts() ) : ?>
                <?php while ( $blog_archive->have_posts() ) : $blog_archive->the_post(); ?>
                       <div class="side-posts-box" style="border-bottom-style:<?php echo $settings['border_style'];?>">

                            <div class="article-pictureside">
                                <?php if (has_post_thumbnail()){ ?>
                                <a href="<?php the_permalink(); ?>">  <img src="<?php the_post_thumbnail_url( 'category-thumb' ); ?>" width="333.4" height="250" alt="article">
                                    </a><?php }else { ?>
                                    <a href="<?php the_permalink(); ?>"><?php echo '<img src="' . $settings['image']['url'] . '" alt="article">';?>
                                    </a><?php } ?>

                        </div>
                           <div class="sidesideinfo">
                           <div class="article-contentside">
                               <a href="<?php the_permalink();?>" class="article-nameside">
                                   <?php the_title();?>
                               </a>
                           </div>
            <div class="article-infoside">
                <div class="article-dateside"><?php if ($posttype == 'product'){ echo woocommerce_template_single_price(); }else{ the_time('F j , Y'); }?></div>
                <a href="<?php the_permalink();?>" class="article-moreside"><?php echo $settings['read_more'];?><span>&#8592;</span></a>
            </div>
                       </div>
                       </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php else : ?>
                <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
            <?php endif;?>


    <?php }


    protected function _content_template()
    {
    }
}
