<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Team extends Widget_Base
{

    public function get_name()
    {
        return 'Team';
    }

    public function get_title()
    {
        return __('اعضای تیم', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-info-box';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }



    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'تصویر عضو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'name',
            [
                'label' => __( 'نام عضو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ادامه مطلب',

            ]
        );
        $this->add_control(
            'team',
            [
                'label' => __( 'سمت عضو', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ادامه مطلب',

            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icon',
            [
                'label' => __( 'آیکون', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'icon_link',
            [
                'label' => __( 'لینک ایکون', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'list_icon',
            [
                'label' => __( 'Repeater List', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Title #1', 'plugin-domain' ),
                    ],
                    [
                        'list_title' => __( 'Title #2', 'plugin-domain' ),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>

        <div class="team-us">
            <div class="people-pic">
            <img src="<?php echo $settings['image']['url']?>" alt="team-people">
            </div>
                <div class="people-information">
            <div class="people-name"><?php echo $settings['name'];?></div>
            <div class="people-post"><?php echo $settings['team'];?></div>
                <div class="people-social">
                    <?php
                    if ( $settings['list_icon'] ) {
                        echo '<div class="social-about">';
                        $i = 0;
                        foreach (  $settings['list_icon'] as $settings ) { $i = $i + 80 ; ?>
                            <a style="transition-delay: <?php echo $i?>ms;" href="<?php echo $settings['icon_link']['url']; ?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        <?php }
                        echo '</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
<?php }


    protected function _content_template()
    {
    }
}
