<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Content extends Widget_Base
{

    public function get_name()
    {
        return 'Content';
    }

    public function get_title()
    {
        return __('محتوای بدنه', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-post-content';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }



    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('محتوا', 'Nova'),
            ]
        );
        $this->add_control(
            'breadcumb_titlese', [
                'label' => __( 'تست', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'تست' , 'plugin-domain' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $post_meta = get_post_meta(get_the_ID());
        if ($post_meta['Nova-select-template'][0]=='post_single') {
            $the_query=new WP_Query(array('post_type'=>'post','posts_per_page'=>1));
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) { $the_query->the_post();
                    the_content();
                }wp_reset_postdata();
            }
        }elseif ($post_meta['Nova-select-template'][0]=='product_single') {
            $the_query=new WP_Query(array('post_type'=>'product','posts_per_page'=>1));
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) { $the_query->the_post();
                    the_content();
                }
            }wp_reset_postdata();
        }elseif ($post_meta['Nova-select-template'][0]=='portfolio_single') {
            $the_query=new WP_Query(array('post_type'=>'portfolio','posts_per_page'=>1));
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) { $the_query->the_post();
                    the_content();
                }
            }wp_reset_postdata();
        }else {
            if (have_posts()){
                while (have_posts()){
                    the_post();
                }
            }
            the_content();
        }
    }


    protected function _content_template()
    {
    }
}
