<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Thetitle extends Widget_Base
{

    public function get_name()
    {
        return 'Thetitle';
    }

    public function get_title()
    {
        return __('عنوان صفحه', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-site-title';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'plugin-name' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'type_type',
            [
                'label' => __( 'نوع نوشتار', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h1',
                'options' => [
                    'h1'  => __( 'h1', 'plugin-domain' ),
                    'span' => __( 'span', 'plugin-domain' ),
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ عنوان صفحه', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .the-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .the-title',
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if ($settings['type_type'] == 'h1'){ ?>
            <h1 class="the-title">
                <?php echo the_title();?>
            </h1>
        <?php } elseif ($settings['type_type'] == 'span'){ ?>
            <span class="the-title">
                <?php echo the_title();?>
            </span>
        <?php } }


    protected function _content_template()
    {
    }
}
