<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Titlebox extends Widget_Base
{

    public function get_name()
    {
        return 'Titlebox';
    }

    public function get_title()
    {
        return __('سربرگ', 'Nova');
    }


    public function get_icon()
    {
        return 'eicon-archive-title';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'sectiojksdt3',
            [
                'label' => __('عنوان', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

            ]

        );
        $this->add_control(
            'widget_title',
            [
                'label' => __( 'عنوان', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Default title', 'plugin-domain' ),
                'placeholder' => __( 'Type your title here', 'plugin-domain' ),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'sectiosdfghjksdt3',
            [
                'label' => __('عنوان', 'nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]

        );
        $this->add_control(
            'coidfukleolor',
            [
                'label' => __( 'رنگ متن توضیح', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-area h4' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenjdfghjkkt_y',
                'label' => __( 'تایپوگرافی', 'plugin-domain' ),
               
                'selector' => '{{WRAPPER}} .title-area h4',
            ]
        );
        $this->add_control(
            'kdnfknfkdnfkndlor',
            [
                'label' => __( 'رنگ خط زیرین', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .relative-line' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'oeowiodjkocod',
            [
                'label' => __( 'رنگ خط بالا', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .absolute-line' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();?>

            <div class="title-area">
                <h4><?php echo $settings['widget_title'];?></h4>
                <hr class="relative-line"/>
                <hr class="absolute-line"/>
            </div>

    <?php }


    protected function _content_template()
    {
    }
}
