<?php

namespace NovaAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;


if (!defined('ABSPATH')) exit; // Exit if accessed directly


class WOOCOMERCEPAGES extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce-page';
    }

    public function get_title()
    {
        return __('صفحه های ووکامرس', 'nova');
    }


    public function get_icon()
    {
        return 'eicon-product-pages';
    }


    public function get_categories()
    {
        return ['Nova_cat'];
    }



    protected function register_controls()
    {
        $this->start_controls_section(
            'section_titleses',
            [
                'label' => __('تنظیمات', 'nova'),
            ]
        );

        $this->add_control(
            'woocomerce-pages',
            [
                'label' => __( 'نوع صفحه را انتخاب نمایید', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    '[woocommerce_cart]'  => __( 'سبد خرید', 'plugin-domain' ),
                    '[woocommerce_checkout]' => __( 'صفحه پرداخت', 'plugin-domain' ),
                    '[woocommerce_my_account]' => __( 'حساب کاربری', 'plugin-domain' ),
                    '[woocommerce_order_tracking]' => __( 'پیگیری سفارش', 'plugin-domain' ),

                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content1',
            [
                'label' => __('رنگ ها', 'Nova'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'title_cosdlor',
            [
                'label' => __( 'رنگ لیبل های ووکامرس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce label' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ بکگراند های ووکامرس', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shop_table thead' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce .button' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce button' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce-order h2' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}}  .woocommerce-order p' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}}  form.checkout h3' => 'background: {{VALUE}} !important',
                    '{{WRAPPER}} .woocommerce-MyAccount-content .edit' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $woochange= $settings['woocomerce-pages'];
        echo do_shortcode(''.$woochange.'');
    }


    protected function _content_template()
    {
    }
}
