<?php if (is_singular('post')) {
    get_header();
    $id = get_theme_mod('single_archive_template');
    if ($id) {
        get_site_templates($id);
    } else { ?>
        <section>
            <div class="container">
                <div class="row content-sigle-article">
                    <div class="col-md-12 col-lg-3">

                        <div class="sidebar-single">
                            <div class="category-sigle-sidebar">
                                <h4>دسته بندی</h4>
                                <?php wp_nav_menu(array('theme_location' => 'side-menu')); ?>
                            </div>
                            <div class="last-article-sigle-sidebar">
                                <h4>آخرین مقالات</h4>
                                <?php
                                $the_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => 3)); ?>
                                <?php if ($the_query->have_posts()) : ?>
                                    <ul>
                                        <?php while ($the_query->have_posts()) : $the_query->the_post(); ?>
                                            <li class="item-last-article">
                                                <div class="text-last-article">
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php the_title(); ?>
                                                    </a>
                                                    <span><?php the_time(); ?></span>
                                                </div>
                                            </li>
                                        <?php endwhile; ?>
                                    </ul>

                                <?php endif; ?>

                            </div>


                        </div>
                    </div>
                    <div class="col-md-12 col-lg-9">
                        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                            <div class="img-article-single">
                                <?php the_post_thumbnail('articlethumb'); ?>
                                <div class="info-img-article-single">
                                    <div class="time-article-single">
                                        <svg id="calendar_2_" data-name="calendar (2)"
                                             xmlns="http://www.w3.org/2000/svg" width="20.013" height="20.013"
                                             viewBox="0 0 20.013 20.013">
                                            <path id="Path_271" data-name="Path 271"
                                                  d="M17.434,1.564h-1.8V.625a.625.625,0,1,0-1.251,0v.938H5.629V.625a.625.625,0,0,0-1.251,0v.938H2.58A2.583,2.583,0,0,0,0,4.143v13.29a2.583,2.583,0,0,0,2.58,2.58H17.434a2.583,2.583,0,0,0,2.58-2.58V4.143A2.583,2.583,0,0,0,17.434,1.564Zm1.329,15.87a1.329,1.329,0,0,1-1.329,1.329H2.58a1.329,1.329,0,0,1-1.329-1.329V7.075a.2.2,0,0,1,.2-.2H18.567a.2.2,0,0,1,.2.2Z"
                                                  fill="#636363"/>
                                        </svg>
                                        <span><?php the_time('j F Y'); ?></span>
                                    </div>
                                    <div class="time-article-single">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20.226" height="17.698"
                                             viewBox="0 0 20.226 17.698">
                                            <g id="folder_1_" data-name="folder (1)" transform="translate(0 -31.999)">
                                                <g id="Group_56" data-name="Group 56" transform="translate(0 31.999)">
                                                    <path id="Path_168" data-name="Path 168"
                                                          d="M20.067,38.248a.842.842,0,0,0-.683-.35h-.843V35.37a.843.843,0,0,0-.843-.843H10.462L8.181,32.246a.84.84,0,0,0-.6-.247H.843A.843.843,0,0,0,0,32.842V48.854c0,.013.006.024.007.036a.814.814,0,0,0,.041.229c0,.013.006.026.01.039a.887.887,0,0,0,.1.189c.008.012.02.02.029.031s.029.031.043.047a.833.833,0,0,0,.166.137c.014.009.027.02.042.029a.868.868,0,0,0,.245.087c.008,0,.015.007.024.008a.8.8,0,0,0,.134.011H16.012a.842.842,0,0,0,.8-.576l3.371-10.113A.845.845,0,0,0,20.067,38.248Zm-3.212-.35H4.214a.843.843,0,0,0-.8.576L1.686,43.66V33.685h5.55l2.281,2.281a.842.842,0,0,0,.6.247h6.742Z"
                                                          transform="translate(0 -31.999)" fill="gray"/>
                                                </g>
                                            </g>
                                        </svg>
                                        <span><?php the_category(' , '); ?></span>
                                    </div>
                                    <div class="time-article-single">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20.75" height="20.75"
                                             viewBox="0 0 20.75 20.75">
                                            <g id="pencil" transform="translate(0)">
                                                <g id="Group_57" data-name="Group 57" transform="translate(0 0)">
                                                    <path id="Path_169" data-name="Path 169"
                                                          d="M20.2,3.369,17.367.537a1.929,1.929,0,0,0-2.669,0L2.023,13.34a.475.475,0,0,0-.119.2L.018,20.151a.472.472,0,0,0,.583.584l6.6-1.888a.474.474,0,0,0,.2-.119L20.2,6.039a1.888,1.888,0,0,0,0-2.67Zm-7.553.6,1.736,1.736L5.316,14.769l-.65-1.3a.472.472,0,0,0-.422-.261H3.489ZM1.158,19.594l.614-2.15L3.308,18.98ZM6.6,18.039l-2.256.645L2.069,16.406l.645-2.256H3.952l.813,1.626a.472.472,0,0,0,.211.211L6.6,16.8v1.239Zm.943-.776v-.755a.472.472,0,0,0-.261-.422l-1.3-.65,9.063-9.063,1.736,1.736ZM19.531,5.383,17.452,7.444,13.307,3.3l2.059-2.078a.965.965,0,0,1,1.334,0l2.83,2.83a.943.943,0,0,1,0,1.332Z"
                                                          transform="translate(0 -0.002)" fill="gray"/>
                                                </g>
                                            </g>
                                        </svg>
                                        <span><?php the_author(); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="text-content-article-single">
                                <?php the_content(); ?>
                            </div>
                            <section>
                                <div class="tags-article">

                                    <div class="folder-article">
                                        <div class="item-folder-article">
                                            <svg id="Group_180" data-name="Group 180" xmlns="http://www.w3.org/2000/svg"
                                                 width="20.341" height="17.798" viewBox="0 0 20.341 17.798">
                                                <path id="Path_279" data-name="Path 279"
                                                      d="M20.18,38.283a.847.847,0,0,0-.687-.352h-.848V35.389a.847.847,0,0,0-.848-.848H10.521L8.227,32.247a.845.845,0,0,0-.6-.248H.848A.847.847,0,0,0,0,32.847v16.1c0,.013.006.024.007.036a.819.819,0,0,0,.042.231c0,.013.006.026.01.039a.892.892,0,0,0,.1.19c.008.012.02.02.029.031s.029.031.043.047a.838.838,0,0,0,.167.138c.014.009.027.02.042.029a.873.873,0,0,0,.247.087c.008,0,.015.007.024.008a.8.8,0,0,0,.135.011H16.1a.847.847,0,0,0,.8-.58l3.39-10.17A.849.849,0,0,0,20.18,38.283Zm-3.23-.352H4.238a.848.848,0,0,0-.8.58L1.7,43.726V33.694H7.277l2.294,2.294a.847.847,0,0,0,.6.248h6.78Z"
                                                      transform="translate(0 -31.999)" fill="#f5b904"/>
                                            </svg>
                                        </div>
                                        <div class="item-folder">
                                            <?php the_category(' , '); ?>
                                        </div>
                                    </div>
                                    <?php
                                    if (has_tag()) { ?>
                                        <div class="tags-article-single">
                                            <div class="item-tags-article">
                                                <svg id="Group_179" data-name="Group 179"
                                                     xmlns="http://www.w3.org/2000/svg" width="20.237" height="16.145"
                                                     viewBox="0 0 20.237 16.145">
                                                    <path id="Path_277" data-name="Path 277"
                                                          d="M16.145,64.367a1.365,1.365,0,0,0-.394-.97L8.131,55.789A3.3,3.3,0,0,0,7.044,55.1,3.292,3.292,0,0,0,5.8,54.819H1.364a1.311,1.311,0,0,0-.959.4A1.311,1.311,0,0,0,0,56.183v4.433a3.29,3.29,0,0,0,.282,1.247A3.179,3.179,0,0,0,.97,62.939l7.62,7.63a1.305,1.305,0,0,0,.959.394,1.365,1.365,0,0,0,.97-.394l5.232-5.243A1.306,1.306,0,0,0,16.145,64.367ZM4.375,59.194a1.314,1.314,0,0,1-.965.4,1.364,1.364,0,0,1,0-2.728,1.364,1.364,0,0,1,.965,2.329Z"
                                                          transform="translate(0 -54.819)" fill="#f5b904"/>
                                                    <path id="Path_278" data-name="Path 278"
                                                          d="M213.336,63.4l-7.62-7.609a3.776,3.776,0,0,0-2.334-.97H201a3.777,3.777,0,0,1,2.334.97l7.619,7.609a1.364,1.364,0,0,1,.395.97,1.305,1.305,0,0,1-.395.959l-5.009,5.009a3.04,3.04,0,0,0,.565.48,1.194,1.194,0,0,0,.629.149,1.364,1.364,0,0,0,.97-.394l5.232-5.243a1.305,1.305,0,0,0,.395-.959A1.365,1.365,0,0,0,213.336,63.4Z"
                                                          transform="translate(-193.494 -54.823)" fill="#f5b904"/>
                                                </svg>
                                            </div>
                                            <div class="item-tags">
                                                <?php the_tags('') ?>
                                            </div>
                                        </div>
                                    <?php } ?>


                                </div>
                            </section>
                            <section>
                                <div class="article-next-pre">
                                    <div class="next-article-slide">
                                        <div class="next-article">
                                            <?php
                                            $next_post = get_next_post();
                                            $nid = $next_post->ID;
                                            $permalink = get_permalink($nid);
                                            ?>
                                            <span>
                                         <a href="<?php echo $permalink; ?>"><?php echo $next_post->post_title; ?></a>
                                        </span>
                                        </div>
                                        <div class="icon-next-article">
                                            <?php next_post_link('%link', __('&lsaquo;', 'twentyeleven')); ?>
                                        </div>
                                    </div>
                                    <div class="pre-article-slide">
                                        <div class="pre-article">
                                            <?php
                                            $prev_post = get_previous_post();
                                            $id = $prev_post->ID;
                                            $permalink = get_permalink($id);
                                            ?>
                                            <span><a href="<?php echo $permalink; ?>"><?php echo $prev_post->post_title; ?></a></span>
                                        </div>
                                        <div class="icon-pre-article">
                                            <?php previous_post_link('%link', __('&rsaquo;', 'twentyeleven')); ?>
                                        </div>
                                    </div>
                                </div>
                            </section>

                            <section>
                                <div class="title-article-mortabet">
                                    <span>___</span>
                                    <h2>مطالب مرتبط</h2>
                                </div>
                                <div class="box-project-mortabet">
                                    <div class="row">
                                        <?php
                                        $orig_post = $post;
                                        global $post;
                                        $tags = wp_get_post_tags($post->ID);

                                        if ($tags) {
                                            $tag_ids = array();
                                            foreach ($tags as $individual_tag) $tag_ids[] = $individual_tag->term_id;
                                            $args = array(
                                                'tag__in' => $tag_ids,
                                                'post__not_in' => array($post->ID),
                                                'posts_per_page' => 2, // Number of related posts to display.
                                                'caller_get_posts' => 1
                                            );

                                            $my_query = new wp_query($args);

                                            while ($my_query->have_posts()) {
                                                $my_query->the_post();
                                                ?>

                                                <div class="item-article col-md-6">

                                                    <div class="article-img">
                                                        <?php the_post_thumbnail('articlethumb'); ?>
                                                        <div class="item-article-img">
                                                            <a href="<?php the_permalink(); ?>"><i
                                                                    class="fas fa-link"></i></a>
                                                        </div>
                                                    </div>
                                                    <div class="text_box-article">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <h2><?php the_title(); ?></h2></a>
                                                    </div>
                                                    <div class="option-item">
                                                        <div class="date-item">
                                                            <i class="far fa-calendar"></i>
                                                            <span><?php the_time(); ?></span>
                                                        </div>
                                                        <div class="folder-item">
                                                            <i class="far fa-folder-open"></i>
                                                            <span><?php the_category(' , '); ?></span>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php }
                                        }
                                        $post = $orig_post;
                                        wp_reset_query();
                                        ?>

                                    </div>
                                </div>
                            </section>


                            <section>
                                <div class="title-didgah">
                                    <span>___</span>
                                    <h2>دیدگاهتان را بنویسید</h2>
                                </div>
                                <div class="didgah-form">


                                    <?php comments_template(); ?>

                                </div>
                            </section>
                        <?php endwhile; else : ?>
                            <p><?php esc_html_e('Sorry, no posts matched your criteria.'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>


        </section>
    <?php }
    get_footer(); ?>
<?php } elseif (is_singular('portfolio')) { ?>
<?php get_header();
$id = get_theme_mod('single_project_template');
if ($id) {
    get_site_templates($id);
} else {
    ?>
    <section>
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-6">
                    <div class="slider-single-project">
                        <div class="owl-carousel slider-project">
                            <div class="item-slider-project">
                                <img src="img/pa2-1.jpg">
                                <div class="onground-slider-project">
                                    <a href="#"><i class="fas fa-search"></i></a>
                                </div>
                            </div>
                            <div class="item-slider-project">
                                <img src="img/pa2-1.jpg">
                                <div class="onground-slider-project">
                                    <a href="#"><i class="fas fa-search"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-6">
                    <div class="paragraf-content-sigle-project">
                        <div class="title-paragraf-project">
                            <span>___</span>
                            <h2><?php the_title(); ?></h2>
                        </div>
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section>
        <div class="container">
            <div class="row">
                <div class="tags-folder-project">
                    <div class="folder-project">
                        <div class="item-folder-project">
                            <svg id="Group_180" data-name="Group 180" xmlns="http://www.w3.org/2000/svg"
                                 width="20.341" height="17.798" viewBox="0 0 20.341 17.798">
                                <path id="Path_279" data-name="Path 279"
                                      d="M20.18,38.283a.847.847,0,0,0-.687-.352h-.848V35.389a.847.847,0,0,0-.848-.848H10.521L8.227,32.247a.845.845,0,0,0-.6-.248H.848A.847.847,0,0,0,0,32.847v16.1c0,.013.006.024.007.036a.819.819,0,0,0,.042.231c0,.013.006.026.01.039a.892.892,0,0,0,.1.19c.008.012.02.02.029.031s.029.031.043.047a.838.838,0,0,0,.167.138c.014.009.027.02.042.029a.873.873,0,0,0,.247.087c.008,0,.015.007.024.008a.8.8,0,0,0,.135.011H16.1a.847.847,0,0,0,.8-.58l3.39-10.17A.849.849,0,0,0,20.18,38.283Zm-3.23-.352H4.238a.848.848,0,0,0-.8.58L1.7,43.726V33.694H7.277l2.294,2.294a.847.847,0,0,0,.6.248h6.78Z"
                                      transform="translate(0 -31.999)" fill="#f5b904"/>
                            </svg>
                        </div>
                        <div class="item-folder">
                            <a href="#"><p></p></a>
                        </div>
                    </div>
                    <div class="tags-project">
                        <div class="item-tags-project">
                            <svg id="Group_179" data-name="Group 179" xmlns="http://www.w3.org/2000/svg"
                                 width="20.237" height="16.145" viewBox="0 0 20.237 16.145">
                                <path id="Path_277" data-name="Path 277"
                                      d="M16.145,64.367a1.365,1.365,0,0,0-.394-.97L8.131,55.789A3.3,3.3,0,0,0,7.044,55.1,3.292,3.292,0,0,0,5.8,54.819H1.364a1.311,1.311,0,0,0-.959.4A1.311,1.311,0,0,0,0,56.183v4.433a3.29,3.29,0,0,0,.282,1.247A3.179,3.179,0,0,0,.97,62.939l7.62,7.63a1.305,1.305,0,0,0,.959.394,1.365,1.365,0,0,0,.97-.394l5.232-5.243A1.306,1.306,0,0,0,16.145,64.367ZM4.375,59.194a1.314,1.314,0,0,1-.965.4,1.364,1.364,0,0,1,0-2.728,1.364,1.364,0,0,1,.965,2.329Z"
                                      transform="translate(0 -54.819)" fill="#f5b904"/>
                                <path id="Path_278" data-name="Path 278"
                                      d="M213.336,63.4l-7.62-7.609a3.776,3.776,0,0,0-2.334-.97H201a3.777,3.777,0,0,1,2.334.97l7.619,7.609a1.364,1.364,0,0,1,.395.97,1.305,1.305,0,0,1-.395.959l-5.009,5.009a3.04,3.04,0,0,0,.565.48,1.194,1.194,0,0,0,.629.149,1.364,1.364,0,0,0,.97-.394l5.232-5.243a1.305,1.305,0,0,0,.395-.959A1.365,1.365,0,0,0,213.336,63.4Z"
                                      transform="translate(-193.494 -54.823)" fill="#f5b904"/>
                            </svg>
                        </div>
                        <div class="item-tags">
                            <a href="#"><p><?php echo the_portfolio_tags(); ?></p></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php }
get_footer(); }else {
    wp_head();
    the_content();
    wp_footer();
} ?>
